#!/usr/bin/perl
#########################################################################
# pgdfb.pl: 	Periodical dump of a database on the local disk. 	#
# 		Last $maxkeep files are keeped. It is expected for these#
#		dumps to be backed up on tape.				#
#									#
# Artist:	Theodore J. Soldatos					#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Version: 	1.0.0							#
# Date: 	03 May 2004						#
#########################################################################
use strict;

my $version = 'pgdfb.pl 1.0.0';
# Configuration

my $datadir = "/usr/local/pgsql/Backup";
my $dbname = "stunt";
my $maxkeep = 10;
my $pidfile = '/usr/local/scripts/pgdfb.pid';

print "$version\n";

# Check if i am running.
if (-e $pidfile) { # Stale or fresh ?
	open PIDFILE, "<$pidfile";
	my ($pid, $scrap) = split / /, <PIDFILE>, 2;
	close PIDFILE;
	open PSOUT, "/bin/ps -p $pid |";
	my @psout;
	while (<PSOUT>) { push @psout, $_ }; 
	if (scalar(@psout) > 1) { # Process in lock file exists
		print "This script is already running. Exiting... \n";
		exit 1;
		}
	else { # Stale...
		print "Removing stale lockfile.\n";
		unlink $pidfile;
		};
	};

# Write new pid file.
open PIDFILE, ">$pidfile";
print PIDFILE $$;
close PIDFILE;


opendir THISDIR, $datadir or die "serious dainbramage: $!";
my @allfiles = sort backwards grep(!/^\.\.?$/, readdir(THISDIR));

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);

$year = $year + 1900;
$mon++;

my $fndate = sprintf("%04d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);

my $newfilename = $datadir . "dump$fndate" . ".txt"; 

my @args = ("/usr/local/pgsql/bin/pg_dump -U postgres $dbname | /usr/bin/gzip > $newfilename"); 

system(@args) == 0 
	or die "pg_dump failed! $?\n";

print "Dump completed.\n";

my ($fn, $cnt);
$cnt = 0;
foreach $fn (@allfiles) {
	print "$fn ";
	$cnt++;
	if ($cnt > $maxkeep) {
		@args = ('/bin/rm', '-f', "$datadir$fn");
		system(@args) == 0 
			or die "Cannot remove old files! $? $!\n";
		print " -- DELETED\n";
	} else {
		print " -- KEPT\n";
	}; 
};

print "Removing lockfile.\n";
unlink $pidfile;
exit 0;

sub backwards {$b cmp $a;};
