#!/usr/bin/perl
#########################################################################
# This script connects to database as superuser and for each technician	#
# summarizes unassigned faults for the type of which the technician is	#
# responsible.								#
# The password is read from the PGPASSWORD environment variable.	#
# Timing of this script is left to cron.				#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.0.0	Starting... (9 June 2004)				#
# V0.1.0	First working version (9 June 2004)			#
# V0.1.1	Added count per category.				#
# V0.1.2	Fork from genmail.pl.					#
# V0.1.3	Added more columns in st_techsmc_faulttypes and using 	#
#		scse column for unassigned mails.			#
# V0.1.4	Mail subject moved to conf file.			#
#									#
#########################################################################

use strict;
use DBI;
use Mail::Sender;				# Perl Module for sending mails
use MIME::QuotedPrint;				# Perl Module for encoding - or decoding - of quoted-printable strings 
use st_lib;

my $data_source = $st_lib::data_source;		# Where to look...
my $smtpserver = $st_lib::smtpserver;
my $fromaddress = $st_lib::fromaddress;
my $url2 = $st_lib::url2;
my $usrs_subj = $st_lib::usrs_subj;

my $sth; 					# SQL statement handler. 
my $lsth; 					# SQL statement handler. 
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables
my @used_ids;					# To avoid mentioning the same fault twice.
my $debug = $st_lib::debug;
my $version = "V0.1.4";
my $passwd = $ENV{PGPASSWD};
my $mailcnt = 0;
my $usercnt = 0;
my $rccount;


my $mail_enabled = 0;

my $dbh = DBI->connect($data_source, 'postgres', $passwd, { RaiseError => 1, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Get user list.

$dst = "SELECT id, fullname, email, main_contact FROM st_users WHERE technician = \'t\' AND active = \'t\'";
$sth = $dbh->prepare($dst);
$sth->execute;

my @user_ary;
while (@user_ary = $sth->fetchrow_array) {
	$usercnt++;
	print "User $user_ary[1] ($user_ary[2])...";
	# For each user, check conditions. Send e-mail only if 
	# there is something to report.
	my $sendit = 0;
	my $body = '';
	@used_ids = '';

	# If MC, find unassigned tickets related through st_techsmc_faulttypes
	if ($user_ary[3] == 1) {
		$dst = "SELECT f.id, f.shortdescr, f.start_time, fc.name, lf.name, sf.name, NULL, u.fullname
			FROM ((((st_faults f INNER JOIN st_faults_companies_v fc ON f.id = fc.id)
				INNER JOIN st_level_of_fault lf ON f.id = lf.id)
				INNER JOIN st_status_of_fault sf ON f.id = sf.id)
				INNER JOIN st_users u ON f.logged_by_user_id = u.id)
				INNER JOIN st_faulttypes ty ON ty.id = f.faulttype_id
			WHERE 	f.end_time IS NULL
				AND f.faulttype_id IN (SELECT faulttype_id FROM st_techsmc_faulttypes
							WHERE user_id = $user_ary[0]
							AND scse = \'t\')
				AND NOT EXISTS (SELECT ft.fault_id FROM st_faultstechs ft WHERE ft.fault_id = f.id)
				AND ty.annoyscse = 't'";
		$lsth = $dbh->prepare($dst);
		$lsth->execute;
		if ($lsth->rows > 0) {
			# Mark, data to send.
			$sendit = 1;
		};
		$rccount = $lsth->rows;
		my $header = 0;
		while (@row_ary = $lsth->fetchrow_array) {
			if (not(st_lib::found(\@used_ids, $row_ary[0]))) {
				if (not($header)) {
					$body = $body . "Unassigned tickets for which you are responsible: \n";
					$body = $body . "Number of tickets: $rccount \n";
					$body = $body . "-----------------------------------------------\n";
					$header = 1;
				};
				push @used_ids, $row_ary[0]; 
				$body = $body . "SR #$row_ary[0]: \t$row_ary[1]\n";
				$body = $body . "Started: \t" . st_lib::datetostr($row_ary[2]) . "\n";
				$body = $body . "Company: \t$row_ary[3]\n";
				$body = $body . "Level: \t\t$row_ary[4]\n";
				$body = $body . "Status: \t$row_ary[5]\n";
				$body = $body . "Owner: \t\t$row_ary[7]\n";
				$body = $body . "Link: \t\t$url2+" . $row_ary[0] . "\n";
				$body = $body . "-----------------------------------------------\n";
			};
		};
	};

	# Print in stdout for debug.
#	print "DEBUG: User $user_ary[1] ($user_ary[2])\n$body";
	if ($sendit) {
		# We have something to send.
		# Footer to all mails.
		$body = $body . "\n+----------------------------------------------------------+";
		$body = $body . "\n!This is an automatically sent e-mail. Please do not reply.!";
		$body = $body . "\n!          Thank you for using Space Ticketing NT          !";
		$body = $body . "\n+----------------------------------------------------------+";
		$body = $body . "\n!            STUNT Unassigned SRs report $version            !";
		$body = $body . "\n+----------------------------------------------------------+";
		$mailcnt++;
		my $to_mail = "$user_ary[1] <$user_ary[2]>";
		$to_mail = encode_qp($to_mail);
		$to_mail =~ s/=\r?\n//g;	# Remove the new line added from encode_qp function
		if ($mail_enabled) {
			(new Mail::Sender)->MailMsg( {smtp => $smtpserver,
						      from => $fromaddress,
						      to => '=?iso-8859-7?Q?'.$to_mail.'?=',
						      subject => $usrs_subj,
						      msg => $body,
					      	      charset => "ISO-8859-7"} );
		} else {
			print " (D) ";
		};
		print "Mail sent.\n";
	} else {
		print "No mail.\n";
	};
};
print "\nMails sent to $mailcnt out of $usercnt CSE's\n";
$sth->finish;
$lsth->finish;
$dbh->disconnect;
