#!/usr/bin/perl
#########################################################################
# This script implements the alert email policy which is defined in the	#
# following tables: 							#
# 									#
# st_faultlevels: Alert mail inetrvals for each severity level.		#
# st_techsmc_faulttypes: If and how a user is assigned to a specific 	#
#			 fault type.					#
# st_mail_alerts: Log of mails send for each fault.			#
#									#
# The password is read from the PGPASSWORD environment variable.	#
# Timing of this script is defining the accuracy of mail alerts. If for #
# example is set to run every 15 minutes, an alert that should be sent	#
# two hours after the creation of the fault, could be send 15 mins late.#
#									#
# Artist: Theodore J. Soldatos						#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.0.0	Starting... (26 August 2004)				#
# V0.1.3	First working version					#
# V0.1.4	Non-techs can also receive alert mails.			#
# V0.1.5	Alerts can be disabled for 1 or more user categories.	#
# V0.1.6	Added an info mail so stdout can now go to /dev/null.	#
# V0.1.7	A record goes in for each mail alert send, no updates.	#
#		Last time is now selected using max().			#
# V0.1.8	Alerts are only sent to faulttypes with alertmails = 't'#
# V0.1.9	Addresses of summary mail in conf file.			#
#									#
#########################################################################

use strict;
use DBI;
use Mail::Sender;				# Perl Module for sending mails
use MIME::QuotedPrint;				# Perl Module for encoding - or decoding - of quoted-printable strings 
use st_lib;

my $data_source = $st_lib::data_source;		# Where to look...
my $smtpserver = $st_lib::smtpserver;
my $fromaddress = $st_lib::fromaddress;
my $url2 = $st_lib::url2;
my $alert_from = $st_lib::alert_from;
my $alert_to = $st_lib::alert_to;

my $sth; 					# SQL statement handler. 
my $lsth; 					# SQL statement handler. 
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables
my @used_ids;					# To avoid mentioning the same fault twice.
my $debug = $st_lib::debug;
my $version = "V0.1.9";
my $passwd = $ENV{PGPASSWD};
my $mailcnt = 0;
my $usercnt = 0;
my $srcnt = 0;
my $rccount;
my $sum_body = '';
my $sum_subj = '';


my $mail_enabled = 0;

my $dbh = DBI->connect($data_source, 'postgres', $passwd, { RaiseError => 1, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Get severities list.
$dst = "SELECT 	id, name, mail_interval_1, mail_interval_x, 
		dm_mail_interval_1, dm_mail_interval_x,
		tm_mail_interval_1, tm_mail_interval_x,
		am_mail_interval_1, am_mail_interval_x,
		gm_mail_interval_1, gm_mail_interval_x,
		dm_mail_interval_1+dm_mail_interval_x+tm_mail_interval_1+tm_mail_interval_x+am_mail_interval_1+am_mail_interval_x+gm_mail_interval_1+gm_mail_interval_x
	FROM st_faultlevels 
	ORDER BY id DESC"; 
$sth = $dbh->prepare($dst);
$sth->execute;

my @sev_ary;

while (@sev_ary = $sth->fetchrow_array) {
	if ($sev_ary[12] eq '00:00') {
		print "Severity $sev_ary[1]: No alerts defined.\n";
	} else {
		print "Working on severity $sev_ary[1]\n";
		# Find faults
		my $ldst = "SELECT f.id, f.shortdescr, f.start_time, fc.name, lf.name, sf.name, f.faulttype_id, u.fullname, ft.name
				FROM ((((st_faults f 	INNER JOIN st_faults_companies_v fc ON f.id = fc.id)
							INNER JOIN st_level_of_fault lf ON f.id = lf.id)
							INNER JOIN st_status_of_fault sf ON f.id = sf.id)
							INNER JOIN st_users u ON f.logged_by_user_id = u.id)
							INNER JOIN st_faulttypes ft ON f.faulttype_id = ft.id
				WHERE 	f.end_time IS NULL
				AND 	lf.faultlevel_id = $sev_ary[0]
				AND 	ft.alertmails = 't'";
		my $lsth = $dbh->prepare($ldst);
		$lsth->execute;
		print "\tFound " . $lsth->rows . " open SRs of severity $sev_ary[1]\n";
		my @f_ary;
		while (@f_ary = $lsth->fetchrow_array) {
			# Process each fault.
			print "\tWorking on SR nr. $f_ary[0]\n";
			my $ml_found = 0;
			# Look for mail log record.
			my $mldst = "SELECT max(last_mailx), max(last_dm_mailx), max(last_tm_mailx), max(last_am_mailx), max(last_gm_mailx)
					FROM st_mail_alerts
					WHERE fault_id = $f_ary[0]";
			my $mlsth = $dbh->prepare($mldst);
			$mlsth->execute;
			$ml_found = $mlsth->rows;
			my @ml_ary = $mlsth->fetchrow_array;
			# For each of the 5 categories, check if mail must be send.
			
			# SCSEs
			if (($sev_ary[2] ne '00:00') and ($sev_ary[3] ne '00:00')) {
				if ($ml_ary[0] eq '') {
					# No mail yet, use first mail interval against start time.
					my $ckdst = "SELECT timestamp \'$f_ary[2]\'+interval \'$sev_ary[2]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tSCSE: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 0, $dbh);
						# Update st_mail_alerts.
						# Update: Always insert, need full log.
							# Record not there yet, insert.
							$ml_found = 1;
							my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_mailx) values($f_ary[0], current_timestamp)";
							my $wsth = $dbh->prepare($wdst);
							$wsth->execute;
							$dbh->commit;
	
					} else {
						# Not yet.
						print "\t\tSCSE: No mails send.\n";
					};
				} else {
					# Mail already send. Use second mail interval against last mail timestamp.
					my $ckdst = "SELECT timestamp \'$ml_ary[0]\'+interval \'$sev_ary[3]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tSCSE: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 0, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tSCSE: No mails send.\n";
					};
	
				};
			} else {
				print "\t\tSCSE: Alerts disabled.\n";
			};

			# Duty managers
			if (($sev_ary[4] ne '00:00') and ($sev_ary[5] ne '00:00')) {
				if ($ml_ary[1] eq '') {
					# No mail yet, use first mail interval against start time.
					my $ckdst = "SELECT timestamp \'$f_ary[2]\'+interval \'$sev_ary[4]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tDuty Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 1, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_dm_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tDuty Manager: No mails send.\n";
					};
				} else {
					# Mail already send. Use second mail interval against last mail timestamp.
					my $ckdst = "SELECT timestamp \'$ml_ary[1]\'+interval \'$sev_ary[5]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tDuty Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 1, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_dm_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tDuty Manager: No mails send.\n";
					};
				};
			} else {
				print "\t\tDuty Managers: Alerts disabled.\n";
			};

			# Technical managers
			if (($sev_ary[6] ne '00:00') and ($sev_ary[7] ne '00:00')) {
				if ($ml_ary[2] eq '') {
					# No mail yet, use first mail interval against start time.
					my $ckdst = "SELECT timestamp \'$f_ary[2]\'+interval \'$sev_ary[6]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tTechnical Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 2, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_tm_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tTechnical Manager: No mails send.\n";
					};
				} else {
					# Mail already send. Use second mail interval against last mail timestamp.
					my $ckdst = "SELECT timestamp \'$ml_ary[2]\'+interval \'$sev_ary[7]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tTechnical Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 2, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_tm_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tTechnical Manager: No mails send.\n";
					};
				};
			} else {
				print "\t\tTechnical Managers: Alerts disabled.\n";
			};

			# Account managers
			if (($sev_ary[8] ne '00:00') and ($sev_ary[9] ne '00:00')) {
				if ($ml_ary[3] eq '') {
					# No mail yet, use first mail interval against start time.
					my $ckdst = "SELECT timestamp \'$f_ary[2]\'+interval \'$sev_ary[8]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tAccount Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 3, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_am_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tAccount Manager: No mails send.\n";
					};
				} else {
					# Mail already send. Use second mail interval against last mail timestamp.
					my $ckdst = "SELECT timestamp \'$ml_ary[3]\'+interval \'$sev_ary[9]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tAccount Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 3, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_am_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tAccount Manager: No mails send.\n";
					};
				};
			} else {
				print "\t\tAccount Managers: Alerts disabled.\n";
			};

			# General managers
			if (($sev_ary[10] ne '00:00') and ($sev_ary[11] ne '00:00')) {
				if ($ml_ary[4] eq '') {
					# No mail yet, use first mail interval against start time.
					my $ckdst = "SELECT timestamp \'$f_ary[2]\'+interval \'$sev_ary[10]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tGeneral Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 4, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_gm_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tGeneral Manager: No mails send.\n";
					};
				} else {
					# Mail already send. Use second mail interval against last mail timestamp.
					my $ckdst = "SELECT timestamp \'$ml_ary[4]\'+interval \'$sev_ary[11]\'<current_timestamp";
					my $cksth = $dbh->prepare($ckdst);
					$cksth->execute;
					my @ck_ary = $cksth->fetchrow_array;
					if ($ck_ary[0] == 1) {
						# Time to send mail.
						print "\t\tGeneral Manager: Must send mails.\n";
						# Send mail code goes here....
						#
						send_mails(\@f_ary, 4, $dbh);
						# Update st_mail_alerts.
						$ml_found = 1;
						my $wdst = "INSERT INTO st_mail_alerts(fault_id, last_gm_mailx) values($f_ary[0], current_timestamp)";
						my $wsth = $dbh->prepare($wdst);
						$wsth->execute;
						$dbh->commit;
					} else {
						# Not yet.
						print "\t\tGeneral Manager: No mails send.\n";
					};
				};
			} else {
				print "\t\tGeneral Managers: Alerts disabled.\n";
			};

		};
	};
};
print "\n$srcnt faults - Total $mailcnt mails sent.\n";
$sum_subj = "STuNT alerts: $srcnt SRs, $mailcnt mails.";
$sum_body = "$srcnt faults - Total $mailcnt mails sent.\n" . $sum_body;
	$sum_body = $sum_body . "\n+----------------------------------------------------------+";
	$sum_body = $sum_body . "\n!This is an automatically sent e-mail. Please do not reply.!";
	$sum_body = $sum_body . "\n!          Thank you for using Space Ticketing NT          !";
	$sum_body = $sum_body . "\n+----------------------------------------------------------+";
	$sum_body = $sum_body . "\n!                   STUNT Alerts $version                    !";
	$sum_body = $sum_body . "\n+----------------------------------------------------------+";

if (($mail_enabled) and ($mailcnt > 0)) {
	# Send mail to noc only if there is something to report.
	(new Mail::Sender)->MailMsg( {smtp => $smtpserver,
				      from => $alert_from, 
				      to => $alert_to,
				      subject => $sum_subj,
			    	      msg => $sum_body,
				      charset => "ISO-8859-7"} );
}; 
	
$sth->finish;
$dbh->disconnect;

sub send_mails {
	# How original, that name...
	my ($faultrecref, $recip_cat, $dbh) = @_;
	my %cat_num = ();
	my %cat_nm = ();
	$cat_num{0} = 'scse';
	$cat_num{1} = 'duty_m';
	$cat_num{2} = 'techn_m';
	$cat_num{3} = 'acc_m';
	$cat_num{4} = 'general_m';
	$cat_nm{0} = 'SCSE';
	$cat_nm{1} = 'Duty Manager';
	$cat_nm{2} = 'Technical Manager';
	$cat_nm{3} = 'Account Manager';
	$cat_nm{4} = 'General Manager';
	# Build recipients list.
	
	my $sdst = "SELECT u.id, u.fullname, u.email, u.main_contact 
		    FROM st_users u 
		    	INNER JOIN st_techsmc_faulttypes tft ON u.id = tft.user_id
		    WHERE 	u.active = \'t\'
		    AND 	tft.faulttype_id = $$faultrecref[6]
		    AND 	tft." . $cat_num{ $recip_cat } . "= \'t\'";
	my $ssth = $dbh->prepare($sdst);
	$ssth->execute;
	if ($ssth->rows == 0) {
		print "\t\t\tWarning: No " . $cat_nm{ $recip_cat } . " recipients found for SR type $$faultrecref[8]\n";
	} else {
		my @u_ary;
		# Log this fault to send mail to admin
		$sum_body = $sum_body . "SR #$$faultrecref[0]: $$faultrecref[1]\n";
		$sum_body = $sum_body . "\tCategory: $cat_nm{$recip_cat}\n";
		$srcnt++;
		# Prepare subject and body of mail
		my $subjtxt = "$$faultrecref[4] severity SR alert: #$$faultrecref[0]";
		my $bodytxt = "Dear " .  $cat_nm{ $recip_cat } . ",\n\nThe following $$faultrecref[4] severity SR is still open: \n\n";
		$bodytxt = $bodytxt . "SR #$$faultrecref[0]: \t$$faultrecref[1]\n";
		$bodytxt = $bodytxt . "Started: \t" . st_lib::datetostr($$faultrecref[2]) . "\n";
		$bodytxt = $bodytxt . "Company: \t$$faultrecref[3]\n";
		$bodytxt = $bodytxt . "Level: \t\t$$faultrecref[4]\n";
		$bodytxt = $bodytxt . "Status: \t$$faultrecref[5]\n";
		$bodytxt = $bodytxt . "Owner: \t\t$$faultrecref[7]\n";
		$bodytxt = $bodytxt . "Link: \t\t$url2+" . $$faultrecref[0] . "\n";

		# Footer to all mails.
		$bodytxt = $bodytxt . "\n+----------------------------------------------------------+";
		$bodytxt = $bodytxt . "\n!This is an automatically sent e-mail. Please do not reply.!";
		$bodytxt = $bodytxt . "\n!          Thank you for using Space Ticketing NT          !";
		$bodytxt = $bodytxt . "\n+----------------------------------------------------------+";
		$bodytxt = $bodytxt . "\n!                   STUNT Alerts $version                    !";
		$bodytxt = $bodytxt . "\n+----------------------------------------------------------+";

		while (@u_ary = $ssth->fetchrow_array) {
			print "\t\t\tSending mail to $u_ary[1] ($u_ary[2]) ";
			$sum_body = $sum_body . "\t\tSending mail to $u_ary[1] ($u_ary[2]) ";
			$mailcnt++;
			my $to_mail = "$u_ary[1] <$u_ary[2]>";
			$to_mail = encode_qp($to_mail);
			$to_mail =~ s/=\r?\n//g;	# Remove the new line added from encode_qp function
			if ($mail_enabled) {
				(new Mail::Sender)->MailMsg( {smtp => $smtpserver,
							      from => $fromaddress,
							      to => '=?iso-8859-7?Q?'.$to_mail.'?=',
							      subject => $subjtxt,
						    	      msg => $bodytxt,
							      charset => "ISO-8859-7"} );
			} else {
				print " (D) ";
				$sum_body = $sum_body . " (D) ";
			};
			print "Mail sent.\n";
			$sum_body = $sum_body . "Mail sent.\n";
		};
	};
	
}; # send_mails ends here.
