--
-- PostgreSQL database dump
--

-- Copyright (C) 2004-2005 Space Hellas	
-- Copyright (C) 2004-2005 Theodore J. Soldatos				
--									
-- This program is free software; you can redistribute it and/or	
-- modify it under the terms of the GNU General Public License		
-- as published by the Free Software Foundation; either version 2	
-- of the License, or (at your option) any later version.		
--								
-- This program is distributed in the hope that it will be useful,	
-- but WITHOUT ANY WARRANTY; without even the implied warranty of	
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	
-- GNU General Public License for more details.				
--									
-- You should have received a copy of the GNU General Public License	
-- along with this program; if not, write to the Free Software		
-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		
-- MA  02110-1301, USA							

\connect - postgres

SET search_path = public, pg_catalog;

--
-- TOC entry 201 (OID 158821)
-- Name: plpgsql_call_handler (); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION plpgsql_call_handler () RETURNS language_handler
    AS '$libdir/plpgsql', 'plpgsql_call_handler'
    LANGUAGE c;


--
-- TOC entry 199 (OID 158822)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler;


--
-- TOC entry 202 (OID 158829)
-- Name: plperl_call_handler (); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION plperl_call_handler () RETURNS language_handler
    AS '$libdir/plperl', 'plperl_call_handler'
    LANGUAGE c;


--
-- TOC entry 200 (OID 158830)
-- Name: plperl; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE plperl HANDLER plperl_call_handler;


--
-- TOC entry 2 (OID 6218071)
-- Name: zs_tableinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE zs_tableinfo (
    tablename text NOT NULL,
    gr_tablename text,
    cgi_string text,
    is_param boolean,
    form_title text,
    do_upd boolean,
    do_ins boolean,
    do_del boolean
);


--
-- TOC entry 3 (OID 6218071)
-- Name: zs_tableinfo; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE zs_tableinfo FROM PUBLIC;
GRANT SELECT ON TABLE zs_tableinfo TO PUBLIC;


--
-- TOC entry 4 (OID 6218076)
-- Name: zs_columninfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE zs_columninfo (
    tablename text NOT NULL,
    columnname text NOT NULL,
    gr_columnname text,
    do_use boolean,
    ordernum integer,
    is_search boolean
);


--
-- TOC entry 5 (OID 6218076)
-- Name: zs_columninfo; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE zs_columninfo FROM PUBLIC;
GRANT SELECT ON TABLE zs_columninfo TO PUBLIC;


--
-- TOC entry 6 (OID 6218083)
-- Name: zs_menus; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE zs_menus (
    id serial NOT NULL,
    parent integer DEFAULT 0 NOT NULL,
    description text NOT NULL,
    url text,
    orderby integer,
    vfg integer[]
);


--
-- TOC entry 7 (OID 6218083)
-- Name: zs_menus; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE zs_menus FROM PUBLIC;
GRANT SELECT ON TABLE zs_menus TO PUBLIC;


--
-- TOC entry 8 (OID 6218090)
-- Name: zs_menus_favorites; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE zs_menus_favorites (
    zs_menus_id integer NOT NULL,
    username text NOT NULL
);


--
-- TOC entry 9 (OID 6218090)
-- Name: zs_menus_favorites; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE zs_menus_favorites FROM PUBLIC;
GRANT ALL ON TABLE zs_menus_favorites TO PUBLIC;


--
-- TOC entry 203 (OID 6218095)
-- Name: null_to_empty (bigint); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION null_to_empty (bigint) RETURNS text
    AS '
	DECLARE 
		inp ALIAS FOR $1;
		toret TEXT;
	BEGIN
		IF inp IS NULL THEN 
			RETURN '' '';
		ELSE 
			toret := CAST(inp AS TEXT);  
			RETURN toret;
		END IF;
	END;	
'
    LANGUAGE plpgsql IMMUTABLE;


--
-- TOC entry 204 (OID 6218096)
-- Name: null_t_to_empty (text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION null_t_to_empty (text) RETURNS text
    AS '
	DECLARE 
		inp ALIAS FOR $1;
	BEGIN
		IF inp IS NULL THEN 
			RETURN '' '';
		ELSE 
			RETURN inp;
		END IF;
	END;	
'
    LANGUAGE plpgsql IMMUTABLE;


--
-- TOC entry 10 (OID 6218099)
-- Name: st_companies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_companies (
    id bigserial NOT NULL,
    name text NOT NULL,
    comments text,
    active boolean DEFAULT true
);


--
-- TOC entry 11 (OID 6218099)
-- Name: st_companies; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_companies FROM PUBLIC;
GRANT SELECT ON TABLE st_companies TO PUBLIC;
GRANT ALL ON TABLE st_companies TO GROUP techs_mc;


--
-- TOC entry 95 (OID 6218099)
-- Name: st_companies_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_companies_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_companies_id_seq TO PUBLIC;
GRANT ALL ON TABLE st_companies_id_seq TO GROUP techs_mc;


--
-- TOC entry 12 (OID 6218108)
-- Name: st_userlevels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_userlevels (
    id serial NOT NULL,
    name text NOT NULL,
    client boolean NOT NULL,
    technician boolean NOT NULL,
    admin boolean NOT NULL,
    pg_groupname text
);


--
-- TOC entry 13 (OID 6218108)
-- Name: st_userlevels; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_userlevels FROM PUBLIC;
GRANT SELECT ON TABLE st_userlevels TO PUBLIC;


--
-- TOC entry 97 (OID 6218108)
-- Name: st_userlevels_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_userlevels_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_userlevels_id_seq TO PUBLIC;


--
-- TOC entry 14 (OID 6218116)
-- Name: st_faultstatus; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faultstatus (
    id serial NOT NULL,
    name text NOT NULL,
    description text
);


--
-- TOC entry 15 (OID 6218116)
-- Name: st_faultstatus; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultstatus FROM PUBLIC;
GRANT SELECT ON TABLE st_faultstatus TO PUBLIC;
GRANT ALL ON TABLE st_faultstatus TO GROUP admin;


--
-- TOC entry 99 (OID 6218116)
-- Name: st_faultstatus_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultstatus_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_faultstatus_id_seq TO PUBLIC;


--
-- TOC entry 16 (OID 6218124)
-- Name: st_faultlevels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faultlevels (
    id serial NOT NULL,
    name text NOT NULL,
    description text,
    mail_interval_1 interval NOT NULL,
    mail_interval_x interval NOT NULL,
    dm_mail_interval_1 interval NOT NULL,
    dm_mail_interval_x interval NOT NULL,
    tm_mail_interval_1 interval NOT NULL,
    tm_mail_interval_x interval NOT NULL,
    am_mail_interval_1 interval NOT NULL,
    am_mail_interval_x interval NOT NULL,
    gm_mail_interval_1 interval NOT NULL,
    gm_mail_interval_x interval NOT NULL
);


--
-- TOC entry 17 (OID 6218124)
-- Name: st_faultlevels; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultlevels FROM PUBLIC;
GRANT SELECT ON TABLE st_faultlevels TO PUBLIC;
GRANT ALL ON TABLE st_faultlevels TO GROUP admin;


--
-- TOC entry 101 (OID 6218124)
-- Name: st_faultlevels_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultlevels_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_faultlevels_id_seq TO PUBLIC;
GRANT ALL ON TABLE st_faultlevels_id_seq TO GROUP admin;


--
-- TOC entry 18 (OID 6218132)
-- Name: st_companieslocations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_companieslocations (
    id serial NOT NULL,
    name text NOT NULL,
    description text NOT NULL,
    address1 text,
    address2 text,
    address3 text,
    phone1 text,
    phone2 text,
    fax text,
    comments text,
    contact_info text,
    active boolean DEFAULT true NOT NULL,
    main_location boolean DEFAULT false NOT NULL,
    company_id bigint NOT NULL,
    sla_responce interval DEFAULT '00:00:00' NOT NULL,
    sla_resolution interval DEFAULT '00:00:00' NOT NULL,
    locident text
);


--
-- TOC entry 19 (OID 6218132)
-- Name: st_companieslocations; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_companieslocations FROM PUBLIC;
GRANT SELECT ON TABLE st_companieslocations TO PUBLIC;
GRANT ALL ON TABLE st_companieslocations TO GROUP techs_mc;


--
-- TOC entry 103 (OID 6218132)
-- Name: st_companieslocations_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_companieslocations_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_companieslocations_id_seq TO PUBLIC;
GRANT ALL ON TABLE st_companieslocations_id_seq TO GROUP techs_mc;


--
-- TOC entry 20 (OID 6218142)
-- Name: st_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_users (
    id serial NOT NULL,
    username text NOT NULL,
    fullname text NOT NULL,
    client boolean NOT NULL,
    technician boolean NOT NULL,
    admin boolean NOT NULL,
    email text NOT NULL,
    phone1 text,
    phone2 text,
    fax text,
    active boolean DEFAULT true NOT NULL,
    main_contact boolean DEFAULT false NOT NULL,
    userlevel_id integer NOT NULL,
    companylocation_id integer NOT NULL,
    ldapdn text
);


--
-- TOC entry 21 (OID 6218142)
-- Name: st_users; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_users FROM PUBLIC;
GRANT SELECT ON TABLE st_users TO PUBLIC;
GRANT INSERT,UPDATE ON TABLE st_users TO GROUP admin;


--
-- TOC entry 105 (OID 6218142)
-- Name: st_users_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_users_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_users_id_seq TO PUBLIC;
GRANT ALL ON TABLE st_users_id_seq TO GROUP admin;


--
-- TOC entry 22 (OID 6218152)
-- Name: st_faults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faults (
    id bigserial NOT NULL,
    shortdescr text NOT NULL,
    start_time timestamp without time zone NOT NULL,
    end_time timestamp without time zone,
    logged_by_user_id integer NOT NULL,
    closed_by_user_id integer,
    companylocation_id integer NOT NULL,
    faulttype_id integer NOT NULL,
    rma_num text,
    tac_num text,
    survey_done boolean NOT NULL,
    confidential boolean NOT NULL DEFAULT 'f'
);


--
-- TOC entry 23 (OID 6218152)
-- Name: st_faults; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faults FROM PUBLIC;
GRANT INSERT,SELECT,UPDATE ON TABLE st_faults TO PUBLIC;
GRANT DELETE ON TABLE st_faults TO GROUP techs_mc;


--
-- TOC entry 107 (OID 6218152)
-- Name: st_faults_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faults_id_seq FROM PUBLIC;
GRANT ALL ON TABLE st_faults_id_seq TO PUBLIC;


--
-- TOC entry 24 (OID 6218160)
-- Name: st_faultsmsglog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faultsmsglog (
    id bigserial NOT NULL,
    description text NOT NULL,
    log_time timestamp without time zone NOT NULL,
    logged_by_user_id integer NOT NULL,
    fault_id bigint NOT NULL
);


--
-- TOC entry 25 (OID 6218160)
-- Name: st_faultsmsglog; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultsmsglog FROM PUBLIC;
GRANT INSERT,SELECT ON TABLE st_faultsmsglog TO PUBLIC;
GRANT DELETE ON TABLE st_faultsmsglog TO GROUP techs_mc;


--
-- TOC entry 109 (OID 6218160)
-- Name: st_faultsmsglog_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultsmsglog_id_seq FROM PUBLIC;
GRANT ALL ON TABLE st_faultsmsglog_id_seq TO PUBLIC;


--
-- TOC entry 26 (OID 6218168)
-- Name: st_faultstechs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faultstechs (
    id bigserial NOT NULL,
    assign_time timestamp without time zone NOT NULL,
    assigned_by_user_id integer NOT NULL,
    assigned_to_user_id integer NOT NULL,
    fault_id bigint NOT NULL
);


--
-- TOC entry 27 (OID 6218168)
-- Name: st_faultstechs; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultstechs FROM PUBLIC;
GRANT SELECT ON TABLE st_faultstechs TO PUBLIC;
GRANT INSERT,DELETE ON TABLE st_faultstechs TO GROUP techs_mc;


--
-- TOC entry 111 (OID 6218168)
-- Name: st_faultstechs_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultstechs_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_faultstechs_id_seq TO PUBLIC;
GRANT ALL ON TABLE st_faultstechs_id_seq TO GROUP techs_mc;


--
-- TOC entry 28 (OID 6218173)
-- Name: st_faultsstatuslog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faultsstatuslog (
    id bigserial NOT NULL,
    change_time timestamp without time zone NOT NULL,
    fault_id bigint NOT NULL,
    faultstatus_id integer NOT NULL,
    changed_by_user_id integer NOT NULL
);


--
-- TOC entry 29 (OID 6218173)
-- Name: st_faultsstatuslog; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultsstatuslog FROM PUBLIC;
GRANT INSERT,SELECT ON TABLE st_faultsstatuslog TO PUBLIC;
GRANT DELETE ON TABLE st_faultsstatuslog TO GROUP techs_mc;


--
-- TOC entry 113 (OID 6218173)
-- Name: st_faultsstatuslog_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultsstatuslog_id_seq FROM PUBLIC;
GRANT ALL ON TABLE st_faultsstatuslog_id_seq TO PUBLIC;


--
-- TOC entry 30 (OID 6218178)
-- Name: st_faultslevellog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faultslevellog (
    id bigserial NOT NULL,
    change_time timestamp without time zone NOT NULL,
    faultlevel_id integer NOT NULL,
    changed_by_user_id integer NOT NULL,
    fault_id bigint NOT NULL
);


--
-- TOC entry 31 (OID 6218178)
-- Name: st_faultslevellog; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultslevellog FROM PUBLIC;
GRANT INSERT,SELECT ON TABLE st_faultslevellog TO PUBLIC;
GRANT DELETE ON TABLE st_faultslevellog TO GROUP techs_mc;


--
-- TOC entry 115 (OID 6218178)
-- Name: st_faultslevellog_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faultslevellog_id_seq FROM PUBLIC;
GRANT ALL ON TABLE st_faultslevellog_id_seq TO PUBLIC;


--
-- TOC entry 32 (OID 6218183)
-- Name: st_faulttypes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faulttypes (
    id serial NOT NULL,
    name text NOT NULL,
    description text,
    annoyscse boolean NOT NULL,
    alertmails boolean DEFAULT 't' NOT NULL,
    confidential_bd boolean DEFAULT 'f' NOT NULL
);


--
-- TOC entry 33 (OID 6218183)
-- Name: st_faulttypes; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faulttypes FROM PUBLIC;
GRANT SELECT ON TABLE st_faulttypes TO PUBLIC;


--
-- TOC entry 117 (OID 6218183)
-- Name: st_faulttypes_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faulttypes_id_seq FROM PUBLIC;
GRANT SELECT ON TABLE st_faulttypes_id_seq TO PUBLIC;


--
-- TOC entry 34 (OID 6218192)
-- Name: st_companies_location_v; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_companies_location_v AS
    SELECT st_companieslocations.id, st_companieslocations.name, st_companieslocations.description, st_companies.comments FROM st_companieslocations, st_companies WHERE (st_companieslocations.company_id = st_companies.id);


--
-- TOC entry 35 (OID 6218192)
-- Name: st_companies_location_v; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_companies_location_v FROM PUBLIC;
GRANT SELECT ON TABLE st_companies_location_v TO PUBLIC;


--
-- TOC entry 36 (OID 6218193)
-- Name: st_faults_users_rel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_faults_users_rel (
    fault_id bigint NOT NULL,
    user_id integer NOT NULL,
    write_perm boolean
);


--
-- TOC entry 37 (OID 6218193)
-- Name: st_faults_users_rel; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faults_users_rel FROM PUBLIC;
GRANT ALL ON TABLE st_faults_users_rel TO PUBLIC;


--
-- TOC entry 205 (OID 6218195)
-- Name: st_faults_1_triggerfunc (); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION st_faults_1_triggerfunc () RETURNS "trigger"
    AS '

	DECLARE
		tmp integer;
		ftype RECORD;
	BEGIN
	/* 
	This procedure will be triggered when a fault is updated
	and will: 
	1. Raise an exception if NEW.end_time is null and OLD is not.
	2. Insert a new status in status log with id=-1 (closed)
	3. Raise an exception if only one of close time, close user has value.
	4. Raise an exception if NEW.old_time is not null and try to change something to the current fault.
	5. Raise an exception if (NEW.resolution_timestamp < NEW.responce_timestamp) or (NEW.responce_timestamp < NEW.report_timestamp).
	6. Raise an exception if while (NEW.end_time is NOT NULL and OLD.end_time is NULL) (e.g. closing), the fault is an SLA fault and
		not all SLA fields are completed.

	Artist: Theodore J. Soldatos
	*/
	
	/* end_time check */	
	IF ((OLD.end_time IS NOT NULL) AND (NEW.end_time IS NULL)) THEN
		RAISE EXCEPTION ''A closed fault cannot be reopened!'';
		RETURN NULL;
	END IF;

	/* close values check */
	IF (((NEW.end_time IS NULL) AND (NEW.closed_by_user_id IS NOT NULL)) OR ((NEW.end_time IS NOT NULL) AND (NEW.closed_by_user_id IS NULL))) THEN
		RAISE EXCEPTION ''Close time and user must both have value!'';
		RETURN NULL;
	END IF;
	
	/* Status log */
	IF (NEW.end_time IS NOT NULL) THEN

		INSERT INTO st_faultsstatuslog(change_time, fault_id, faultstatus_id, changed_by_user_id) VALUES(NEW.end_time, NEW.id, -1, NEW.closed_by_user_id); 
	END IF;
	
	/* Check changing closed fault */
	/* Added extra check to permit update of survey_done */
	IF (((OLD.end_time IS NOT NULL) AND (OLD.survey_done = ''t'')) OR ((OLD.end_time IS NOT NULL) AND (OLD.survey_done = NEW.survey_done))) THEN
		RAISE EXCEPTION ''A closed fault cannot be changed!'';
		RETURN NULL;
	END IF;
	
	/* Manual dates check (see no5 above) */
	IF ((NEW.report_timestamp IS NULL) AND (NEW.responce_timestamp IS NOT NULL)) THEN
		RAISE EXCEPTION ''Responce without report is illogical!'';
		RETURN NULL;
	END IF;
	IF ((NEW.responce_timestamp IS NULL) AND (NEW.recovery_timestamp IS NOT NULL)) THEN
		RAISE EXCEPTION ''Recovery without responce is illogical!'';
		RETURN NULL;
	END IF;
	IF ((NEW.responce_timestamp <= NEW.report_timestamp)) THEN
		RAISE EXCEPTION ''Responce before report is illogical!'';
		RETURN NULL;
	END IF;
	IF ((NEW.recovery_timestamp <= NEW.responce_timestamp)) THEN
		RAISE EXCEPTION ''Recovery before responce is illogical!'';
		RETURN NULL;
	END IF;

	/* Find out if this is an SLA fault */
	SELECT INTO ftype * FROM st_faulttypes WHERE id = NEW.faulttype_id;
	IF ((ftype.manual_dates = ''t'') AND (OLD.end_time IS NULL) AND (NEW.end_time IS NOT NULL)) THEN
		IF ((NEW.report_timestamp IS NULL) OR (NEW.responce_timestamp IS NULL) OR (NEW.recovery_timestamp IS NULL) OR (NEW.sla_actions IS NULL)) THEN
			RAISE EXCEPTION ''SLA fields missing on an SLA SR. Please complete all SLA fields.'';
		END IF;
	END IF;

	RETURN NEW;
	END;
'
    LANGUAGE plpgsql;


CREATE FUNCTION st_faults_2_triggerfunc () RETURNS "trigger" AS '

	DECLARE
		tmp BOOLEAN;
		ftype RECORD;
	BEGIN

	/*
		This procedure will set the confidential flag of each new
		fault record according to its type, based on the corresponding
		flag on st_faulttypes.
	*/
	SELECT INTO ftype * FROM st_faulttypes WHERE id = NEW.faulttype_id;	
	NEW.confidential = ftype.confidential_bd;
	RETURN NEW;
	END;
' LANGUAGE 'plpgsql';


--
-- TOC entry 206 (OID 6218196)
-- Name: st_users_1_triggerfunc (); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION st_users_1_triggerfunc () RETURNS "trigger"
    AS '

DECLARE
command_clients varchar(100);  /* Dynamic Command String - clients group */
command_clients_mc varchar(100);  /* Dynamic Command String - clients_mc group */
command_techs varchar(100);  /* Dynamic Command String - techs group */
command_techs_mc varchar(100);  /* Dynamic Command String - techs_mc group*/
command_admin varchar(100);  /* Dynamic Command String - admin group */
clean_command varchar(300);/* Dynamic Command String - clean groups */
command_drop_user varchar(50);/* Dynamic Command String - drop users */
BEGIN

/* 
This procedure will be triggered when a new (user) record is added or updated to the st_users table 
and will check :
1. Check the three (3) boolean flags (client, technicians, admin) if they have followed the proper rules.
2. Check the main_contact boolean flag if it is checked in case the admin flag is checked.
3. Populate (create) the user groups.
4. If active is false means user disactivation so drop user command.

----------------------------
Artist: Politis Konstantinos
----------------------------
*/

/* Start to check the above */

IF NEW.admin IS TRUE THEN
IF NEW.technician IS FALSE OR NEW.client IS FALSE THEN
/* FATAL ERROR */
RAISE EXCEPTION ''FATAL ERROR --- % Action --- % user   ---> Check User Levels'', TG_OP, NEW.username;
ELSE
NEW.main_contact := TRUE; /* If admin = true ---> main_contact must be true */
END IF;
END IF;

IF NEW.technician IS TRUE THEN
IF NEW.client IS FALSE THEN
/* FATAL ERROR */
RAISE EXCEPTION ''FATAL ERROR --- % Action --- % user   ---> Check User Level'', TG_OP, NEW.username;
END IF;
END IF;

IF NEW.client IS FALSE THEN
/* FATAL ERROR */
RAISE EXCEPTION ''FATAL ERROR --- % Action --- % user   ---> Check User Level'', TG_OP, NEW.username;
END IF;

/* Checking ends here */

/* Start to populate the user groups */

/* Initialize command_<string> */

command_clients := '''';
command_clients_mc := '''';
command_techs := '''';
command_techs_mc := '''';
command_admin := '''';
clean_command := '''';

clean_command := clean_command || ''ALTER GROUP clients DROP USER '' || NEW.username || '';'' ||
    ''ALTER GROUP clients_mc DROP USER '' || NEW.username || '';'' ||
  ''ALTER GROUP techs DROP USER '' || NEW.username || '';'' ||
  ''ALTER GROUP techs_mc DROP USER '' || NEW.username || '';'' ||
  ''ALTER GROUP admin DROP USER '' || NEW.username || '';'';

command_clients := command_clients || ''ALTER GROUP clients ADD USER '' || NEW.username || '';'';
command_clients_mc := command_clients_mc || ''ALTER GROUP clients_mc ADD USER '' || NEW.username || '';'';
command_techs := command_techs || ''ALTER GROUP techs ADD USER '' || NEW.username || '';'';
command_techs_mc := command_techs_mc || ''ALTER GROUP techs_mc ADD USER '' || NEW.username || '';'';
command_admin := command_admin || ''ALTER GROUP admin ADD USER '' || NEW.username || '';'';

IF NEW.active IS TRUE THEN
-- First clean up (drop) the previous groups ---
EXECUTE clean_command;

IF NEW.client IS TRUE THEN
IF NEW.main_contact IS TRUE THEN
-- Add user to clients_mc group
EXECUTE command_clients_mc;

-- Add user to clients group
EXECUTE command_clients;
ELSE
-- Add user to clients group
EXECUTE command_clients;
END IF;
END IF;
IF NEW.technician IS TRUE THEN
IF NEW.main_contact IS TRUE THEN
-- Add user to techs_mc group
EXECUTE command_techs_mc;

-- Add user to techs group
EXECUTE command_techs;
ELSE
-- Add user to techs group
EXECUTE command_techs;
END IF;
END IF;

IF NEW.admin IS TRUE THEN
-- Add user to admin group
EXECUTE command_admin;
END IF;
ELSE
--- Active is false. That means that a user was disactivated ---
--- The trigger must drop this user from pg_user table     ---

command_drop_user := '''';
command_drop_user := command_drop_user || ''DROP USER '' || NEW.username || '';'';
EXECUTE command_drop_user;
END IF;

/* Population ends here */

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 207 (OID 6218197)
-- Name: st_companies_1_triggerfunc (); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION st_companies_1_triggerfunc () RETURNS "trigger"
    AS '

	DECLARE
		user RECORD;
	BEGIN
	/* 
	This procedure will be triggered when a company is updated
	and set inactive and will: 
	1. Set to inactive all users of the company.
	2. Set to inactive all locations of the company.

	Artist: Theodore J. Soldatos
	*/
	
	IF ((NEW.active = ''f'') AND (OLD.active = ''t'')) THEN
		FOR user IN SELECT user_id FROM st_user_company_id_v WHERE company_id = OLD.id LOOP
			EXECUTE ''UPDATE st_users SET active = \\''f\\'' WHERE id ='' || user.user_id;
		END LOOP;
		EXECUTE ''UPDATE st_companieslocations SET active = \\''f\\'' WHERE company_id ='' || OLD.id;
	END IF;
	
	RETURN NEW;
	END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 38 (OID 6218198)
-- Name: st_techsmc_faulttypes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_techsmc_faulttypes (
    user_id integer NOT NULL,
    faulttype_id integer NOT NULL,
    scse boolean DEFAULT 't' NOT NULL,
    duty_m boolean DEFAULT 'f' NOT NULL,
    techn_m boolean DEFAULT 'f' NOT NULL,
    acc_m boolean DEFAULT 'f' NOT NULL,
    general_m boolean DEFAULT 'f' NOT NULL
);


--
-- TOC entry 39 (OID 6218198)
-- Name: st_techsmc_faulttypes; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_techsmc_faulttypes FROM PUBLIC;
GRANT SELECT ON TABLE st_techsmc_faulttypes TO PUBLIC;
GRANT ALL ON TABLE st_techsmc_faulttypes TO GROUP admin;


--
-- TOC entry 208 (OID 6218205)
-- Name: st_techsmc_1_triggerfunc (); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION st_techsmc_1_triggerfunc () RETURNS "trigger"
    AS '

DECLARE
myrecord RECORD;/* For SELECT output command     */
global_command varchar(200);/* Dynamic Global Command String */

BEGIN

This procedure will be triggered when a new record is added or updated to the st_techsmc_faulttypes table.
It checks that users in st_techsmc_faulttypes are at least tech_mc.

/* 
----------------------------
Artist: Politis Konstantinos
----------------------------
*/

/*global_command := '''';
global_command := global_command || ''SELECT INTO myrecord ''
 || '' FROM st.users u WHERE '' || NEW.user_id || ''= u.id;'';*/
/*EXECUTE global_command;*/

SELECT INTO myrecord * FROM st_users u WHERE NEW.user_id = u.id;

/* Start checking */

IF myrecord.technician IS TRUE THEN
IF myrecord.main_contact IS FALSE THEN
/* FATAL ERROR */
RAISE EXCEPTION ''FATAL ERROR ----- % Action ----- INVALID User level (ID:%) '', TG_OP, NEW.user_id;
END IF;
ELSE
/* FATAL ERROR */
RAISE EXCEPTION ''FATAL ERROR ----- % Action ----- INVALID User level (ID:%) '', TG_OP, NEW.user_id;
END IF;

/* Stop checking */

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 40 (OID 6218208)
-- Name: st_surveys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_surveys (
    id bigserial NOT NULL,
    title text NOT NULL,
    xtext text
);


--
-- TOC entry 41 (OID 6218208)
-- Name: st_surveys; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_surveys FROM PUBLIC;
GRANT SELECT ON TABLE st_surveys TO PUBLIC;


--
-- TOC entry 42 (OID 6218216)
-- Name: st_surv_design; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_surv_design (
    id bigserial NOT NULL,
    surv_id bigint NOT NULL,
    "type" text NOT NULL,
    value1 text,
    value2 text,
    qu_text text
);


--
-- TOC entry 43 (OID 6218216)
-- Name: st_surv_design; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_surv_design FROM PUBLIC;
GRANT SELECT ON TABLE st_surv_design TO PUBLIC;


--
-- TOC entry 44 (OID 6218222)
-- Name: st_surv2types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_surv2types (
    surv_id bigint NOT NULL,
    type_id bigint NOT NULL
);


--
-- TOC entry 45 (OID 6218222)
-- Name: st_surv2types; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_surv2types FROM PUBLIC;
GRANT SELECT ON TABLE st_surv2types TO PUBLIC;


--
-- TOC entry 46 (OID 6218224)
-- Name: st_surv_answ; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_surv_answ (
    fault_id bigint NOT NULL,
    surv_id bigint NOT NULL,
    qu_id bigint NOT NULL,
    answer text
);


--
-- TOC entry 47 (OID 6218224)
-- Name: st_surv_answ; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_surv_answ FROM PUBLIC;
REVOKE ALL ON TABLE st_surv_answ FROM postgres;
GRANT INSERT,RULE,UPDATE,DELETE,REFERENCES,TRIGGER ON TABLE st_surv_answ TO postgres;
GRANT SELECT ON TABLE st_surv_answ TO theodore;
GRANT SELECT ON TABLE st_surv_answ TO hada;
GRANT INSERT,SELECT ON TABLE st_surv_answ TO GROUP clients;
GRANT SELECT,DELETE ON TABLE st_surv_answ TO GROUP techs_mc;


--
-- TOC entry 48 (OID 6218229)
-- Name: st_comp_ftypes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_comp_ftypes (
    comp_id bigint NOT NULL,
    faulttype_id bigint NOT NULL
);


--
-- TOC entry 49 (OID 6218229)
-- Name: st_comp_ftypes; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_comp_ftypes FROM PUBLIC;
GRANT SELECT ON TABLE st_comp_ftypes TO PUBLIC;
GRANT ALL ON TABLE st_comp_ftypes TO GROUP techs_mc;


--
-- TOC entry 50 (OID 6218233)
-- Name: st_c_faults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_faults (
    id bigserial NOT NULL,
    shortdescr text NOT NULL,
    start_time timestamp without time zone NOT NULL,
    end_time timestamp without time zone,
    logged_by_user_id integer NOT NULL,
    closed_by_user_id integer,
    companylocation_id integer NOT NULL,
    faulttype_id integer,
    rma_num text,
    tac_num text,
    survey_done boolean NOT NULL,
    confidential boolean NOT NULL DEFAULT 'f'
);


--
-- TOC entry 51 (OID 6218233)
-- Name: st_c_faults; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faults FROM PUBLIC;
GRANT INSERT ON TABLE st_c_faults TO GROUP techs_mc;


--
-- TOC entry 121 (OID 6218233)
-- Name: st_c_faults_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faults_id_seq FROM PUBLIC;


--
-- TOC entry 52 (OID 6218241)
-- Name: st_c_faultslevellog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_faultslevellog (
    id bigserial NOT NULL,
    change_time timestamp without time zone NOT NULL,
    faultlevel_id integer NOT NULL,
    changed_by_user_id integer NOT NULL,
    fault_id bigint NOT NULL
);


--
-- TOC entry 53 (OID 6218241)
-- Name: st_c_faultslevellog; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultslevellog FROM PUBLIC;
GRANT INSERT ON TABLE st_c_faultslevellog TO GROUP techs_mc;


--
-- TOC entry 123 (OID 6218241)
-- Name: st_c_faultslevellog_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultslevellog_id_seq FROM PUBLIC;


--
-- TOC entry 54 (OID 6218246)
-- Name: st_c_faultsmsglog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_faultsmsglog (
    id bigserial NOT NULL,
    description text NOT NULL,
    log_time timestamp without time zone NOT NULL,
    logged_by_user_id integer NOT NULL,
    fault_id bigint NOT NULL
);


--
-- TOC entry 55 (OID 6218246)
-- Name: st_c_faultsmsglog; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultsmsglog FROM PUBLIC;
GRANT INSERT ON TABLE st_c_faultsmsglog TO GROUP techs_mc;


--
-- TOC entry 125 (OID 6218246)
-- Name: st_c_faultsmsglog_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultsmsglog_id_seq FROM PUBLIC;


--
-- TOC entry 56 (OID 6218254)
-- Name: st_c_faultsstatuslog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_faultsstatuslog (
    id bigserial NOT NULL,
    change_time timestamp without time zone NOT NULL,
    fault_id bigint NOT NULL,
    faultstatus_id integer NOT NULL,
    changed_by_user_id integer NOT NULL
);


--
-- TOC entry 57 (OID 6218254)
-- Name: st_c_faultsstatuslog; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultsstatuslog FROM PUBLIC;
GRANT INSERT ON TABLE st_c_faultsstatuslog TO GROUP techs_mc;


--
-- TOC entry 127 (OID 6218254)
-- Name: st_c_faultsstatuslog_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultsstatuslog_id_seq FROM PUBLIC;


--
-- TOC entry 58 (OID 6218259)
-- Name: st_c_faultstechs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_faultstechs (
    id bigserial NOT NULL,
    assign_time timestamp without time zone NOT NULL,
    assigned_by_user_id integer NOT NULL,
    assigned_to_user_id integer NOT NULL,
    fault_id bigint NOT NULL
);


--
-- TOC entry 59 (OID 6218259)
-- Name: st_c_faultstechs; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultstechs FROM PUBLIC;
GRANT INSERT ON TABLE st_c_faultstechs TO GROUP techs_mc;


--
-- TOC entry 129 (OID 6218259)
-- Name: st_c_faultstechs_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faultstechs_id_seq FROM PUBLIC;


--
-- TOC entry 60 (OID 6218262)
-- Name: st_c_faults_users_rel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_faults_users_rel (
    fault_id bigint NOT NULL,
    user_id integer NOT NULL,
    write_perm boolean
);


--
-- TOC entry 61 (OID 6218262)
-- Name: st_c_faults_users_rel; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_faults_users_rel FROM PUBLIC;
GRANT INSERT ON TABLE st_c_faults_users_rel TO GROUP techs_mc;


--
-- TOC entry 62 (OID 6218264)
-- Name: st_c_surv_answ; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_surv_answ (
    fault_id bigint NOT NULL,
    surv_id bigint NOT NULL,
    qu_id bigint NOT NULL,
    answer text
);


--
-- TOC entry 63 (OID 6218264)
-- Name: st_c_surv_answ; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_surv_answ FROM PUBLIC;
REVOKE ALL ON TABLE st_c_surv_answ FROM postgres;
GRANT INSERT,RULE,UPDATE,DELETE,REFERENCES,TRIGGER ON TABLE st_c_surv_answ TO postgres;
GRANT INSERT ON TABLE st_c_surv_answ TO GROUP techs_mc;


--
-- TOC entry 64 (OID 6218275)
-- Name: st_cancelled_by; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_cancelled_by (
    id bigserial NOT NULL,
    fault_id bigserial NOT NULL,
    cancelled_by bigserial NOT NULL
);


--
-- TOC entry 65 (OID 6218275)
-- Name: st_cancelled_by; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_cancelled_by FROM PUBLIC;
GRANT INSERT ON TABLE st_cancelled_by TO GROUP techs_mc;


--
-- TOC entry 131 (OID 6218275)
-- Name: st_cancelled_by_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_cancelled_by_id_seq FROM PUBLIC;
GRANT ALL ON TABLE st_cancelled_by_id_seq TO PUBLIC;


--
-- TOC entry 209 (OID 6218280)
-- Name: cancel_fault (bigint); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION cancel_fault (bigint) RETURNS integer
    AS '
	DECLARE
		sr_id ALIAS FOR $1;
		surv_answ_rec RECORD;
		faultstechs_rec RECORD;
		faultsstatuslog_rec RECORD;
		faultsmsglog_rec RECORD;
		faultslevellog_rec RECORD;
		faults_users_rel_rec RECORD;
		faults_files_rec RECORD;
		faults_rec RECORD;
		mail_alerts_rec RECORD;
	BEGIN
	/* 
		This procedure will move all fault data related to a 
		specific fault to the corresponding st_c_* tables, thus
		cancelling the fault.

		Artist: Theodore J. Soldatos
	*/

		-- Move the fault record, needed for the others.
		FOR faults_rec IN SELECT * FROM st_faults WHERE id = sr_id LOOP
			INSERT INTO st_c_faults(id, shortdescr, start_time, end_time, logged_by_user_id, closed_by_user_id, companylocation_id, faulttype_id, rma_num, tac_num, survey_done, report_timestamp, responce_timestamp, recovery_timestamp, sla_actions, sla_fail_comments, confidential) 
			VALUES(faults_rec.id, faults_rec.shortdescr, faults_rec.start_time, faults_rec.end_time, faults_rec.logged_by_user_id, faults_rec.closed_by_user_id, faults_rec.companylocation_id, faults_rec.faulttype_id, faults_rec.rma_num, faults_rec.tac_num, faults_rec.survey_done, faults_rec.report_timestamp, faults_rec.responce_timestamp, faults_rec.recovery_timestamp, faults_rec.sla_actions, faults_rec.sla_fail_comments, faults_rec.confidential);

		END LOOP;

		-- First, move survey answers.
		FOR surv_answ_rec IN SELECT * FROM st_surv_answ WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_surv_answ(fault_id, surv_id, qu_id, answer)
			VALUES(surv_answ_rec.fault_id, surv_answ_rec.surv_id, surv_answ_rec.qu_id, surv_answ_rec.answer);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_surv_answ WHERE fault_id = sr_id;

		-- Move tech log
		FOR faultstechs_rec IN SELECT * FROM st_faultstechs WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultstechs(id, assign_time, assigned_by_user_id, assigned_to_user_id, fault_id) 
			VALUES(faultstechs_rec.id, faultstechs_rec.assign_time, faultstechs_rec.assigned_by_user_id, faultstechs_rec.assigned_to_user_id, faultstechs_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultstechs WHERE fault_id = sr_id;

		-- Move status log
		FOR faultsstatuslog_rec IN SELECT * FROM st_faultsstatuslog WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultsstatuslog(id, change_time, fault_id, faultstatus_id, changed_by_user_id)
			VALUES(faultsstatuslog_rec.id, faultsstatuslog_rec.change_time, faultsstatuslog_rec.fault_id, faultsstatuslog_rec.faultstatus_id, faultsstatuslog_rec.changed_by_user_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultsstatuslog WHERE fault_id = sr_id;

		-- Message log
		FOR faultsmsglog_rec IN SELECT * FROM st_faultsmsglog WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultsmsglog(id, description, log_time, logged_by_user_id, fault_id)
			VALUES(faultsmsglog_rec.id, faultsmsglog_rec.description, faultsmsglog_rec.log_time, faultsmsglog_rec.logged_by_user_id, faultsmsglog_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultsmsglog WHERE fault_id = sr_id;

		-- Level change log
		FOR faultslevellog_rec IN SELECT * FROM st_faultslevellog WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultslevellog(id, change_time, faultlevel_id, changed_by_user_id, fault_id)
			VALUES(faultslevellog_rec.id, faultslevellog_rec.change_time, faultslevellog_rec.faultlevel_id, faultslevellog_rec.changed_by_user_id, faultslevellog_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultslevellog WHERE fault_id = sr_id;

		-- Related users 
		FOR faults_users_rel_rec IN SELECT * FROM st_faults_users_rel WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faults_users_rel(fault_id, user_id, write_perm)
			VALUES(faults_users_rel_rec.fault_id, faults_users_rel_rec.user_id, faults_users_rel_rec.write_perm);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faults_users_rel WHERE fault_id = sr_id;

		-- File records 
		FOR faults_files_rec IN SELECT * FROM st_files WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_files(id, filename, realfilename, size, added_by, removed_by, insert_time, delete_time, comments, fault_id)
			VALUES(faults_files_rec.id, faults_files_rec.filename, faults_files_rec.realfilename, faults_files_rec.size, faults_files_rec.added_by, faults_files_rec.removed_by, faults_files_rec.insert_time, faults_files_rec.delete_time, faults_files_rec.comments, faults_files_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_files WHERE fault_id = sr_id;

		-- Mail Log records 
		FOR mail_alerts_rec IN SELECT * FROM st_mail_alerts WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_mail_alerts(fault_id, last_mailx, last_tm_mailx, last_dm_mailx, last_am_mailx, last_gm_mailx)
			VALUES(mail_alerts_rec.fault_id, mail_alerts_rec.last_mailx, mail_alerts_rec.last_tm_mailx, mail_alerts_rec.last_dm_mailx, mail_alerts_rec.last_am_mailx, mail_alerts_rec.last_gm_mailx);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_mail_alerts WHERE fault_id = sr_id;

		-- Now delete the fault itself.
		DELETE FROM st_faults WHERE id = sr_id;
		
		RETURN 0;
	END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 66 (OID 6218283)
-- Name: st_status_of_fault; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_status_of_fault AS
    SELECT f.id, fs.faultstatus_id, s.name FROM ((st_faults f JOIN st_faultsstatuslog fs ON ((fs.fault_id = f.id))) JOIN st_faultstatus s ON ((fs.faultstatus_id = s.id))) WHERE (fs.change_time = (SELECT max(st_faultsstatuslog.change_time) AS max FROM st_faultsstatuslog WHERE (st_faultsstatuslog.fault_id = f.id)));


--
-- TOC entry 67 (OID 6218283)
-- Name: st_status_of_fault; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_status_of_fault FROM PUBLIC;
GRANT SELECT ON TABLE st_status_of_fault TO PUBLIC;


--
-- TOC entry 68 (OID 6218286)
-- Name: st_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_files (
    id bigserial NOT NULL,
    filename text NOT NULL,
    realfilename text NOT NULL,
    size bigint NOT NULL,
    added_by integer NOT NULL,
    removed_by integer,
    insert_time timestamp without time zone NOT NULL,
    delete_time timestamp without time zone,
    comments text,
    fault_id bigint NOT NULL
);


--
-- TOC entry 69 (OID 6218286)
-- Name: st_files; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_files FROM PUBLIC;
GRANT INSERT,SELECT,UPDATE ON TABLE st_files TO PUBLIC;
GRANT DELETE ON TABLE st_files TO GROUP techs_mc;


--
-- TOC entry 135 (OID 6218286)
-- Name: st_files_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_files_id_seq FROM PUBLIC;
GRANT ALL ON TABLE st_files_id_seq TO PUBLIC;


--
-- TOC entry 70 (OID 6218294)
-- Name: st_c_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_files (
    id bigserial NOT NULL,
    filename text NOT NULL,
    realfilename text NOT NULL,
    size bigint NOT NULL,
    added_by integer NOT NULL,
    removed_by integer,
    insert_time timestamp without time zone NOT NULL,
    delete_time timestamp without time zone,
    comments text,
    fault_id bigint NOT NULL
);


--
-- TOC entry 71 (OID 6218294)
-- Name: st_c_files; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_files FROM PUBLIC;
GRANT INSERT ON TABLE st_c_files TO GROUP techs_mc;


--
-- TOC entry 137 (OID 6218294)
-- Name: st_c_files_id_seq; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_files_id_seq FROM PUBLIC;


--
-- TOC entry 72 (OID 6218302)
-- Name: st_tech_of_fault; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_tech_of_fault AS
    SELECT f.id, ft.assigned_to_user_id, u.fullname FROM ((st_faults f JOIN st_faultstechs ft ON ((ft.fault_id = f.id))) JOIN st_users u ON ((ft.assigned_to_user_id = u.id))) WHERE (ft.assign_time = (SELECT max(st_faultstechs.assign_time) AS max FROM st_faultstechs WHERE (st_faultstechs.fault_id = f.id)));


--
-- TOC entry 73 (OID 6218302)
-- Name: st_tech_of_fault; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_tech_of_fault FROM PUBLIC;
GRANT SELECT ON TABLE st_tech_of_fault TO PUBLIC;


--
-- TOC entry 74 (OID 6218306)
-- Name: st_faults_companies_v; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_faults_companies_v AS
    SELECT f.id, l.company_id, c.name FROM ((st_faults f JOIN st_companieslocations l ON ((f.companylocation_id = l.id))) JOIN st_companies c ON ((l.company_id = c.id)));


--
-- TOC entry 75 (OID 6218306)
-- Name: st_faults_companies_v; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_faults_companies_v FROM PUBLIC;
GRANT SELECT ON TABLE st_faults_companies_v TO PUBLIC;


--
-- TOC entry 76 (OID 6218309)
-- Name: st_level_of_fault; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_level_of_fault AS
    SELECT f.id, fl.faultlevel_id, l.name FROM ((st_faults f JOIN st_faultslevellog fl ON ((fl.fault_id = f.id))) JOIN st_faultlevels l ON ((fl.faultlevel_id = l.id))) WHERE (fl.change_time = (SELECT max(st_faultslevellog.change_time) AS max FROM st_faultslevellog WHERE (st_faultslevellog.fault_id = f.id)));


--
-- TOC entry 77 (OID 6218309)
-- Name: st_level_of_fault; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_level_of_fault FROM PUBLIC;
GRANT SELECT ON TABLE st_level_of_fault TO PUBLIC;


--
-- TOC entry 78 (OID 6218311)
-- Name: st_mail_alerts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_mail_alerts (
    fault_id bigint NOT NULL,
    last_mailx timestamp without time zone,
    last_dm_mailx timestamp without time zone,
    last_tm_mailx timestamp without time zone,
    last_am_mailx timestamp without time zone,
    last_gm_mailx timestamp without time zone
);


--
-- TOC entry 79 (OID 6218311)
-- Name: st_mail_alerts; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_mail_alerts FROM PUBLIC;
GRANT SELECT ON TABLE st_mail_alerts TO PUBLIC;


--
-- TOC entry 80 (OID 6218315)
-- Name: st_fpt; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_fpt AS
    SELECT count(f.*) AS sr_count, tf.assigned_to_user_id AS user_id FROM (st_faults f JOIN st_tech_of_fault tf ON ((f.id = tf.id))) WHERE (f.end_time IS NULL) GROUP BY tf.assigned_to_user_id;


--
-- TOC entry 81 (OID 6218315)
-- Name: st_fpt; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_fpt FROM PUBLIC;
GRANT SELECT ON TABLE st_fpt TO PUBLIC;


--
-- TOC entry 82 (OID 6218316)
-- Name: st_c_mail_alerts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_c_mail_alerts (
    fault_id bigint NOT NULL,
    last_mailx timestamp without time zone,
    last_dm_mailx timestamp without time zone,
    last_tm_mailx timestamp without time zone,
    last_am_mailx timestamp without time zone,
    last_gm_mailx timestamp without time zone
);


--
-- TOC entry 83 (OID 6218316)
-- Name: st_c_mail_alerts; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_c_mail_alerts FROM PUBLIC;
GRANT INSERT ON TABLE st_c_mail_alerts TO GROUP techs_mc;


--
-- TOC entry 84 (OID 6218320)
-- Name: st_user_company_id_v; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW st_user_company_id_v AS
    SELECT u.id AS user_id, u.username, c.id AS company_id, c.name AS companyname, u.fullname, u.active FROM st_users u, st_companieslocations l, st_companies c WHERE ((u.companylocation_id = l.id) AND (c.id = l.company_id));


--
-- TOC entry 85 (OID 6218320)
-- Name: st_user_company_id_v; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_user_company_id_v FROM PUBLIC;
GRANT SELECT ON TABLE st_user_company_id_v TO PUBLIC;


--
-- TOC entry 210 (OID 6218321)
-- Name: null_to_zero (bigint); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION null_to_zero (bigint) RETURNS bigint
    AS '
	DECLARE 
		inp ALIAS FOR $1;
		toret bigint;
	BEGIN
		IF inp IS NULL THEN 
			RETURN 0;
		ELSE 
			RETURN inp;
		END IF;
	END;	
'
    LANGUAGE plpgsql IMMUTABLE;


--
-- TOC entry 86 (OID 6218322)
-- Name: st_sreports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_sreports (
    srep_id bigint NOT NULL,
    fault_id bigint NOT NULL,
    added_by integer NOT NULL,
    onsitecse integer NOT NULL,
    start_time timestamp without time zone NOT NULL,
    end_time timestamp without time zone NOT NULL
);


--
-- TOC entry 87 (OID 6218322)
-- Name: st_sreports; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_sreports FROM PUBLIC;
GRANT INSERT,SELECT,UPDATE ON TABLE st_sreports TO GROUP techs;
GRANT INSERT,SELECT,UPDATE ON TABLE st_sreports TO GROUP techs_mc;


--
-- TOC entry 88 (OID 6218324)
-- Name: st_mailprefs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_mailprefs (
    user_id integer NOT NULL,
    newlogentry boolean DEFAULT 't' NOT NULL,
    severchange boolean DEFAULT 't' NOT NULL,
    statuschang boolean DEFAULT 't' NOT NULL,
    techassignm boolean DEFAULT 't' NOT NULL,
    closedfault boolean DEFAULT 't' NOT NULL,
    addnewfault boolean DEFAULT 't' NOT NULL,
    relusersadd boolean DEFAULT 't' NOT NULL,
    relusersrem boolean DEFAULT 't' NOT NULL,
    filesupload boolean DEFAULT 't' NOT NULL
);


--
-- TOC entry 89 (OID 6218324)
-- Name: st_mailprefs; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_mailprefs FROM PUBLIC;
GRANT ALL ON TABLE st_mailprefs TO PUBLIC;


--
-- TOC entry 90 (OID 6328936)
-- Name: st_srepxtra; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_srepxtra (
    tr_id bigserial NOT NULL,
    srep_id bigint,
    start_time timestamp without time zone NOT NULL,
    end_time timestamp without time zone NOT NULL
);


--
-- TOC entry 91 (OID 6750602)
-- Name: st_f2f; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE st_f2f (
    source_fault_id bigint NOT NULL,
    target_fault_id bigint NOT NULL
);


--
-- TOC entry 92 (OID 6750602)
-- Name: st_f2f; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE st_f2f FROM PUBLIC;
GRANT INSERT,SELECT,DELETE ON TABLE st_f2f TO PUBLIC;


--
-- Data for TOC entry 211 (OID 6218071)
-- Name: zs_tableinfo; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY zs_tableinfo (tablename, gr_tablename, cgi_string, is_param, form_title, do_upd, do_ins, do_del) FROM stdin;
st_faultlevels	Severity Levels	\N	t	Severity Levels	t	t	t
zs_tableinfo	Table info	\N	t	Table info (System)	t	t	t
zs_columninfo	Column info	\N	t	Column info (System)	t	t	t
st_faultstatus	SR status types	\N	t	SR status types	t	t	t
st_faulttypes	SR types	\N	t	SR types	t	t	t
zs_menus	Menu entries	\N	f	Menu entries	t	t	t
st_userlevels	User Categories	\N	t	User Categories	t	t	t
\.


--
-- Data for TOC entry 212 (OID 6218076)
-- Name: zs_columninfo; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY zs_columninfo (tablename, columnname, gr_columnname, do_use, ordernum, is_search) FROM stdin;
st_faultlevels	id	ID	t	1	t
st_faultstatus	id	ID	t	1	t
st_faulttypes	id	ID	t	1	t
zs_tableinfo	tablename	Table Name	t	1	t
zs_tableinfo	gr_tablename	Displayed table name	t	2	t
zs_tableinfo	is_param	Is it parameter?	t	4	t
zs_tableinfo	form_title	Form title	t	5	t
zs_tableinfo	do_upd	Changes?	t	6	t
zs_tableinfo	do_ins	Inserts?	t	7	t
zs_tableinfo	do_del	Deletes?	t	8	t
zs_columninfo	tablename	Table name	t	1	t
zs_columninfo	columnname	Column name	t	2	t
zs_columninfo	gr_columnname	Displayed name	t	3	t
zs_columninfo	do_use	Use?	t	4	t
zs_columninfo	ordernum	Order	t	5	t
zs_columninfo	is_search	Search?	t	6	t
zs_tableinfo	cgi_string	CGI string	t	3	t
st_faultlevels	name	Name	t	2	t
st_faultstatus	name	Name	t	2	t
st_faulttypes	name	Name	t	2	t
st_faultlevels	description	Description	t	3	t
st_faultstatus	description	Description	t	3	t
st_faulttypes	description	Description	t	3	t
zs_menus	id	ID	t	1	t
zs_menus	parent	Parent	t	2	t
zs_menus	description	Description	t	3	t
zs_menus	url	URL	t	4	t
zs_menus	orderby	Order	t	5	t
zs_menus	vfg	Valid Groups	t	\N	t
st_faulttypes	annoyscse	Annow SCSE	t	4	t
st_faulttypes	confidential_bd	Confidential by default ?	t	7	t
st_faulttypes	alertmails	Mail Alerts ?	t	5	t
st_faultlevels	mail_interval_1	1st scse mail interval	t	4	t
st_faultlevels	mail_interval_x	scse mail interval	t	5	t
st_faultlevels	dm_mail_interval_x	dm mail interval	t	6	t
st_faultlevels	dm_mail_interval_1	1st dm mail interval	t	7	t
st_faultlevels	tm_mail_interval_1	1st tm mail interval	t	8	t
st_faultlevels	tm_mail_interval_x	tm mail interval	t	9	t
st_faultlevels	am_mail_interval_x	ac mail interval	t	10	t
st_faultlevels	am_mail_interval_1	1st ac mail interval	t	11	t
st_faultlevels	gm_mail_interval_1	1st gm mail interval	t	12	t
st_faultlevels	gm_mail_interval_x	gm mail interval	t	13	t
st_userlevels	id	ID	t	1	t
st_userlevels	name	Name	t	2	t
st_userlevels	client	client	t	3	t
st_userlevels	technician	technician	t	4	t
st_userlevels	admin	admin	t	5	t
st_userlevels	pg_groupname	pg_groupname	t	6	t
\.


--
-- Data for TOC entry 213 (OID 6218083)
-- Name: zs_menus; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY zs_menus (id, parent, description, url, orderby, vfg) FROM stdin;
2	0	Parameters	\N	99	\N
147	0	Companies	\N	10	{103,104}
143	0	Service Requests	\N	0	{100,101,102,103,104}
145	143	Service Requests directory	/cgi-bin/stunt/st_faults.pl?2	5	{100,101,102,103,104}
149	2	Severity levels	/cgi-bin/stunt//st_unitbound.pl?st_faultlevels	1	{104}
151	2	SR types	/cgi-bin/stunt//st_unitbound.pl?st_faulttypes	3	{104}
154	140	SR types/users matrix	/cgi-bin/stunt/st_ftusermatrix.pl	3	{103,104}
155	140	Mail preferences	/cgi-bin/stunt/st_faults.pl?21+0	4	{100,101,102,103,104}
140	0	User management	\N	98	{100,101,102,103,104}
141	140	User management	/cgi-bin/stunt/st_usermanagement.pl?0	1	{104}
142	140	Change password	/cgi-bin/stunt/st_usermanagement.pl?7	2	{100,101,102,103,104}
148	147	Companies management	/cgi-bin/stunt/st_companies.pl?2	10	{103,104}
152	147	Create company	/cgi-bin/stunt/st_companies.pl?0	5	{103,104}
153	2	System mass mail	/cgi-bin/stunt/st_usermanagement.pl?9	10	{104}
144	143	Create new Service Request	/cgi-bin/stunt/st_faults.pl?0	1	{100,101,102,103,104}
146	143	Service Requests statistics	/cgi-bin/stunt/st_faults.pl?11	99	{100,101,102,103,104}
150	2	SR status management	/cgi-bin/stunt//st_unitbound.pl?st_faultstatus	2	{104}
165	143	Global statistics	\N	100	{103,104}
156	165	SR count per type	/cgi-bin/stunt/st_stats.pl?0+0	10	{103,104}
157	165	SR count per CSE	/cgi-bin/stunt/st_stats.pl?0+1	20	{103,104}
158	165	Elapsed time (24h)	/cgi-bin/stunt/st_stats.pl?0+2	30	{103,104}
159	165	SR count per initial priority	/cgi-bin/stunt/st_stats.pl?0+3	40	{103,104}
160	165	Various statistics	/cgi-bin/stunt/st_stats.pl?0+4	50	{103,104}
161	165	Opened SRs per user	/cgi-bin/stunt/st_stats.pl?0+5	60	{103,104}
162	165	Opened SRs per company	/cgi-bin/stunt/st_stats.pl?0+6	70	{103,104}
163	165	Elapsed time (working hours)	/cgi-bin/stunt/st_stats.pl?0+7	34	{103,104}
164	165	Elapsed time (outside working hours)	/cgi-bin/stunt/st_stats.pl?0+8	38	{103,104}
166	165	SLA compliance summary	/cgi-bin/stunt/st_stats.pl?0+9	39	{103,104}
\.


--
-- Data for TOC entry 214 (OID 6218090)
-- Name: zs_menus_favorites; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY zs_menus_favorites (zs_menus_id, username) FROM stdin;
\.


--
-- Data for TOC entry 215 (OID 6218099)
-- Name: st_companies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_companies (id, name, comments, active) FROM stdin;
\.


--
-- Data for TOC entry 216 (OID 6218108)
-- Name: st_userlevels; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_userlevels (id, name, client, technician, admin, pg_groupname) FROM stdin;
0	Default User Type	t	t	t	Default
1	Non technical non client user	f	t	t	Sales
2	Non technical, full access	f	t	t	Management
\.


--
-- Data for TOC entry 217 (OID 6218116)
-- Name: st_faultstatus; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faultstatus (id, name, description) FROM stdin;
0	Unassigned	Default status for new service requests.
-1	Closed	When SR is closed.
1	CSE response pending	Waiting for CSE to respond
10	Customer response pending	Waiting for customer to respond.
\.


--
-- Data for TOC entry 218 (OID 6218124)
-- Name: st_faultlevels; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faultlevels (id, name, description, mail_interval_1, mail_interval_x, dm_mail_interval_1, dm_mail_interval_x, tm_mail_interval_1, tm_mail_interval_x, am_mail_interval_1, am_mail_interval_x, gm_mail_interval_1, gm_mail_interval_x) FROM stdin;
20	Average (3)	\N	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00
30	Low (4)	\N	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00
40	Tracking (5)	\N	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00	00:00
0	Critical (1)	\N	01:00	04:00	01:00	04:00	04:00	08:00	01:00	04:00	08:00	1 day
10	High (2)	\N	04:00	08:00	04:00	08:00	08:00	08:00	04:00	08:00	1 day	1 day
\.


--
-- Data for TOC entry 219 (OID 6218132)
-- Name: st_companieslocations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_companieslocations (id, name, description, address1, address2, address3, phone1, phone2, fax, comments, contact_info, active, main_location, company_id) FROM stdin;
\.


--
-- Data for TOC entry 220 (OID 6218142)
-- Name: st_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_users (id, username, fullname, client, technician, admin, email, phone1, phone2, fax, active, main_contact, userlevel_id, companylocation_id, ldapdn) FROM stdin;
2	postgres	Administrator	t	t	t	noc@yourcompany.example	11111111	2222222	3333333	t	t	0	1	\N
\.


--
-- Data for TOC entry 221 (OID 6218152)
-- Name: st_faults; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faults (id, shortdescr, start_time, end_time, logged_by_user_id, closed_by_user_id, companylocation_id, faulttype_id, rma_num, tac_num, survey_done) FROM stdin;
\.


--
-- Data for TOC entry 222 (OID 6218160)
-- Name: st_faultsmsglog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faultsmsglog (id, description, log_time, logged_by_user_id, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 223 (OID 6218168)
-- Name: st_faultstechs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faultstechs (id, assign_time, assigned_by_user_id, assigned_to_user_id, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 224 (OID 6218173)
-- Name: st_faultsstatuslog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faultsstatuslog (id, change_time, fault_id, faultstatus_id, changed_by_user_id) FROM stdin;
\.


--
-- Data for TOC entry 225 (OID 6218178)
-- Name: st_faultslevellog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faultslevellog (id, change_time, faultlevel_id, changed_by_user_id, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 226 (OID 6218183)
-- Name: st_faulttypes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faulttypes (id, name, description, annoyscse, alertmails) FROM stdin;
1	Software - OS	\N	f	f
2	Software - Application	\N	f	f
3	Hardware - Router	\N	f	f
4	Hardware - Switch	\N	f	f
5	Hardware - Server	\N	f	f
7	Cabling	\N	f	f
6	Hardware - PC	\N	f	f
\.


--
-- Data for TOC entry 227 (OID 6218193)
-- Name: st_faults_users_rel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_faults_users_rel (fault_id, user_id, write_perm) FROM stdin;
\.


--
-- Data for TOC entry 228 (OID 6218198)
-- Name: st_techsmc_faulttypes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_techsmc_faulttypes (user_id, faulttype_id, scse, duty_m, techn_m, acc_m, general_m) FROM stdin;
\.


--
-- Data for TOC entry 229 (OID 6218208)
-- Name: st_surveys; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_surveys (id, title, xtext) FROM stdin;
1	Sample satisfaction survey	Dear customer,
\.


--
-- Data for TOC entry 230 (OID 6218216)
-- Name: st_surv_design; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_surv_design (id, surv_id, "type", value1, value2, qu_text) FROM stdin;
1	1	num	1	5	Overall handling of case
2	1	txt	3	50	Comments about Overall handling of case
3	1	num	1	5	Ease of Access to help
4	1	txt	3	50	Comments about Ease of Access to help
5	1	num	1	5	Timeliness of Problem Resolution
6	1	txt	3	50	Comments about Timeliness of Problem Resolution
7	1	num	1	5	Communication of Problem Status
8	1	txt	3	50	Comments about Communication of Problem Status
9	1	num	1	5	Effectiveness of Solution/Info
10	1	txt	3	50	Comments about Effectiveness of Solution/Info
11	1	num	1	5	Technical Expertise of Engineer
12	1	txt	3	50	Comments about Technical Expertise of Engineer
13	1	num	1	5	Courteous Service
14	1	txt	3	50	Comments about Courteous Service
15	1	txt	10	50	Please write any other comments here
\.


--
-- Data for TOC entry 231 (OID 6218222)
-- Name: st_surv2types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_surv2types (surv_id, type_id) FROM stdin;
1	1
1	2
1	3
\.


--
-- Data for TOC entry 232 (OID 6218224)
-- Name: st_surv_answ; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_surv_answ (fault_id, surv_id, qu_id, answer) FROM stdin;
\.


--
-- Data for TOC entry 233 (OID 6218229)
-- Name: st_comp_ftypes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_comp_ftypes (comp_id, faulttype_id) FROM stdin;
\.


--
-- Data for TOC entry 234 (OID 6218233)
-- Name: st_c_faults; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_faults (id, shortdescr, start_time, end_time, logged_by_user_id, closed_by_user_id, companylocation_id, faulttype_id, rma_num, tac_num, survey_done) FROM stdin;
\.


--
-- Data for TOC entry 235 (OID 6218241)
-- Name: st_c_faultslevellog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_faultslevellog (id, change_time, faultlevel_id, changed_by_user_id, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 236 (OID 6218246)
-- Name: st_c_faultsmsglog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_faultsmsglog (id, description, log_time, logged_by_user_id, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 237 (OID 6218254)
-- Name: st_c_faultsstatuslog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_faultsstatuslog (id, change_time, fault_id, faultstatus_id, changed_by_user_id) FROM stdin;
\.


--
-- Data for TOC entry 238 (OID 6218259)
-- Name: st_c_faultstechs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_faultstechs (id, assign_time, assigned_by_user_id, assigned_to_user_id, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 239 (OID 6218262)
-- Name: st_c_faults_users_rel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_faults_users_rel (fault_id, user_id, write_perm) FROM stdin;
\.


--
-- Data for TOC entry 240 (OID 6218264)
-- Name: st_c_surv_answ; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_surv_answ (fault_id, surv_id, qu_id, answer) FROM stdin;
\.


--
-- Data for TOC entry 241 (OID 6218275)
-- Name: st_cancelled_by; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_cancelled_by (id, fault_id, cancelled_by) FROM stdin;
\.


--
-- Data for TOC entry 242 (OID 6218286)
-- Name: st_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_files (id, filename, realfilename, size, added_by, removed_by, insert_time, delete_time, comments, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 243 (OID 6218294)
-- Name: st_c_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_files (id, filename, realfilename, size, added_by, removed_by, insert_time, delete_time, comments, fault_id) FROM stdin;
\.


--
-- Data for TOC entry 244 (OID 6218311)
-- Name: st_mail_alerts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_mail_alerts (fault_id, last_mailx, last_dm_mailx, last_tm_mailx, last_am_mailx, last_gm_mailx) FROM stdin;
\.


--
-- Data for TOC entry 245 (OID 6218316)
-- Name: st_c_mail_alerts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_c_mail_alerts (fault_id, last_mailx, last_dm_mailx, last_tm_mailx, last_am_mailx, last_gm_mailx) FROM stdin;
\.


--
-- Data for TOC entry 246 (OID 6218322)
-- Name: st_sreports; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_sreports (srep_id, fault_id, added_by, onsitecse, start_time, end_time) FROM stdin;
\.


--
-- Data for TOC entry 247 (OID 6218324)
-- Name: st_mailprefs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_mailprefs (user_id, newlogentry, severchange, statuschang, techassignm, closedfault, addnewfault, relusersadd, relusersrem, filesupload) FROM stdin;
\.


--
-- Data for TOC entry 248 (OID 6328936)
-- Name: st_srepxtra; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_srepxtra (tr_id, srep_id, start_time, end_time) FROM stdin;
\.


--
-- Data for TOC entry 249 (OID 6750602)
-- Name: st_f2f; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY st_f2f (source_fault_id, target_fault_id) FROM stdin;
\.


--
-- TOC entry 149 (OID 6220305)
-- Name: st_user_username_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX st_user_username_idx ON st_users USING btree (username);


--
-- TOC entry 173 (OID 6220306)
-- Name: idx_1; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_1 ON st_surv_design USING btree (id);


--
-- TOC entry 151 (OID 6220307)
-- Name: speed_idx_1; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_1 ON st_faults USING btree (logged_by_user_id);


--
-- TOC entry 152 (OID 6220308)
-- Name: speed_idx_2; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_2 ON st_faults USING btree (companylocation_id);


--
-- TOC entry 147 (OID 6220309)
-- Name: speed_idx_3; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_3 ON st_companieslocations USING btree (company_id);


--
-- TOC entry 163 (OID 6220310)
-- Name: speed_idx_4; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_4 ON st_faultslevellog USING btree (fault_id);


--
-- TOC entry 164 (OID 6220311)
-- Name: speed_idx_5; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_5 ON st_faultslevellog USING btree (faultlevel_id);


--
-- TOC entry 165 (OID 6220312)
-- Name: speed_idx_6; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_6 ON st_faultslevellog USING btree (change_time);


--
-- TOC entry 159 (OID 6220313)
-- Name: speed_idx_7; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_7 ON st_faultsstatuslog USING btree (fault_id);


--
-- TOC entry 160 (OID 6220314)
-- Name: speed_idx_8; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_8 ON st_faultsstatuslog USING btree (faultstatus_id);


--
-- TOC entry 161 (OID 6220315)
-- Name: speed_idx_9; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_9 ON st_faultsstatuslog USING btree (change_time);


--
-- TOC entry 155 (OID 6220316)
-- Name: speed_idx_10; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_10 ON st_faultstechs USING btree (fault_id);


--
-- TOC entry 156 (OID 6220317)
-- Name: speed_idx_11; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_11 ON st_faultstechs USING btree (assigned_to_user_id);


--
-- TOC entry 157 (OID 6220318)
-- Name: speed_idx_12; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_12 ON st_faultstechs USING btree (assign_time);


--
-- TOC entry 168 (OID 6220319)
-- Name: speed_idx_13; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_13 ON st_faults_users_rel USING btree (fault_id);


--
-- TOC entry 169 (OID 6220320)
-- Name: speed_idx_14; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX speed_idx_14 ON st_faults_users_rel USING btree (user_id);


--
-- TOC entry 188 (OID 6220321)
-- Name: st_ma1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX st_ma1_idx ON st_mail_alerts USING btree (fault_id, last_mailx);


--
-- TOC entry 189 (OID 6220322)
-- Name: st_ma2_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX st_ma2_idx ON st_mail_alerts USING btree (fault_id, last_dm_mailx);


--
-- TOC entry 190 (OID 6220323)
-- Name: st_ma3_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX st_ma3_idx ON st_mail_alerts USING btree (fault_id, last_tm_mailx);


--
-- TOC entry 191 (OID 6220324)
-- Name: st_ma4_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX st_ma4_idx ON st_mail_alerts USING btree (fault_id, last_am_mailx);


--
-- TOC entry 192 (OID 6220325)
-- Name: st_ma5_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX st_ma5_idx ON st_mail_alerts USING btree (fault_id, last_gm_mailx);


--
-- TOC entry 196 (OID 6750614)
-- Name: st_f2f_i1; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX st_f2f_i1 ON st_f2f USING btree (source_fault_id);


--
-- TOC entry 197 (OID 6750615)
-- Name: st_f2f_i2; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX st_f2f_i2 ON st_f2f USING btree (target_fault_id);


--
-- TOC entry 139 (OID 6220342)
-- Name: zs_tableinfo_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY zs_tableinfo
    ADD CONSTRAINT zs_tableinfo_pkey PRIMARY KEY (tablename);


--
-- TOC entry 140 (OID 6220344)
-- Name: zs_columninfo_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY zs_columninfo
    ADD CONSTRAINT zs_columninfo_pkey PRIMARY KEY (tablename, columnname);


--
-- TOC entry 141 (OID 6220346)
-- Name: zs_menus_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY zs_menus
    ADD CONSTRAINT zs_menus_pkey PRIMARY KEY (id);


--
-- TOC entry 142 (OID 6220348)
-- Name: zs_menus_favorites_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY zs_menus_favorites
    ADD CONSTRAINT zs_menus_favorites_pkey PRIMARY KEY (zs_menus_id, username);


--
-- TOC entry 250 (OID 6220350)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY zs_menus_favorites
    ADD CONSTRAINT "$1" FOREIGN KEY (zs_menus_id) REFERENCES zs_menus(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 143 (OID 6220354)
-- Name: st_companies_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_companies
    ADD CONSTRAINT st_companies_pkey PRIMARY KEY (id);


--
-- TOC entry 144 (OID 6220356)
-- Name: st_userlevels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_userlevels
    ADD CONSTRAINT st_userlevels_pkey PRIMARY KEY (id);


--
-- TOC entry 145 (OID 6220358)
-- Name: st_faultstatus_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultstatus
    ADD CONSTRAINT st_faultstatus_pkey PRIMARY KEY (id);


--
-- TOC entry 146 (OID 6220360)
-- Name: st_faultlevels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultlevels
    ADD CONSTRAINT st_faultlevels_pkey PRIMARY KEY (id);


--
-- TOC entry 148 (OID 6220362)
-- Name: st_companieslocations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_companieslocations
    ADD CONSTRAINT st_companieslocations_pkey PRIMARY KEY (id);


--
-- TOC entry 251 (OID 6220364)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_companieslocations
    ADD CONSTRAINT "$1" FOREIGN KEY (company_id) REFERENCES st_companies(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 150 (OID 6220368)
-- Name: st_users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_users
    ADD CONSTRAINT st_users_pkey PRIMARY KEY (id);


--
-- TOC entry 253 (OID 6220370)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_users
    ADD CONSTRAINT "$2" FOREIGN KEY (userlevel_id) REFERENCES st_userlevels(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 252 (OID 6220374)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_users
    ADD CONSTRAINT "$3" FOREIGN KEY (companylocation_id) REFERENCES st_companieslocations(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 153 (OID 6220378)
-- Name: st_faults_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults
    ADD CONSTRAINT st_faults_pkey PRIMARY KEY (id);


--
-- TOC entry 257 (OID 6220380)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults
    ADD CONSTRAINT "$1" FOREIGN KEY (logged_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 154 (OID 6220384)
-- Name: st_faultsmsglog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultsmsglog
    ADD CONSTRAINT st_faultsmsglog_pkey PRIMARY KEY (id);


--
-- TOC entry 259 (OID 6220386)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultsmsglog
    ADD CONSTRAINT "$1" FOREIGN KEY (logged_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 258 (OID 6220390)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultsmsglog
    ADD CONSTRAINT "$2" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 158 (OID 6220394)
-- Name: st_faultstechs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultstechs
    ADD CONSTRAINT st_faultstechs_pkey PRIMARY KEY (id);


--
-- TOC entry 262 (OID 6220396)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultstechs
    ADD CONSTRAINT "$1" FOREIGN KEY (assigned_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 261 (OID 6220400)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultstechs
    ADD CONSTRAINT "$2" FOREIGN KEY (assigned_to_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 260 (OID 6220404)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultstechs
    ADD CONSTRAINT "$3" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 162 (OID 6220408)
-- Name: st_faultsstatuslog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultsstatuslog
    ADD CONSTRAINT st_faultsstatuslog_pkey PRIMARY KEY (id);


--
-- TOC entry 264 (OID 6220410)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultsstatuslog
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 263 (OID 6220414)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultsstatuslog
    ADD CONSTRAINT "$2" FOREIGN KEY (faultstatus_id) REFERENCES st_faultstatus(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 166 (OID 6220418)
-- Name: st_faultslevellog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultslevellog
    ADD CONSTRAINT st_faultslevellog_pkey PRIMARY KEY (id);


--
-- TOC entry 266 (OID 6220420)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultslevellog
    ADD CONSTRAINT "$1" FOREIGN KEY (faultlevel_id) REFERENCES st_faultlevels(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 265 (OID 6220424)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faultslevellog
    ADD CONSTRAINT "$2" FOREIGN KEY (changed_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 167 (OID 6220428)
-- Name: st_faulttypes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faulttypes
    ADD CONSTRAINT st_faulttypes_pkey PRIMARY KEY (id);


--
-- TOC entry 170 (OID 6220430)
-- Name: st_faults_users_rel_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults_users_rel
    ADD CONSTRAINT st_faults_users_rel_pkey PRIMARY KEY (fault_id, user_id);


--
-- TOC entry 268 (OID 6220432)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults_users_rel
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 267 (OID 6220436)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults_users_rel
    ADD CONSTRAINT "$2" FOREIGN KEY (user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 256 (OID 6220440)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults
    ADD CONSTRAINT "$2" FOREIGN KEY (closed_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 255 (OID 6220444)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults
    ADD CONSTRAINT "$3" FOREIGN KEY (companylocation_id) REFERENCES st_companieslocations(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 254 (OID 6220448)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_faults
    ADD CONSTRAINT "$4" FOREIGN KEY (faulttype_id) REFERENCES st_faulttypes(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 171 (OID 6220452)
-- Name: st_techsmc_faulttypes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_techsmc_faulttypes
    ADD CONSTRAINT st_techsmc_faulttypes_pkey PRIMARY KEY (user_id, faulttype_id);


--
-- TOC entry 270 (OID 6220454)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_techsmc_faulttypes
    ADD CONSTRAINT "$1" FOREIGN KEY (user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 269 (OID 6220458)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_techsmc_faulttypes
    ADD CONSTRAINT "$2" FOREIGN KEY (faulttype_id) REFERENCES st_faulttypes(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 172 (OID 6220462)
-- Name: st_surveys_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surveys
    ADD CONSTRAINT st_surveys_pkey PRIMARY KEY (id);


--
-- TOC entry 174 (OID 6220464)
-- Name: st_surv_design_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv_design
    ADD CONSTRAINT st_surv_design_pkey PRIMARY KEY (id, surv_id);


--
-- TOC entry 271 (OID 6220466)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv_design
    ADD CONSTRAINT "$1" FOREIGN KEY (surv_id) REFERENCES st_surveys(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 273 (OID 6220470)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv2types
    ADD CONSTRAINT "$1" FOREIGN KEY (surv_id) REFERENCES st_surveys(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 272 (OID 6220474)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv2types
    ADD CONSTRAINT "$2" FOREIGN KEY (type_id) REFERENCES st_faulttypes(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 176 (OID 6220478)
-- Name: st_surv_answ_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv_answ
    ADD CONSTRAINT st_surv_answ_pkey PRIMARY KEY (fault_id, surv_id, qu_id);


--
-- TOC entry 276 (OID 6220480)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv_answ
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 275 (OID 6220484)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv_answ
    ADD CONSTRAINT "$2" FOREIGN KEY (surv_id) REFERENCES st_surveys(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 274 (OID 6220488)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv_answ
    ADD CONSTRAINT "$3" FOREIGN KEY (qu_id) REFERENCES st_surv_design(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 175 (OID 6220492)
-- Name: st_surv2types_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_surv2types
    ADD CONSTRAINT st_surv2types_pkey PRIMARY KEY (surv_id, type_id);


--
-- TOC entry 177 (OID 6220494)
-- Name: st_comp_ftypes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_comp_ftypes
    ADD CONSTRAINT st_comp_ftypes_pkey PRIMARY KEY (comp_id, faulttype_id);


--
-- TOC entry 278 (OID 6220496)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_comp_ftypes
    ADD CONSTRAINT "$1" FOREIGN KEY (comp_id) REFERENCES st_companies(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 277 (OID 6220500)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_comp_ftypes
    ADD CONSTRAINT "$2" FOREIGN KEY (faulttype_id) REFERENCES st_faulttypes(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 178 (OID 6220504)
-- Name: st_c_faults_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults
    ADD CONSTRAINT st_c_faults_pkey PRIMARY KEY (id);


--
-- TOC entry 282 (OID 6220506)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults
    ADD CONSTRAINT "$1" FOREIGN KEY (logged_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 281 (OID 6220510)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults
    ADD CONSTRAINT "$2" FOREIGN KEY (closed_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 280 (OID 6220514)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults
    ADD CONSTRAINT "$3" FOREIGN KEY (companylocation_id) REFERENCES st_companieslocations(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 279 (OID 6220518)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults
    ADD CONSTRAINT "$4" FOREIGN KEY (faulttype_id) REFERENCES st_faulttypes(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 179 (OID 6220522)
-- Name: st_c_faultslevellog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultslevellog
    ADD CONSTRAINT st_c_faultslevellog_pkey PRIMARY KEY (id);


--
-- TOC entry 284 (OID 6220524)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultslevellog
    ADD CONSTRAINT "$1" FOREIGN KEY (faultlevel_id) REFERENCES st_faultlevels(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 283 (OID 6220528)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultslevellog
    ADD CONSTRAINT "$2" FOREIGN KEY (changed_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 180 (OID 6220532)
-- Name: st_c_faultsmsglog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultsmsglog
    ADD CONSTRAINT st_c_faultsmsglog_pkey PRIMARY KEY (id);


--
-- TOC entry 286 (OID 6220534)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultsmsglog
    ADD CONSTRAINT "$1" FOREIGN KEY (logged_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 285 (OID 6220538)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultsmsglog
    ADD CONSTRAINT "$2" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 181 (OID 6220542)
-- Name: st_c_faultsstatuslog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultsstatuslog
    ADD CONSTRAINT st_c_faultsstatuslog_pkey PRIMARY KEY (id);


--
-- TOC entry 288 (OID 6220544)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultsstatuslog
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 287 (OID 6220548)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultsstatuslog
    ADD CONSTRAINT "$2" FOREIGN KEY (faultstatus_id) REFERENCES st_faultstatus(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 182 (OID 6220552)
-- Name: st_c_faultstechs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultstechs
    ADD CONSTRAINT st_c_faultstechs_pkey PRIMARY KEY (id);


--
-- TOC entry 291 (OID 6220554)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultstechs
    ADD CONSTRAINT "$1" FOREIGN KEY (assigned_by_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 290 (OID 6220558)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultstechs
    ADD CONSTRAINT "$2" FOREIGN KEY (assigned_to_user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 289 (OID 6220562)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faultstechs
    ADD CONSTRAINT "$3" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 183 (OID 6220566)
-- Name: st_c_faults_users_rel_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults_users_rel
    ADD CONSTRAINT st_c_faults_users_rel_pkey PRIMARY KEY (fault_id, user_id);


--
-- TOC entry 293 (OID 6220568)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults_users_rel
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 292 (OID 6220572)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_faults_users_rel
    ADD CONSTRAINT "$2" FOREIGN KEY (user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 184 (OID 6220576)
-- Name: st_c_surv_answ_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_surv_answ
    ADD CONSTRAINT st_c_surv_answ_pkey PRIMARY KEY (fault_id, surv_id, qu_id);


--
-- TOC entry 296 (OID 6220578)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_surv_answ
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 295 (OID 6220582)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_surv_answ
    ADD CONSTRAINT "$2" FOREIGN KEY (surv_id) REFERENCES st_surveys(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 294 (OID 6220586)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_surv_answ
    ADD CONSTRAINT "$3" FOREIGN KEY (qu_id) REFERENCES st_surv_design(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 185 (OID 6220590)
-- Name: st_cancelled_by_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_cancelled_by
    ADD CONSTRAINT st_cancelled_by_pkey PRIMARY KEY (id);


--
-- TOC entry 298 (OID 6220592)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_cancelled_by
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 297 (OID 6220596)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_cancelled_by
    ADD CONSTRAINT "$2" FOREIGN KEY (cancelled_by) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 186 (OID 6220600)
-- Name: st_files_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_files
    ADD CONSTRAINT st_files_pkey PRIMARY KEY (id);


--
-- TOC entry 301 (OID 6220602)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_files
    ADD CONSTRAINT "$1" FOREIGN KEY (added_by) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 300 (OID 6220606)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_files
    ADD CONSTRAINT "$2" FOREIGN KEY (removed_by) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 299 (OID 6220610)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_files
    ADD CONSTRAINT "$3" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 187 (OID 6220614)
-- Name: st_c_files_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_files
    ADD CONSTRAINT st_c_files_pkey PRIMARY KEY (id);


--
-- TOC entry 304 (OID 6220616)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_files
    ADD CONSTRAINT "$1" FOREIGN KEY (added_by) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 303 (OID 6220620)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_files
    ADD CONSTRAINT "$2" FOREIGN KEY (removed_by) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 302 (OID 6220624)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_files
    ADD CONSTRAINT "$3" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 305 (OID 6220628)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_mail_alerts
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 306 (OID 6220632)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_c_mail_alerts
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_c_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 193 (OID 6220636)
-- Name: st_sreports_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_sreports
    ADD CONSTRAINT st_sreports_pkey PRIMARY KEY (srep_id);


--
-- TOC entry 309 (OID 6220638)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_sreports
    ADD CONSTRAINT "$1" FOREIGN KEY (fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 308 (OID 6220642)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_sreports
    ADD CONSTRAINT "$2" FOREIGN KEY (added_by) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 307 (OID 6220646)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_sreports
    ADD CONSTRAINT "$3" FOREIGN KEY (onsitecse) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 194 (OID 6220650)
-- Name: st_mailprefs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_mailprefs
    ADD CONSTRAINT st_mailprefs_pkey PRIMARY KEY (user_id);


--
-- TOC entry 310 (OID 6220652)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_mailprefs
    ADD CONSTRAINT "$1" FOREIGN KEY (user_id) REFERENCES st_users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 195 (OID 6328939)
-- Name: st_srepxtra_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_srepxtra
    ADD CONSTRAINT st_srepxtra_pkey PRIMARY KEY (tr_id);


--
-- TOC entry 311 (OID 6328941)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_srepxtra
    ADD CONSTRAINT "$1" FOREIGN KEY (srep_id) REFERENCES st_sreports(srep_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 198 (OID 6750604)
-- Name: st_f2f_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_f2f
    ADD CONSTRAINT st_f2f_pkey PRIMARY KEY (source_fault_id, target_fault_id);


--
-- TOC entry 313 (OID 6750606)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_f2f
    ADD CONSTRAINT "$1" FOREIGN KEY (source_fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 312 (OID 6750610)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY st_f2f
    ADD CONSTRAINT "$2" FOREIGN KEY (target_fault_id) REFERENCES st_faults(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 314 (OID 6220656)
-- Name: st_companies_1_trigger; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER st_companies_1_trigger
    BEFORE UPDATE ON st_companies
    FOR EACH ROW
    EXECUTE PROCEDURE st_companies_1_triggerfunc ();


--
-- TOC entry 316 (OID 6220658)
-- Name: st_faults_1_trigger; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER st_faults_1_trigger
    BEFORE UPDATE ON st_faults
    FOR EACH ROW
    EXECUTE PROCEDURE st_faults_1_triggerfunc ();

CREATE TRIGGER st_faults_2_trigger
    BEFORE INSERT ON st_faults
    FOR EACH ROW
    EXECUTE PROCEDURE st_faults_2_triggerfunc ();

--
-- TOC entry 315 (OID 6328958)
-- Name: st_users_1_trigger; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER st_users_1_trigger
    BEFORE INSERT OR UPDATE ON st_users
    FOR EACH ROW
    EXECUTE PROCEDURE st_users_1_triggerfunc ();


--
-- TOC entry 93 (OID 6218081)
-- Name: zs_menus_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('zs_menus_id_seq', 155, true);


--
-- TOC entry 94 (OID 6218097)
-- Name: st_companies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_companies_id_seq', 1, true);


--
-- TOC entry 96 (OID 6218106)
-- Name: st_userlevels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_userlevels_id_seq', 4, true);


--
-- TOC entry 98 (OID 6218114)
-- Name: st_faultstatus_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faultstatus_id_seq', 2, true);


--
-- TOC entry 100 (OID 6218122)
-- Name: st_faultlevels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faultlevels_id_seq', 5, true);


--
-- TOC entry 102 (OID 6218130)
-- Name: st_companieslocations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_companieslocations_id_seq', 1, true);


--
-- TOC entry 104 (OID 6218140)
-- Name: st_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_users_id_seq', 3, true);


--
-- TOC entry 106 (OID 6218150)
-- Name: st_faults_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faults_id_seq', 100000, true);


--
-- TOC entry 108 (OID 6218158)
-- Name: st_faultsmsglog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faultsmsglog_id_seq', 1, true);


--
-- TOC entry 110 (OID 6218166)
-- Name: st_faultstechs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faultstechs_id_seq', 1, true);


--
-- TOC entry 112 (OID 6218171)
-- Name: st_faultsstatuslog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faultsstatuslog_id_seq', 1, true);


--
-- TOC entry 114 (OID 6218176)
-- Name: st_faultslevellog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faultslevellog_id_seq', 1, true);


--
-- TOC entry 116 (OID 6218181)
-- Name: st_faulttypes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_faulttypes_id_seq', 10, true);


--
-- TOC entry 118 (OID 6218206)
-- Name: st_surveys_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_surveys_id_seq', 1, true);


--
-- TOC entry 119 (OID 6218214)
-- Name: st_surv_design_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_surv_design_id_seq', 16, true);


--
-- TOC entry 120 (OID 6218231)
-- Name: st_c_faults_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_c_faults_id_seq', 1, false);


--
-- TOC entry 122 (OID 6218239)
-- Name: st_c_faultslevellog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_c_faultslevellog_id_seq', 1, false);


--
-- TOC entry 124 (OID 6218244)
-- Name: st_c_faultsmsglog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_c_faultsmsglog_id_seq', 1, false);


--
-- TOC entry 126 (OID 6218252)
-- Name: st_c_faultsstatuslog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_c_faultsstatuslog_id_seq', 1, false);


--
-- TOC entry 128 (OID 6218257)
-- Name: st_c_faultstechs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_c_faultstechs_id_seq', 1, false);


--
-- TOC entry 130 (OID 6218269)
-- Name: st_cancelled_by_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_cancelled_by_id_seq', 18, true);


--
-- TOC entry 132 (OID 6218271)
-- Name: st_cancelled_by_fault_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_cancelled_by_fault_id_seq', 1, false);


--
-- TOC entry 133 (OID 6218273)
-- Name: st_cancelled_by_cancelled_by_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_cancelled_by_cancelled_by_seq', 1, false);


--
-- TOC entry 134 (OID 6218284)
-- Name: st_files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_files_id_seq', 1, true);


--
-- TOC entry 136 (OID 6218292)
-- Name: st_c_files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_c_files_id_seq', 1, false);


--
-- TOC entry 138 (OID 6328934)
-- Name: st_srepxtra_tr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval ('st_srepxtra_tr_id_seq', 1, true);

CREATE VIEW st_elapsed AS (

SELECT  ((t.assign_time - f.start_time) < CAST('10 min' AS interval)) AS e10min,
        ((t.assign_time - f.start_time) < CAST('30 min' AS interval) AND (t.assign_time - f.start_time) >= CAST('10 min' AS interval)) AS e30min,
        ((t.assign_time - f.start_time) < CAST('1 hour' AS interval) AND (t.assign_time - f.start_time) >= CAST('30 min' AS interval)) AS e1hour,
        ((t.assign_time - f.start_time) >= CAST('1 hour' AS interval)) AS emore,
        f.id, f.faulttype_id, f.start_time
FROM st_faults f INNER JOIN st_faultstechs t ON f.id = t.fault_id WHERE
        ((t.assign_time = (SELECT min(st_faultstechs.assign_time) AS min
        FROM st_faultstechs
        WHERE (st_faultstechs.fault_id = f.id))))

);

GRANT SELECT ON st_elapsed TO PUBLIC;
CREATE VIEW st_init_level_of_fault AS (
        SELECT f.id, fl.faultlevel_id, l.name
        FROM st_faults f INNER JOIN st_faultslevellog fl
                ON fl.fault_id = f.id
        INNER JOIN st_faultlevels l
                ON fl.faultlevel_id = l.id
        WHERE fl.change_time = (
                SELECT min(change_time) FROM st_faultslevellog
                WHERE fault_id = f.id
                )
);

GRANT SELECT ON  st_init_level_of_fault TO PUBLIC;

--
-- DB Changes from 1.1.2 to 1.1.3
--

ALTER TABLE st_faults ADD COLUMN report_timestamp TIMESTAMP;
ALTER TABLE st_faults ADD COLUMN responce_timestamp TIMESTAMP;
ALTER TABLE st_faults ADD COLUMN recovery_timestamp TIMESTAMP;
ALTER TABLE st_faults ADD COLUMN sla_actions TEXT;
ALTER TABLE st_faults ADD COLUMN sla_fail_comments TEXT;
ALTER TABLE st_c_faults ADD COLUMN report_timestamp TIMESTAMP;
ALTER TABLE st_c_faults ADD COLUMN responce_timestamp TIMESTAMP;
ALTER TABLE st_c_faults ADD COLUMN recovery_timestamp TIMESTAMP;
ALTER TABLE st_c_faults ADD COLUMN sla_actions TEXT;
ALTER TABLE st_c_faults ADD COLUMN sla_fail_comments TEXT;
ALTER TABLE st_faulttypes ADD COLUMN manual_dates BOOLEAN;
UPDATE st_faulttypes SET manual_dates = 'f';
ALTER TABLE st_faulttypes ALTER COLUMN manual_dates SET NOT NULL;
ALTER TABLE st_faulttypes ALTER COLUMN manual_dates SET DEFAULT 'f';
INSERT INTO zs_columninfo(tablename, columnname, gr_columnname, do_use, ordernum, is_search) VALUES('st_faulttypes', 'manual_dates', 'Extra Dates', 't', '6', 't');
ALTER TABLE st_companies ADD COLUMN user_order_by TEXT;

CREATE VIEW f2sla AS (
SELECT f.id, f.report_timestamp,
f.responce_timestamp-f.report_timestamp AS responce_time,
f.faulttype_id,
f.recovery_timestamp-f.report_timestamp AS recovery_time,
f.shortdescr,l.name AS location_name,
c.name AS company_name,
l.sla_resolution, l.sla_responce, 
l.sla_resolution < (f.recovery_timestamp-f.report_timestamp) AS recovery_nok, 
l.sla_responce < (f.responce_timestamp-f.report_timestamp) AS responce_nok,
l.locident, fl.name AS faultlevel,
f.sla_actions, f.sla_fail_comments
FROM
((((st_faults f INNER JOIN st_companieslocations l ON f.companylocation_id = l.id)
INNER JOIN st_faulttypes t ON f.faulttype_id = t.id)
INNER JOIN st_companies c ON l.company_id = c.id)
INNER JOIN st_faultslevellog ll ON ll.fault_id = f.id)
INNER JOIN st_faultlevels fl ON ll.faultlevel_id = fl.id
WHERE (l.sla_responce != '00:00' OR l.sla_resolution != '00:00')
AND t.manual_dates = 't'
);

GRANT SELECT ON f2sla TO PUBLIC;
