DROP VIEW f2sla;
CREATE VIEW f2sla AS (
SELECT f.id, f.report_timestamp,
f.responce_timestamp-f.report_timestamp AS responce_time,
f.faulttype_id,
f.recovery_timestamp-f.report_timestamp AS recovery_time,
f.shortdescr,l.name AS location_name,
c.name AS company_name,
l.sla_resolution, l.sla_responce, 
l.sla_resolution < (f.recovery_timestamp-f.report_timestamp) AS recovery_nok, 
l.sla_responce < (f.responce_timestamp-f.report_timestamp) AS responce_nok,
l.locident, fl.name AS faultlevel,
f.sla_actions, f.sla_fail_comments,
f.responce_timestamp, f.recovery_timestamp
FROM
((((st_faults f INNER JOIN st_companieslocations l ON f.companylocation_id = l.id)
INNER JOIN st_faulttypes t ON f.faulttype_id = t.id)
INNER JOIN st_companies c ON l.company_id = c.id)
INNER JOIN st_faultslevellog ll ON ll.fault_id = f.id)
INNER JOIN st_faultlevels fl ON ll.faultlevel_id = fl.id
WHERE (l.sla_responce != '00:00' OR l.sla_resolution != '00:00')
AND t.manual_dates = 't'
);

GRANT SELECT ON f2sla TO public;


