CREATE OR REPLACE FUNCTION st_faults_1_triggerfunc () RETURNS TRIGGER AS '

	DECLARE
		tmp integer;
	BEGIN
	/* 
	This procedure will be triggered when a fault is updated
	and will: 
	1. Raise an exception if NEW.end_time is null and OLD is not.
	2. Insert a new status in status log with id=-1 (closed)
	3. Raise an exception if only one of close time, close user has value.
	4. Raise an exception if NEW.old_time is not null and try to change something to the current fault.
	5. Raise an exception if (NEW.resolution_timestamp < NEW.responce_timestamp) or (NEW.responce_timestamp < NEW.report_timestamp).

	Artist: Theodore J. Soldatos
	*/
	
	/* end_time check */	
	IF ((OLD.end_time IS NOT NULL) AND (NEW.end_time IS NULL)) THEN
		RAISE EXCEPTION \'A closed fault cannot be reopened!\';
		RETURN NULL;
	END IF;

	/* close values check */
	IF (((NEW.end_time IS NULL) AND (NEW.closed_by_user_id IS NOT NULL)) OR ((NEW.end_time IS NOT NULL) AND (NEW.closed_by_user_id IS NULL))) THEN
		RAISE EXCEPTION \'Close time and user must both have value!\';
		RETURN NULL;
	END IF;
	
	/* Status log */
	IF (NEW.end_time IS NOT NULL) THEN

		INSERT INTO st_faultsstatuslog(change_time, fault_id, faultstatus_id, changed_by_user_id) VALUES(NEW.end_time, NEW.id, -1, NEW.closed_by_user_id); 
	END IF;
	
	/* Check changing closed fault */
	/* Added extra check to permit update of survey_done */
	IF (((OLD.end_time IS NOT NULL) AND (OLD.survey_done = \'t\')) OR ((OLD.end_time IS NOT NULL) AND (OLD.survey_done = NEW.survey_done))) THEN
		RAISE EXCEPTION \'A closed fault cannot be changed!\';
		RETURN NULL;
	END IF;

	/* Manual dates check (see no5 above) */
	IF ((NEW.report_timestamp IS NULL) AND (NEW.responce_timestamp IS NOT NULL)) THEN
		RAISE EXCEPTION \'Responce without report is illogical!\';
		RETURN NULL;
	END IF;
	IF ((NEW.responce_timestamp IS NULL) AND (NEW.recovery_timestamp IS NOT NULL)) THEN
		RAISE EXCEPTION \'Recovery without responce is illogical!\';
		RETURN NULL;
	END IF;
	IF ((NEW.responce_timestamp <= NEW.report_timestamp)) THEN
		RAISE EXCEPTION \'Responce before report is illogical!\';
		RETURN NULL;
	END IF;
	IF ((NEW.recovery_timestamp <= NEW.responce_timestamp)) THEN
		RAISE EXCEPTION \'Recovery before responce is illogical!\';
		RETURN NULL;
	END IF;
	
	RETURN NEW;
	END;
' LANGUAGE 'plpgsql';

DROP TRIGGER st_faults_1_trigger ON st_faults; 

CREATE TRIGGER st_faults_1_trigger BEFORE UPDATE ON st_faults 
FOR EACH ROW EXECUTE PROCEDURE st_faults_1_triggerfunc();
	
