CREATE OR REPLACE FUNCTION cancel_fault(BIGINT) RETURNS INTEGER AS '
	DECLARE
		sr_id ALIAS FOR $1;
		surv_answ_rec RECORD;
		faultstechs_rec RECORD;
		faultsstatuslog_rec RECORD;
		faultsmsglog_rec RECORD;
		faultslevellog_rec RECORD;
		faults_users_rel_rec RECORD;
		faults_files_rec RECORD;
		faults_rec RECORD;
		mail_alerts_rec RECORD;
	BEGIN
	/* 
		This procedure will move all fault data related to a 
		specific fault to the corresponding st_c_* tables, thus
		cancelling the fault.

		Artist: Theodore J. Soldatos
	*/

		-- Move the fault record, needed for the others.
		FOR faults_rec IN SELECT * FROM st_faults WHERE id = sr_id LOOP
			INSERT INTO st_c_faults(id, shortdescr, start_time, end_time, logged_by_user_id, closed_by_user_id, companylocation_id, faulttype_id, rma_num, tac_num, survey_done, report_timestamp, responce_timestamp, recovery_timestamp, sla_actions, sla_fail_comments) 
			VALUES(faults_rec.id, faults_rec.shortdescr, faults_rec.start_time, faults_rec.end_time, faults_rec.logged_by_user_id, faults_rec.closed_by_user_id, faults_rec.companylocation_id, faults_rec.faulttype_id, faults_rec.rma_num, faults_rec.tac_num, faults_rec.survey_done, faults_rec.report_timestamp, faults_rec.responce_timestamp, faults_rec.recovery_timestamp, faults_rec.sla_actions, faults_rec.sla_fail_comments);
		END LOOP;

		-- First, move survey answers.
		FOR surv_answ_rec IN SELECT * FROM st_surv_answ WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_surv_answ(fault_id, surv_id, qu_id, answer)
			VALUES(surv_answ_rec.fault_id, surv_answ_rec.surv_id, surv_answ_rec.qu_id, surv_answ_rec.answer);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_surv_answ WHERE fault_id = sr_id;

		-- Move tech log
		FOR faultstechs_rec IN SELECT * FROM st_faultstechs WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultstechs(id, assign_time, assigned_by_user_id, assigned_to_user_id, fault_id) 
			VALUES(faultstechs_rec.id, faultstechs_rec.assign_time, faultstechs_rec.assigned_by_user_id, faultstechs_rec.assigned_to_user_id, faultstechs_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultstechs WHERE fault_id = sr_id;

		-- Move status log
		FOR faultsstatuslog_rec IN SELECT * FROM st_faultsstatuslog WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultsstatuslog(id, change_time, fault_id, faultstatus_id, changed_by_user_id)
			VALUES(faultsstatuslog_rec.id, faultsstatuslog_rec.change_time, faultsstatuslog_rec.fault_id, faultsstatuslog_rec.faultstatus_id, faultsstatuslog_rec.changed_by_user_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultsstatuslog WHERE fault_id = sr_id;

		-- Message log
		FOR faultsmsglog_rec IN SELECT * FROM st_faultsmsglog WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultsmsglog(id, description, log_time, logged_by_user_id, fault_id)
			VALUES(faultsmsglog_rec.id, faultsmsglog_rec.description, faultsmsglog_rec.log_time, faultsmsglog_rec.logged_by_user_id, faultsmsglog_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultsmsglog WHERE fault_id = sr_id;

		-- Level change log
		FOR faultslevellog_rec IN SELECT * FROM st_faultslevellog WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faultslevellog(id, change_time, faultlevel_id, changed_by_user_id, fault_id)
			VALUES(faultslevellog_rec.id, faultslevellog_rec.change_time, faultslevellog_rec.faultlevel_id, faultslevellog_rec.changed_by_user_id, faultslevellog_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faultslevellog WHERE fault_id = sr_id;

		-- Related users 
		FOR faults_users_rel_rec IN SELECT * FROM st_faults_users_rel WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_faults_users_rel(fault_id, user_id, write_perm)
			VALUES(faults_users_rel_rec.fault_id, faults_users_rel_rec.user_id, faults_users_rel_rec.write_perm);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_faults_users_rel WHERE fault_id = sr_id;

		-- File records 
		FOR faults_files_rec IN SELECT * FROM st_files WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_files(id, filename, realfilename, size, added_by, removed_by, insert_time, delete_time, comments, fault_id)
			VALUES(faults_files_rec.id, faults_files_rec.filename, faults_files_rec.realfilename, faults_files_rec.size, faults_files_rec.added_by, faults_files_rec.removed_by, faults_files_rec.insert_time, faults_files_rec.delete_time, faults_files_rec.comments, faults_files_rec.fault_id);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_files WHERE fault_id = sr_id;

		-- Mail Log records 
		FOR mail_alerts_rec IN SELECT * FROM st_mail_alerts WHERE fault_id = sr_id LOOP
			INSERT INTO st_c_mail_alerts(fault_id, last_mailx, last_tm_mailx, last_dm_mailx, last_am_mailx, last_gm_mailx)
			VALUES(mail_alerts_rec.fault_id, mail_alerts_rec.last_mailx, mail_alerts_rec.last_tm_mailx, mail_alerts_rec.last_dm_mailx, mail_alerts_rec.last_am_mailx, mail_alerts_rec.last_gm_mailx);
		END LOOP;
		-- Delete all moved records.
		DELETE FROM st_mail_alerts WHERE fault_id = sr_id;

		-- Now delete the fault itself.
		DELETE FROM st_faults WHERE id = sr_id;
		
		RETURN 0;
	END;
' LANGUAGE 'plpgsql';
