-- This view returns the last assigned (current) level for each fault.
DROP VIEW st_init_level_of_fault;
CREATE VIEW st_init_level_of_fault AS (
	SELECT f.id, fl.faultlevel_id, l.name
	FROM st_faults f INNER JOIN st_faultslevellog fl
		ON fl.fault_id = f.id
	INNER JOIN st_faultlevels l 
		ON fl.faultlevel_id = l.id
	WHERE fl.change_time = (
		SELECT min(change_time) FROM st_faultslevellog
		WHERE fault_id = f.id
		)
);

GRANT SELECT ON  st_init_level_of_fault TO PUBLIC;
