CREATE VIEW st_elapsed AS (

SELECT 	((t.assign_time - f.start_time) < CAST('10 min' AS interval)) AS e10min,
	((t.assign_time - f.start_time) < CAST('30 min' AS interval) AND (t.assign_time - f.start_time) >= CAST('10 min' AS interval)) AS e30min,
	((t.assign_time - f.start_time) < CAST('1 hour' AS interval) AND (t.assign_time - f.start_time) >= CAST('30 min' AS interval)) AS e1hour,
	((t.assign_time - f.start_time) >= CAST('1 hour' AS interval)) AS emore,
	f.id, f.faulttype_id, f.start_time
FROM st_faults f INNER JOIN st_faultstechs t ON f.id = t.fault_id WHERE
	((t.assign_time = (SELECT min(st_faultstechs.assign_time) AS min 
	FROM st_faultstechs 
	WHERE (st_faultstechs.fault_id = f.id))))

);

GRANT SELECT ON st_elapsed TO PUBLIC;
