#########################################################################
# st_lib: A module to add all common subroutines.			#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.1.0	Clone from NetDB zs_lib code V1.2.4.			#
# V0.2.0	Changed login system.					#
# V0.2.1	Better usage of new login system. 			#
# V0.2.2	Category string based on booleans, not on userlevel.	#
#		Corrected silly bug.					#
# V0.2.3	Added logout field on footer.	 			#
# V0.2.4	Fixed old datetostr.		 			#
# V0.2.5	Translated to english.		 			#
# V0.2.6	Make SMTP server and From: address parameters		# 
# V0.2.7	Added ids of critical and high severity as parameters.	# 
# V0.2.8	Global version change (first install)			#
# V0.2.9	Global version change (terminology review)		#
#		Terminology review and update.				#
# V0.3.0	File DB path added.					#
# V0.3.1	Fault by user permissions added.			#
# V0.3.2	Configuration now in conf file (AppConfig).		#
# V0.3.3	Userlevel is checked on permissions. Used to give read	#
#		only access to management and sales people.		#
# V0.3.4	Userlevel splitted in 1 (only related) and 2 (full)	#
# V0.3.5	Added cse_sort parameter in stunt.conf			#
# V0.3.6	Added compstr parameter in stunt.conf			#
# V0.3.7	Implemented new menu style in main fault screen.	#
# V0.3.8	Translated yes and no.					#
# V0.3.9	Added wh_* params, major version number change.		#
# V0.4.0	Added graphfont parameter.				#
# V0.4.1	Added sencoding parameter.				#
# V0.4.2	Added slang parameter.					#
# V0.4.3	Sub slasummarytxt for SLA stats, version up.		#
# V0.4.4	Sub slasummarytxt: added more fields.			#
# V0.4.5	Responce and resolution times in csv are now absolute.	#
# V0.4.6	Added checks for confidential flag in fbup.		#
# V0.4.7	Added lockedcolor parameter, major version number 	#
#		change.							#
#########################################################################
package st_lib;
use strict;
use Crypt::PasswdMD5;
use AppConfig;

use vars qw($debug $bgcolor $headcellcolor $mheadcellcolor $cellcolor $textcolor $headtextcolor $lighttextcolor $linkcolor $vlinkcolor $data_source $backcellcolor $smbpath $cgipath $secretdir $smtpserver $fromaddress $url $url2 $criticalid $highid $filedbpath $motd $dsrs_subj $alert_from $alert_to $usrs_subj $cse_sort $wh_start $wh_end $graphfont $sencoding $slang $lockedcolor);

my $configfile = '/etc/stunt.conf';
# create a new AppConfig object
my $stunt_config = AppConfig->new({ 
        GLOBAL => {
                DEFAULT  => "<undef>",
                ARGCOUNT => 'ARGCOUNT_ONE',
            }
    });

$stunt_config->define(	"system_debug", { DEFAULT => 0 }); 
$stunt_config->define(	"system_criticalid", { DEFAULT => 0 }); 
$stunt_config->define(	"system_highid", { DEFAULT => 10 }); 
$stunt_config->define(	"system_dbname", { DEFAULT => "stunt" }); 
$stunt_config->define(	"system_passphrase", { DEFAULT => "hdibi BIghhj uhyghggiIGIGIKI iugUgUKGHg 7u66tIG69y BKKb88gbbf7BNik uvb88hd74nf78" }); 
$stunt_config->define(	"system_sencoding", { DEFAULT => "iso-8859-1" }); 
$stunt_config->define(	"system_slang", { DEFAULT => "en-US" }); 
$stunt_config->define(	"paths_secretdir", { DEFAULT => "/tmp/stunt" }); 
$stunt_config->define(	"paths_cgipath", { DEFAULT => "/cgi-bin/stunt/" }); 
$stunt_config->define(	"addresses_myhost", { DEFAULT => "127.0.0.1" }); 
$stunt_config->define(	"addresses_smtpserver", { DEFAULT => "mail.mydomain.com" }); 
$stunt_config->define(	"addresses_fromaddress", { DEFAULT => 'stunt@mydomain.com' }); 
$stunt_config->define(	"system_httpprot", { DEFAULT => 'https' }); 
$stunt_config->define(	"paths_filedbpath", { DEFAULT => '/FaultFiles/' }); 
$stunt_config->define(	"colors_bgcolor", { DEFAULT => 'EEEEFF' }); 
$stunt_config->define(	"colors_headcellcolor", { DEFAULT => 'CCCCFF' }); 
$stunt_config->define(	"colors_mheadcellcolor", { DEFAULT => 'B38AD3' }); 
$stunt_config->define(	"colors_cellcolor", { DEFAULT => 'E0E6F0' }); 
$stunt_config->define(	"colors_textcolor", { DEFAULT => '000000' }); 
$stunt_config->define(	"colors_headtextcolor", { DEFAULT => '111111' }); 
$stunt_config->define(	"colors_lighttextcolor", { DEFAULT => 'CCCCFF' }); 
$stunt_config->define(	"colors_linkcolor", { DEFAULT => '7777DD' }); 
$stunt_config->define(	"colors_vlinkcolor", { DEFAULT => '000088' }); 
$stunt_config->define(	"colors_backcellcolor", { DEFAULT => 'C2C8E2' }); 
$stunt_config->define(	"colors_lockedcolor", { DEFAULT => 'FF6600' }); 
$stunt_config->define(	"misc_motd", { DEFAULT => 'Message Of The Day Goes Here' }); 
$stunt_config->define(	"misc_dsrs_subj", { DEFAULT => 'Daily Service Request Summary' }); 
$stunt_config->define(	"misc_usrs_subj", { DEFAULT => 'Unassigned Service Request Summary' }); 
$stunt_config->define(	"misc_cse_sort", { DEFAULT => 0 }); 
$stunt_config->define(	"misc_compstr", { DEFAULT => '' }); 
$stunt_config->define(	"misc_wh_start", { DEFAULT => '08:00:00' }); 
$stunt_config->define(	"misc_wh_end", { DEFAULT => '17:00:00' }); 
$stunt_config->define(	"misc_graphfont", { DEFAULT => 'gdTinyFont' }); 
$stunt_config->define(	"paths_logopath", { DEFAULT => '/icons/logo.png' }); 
$stunt_config->define(	"addresses_alert_from", { DEFAULT => 'root@mydomain.com' }); 
$stunt_config->define(	"addresses_alert_to", { DEFAULT => 'noc@mydomain.com' }); 

# read configuration file
$stunt_config->file($configfile);

# Options
$debug = $stunt_config->get('system_debug');				# Debug: 1 = on, 0 = off
$sencoding = $stunt_config->get('system_sencoding');			# Encoding
$slang = $stunt_config->get('system_slang');				# Language
$criticalid = $stunt_config->get('system_criticalid');			# Critical severity db id.
$highid = $stunt_config->get('system_highid');			# High severity db id.

my $dbname = $stunt_config->get('system_dbname');
$data_source = "dbi:Pg:dbname=$dbname";	# Where to look...
my $passphrase = $stunt_config->get('system_passphrase'); 	# Used on cookies and URLs. FIXME: Put it somewhere safe... 
$secretdir = $stunt_config->get('paths_secretdir'); # A directory readable only by the apache user. Session strings will be stored here.

# Full cgi path of the application's CGI scripts
$cgipath = $stunt_config->get('paths_cgipath');

my $myhost = $stunt_config->get('addresses_myhost');

# Colors! 

$bgcolor = '#' . $stunt_config->get('colors_bgcolor');
$headcellcolor = '#' . $stunt_config->get('colors_headcellcolor');
$mheadcellcolor = '#' . $stunt_config->get('colors_mheadcellcolor');
$cellcolor = '#' . $stunt_config->get('colors_cellcolor');
$textcolor = '#' . $stunt_config->get('colors_textcolor');
$headtextcolor = '#' . $stunt_config->get('colors_headtextcolor');
$lighttextcolor = '#' . $stunt_config->get('colors_lighttextcolor');
$linkcolor = '#' . $stunt_config->get('colors_linkcolor');
$vlinkcolor = '#' . $stunt_config->get('colors_vlinkcolor');
$backcellcolor = '#' . $stunt_config->get('colors_backcellcolor');
$lockedcolor = '#' . $stunt_config->get('colors_lockedcolor');

# For st_mail - smtp server, from address, url (link - closed fault)

$smtpserver = $stunt_config->get('addresses_smtpserver');					# SMTP Server
$fromaddress = $stunt_config->get('addresses_fromaddress');					# From address (parameter st_mail routine)
my $httpprot = $stunt_config->get('system_httpprot');
$url = "$httpprot://$myhost" . $cgipath . "st_faults.pl?14";		# For link - closed fault - mail routine
$url2 = "$httpprot://$myhost" . $cgipath . "st_faults.pl?4";		# For link - All mails, points to fault. 
$filedbpath = $stunt_config->get('paths_filedbpath');			# Where fault files will be stored.
$motd = $stunt_config->get('misc_motd');
my $logopath = $stunt_config->get('paths_logopath');
$dsrs_subj = $stunt_config->get('misc_dsrs_subj');
$usrs_subj = $stunt_config->get('misc_usrs_subj');
$cse_sort = $stunt_config->get('misc_cse_sort');
$wh_start = $stunt_config->get('misc_wh_start');
$wh_end = $stunt_config->get('misc_wh_end');
$graphfont = $stunt_config->get('misc_graphfont');
my $compstr = $stunt_config->get('misc_compstr');
$alert_from = $stunt_config->get('addresses_alert_from');
$alert_to = $stunt_config->get('addresses_alert_to');

# Main version number to be printed in footer, will change in every install.
#
# Version dateline: 
# 0.1.0: 08 Mar 2004 
# 1.0.0: 06 May 2004 - First install
# 1.0.1: 17 May 2004 - Terminology review
# 1.0.2: 01 Jun 2004 - File management version change.
# 1.1.0: 14 Sep 2004 - Mail alerts, many small changes. 
# 1.1.1: 21 Oct 2004 - Service reports, other small changes. 
# 1.1.2: 22 Nov 2005 - Global statistics, other small changes. 
# 1.1.3: 23 Apr 2006 - SLA stuff, small changes. 
# 1.1.4: 29 Jun 2006 - Confidential tickets stuff, small changes. 

my $mainversion = 'Version 1.1.4';

#############################################################################
# Write debug messages. In this case, output goes to the error.log of Apache#
#############################################################################
sub wDbg { 
if (! $debug) {
	return;
	};
my ($msg, $sub, $rest) = @_;
#Check to see if it is array or not and do your thing
#if ((length($msg) == 1) && (scalar($msg)  1)) {
#	print STDERR scalar(localtime)," ",$sub, ": ", $msg,"\n";
my $check=scalar($msg);
my ($ar, $not)=split(/\(/,$check);
if ($ar eq "ARRAY"){
	my $x=0;
	my $dsp="";
	print STDERR scalar(localtime),"   DEBUG ARRAY RESULTS (subject: $sub)\n";
	print STDERR scalar(localtime),"   ---------------------------------------------\n";
	for (@$msg){
		if ($x < 10) {
			$dsp="0$x";
		}else{
			$dsp=$x;
		}
		print STDERR scalar(localtime),"   DEBUG: (count=$dsp) ->#@$msg[$x]#\n";
		$x++;
	}
}else{
	print STDERR scalar(localtime)," ",$sub, ": ", $msg, "\n";
}
return;

}; # wDbg ends here.

#########################################################################
# Get directly error number and text and do something with them. Return	#
# 1 on error.								#
#########################################################################

sub sthErr {
	my ($rc, $txt) = @_;
	if (! (defined $rc)) {
		return 0; # No error
		}
	else {
		print "<H3><FONT COLOR=RED>Internal Error: $rc\n<P>";
		print "$txt\n<P></H3></FONT>";
		st_lib::wDbg("Internal Error: $rc $txt", "sthErr");
		return 1;
	};
}; # sthErr ends here.

#########################################################################
# Get data and datatype and decide how to print it for readonly use.	#
#########################################################################

sub viewFormDT {
	my ($type, $data) = @_;
	if ($type eq 'bool') {
		# Boolean 
		if ($data eq '0') {
			# False 
			print "No";
		} elsif ($data eq '1') {
			print "Yes";
		} else { 
			# NULL
		};
	} else {
		# Default print, all other
		print $data;
	};
return 0;
}; # viewFormDT ends here.

#########################################################################
# Similar to viewFormDT, but for update. Takes query, fieldname,  	#
# datatype and data and prints via query.				#
#########################################################################

sub editFormDT {
	my ($query, $fname, $type, $data) = @_;
	if ($type eq 'bool') {
		# Boolean
		if ($data eq '') {
			$data = -1;
		};
		my %labels = (-1 => '?', 0 => 'No', 1 => 'Yes');
		print $query->radio_group(-name => $fname,
					  -values => ['1', '0', '-1'], 
					  -default => $data,
					  -labels => \%labels);
					  
	} else {
		# Default textfield, all other.
		print $query->textfield(-name=>$fname,
					-size=>16,
					-default=>$data,
					-maxlength=>2048);
	};
return 0;
}; # editFormDT ends here.



#########################################################################
# Validate user/pass, encrypt them and store them in cookies		# 
# 									#
# New for STUNT: Password is stored (along with other stuff) in a 	#
# string. This string is then stored in the $secretdit, in a file named	#
# after the user.							#
# Encrypted with PasswdMD5, is then send as a cookie to the user. 	#
# Session string format (tab separated):				#
# id username password fullname active client technician admin mc 	#
# userlevel_id companylocation_id company_id				#
#########################################################################

sub ValidateUser {

use CGI;
use DBI;

my ($user, $pass, $urltogo, $query, $rest) = @_;

# Try to connect to see if user and pass are valid.
my $dbh = DBI->connect($data_source, $user, $pass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

if (not(defined $dbh)) {
	print $query->header(	-Refresh=>"3; URL=$cgipath/st_menus.pl?0",
				-charset=>$sencoding),
       	$query->start_html(-title=>'Connection failed.',
			  -text=>$textcolor,
			  -BGCOLOR=>$bgcolor);
	print "<P><CENTER><H1><FONT COLOR=RED>Connection failed. Please try again.</FONT></H1><P>";
	print "You will be transfered <A HREF=\"$cgipath/st_menus.pl?0\">here</A> to retry.";
	print $query->end_html;
	st_lib::wDbg("Login for /$user/ failed due to connect failure.", "ValidateUser");
	exit 0;
	}
else { # Success!!!
	st_lib::wDbg("Success, starting login for $user.", "ValidateUser");
	my $fullname;
	# Find user's record 
#	my $dst = "SELECT realname FROM zs_fullnames WHERE username = '$user'";
	my $dst = "SELECT u.id, u.fullname, u.active, u.client, u.technician, u.admin, u.main_contact, u.userlevel_id,
			u.companylocation_id, cl.company_id, c.name, ul.name 
			FROM st_users u, st_companieslocations cl, st_companies c, st_userlevels ul
			WHERE u.username = '$user'
			AND u.companylocation_id = cl.id
			AND cl.company_id = c.id
			AND u.userlevel_id = ul.id";
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed to select.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @row_ary;
	if ($sth->rows == 0) {
		# User does not exists in tables, cannot proceed. This is a strange case if ever happens. Warn in logs.
		print $query->header(	-Refresh=>"3; URL=$cgipath/st_menus.pl?0",
					-charset=>$sencoding),
	       	$query->start_html(-title=>'Connection failed.',
				  -text=>$textcolor,
				  -BGCOLOR=>$bgcolor);
		print "<P><CENTER><H1><FONT COLOR=RED>Connection failed. Please try again.</FONT></H1><P>";
		print "You will be transfered <A HREF=\"$cgipath/st_menus.pl?0\">here</A> to retry.";
		print $query->end_html;
		st_lib::wDbg("WARNING: Login for /$user/ failed - st_users record not found.", "ValidateUser");
		exit 0;
	} else {
		@row_ary = $sth->fetchrow_array;
		$fullname = $row_ary[0];
	};
	
	# Try to open old session file, just in case.
	my $oldss = '';
	if (not(defined(open SESSFILE, "<$secretdir$user"))) {
		# File does not exist
		st_lib::wDbg("Old session open for /$user/ failed.", "ValidateUser");
	} else {
		$oldss = <SESSFILE> ;
		close SESSFILE;
	};
	
	# If old session string is not null, inform user.
	my $stale_date = '';
	if ($oldss ne '') {
		# Parse it to get timestamp
		my @tmp = split /\t/, $oldss, 15;
		$stale_date = $tmp[12];
	};

	# Build new session string.
	my $sessionstring = sprintf "%d\t%s\t%s\t%s\t%3s\t%3s\t%3s\t%3s\t%3s\t%d\t%d\t%d\t%d\t%s\t%s", $row_ary[0], $user, $pass, $row_ary[1], $row_ary[2], $row_ary[3], $row_ary[4], $row_ary[5], $row_ary[6], $row_ary[7], $row_ary[8], $row_ary[9], time, $row_ary[10], $row_ary[11];
	
	# Update sessionfile
	if (not(defined(open SESSFILE, ">$secretdir$user"))) {
		# File cannot be opened
		print "<H1><FONT COLOR=RED>System error (session open fail)</FONT></H1>";
		print $query->end_html;
		st_lib::wDbg("ERROR: New session open for /$user/ failed.", "ValidateUser");
	} else {
		print SESSFILE $sessionstring;
		close SESSFILE;
	};
	
	
	$sth->finish;
	$dbh->disconnect;

	# Encrypt session string
	my $cryptss = unix_md5_crypt($sessionstring);
	# Build cookies.
	my $usercookie = $query->cookie(-name=>'user',
        				-value=>$user,
					-domain=>$myhost);
	my $sscookie = $query->cookie(-name=>'session',
        				-value=>$cryptss,
					-domain=>$myhost);

	st_lib::wDbg("Cookies ready.", "ValidateUser");
	# Send cookies with header.
	print  	$query->header(	-cookie=>[$sscookie, $usercookie],
				-Refresh=>"3; URL=$urltogo",
				-charset=> $sencoding),
       		$query->start_html(	-title=>' .',
					-text=>$textcolor,
					-BGCOLOR=>$bgcolor);
	print "<CENTER><H1><FONT COLOR=GREEN>Connection successfull!</FONT></H1>";
	if ($stale_date ne '') {
		# Inform of old session
		my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($stale_date);
		$year = $year + 1900;
		$mon++;
		print "<br>Old session from $mday" . "-" . $mon . "-" . $year . ", $hour:$min:$sec deleted.<br>";
	};
	print "Now you will be transfered <A HREF=\"$urltogo\">here.</A>.";
	print "<P>";
	print $query->end_html;
#	return;
};

}; # ValidateUser ends here.


#########################################################################
# Get user/pass from cookies, decrypt and return to calling function.	# 
# Also return username.							#
# Update for STUNT: The cookie is only used to validate the data stored	#
#	in the session file, all data extracted from the file.		#
#									#
# Session string format (tab separated):				#
# id username password fullname active client technician admin mc 	#
# userlevel_id companylocation_id company_id				#
#########################################################################
sub GetCredentials {
use CGI;

my ($query, $rest) = @_;

my $sscookie = $query->cookie(-name=>'session');
my $user = $query->cookie(-name=>'user');
my $sessionstring = '';

if ($sscookie) { # Credentials are there, check if they are ok.
	# Get salt.
	my ($one, $two, $salt, $rest) = split /\$/, $sscookie, 4; 
	# Open session file 

	if (not(defined(open SESSFILE, "<$secretdir$user"))) {
		# File does not exist
		st_lib::wDbg("Session open for /$user/ failed.", "ValidateUser");
		return (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	} else {
		$sessionstring = <SESSFILE> ;
		close SESSFILE;
	};

	# Crypt ant compare
	my $cryptss = unix_md5_crypt($sessionstring, $salt);
	if ($cryptss eq $sscookie) {
		# It's him, the user, let's find the data.
		my ($id, $user, $pass, $fullname, $active, $client, $technician, $admin, $mc, $userlevel_id, $companylocation_id, $company_id, $timestamp, $companyname, $userlevelname) = split /\t/, $sessionstring, 15; 

		return ($user, $pass, $fullname, $id, $active, $client, $technician, $admin, $mc, $userlevel_id, $companylocation_id, $company_id, $timestamp, $companyname, $userlevelname);
	} else {
		st_lib::wDbg("WARNING: Cookie session different than file session!", "GetCredentials"); 
		return (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	};
} else { # No credentials, return 0
	st_lib::wDbg("No cookies found! Monster wants cookie!", "GetCredentials"); 
	return (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	};
}; # GetCredentials ends here.

#############################################################################
# Login user								    #
#############################################################################

sub GetUserForLogin {

use CGI;

my ($urltogo, $query, $rest) = @_;

# Ok, now send the form to the client.


print  $query->header(-charset => $sencoding),
       $query->start_html(-title=>'Login',
       				-text=>$textcolor,
				-BGCOLOR=>$bgcolor),
       $query->start_multipart_form(-method=>'POST',
			 -action=>"$cgipath/st_menus.pl?3"),
       "<P>",
	"<CENTER>",
	"<FONT SIZE=-1>",
	"<TABLE BORDER=1>",
	"<TR><TD BGCOLOR=$headcellcolor COLSPAN=4>",
       "<CENTER><H3>Login</H3></CENTER>",
       "</TD></TR>",
	"<TR><TD BGCOLOR=$cellcolor>",
	"<FONT SIZE=-1>",
       "Username: ",
	"</TD>",
	"<TD BGCOLOR=$cellcolor>",
	"<FONT SIZE=-1>",
       $query->textfield(-name=>'user',
			 -size=>10,
			 -maxlength=>20),
	"</TD>",
	"<TD BGCOLOR=$cellcolor>",
	"<FONT SIZE=-1>",
       "Password: ",
	"</TD>",
	"<TD BGCOLOR=$cellcolor>",
	"<FONT SIZE=-1>",
       $query->password_field(-name=>'pass',
			 -size=>10,
			 -maxlength=>20),
	"</TD>",
	"</TR><TR>",
       "<TD BGCOLOR=$cellcolor COLSPAN=4>",
	"<FONT SIZE=-1><CENTER>",
       $query->submit(-value=>'Login'),
	"</FONT></CENTER></TD></TR></TABLE>",
	$query->hidden(-name=>'urltogo',
			-default=>$urltogo),
       $query->endform;

print $query->end_html;
return;
}; # GetUserForLogin ends here


#################################################################################
# Prints header and footer screens. The query must be already initialized.	#
#										#
# Arguments description:							#
#	footer: 	if 0, print header, if 1 print footer.			#
#	$fullname: 	User's full name.					#
#	$version: 	Script's version					#
#	$mm: 		Called from main menu, don't print main menu link.	#
#################################################################################
sub zsHeaderFooter {
	my ($footer, $fullname, $version, $mm, $zdata) = @_;
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(@$zdata[9]);
	$year = $year+1900;
	$mon++;
	my $loggedfrom = sprintf "Logged in since %02d-%02d-%04d %02d:%02d:%02d", $mday, $mon, $year, $hour, $min, $sec;
	# Build authorization description string.
	my $ads = '';
	if (@$zdata[4] == 1) {
		# Admin
		$ads = 'Administrator';
	} elsif (@$zdata[3] == 1) {
		# Tech
		$ads = 'CSE';
	} elsif (@$zdata[2] == 1) {
	 	# Client
		$ads = 'Customer';
	} else {
		# This should not happen.
		$ads = '*Unknown*';
	};
	if ($$zdata[5] == 1) {
		# Main contact
		$ads = "<FONT COLOR=RED><B>$ads</B></FONT>";
	};
	if ($footer) {
		print "<P>";
	};
	print "<TABLE WIDTH=\"100%\"><TR>";
	if (not($footer)) {
		print "<TD VALIGN=CENTER ALIGN=LEFT WIDTH=\"10%\"><IMG SRC=\"$logopath\"></TD><TD><FONT COLOR=$linkcolor><B>$compstr<br></B></FONT>";
		print "</TD>";
		print "<TD ALIGN=RIGHT VALIGN=CENTER WIDTH=\"20%\"><FONT COLOR=$linkcolor>User: $fullname<br>@$zdata[10]<br>$ads<br>$loggedfrom</FONT></TD>";
		if (not($mm)) {
			print "<TD VALIGN=CENTER WIDTH=\"5%\"><CENTER><A HREF=\"$cgipath/st_menus.pl\">Main<br>Menu</A></CENTER></TD>";
		} else {
			print "<TD VALIGN=CENTER WIDTH=\"5%\"></TD>";
		};
		print "</TR><TR><TD ALIGN=CENTER VALIGN=CENTER COLSPAN=4><FONT COLOR=$linkcolor><H2><B>Space Ticketing NT</B></H2></FONT></TD>";
	};
	if ($footer) {
		print "<TD ALIGN=LEFT VALIGN=CENTER WIDTH=\"50%\"><FONT COLOR=$linkcolor>$mainversion ($version)</FONT></TD>"; 
		print "<TD WIDTH=\"10%\"></TD>";
		print "<TD WIDTH=\"10%\"></TD>";
		print "<TD ALIGN=RIGHT VALIGN=CENTER WIDTH=\"25%\"><FONT COLOR=$linkcolor>User: $fullname<br>@$zdata[10]<br>$ads<br><A HREF=\"$cgipath/st_menus.pl?6\">Logout</A></FONT></TD>";
		if (not($mm)) {
			print "<TD  ALIGN=CENTER VALIGN=CENTER WIDTH=\"5%\"><A HREF=\"$cgipath/st_menus.pl\">Main<br>Menu</A></TD>";
		} else {
			print "<TD  VALIGN=CENTER WIDTH=\"5%\"></TD>";
		};
	};
	print "</TR></TABLE>";
}; # zsHeader ends here.

#################################################################################
# Silly routinette to facilitate row changes on HTML tables.			#
#################################################################################
sub zrccnt {
	my ($cnt, $limit) = @_;
	if ($cnt > $limit) {
		print "</TR><TR>";
		return 0;
	} else {
		$cnt++;
		return $cnt;
	};
}; # zrccnt ends here

####################################################################################################################
# datetostr -> converts the postgres date into a more convenient one! Called with the postgres date as a paramater #
####################################################################################################################

sub datetostr
{
 my ($old_date) = @_;
 my ($old_date, $old_hour) = split ' ', $old_date, 2;
 my $new_date;
 my $new_hour;
 my ($year,$month,$date) = split '-',$old_date, 3;
 my ($new_hour, $rest) = split '\.', $old_hour, 2;
 #SWITCH :
 #{
 #  if ($month eq '01') {$month='';}
 #  if ($month eq '02') {$month='';}
 #  if ($month eq '03') {$month='';}
 #  if ($month eq '04') {$month='';}
 #  if ($month eq '05') {$month='';}
 #  if ($month eq '06') {$month='';}
 #  if ($month eq '07') {$month='';}
 #  if ($month eq '08') {$month='';}
 #  if ($month eq '09') {$month='';}
 #  if ($month eq '10') {$month='';}
 #  if ($month eq '11') {$month='';}
 #  if ($month eq '12') {$month='';}
 #}
 SWITCH :
 {
   if ($month eq '01') {$month='January';}
   if ($month eq '02') {$month='February';}
   if ($month eq '03') {$month='March';}
   if ($month eq '04') {$month='April';}
   if ($month eq '05') {$month='May';}
   if ($month eq '06') {$month='June';}
   if ($month eq '07') {$month='July';}
   if ($month eq '08') {$month='August';}
   if ($month eq '09') {$month='September';}
   if ($month eq '10') {$month='October';}
   if ($month eq '11') {$month='November';}
   if ($month eq '12') {$month='December';}
 }
 $new_date="$date $month $year $new_hour";
 return $new_date; 
}; # datetostr ends here.

#########################################################################
# pgarr2arr: Transform the string representing a PostgreSQL array to a 	#
#		normal perl array.					#
#########################################################################

sub pgarr2arr {
	my ($inp, $rest) = @_;
	($rest, $inp) = split /{/, $inp; 
	($inp, $rest) = split /}/, $inp; 
	my @toret = split /,/, $inp;
	return @toret;
}; # sub pgarr2arr ends here.

#########################################################################
# arr2pgarr: Transform an array to the string representing a PostgreSQL #
#		array (the reverse of pgarr2arr)			#
#########################################################################

sub arr2pgarr {
	my ($inp, $rest) = @_;
	my $toret = '{';
	my $first = 1;
	foreach $rest (@$inp) {
		if ($first) {
			$toret = $toret . $rest;
			$first = 0;
		} else {
			$toret = $toret . ',' . $rest;
		};
	};
	$toret = $toret . '}';
	return $toret;
}; # sub arr2pgarr ends here.

#########################################################################
# vgok: Compare list of groups where user belongs with list of groups 	#
# 	valid for a menu item. 						#
#									#
# Parameters:								#
# 	1: List of user groups (array)					#
#	2: List of valid groups (PgArray string)			#
#########################################################################

sub vgok {
	my ($ugref, $vgs) = @_;
	my @vgsa = pgarr2arr($vgs);
	my $sg;
	foreach $sg (@vgsa) {
		if (found($ugref, $sg)) {
			return 1;
		};
	};
	return 0;
}; # sub vgok ends here.

#########################################################################
# Check if a number exists in an array. Yes, i know. No, i like it that	#
# way.									#
#########################################################################
sub found {
	my ($aref, $token) = @_;
	my $found = 0;
	my $tmp;
	foreach $tmp ( @$aref ) {
		if ($tmp == $token) {
			$found = 1;
		};
	};
	return $found;
}; # sub found ends here.

#########################################################################
# Print the two arrays of arrays containing the menu items on a table.	#
# Column number is fixed (4), rows are dynamic.				#
#########################################################################
sub st_print_menu {
	my ($labelsref, $linksref) = @_;
	my ($col, $row, $x, $y, $i);
	my $maxrows = 0;
	my @labelsarr = @$labelsref;
	my @linksarr = @$linksref;
	
	# Count loop.
	for $x (0 .. $#labelsarr) {
		if (defined($labelsarr[$x])) {
			my @labelslice =  @{ $labelsarr[$x] };
			if (scalar(@labelslice) > $maxrows) {
				$maxrows = scalar(@labelslice);
			};
		};
	};

	$maxrows--;

	# Main loop.
	for $y (0 .. $maxrows) {
		print "<TR>";
		for $x (0 .. $#labelsarr) {
			if (defined($labelsarr[$x])) {
				my @labelslice =  @{ $labelsarr[$x] };
				print "<TD BGCOLOR=$cellcolor><CENTER><A HREF=\"";
				print $linksarr[$x][$y];
				print "\">";
				print $labelsarr[$x][$y];
				print "</A></CENTER></TD>";
			} else {
				print "<TD BGCOLOR=$cellcolor></TD>";
			};
		};
		print "</TR>";
	};
}; # sub st_print_menu ends here.


#########################################################################
# Fault by user permissions: Get a zdata array and a fault id and check #
# if the specific user has permissions on the specific fault. 		#
# This will be used as an extra safeguard in the code, in case that the	#
# luser starts to mess up with URL's parameters.			#
#									#
# Return codes: 							#
#	-1 	: Error. Fault not found or something other.		#
#	00	: No permissions. Eat door, luser!			#
#	01	: Read only.						#
#	02	: Full access.						#
#########################################################################
sub fbup {
	my ($zdataref, $dbh, $fault_id, $rest) = @_;
	my ($ldst, $lsth, @lrow, $confidential); # Use local variables for these, no need to mess up.

	# Get the confidential flag.
	$ldst = "SELECT confidential FROM st_faults WHERE id = $fault_id";
	$lsth = $dbh->prepare($ldst);
	$lsth->execute;
	if (defined($lsth->err)) { 
		# Internal Error.
		$dbh->rollback;
		$lsth->finish;
		return -1;
	};
	@lrow = $lsth->fetchrow_array;
	$confidential = $lrow[0]; 	# One 

	# First, standard cases (full access): Admins and tech_mc's.
	# Confidentials will be treated as if the user is not MC.
	# Exceptions: Confidential flag.
	if (($$zdataref[4] == 1) or (($$zdataref[3] == 1) and ($$zdataref[5] == 1) and (not($confidential)))) {
		# Check userlevel
		if ($$zdataref[6] > 0) {
			# Will be defined later.
		} else {
			# Default
			return 2;
		};
	};

	# In case of customers, check company of fault.
	if (($$zdataref[3]) == 0 and ($$zdataref[2] == 1)) { # Not tech, customer.
		
		$ldst = "SELECT company_id FROM st_faults_companies_v WHERE id = $fault_id";
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		@lrow = $lsth->fetchrow_array;
		if ($lrow[0] != $$zdataref[8]) {
			# Customers do not have access in other companies records.
			$lsth->finish;
			return 0;
		};
		# If the customer is mc, give full access.
		# Confidentials will be treated as if the user is not MC.
		# Exceptions: Confidential flag.
		if (($$zdataref[5] == 1) and (not($confidential))) {
			$lsth->finish;
			return 2;
		};


		# Customer, not mc, fault of own company. Let's see if there is any relation.
		# First, check if owner.
		$ldst = "SELECT logged_by_user_id FROM st_faults WHERE id = $fault_id";
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		@lrow = $lsth->fetchrow_array;
		if ($lrow[0] == $$zdataref[0]) {
			# Owner, full access.
			$lsth->finish;
			return 2;
		};
		# Check if related.
		$ldst = "SELECT write_perm FROM st_faults_users_rel WHERE fault_id = $fault_id AND user_id = " . $$zdataref[0];
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		if ($lsth->rows > 0) {
			@lrow = $lsth->fetchrow_array;
			if ($lrow[0] == 1) {
				$lsth->finish;
				return 2;
			} else {
				$lsth->finish;
				return 1;
			};
		};
		# Default: Deny all :-)
		$lsth->finish;
		return 0;
	};
	if ((($$zdataref[3] == 1) and ($$zdataref[5] == 0)) or ($$zdataref[6] > 0) or (($$zdataref[3] == 1) and ($confidential))) { 
		# tech, not mc. Also non-technical user.
		# Also tech on confidential.
		# Tech, not mc. Let's see if there is any relation.
		# First, check if owner.
		$ldst = "SELECT logged_by_user_id FROM st_faults WHERE id = $fault_id";
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		@lrow = $lsth->fetchrow_array;
		if ($lrow[0] == $$zdataref[0]) {
			# Owner, full access.
			$lsth->finish;
			return 2;
		};
		# Check if assigned.
		$ldst = "SELECT assigned_to_user_id FROM st_tech_of_fault WHERE id = $fault_id";
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		@lrow = $lsth->fetchrow_array;
		if ($lrow[0] == $$zdataref[0]) {
			# Tech, full access.
			$lsth->finish;
			return 2;
		};
		# Check if related.
		$ldst = "SELECT write_perm FROM st_faults_users_rel WHERE fault_id = $fault_id AND user_id = " . $$zdataref[0];
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		if ($lsth->rows > 0) {
			@lrow = $lsth->fetchrow_array;
			if ($lrow[0] == 1) {
				$lsth->finish;
				return 2;
			} else {
				$lsth->finish;
				return 1;
			};
		};
		# Now the $$zdataref[6] case. Not related, but should have read access
		if ($$zdataref[6] > 0) {
			if ($$zdataref[6] == 2) {
				# Full read access
				$lsth->finish;
				return 1;
			};
			# Conditional, check if a relation record exists.
			$ldst = "SELECT * FROM st_faults f INNER JOIN st_techsmc_faulttypes r ON f.faulttype_id = r.faulttype_id
				 WHERE f.id = $fault_id
				 AND r.user_id = $$zdataref[0]";
			$lsth = $dbh->prepare($ldst);
			$lsth->execute;
			if (defined($lsth->err)) { 
				# Internal Error.
				$dbh->rollback;
				$lsth->finish;
				return -1;
			};
			if ($lsth->rows > 0) {
				$lsth->finish;
				return 1;
			};

			# Default: Deny all :-)
			$lsth->finish;
			return 0;
		};

		# Check if related through the matrix (SCSE, Duty Manager etc). This goes after
		# the $$zdataref[6] case, because we don't want to give r/w permission
		# to the wrong person.
		$ldst = "SELECT * FROM st_faults f INNER JOIN st_techsmc_faulttypes r ON f.faulttype_id = r.faulttype_id
			 WHERE f.id = $fault_id
			 AND r.user_id = $$zdataref[0]";
		$lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (defined($lsth->err)) { 
			# Internal Error.
			$dbh->rollback;
			$lsth->finish;
			return -1;
		};
		if ($lsth->rows > 0) {
			$lsth->finish;
			return 2;
		};

		# Default: Deny all :-)
		$lsth->finish;
		return 0;

	};
	# Default: Deny all :-)
	return 0;
};


#########################################################################
# slasummarytxt: The same output as action 10 of st_stats, but in the	#
# 		form of a csv ascii text file. The result is returned	#
#		as an array and the calling code should do the print.	#
#########################################################################
sub slasummarytxt {

	my ($dbh, $start_date, $end_date, $typeslistref, $resultref, $rest) = @_;

	my @typeslist = @$typeslistref;

	my $i;
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';
	my $dst = "SELECT id, faulttype_id, company_name, location_name, shortdescr, report_timestamp, responce_timestamp, recovery_timestamp, sla_responce, sla_resolution, recovery_nok, responce_nok,
			locident, faultlevel, sla_actions, sla_fail_comments
			FROM f2sla WHERE faulttype_id IN $sqlin";
	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND report_timestamp >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND report_timestamp <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	$dst = $dst . " ORDER BY 5 DESC";
	my $sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		$dbh->disconnect;
		exit;
	};
	push @$resultref, '"SR id","End-Customer ID","End-Customer Name","SR Severity","Time Reported (partner)","Responce Time (company)","Resolution Time (company)","Fault Description","Company Resolution Actions","Responce SLA Conformance","Resolution SLA Conformance","Comments that failed the SLA"';
	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
			if ($lrow[6] eq '') { $lrow[6] = 'N/A'; };
			if ($lrow[7] eq '') { $lrow[7] = 'N/A'; };
			my $csvline = '"' .  $lrow[0] . '","' . $lrow[12] . '","' . $lrow[3] . '","' . $lrow[13] . '","' . $lrow[5] . '","' . $lrow[6] . '","' . $lrow[7] . '","' . $lrow[4] . '","' . $lrow[14] . '","';
			if ($lrow[11]) {
				$csvline = $csvline . 'NO","';
			} elsif ($lrow[11] eq '') {
				$csvline = $csvline . 'N/A","';
			} else {
				$csvline = $csvline . 'YES","';
			};
			if ($lrow[10]) {
				$csvline = $csvline . 'NO","';
			} elsif ($lrow[10] eq '') {
				$csvline = $csvline . 'N/A","';
			} else {
				$csvline = $csvline . 'YES","';
			};
			$csvline = $csvline . $lrow[15] . '"';
			push @$resultref, $csvline;
	};
	return;
}; 	# slasummarytxt end.

1;
