#########################################################################################################################
# This module supports the JAVASCRIPT mechanism of User Management 							#
# part of STUNT.													#  
# Also includes the follow routines:											#
#															#
#	- Check_userlevel() -> For checking the checkboxes (?)								#
#	- sub_user_levels_names() -> For reading the user levels from st_userlevels table				#
#	- sub_companies_names () -> For reading the companies names from st_companies table				#
#	- sub_companieslocations_names() -> For reading the locations of companies from st_companieslocations table	#
#															#
# Artist: Politis Konstantinos												#
#	  Dourmousoglou Alexandros											#
#	  Theodore J. Soldatos												#
#															#
# Copyright (C) 2004-2005 Space Hellas											#
# Copyright (C) 2004-2005 Theodore J. Soldatos										#
#															#
# This program is free software; you can redistribute it and/or								#
# modify it under the terms of the GNU General Public License								#
# as published by the Free Software Foundation; either version 2							#
# of the License, or (at your option) any later version.								#
#															#
# This program is distributed in the hope that it will be useful,							#
# but WITHOUT ANY WARRANTY; without even the implied warranty of							#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the								#
# GNU General Public License for more details.										#
#															#
# You should have received a copy of the GNU General Public License							#
# along with this program; if not, write to the Free Software								#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,								#
# MA  02110-1301, USA													#
#															#
#															#
# V0.0 -> Starting...													#
# V0.1 -> Add the 3 subroutines (reading from tables st_userlevels, st_companies, st_companieslocations). 		#
# ----------------------------->>>>											#
# V1.0 -> Buillding 2 more routines:											#
#	- control_lists_with_javascript($dbh,source_list,target_list) ->>						#
#	  Which controls the list values of company, companylocation with Javascript   					#
#	- sub_def_value_company -> Which checks the default value for company based on default value of location	#
#	  (This function runs when <l>user tries to update his record							#
#															#
# V1.1 -> Corrected bug in control_lists_with_javascript (parameters were not used). Changed strings to greek.		#
# V1.2 -> Corrected operation of javascript. Support now case of loading forms (insert or update) when passing 		#
#	  company_id parameter.												#
# V1.3 -> Fix bug javascript (onLoad HTML page - edit user record page). Appearing now the correct (user) values.	#
#	  Passing one more parameter (default = '') for the case of running script onLoad page (edit user record).	#
# V1.4 -> Building 1 more routine:											#
#	  - sub_userlevel_names() -> For reading userlevel nbames from st_userlevels table				#
# V1.5 -> Fixed sub_def_value_company											#
#########################################################################################################################

package st_jscript;
use strict;
use st_lib;
use DBI;
use CGI;

my $data_source = $st_lib::data_source;		# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables
my $JAVASCRIPT;					# String for Javascript routines

my $debug = $st_lib::debug;
my $myhost = $st_lib::myhost;

my $cgipath = 		$st_lib::cgipath; 	# CGI path
my $JAVASCRIPT;					# String for Javascript routines
my $query = new CGI;



# Routine which reads the User Levels from st_userlevels table

sub sub_user_levels_names()
{
	# Check credentials, if not ok call GetUserForLogin

	my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
	if ($zpass eq '0') {
		# Must login
		st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
		exit;
	};

	# Initialize db connection
	
	my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

	my $dst = "SELECT u.id, u.name, u.client, u.technician, u.admin 
		   FROM st_userlevels u";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @array_id_userlevels;
	my %array_name_userlevels;
	my @row_ary;
	my $metr = 0;
	
	while (@row_ary = $sth->fetchrow_array) 
	{
		#print STDERR "$row_ary[0], $row_ary[1], $row_ary[2], $row_ary[3], $row_ary[4]" . "\n";
		$array_id_userlevels[$metr] = $row_ary[0];
		$array_name_userlevels{$row_ary[0]} = $row_ary[1];
		$metr = $metr + 1;
	};
	
	$dbh->disconnect;
	return (\@array_id_userlevels, \%array_name_userlevels);
}


# Routine which reads the companies from st_companies table

sub sub_companies_names()
{
	# Check credentials, if not ok call GetUserForLogin

	my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
	if ($zpass eq '0') {
		# Must login
		st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
		exit;
	};

	# Initialize db connection
	
	my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

	my $dst = "SELECT u.id, u.name, u.comments, u.active 
		   FROM st_companies u";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @array_id_companies;
	my %array_name_companies;
	my @row_ary;
	my $metr = 1;

	$array_id_companies[0] = '';
	$array_name_companies{''} = 'Choose company';
	
	while (@row_ary = $sth->fetchrow_array) 
	{
		#print STDERR "$row_ary[0], $row_ary[1], $row_ary[2], $row_ary[3]" . "\n";
		$array_id_companies[$metr] = $row_ary[0];
		$array_name_companies{$row_ary[0]} = $row_ary[1];
		$metr = $metr + 1;
	};

	$dbh->disconnect;
	return (\@array_id_companies, \%array_name_companies);
}

## Routine which loads the user levels names from st_userlevels table.

sub sub_userlevel_names()
{
	# Check credentials, if not ok call GetUserForLogin

	my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
	if ($zpass eq '0') {
		# Must login
		st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
		exit;
	};

	# Initialize db connection
	
	my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

	my $dst = "SELECT u.id, u.name 
		   FROM st_userlevels u";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @array_id_levels;
	my %array_name_levels;
	my @row_ary;
	my $metr = 0;

	while (@row_ary = $sth->fetchrow_array) 
	{
		#print STDERR "$row_ary[0], $row_ary[1], $row_ary[2], $row_ary[3]" . "\n";
		$array_id_levels[$metr] = $row_ary[0];
		$array_name_levels{$row_ary[0]} = $row_ary[1];
		$metr = $metr + 1;
	};

	$dbh->disconnect;
	return (\@array_id_levels, \%array_name_levels);
}

# Routine which reads the companieslocations from st_companieslocations table

sub sub_companieslocations_names
{
	my ($c_id, $rest) = @_;
	# Check credentials, if not ok call GetUserForLogin

	my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
	if ($zpass eq '0') {
		# Must login
		st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
		exit;
	};

	# Initialize db connection
	
	my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

	my $dst = "SELECT u.id, u.name 
		   FROM st_companieslocations u ";
	if ($c_id ne '') {
		# Add a where clause, company specified.
		$dst = $dst . " WHERE company_id = $c_id ";
	};
	$dst = $dst . " ORDER BY u.name";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @array_id_companieslocations;
	my %array_name_companieslocations;
	my @row_ary;
	my $metr = 1;

	$array_id_companieslocations[0] = '';
	$array_name_companieslocations{''} = 'Choose location';
	
	while (@row_ary = $sth->fetchrow_array) 
	{
		#print STDERR "$row_ary[0], $row_ary[1]" . "\n";
		$array_id_companieslocations[$metr] = $row_ary[0];
		$array_name_companieslocations{$row_ary[0]} = $row_ary[1];
		$metr = $metr + 1;
	};

	$dbh->disconnect;
	return (\@array_id_companieslocations, \%array_name_companieslocations);
}


# Subroutine for checking the pg_users table, which user can be disactivated - SuperUsers always active

sub check_pg_users_for_delete
{
my ($user_for_check) = @_;

	# Check credentials, if not ok call GetUserForLogin

	my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
	if ($zpass eq '0') {
		# Must login
		st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
		exit;
	};

	# Initialize db connection
	
	my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

	my $dst = "SELECT u.usename, u.usesysid, u.usesuper 
		   FROM pg_user u";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @row_ary;
	my $flag_control = "false";
	
	while (@row_ary = $sth->fetchrow_array) 
	{
		if ($row_ary[0] eq $user_for_check)
		{
			# You just find the user - start checking the user_flag

			if ($row_ary[2] eq "1")
			{
				$flag_control = "true";
			}
		}
	};
	
	$dbh->disconnect;
	return $flag_control;
}


### Routine which controls the list values of companies & companieslocation with Javascripts ###

sub control_lists_with_javascript
{

my $sth;
my ($dbh, $saref, $taref) = @_;
my @source_array=@$saref;
my @target_array=@$taref;
my @row_ary;
my $JAVASCRIPT = "";
my $var_Company_label_array = "";
my $var_LocationCompany_id_array = "";
my $var_Location_label_array = "";
my $var_Location_id_array = "";
my $query = new CGI;

$sth = $dbh->prepare("SELECT u.id, u.name, u.comments FROM st_companies u");
$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Internal Error.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Use companies to fill the array
if ($sth->rows > 0) {
	$JAVASCRIPT = $JAVASCRIPT . "var CompanyArray =  new Array(\"Choose company\"";
	$var_Company_label_array = $var_Company_label_array . "var Company_LabelArray =  new Array(\"Choose company\"";

	while (@row_ary = $sth->fetchrow_array) 
	{
		$JAVASCRIPT = $JAVASCRIPT . ",\"$row_ary[0]\"";
		$var_Company_label_array = $var_Company_label_array . ",\"$row_ary[1]\"";
	};
	$JAVASCRIPT = $JAVASCRIPT . ");\n";
	$var_Company_label_array = $var_Company_label_array . ");\n";
} else {
	$JAVASCRIPT = $JAVASCRIPT . "var CompanyArray =  new Array(\"No companies found\");";
};

$JAVASCRIPT = $JAVASCRIPT . $var_Company_label_array;

# Use locations to fill the array
$sth = $dbh->prepare("SELECT u.id, u.name, u.company_id FROM st_companieslocations u ORDER BY u.name;");
$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Internal Error.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

if ($sth->rows > 0) {
	$var_LocationCompany_id_array = $var_LocationCompany_id_array . "var LocationCompany_idArray =  new Array(\"Choose location\"";
	$var_Location_label_array = $var_Location_label_array . "var Location_LabelArray =  new Array(\"Choose location\"";
	
	while (@row_ary = $sth->fetchrow_array) 
	{
		# Escape double quotes to avoid having data breaking the code
		$row_ary[1] =~ s/\"/\\\"/g;

		$var_LocationCompany_id_array = $var_LocationCompany_id_array . ",\"$row_ary[2]\"";
		$var_Location_label_array = $var_Location_label_array . ",\"$row_ary[1]\"";
	};

	$var_LocationCompany_id_array = $var_LocationCompany_id_array . ");\n";
	$var_Location_label_array = $var_Location_label_array . ");\n";
} else 
{
	$var_LocationCompany_id_array = $var_LocationCompany_id_array . "var LocationCompany_idArray =  new Array(\"No locations found\");";
	$var_Location_label_array = $var_Location_label_array . "var Location_LabelArray =  new Array(\"No locations found\"";
};

$JAVASCRIPT = $JAVASCRIPT . $var_LocationCompany_id_array . $var_Location_label_array;

$sth = $dbh->prepare("SELECT u.id, u.name, u.company_id FROM st_companieslocations u ORDER BY u.name;");
$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Internal Error.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

if ($sth->rows > 0) {
	$var_Location_id_array = $var_Location_id_array . "var Location_idArray =  new Array(\"Choose location\"";
	
	while (@row_ary = $sth->fetchrow_array) 
	{ $var_Location_id_array = $var_Location_id_array . ",\"$row_ary[0]\""; };

	$var_Location_id_array = $var_Location_id_array . ");\n";
} else 
{ $var_Location_id_array = $var_Location_id_array . "var Location_idArray =  new Array(\"No locations found\""; };

$JAVASCRIPT = $JAVASCRIPT . $var_Location_id_array;

my $i;
for($i=0;$i<=$#target_array;$i++)
{

  $JAVASCRIPT = $JAVASCRIPT . "function control_lists" . "(inForm, selected, flag_company_id_param, flag_companylocation_name_param) { 
  var metr, i, special_flag;
  
  special_flag = -1;
  if (flag_company_id_param == 1)
  {
	 while (inForm." . $source_array[$i] . ".options.length) { inForm." . $source_array[$i] . ".options[0] = null; }
	 inForm." . $source_array[$i] . ".options[inForm." . $source_array[$i] . ".length] = new Option (Company_LabelArray[selected]);
	 inForm." . $source_array[$i] . ".options[inForm." . $source_array[$i] . ".length-1].value = Company_LabelArray[selected];
  }

  while (inForm." . $target_array[$i] . ".options.length) { inForm." . $target_array[$i] . ".options[0] = null; }

  metr = 0;
  i = 0;
  while (metr < LocationCompany_idArray.length)
  {
	if (Location_LabelArray[metr] == flag_companylocation_name_param)
	{
		if (flag_companylocation_name_param != '')
		{ special_flag = i; }
	}
	
	if (selected == LocationCompany_idArray[metr])
	{
		inForm." . $target_array[$i] . ".options[inForm." . $target_array[$i] . ".length] = new Option (Location_LabelArray[metr]);
		inForm." . $target_array[$i] . ".options[inForm." . $target_array[$i] . ".length-1].value = Location_idArray[metr];
		i = i + 1;
	}
	metr = metr + 1;
  }

  if (selected == \"\")
  {
	inForm." . $target_array[$i] . ".options[inForm." . $target_array[$i] . ".length] = new Option (\"<------------------\");
  }
  
  if (special_flag == -1)
  { inForm." . $target_array[$i] . ".options[0].selected = 'selected'; }
  else
  { inForm." . $target_array[$i] . ".options[special_flag].selected = 'selected'; }
   
  }";
}

$JAVASCRIPT = $JAVASCRIPT . "function check_userlevel(type_of_check) 
		       	     {
		        	var client, technician, admin;
				
				client = document.forms[0].client;
				technician = document.forms[0].technician;
				admin = document.forms[0].admin;
			  
				if (technician.checked)	{ client.checked = 'true'; }
				if (admin.checked)		{ client.checked = 'true';
				 				  technician.checked = 'true'; }
			  

			       }";

return $JAVASCRIPT;
}


### SubRoutine for checking the default company value depending on the location value ###

sub sub_def_value_company
{
my ($dbh, $location_value) = @_;
my $return_value = 0;

	my $dst = "SELECT id, company_id FROM st_companieslocations WHERE id = $location_value";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @row_ary;
	if ($sth->rows == 1) {
		@row_ary = $sth->fetchrow_array;
		$return_value = $row_ary[1];
	};
	return $return_value;
}


1;
