#!/usr/bin/perl

#########################################################################################
# User management code.									#
#											#
# Artists: Politis Konstantinos								#
#	   Dourmousoglou Alexandros							#
#	   Theodore J. Soldatos								#
#											#
# Copyright (C) 2004-2005 Space Hellas							#
# Copyright (C) 2004-2005 Theodore J. Soldatos						#
#											#
# This program is free software; you can redistribute it and/or				#
# modify it under the terms of the GNU General Public License				#
# as published by the Free Software Foundation; either version 2			#
# of the License, or (at your option) any later version.				#
#											#
# This program is distributed in the hope that it will be useful,			#
# but WITHOUT ANY WARRANTY; without even the implied warranty of			#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the				#
# GNU General Public License for more details.						#
#											#
# You should have received a copy of the GNU General Public License			#
# along with this program; if not, write to the Free Software				#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,				#
# MA  02110-1301, USA									#
#											#
#											#
# Revision history: 									#
# V0.1.0	Clone from zs_usermanagement.pl V0.0.3					#
# V0.1.1	New code for communication with the					#
#               latest version of STUNT database					#
# V0.1.2	Fix procedures => 							#
#		1. Add user record							#
#		2. Edit/Update User Record						#
#		3. Background Messages							#
# --------------------------------------------------------------------->>>		#
# V1.0.0	Fix Procedures Operation						# 
#		(Including Javascript, control procedures,				#
#		 fixing gui interface,....)						#
# V1.0.1	- Add two (2) more subroutines for supporting 				#
#		the error cases (display the input-update forms with the		#
#		proper error messages):							#
#											#
#		1) sub display_input_form : Displays the input form (insert		#
#		   			    user record) with a status bar		#
#					    (error bar).				#
#		2) sub display_update_password_form : The same with the 		#
#						      above routine for 		#
#						      update password form.		#
#		- Add subroutine display_password_activation_form which			# 
#		display the passwordform (with the proper error messages)		#
#		[When you activate an old user, a new password must be inserted! 	#
#											#
#		- Fix problems with active flag (activation - disactivation user)	#
#		1. Activation (Create User with password - active flag => true) 	#
#		2. Disactivation (Drop User - Change active flag => false)		#
# V1.0.2	Fix greek titles, messages of gui output.				#
# V1.0.3	Fix mechanism <company_id> parameter to st_usermanagement_pl		#
#		[Display only the users which belong to the special company_id,		#
#		adding a link for returning to the previous form].			# 
# V1.0.4	Fix bug when calling user management from companies.			#
# 		When usermanagement code is calling with company_id parameter		#
#		all the actions (add, update, activate, disactivate) must executed	#
#		with base the parameter company_id (pages links, operation).		# 
#		Fix javascript operation too when passing company_id parameter.		#
# V1.0.5	Added more info in main user directory.					#
#		Fix bug activation (fullname) - confused with the parameters.		#
# V1.0.6	Fix javascript bug (control_lists - onLoad page), passing one more	#
#		parameter, the (user) selected companylocation_name.			#
#		Default value '' when it is used for another purpose. 			#
#		Fix form to manage st_techsmc_faulttypes. Will be available for admin	#
#		users only.								#
# V1.0.7	Fix admin group previleges to edit, activate and insert pages of 	#
#		usermanagement interface. 						#
#		- Users details screen should be read-only for non-admin users.		#
#		- edit/activate/insert links should not be available for non-admin 	#
#		  users.								#
# V1.0.8	English version of gui interface.					#
# V1.0.9	Now (when action is edit user details) printing foremost categories	#
#		for current user.							#
# V1.0.10	Fix managing grants to table st_surv_answ by user.			#
# V1.0.11	Fix bug --> checkbox grants survey - now operation looks good.		#
# V1.0.12	Building the form to send mass mail to users (by company).		#
# V1.0.13	Terminology and translation review.					#
# V1.0.14	Added display user details screen (r/o). NOT FINISHED YET.		#
# V1.0.15	Added display user details screen (r/o). FINISHED.			#
# V1.0.16	Fixed field sizes (made longer).					#
# V1.0.17	Added info on new fields of st_techsmc_faulttypes. Read-only, on new 	#
#		categories extra info must be inserted manually.			#
# V1.0.18	Added simple user statistics.						#
# V1.0.19	Cosmetic change.							#
# V1.0.20	ORDER BY added.								#
# V1.0.21	Added Categories per SCSE details					#
# V1.0.22	Added User Level field							#
# V1.0.23	Corrected display bug in companies user management.			#
# V1.0.24	Replaced hardcoded encodings with parameter.				#
# V1.0.25	Replaced hardcoded language with parameter.				#
#											#
# Arguments description (* = internal, not menu):					#
# 	action: 									#
#	0: 	User list								#
#	1: 	User edit								#
#	2: 	User delete (confirmation)						#
#	3: 	User edit - post changes.						#
#	4: 	New user								#
#	5: 	User delete 								#
#	7: 	User password change.							#
#	8:	Control fault type (for techs_mc users only)				#
#	9:	Mass mail to users (by company)						#
#	10:	Just print user info (copy from 1)					#
#											#
#########################################################################################

use strict;
use DBI;
use CGI;
use st_lib;
use st_jscript;
use Mail::Sender;				# Perl Module for sending mails
use MIME::QuotedPrint;				# Perl Module for encoding - or decoding - of quoted-printable strings 


my $data_source = $st_lib::data_source;		# Where to look...
my ($sth, $ssth); 				# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables
my $JAVASCRIPT;					# String for Javascript routines
my $flag_control;				# Temp flag control for checking pg_users activation
my $flag_company_id_param;
my $debug = $st_lib::debug;
my $myhost = $st_lib::myhost;
my ($flag_techs_mc_group, $flag_admin_group);	# Flag for checking if current user belongs to the admin group
my $name_location;
my $smtpserver = $st_lib::smtpserver;
my $fromaddress = $st_lib::fromaddress;

# Colors

my $bgcolor = 		$st_lib::bgcolor; 		# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;		# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;	# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;		# Cells in tables
my $textcolor =		$st_lib::textcolor;		# General text color
my $headtextcolor = 	$st_lib::headtextcolor;		# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;	# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;		# Links
my $vlinkcolor =	$st_lib::vlinkcolor;		# Visited links

my $cgipath = 		$st_lib::cgipath; 		# CGI path
my $sencoding =		$st_lib::sencoding;		# Encoding for HTML etc
my $slang =		$st_lib::slang;			# Language for HTML etc


my %formtitles = ( 	

		# Form title depending on action. Also used to check
		# parameter validity.

		0 => 'User index',
		1 => 'User details',
		2 => 'Confirm user disactivation',
		3 => 'Edit user',
		4 => 'Add new user',
		5 => 'User disactivation',
		6 => 'User activation',
		7 => 'Change password',
		8 => 'Category foremost',
		9 => 'Mass mails',
		10 => 'User details'
		);

my $version = "st_usermanagement.pl V1.0.25";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');

### Gets all categoryforemost parameters, and puts them into catformost array ###
my @REST=$query->param;
my $koder=0;
my $koder1=0;
my $tmp="";
my @catformost;
for (@REST)
{
	if ($REST[$koder]=~"CATEG_")
	{
		($tmp,$catformost[$koder1][0],$catformost[$koder1][1])=split(/_/,$REST[$koder]);
		$koder1++;
	}
	$koder++;	
}


my $action = $chooserlist[0];
my $passchngspecial = $chooserlist[1];

if (not (exists $formtitles{$action})) {

	# Default is 0
	$action = 0;
};

# Check credentials, if not ok call GetUserForLogin

my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);

if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Initialize CGI and send headers.
# Successfully change password - action = 7

my $param_company_id = $chooserlist[1];
my $rmsg = '';
my $rcol = 'GREEN';

### Check if the logged user belongs to the admin group ###

$flag_admin_group = 0;
$flag_admin_group = check_user_if_group_admin ($dbh, $zuser);

if (($action == 7) and ($passchngspecial == 1)) 
{
	# Do the change
	my $pass1 = $query->param('pass1');
	$pass1 =~ s/^\s*(.*?)\s*$/$1/;
	my $pass2 = $query->param('pass2');
	$pass2 =~ s/^\s*(.*?)\s*$/$1/;
	my $oldpass = $query->param('oldpass');
	$oldpass =~ s/^\s*(.*?)\s*$/$1/;

	if ( $pass1 ne $pass2 ) {
		$rmsg = "Passwords are not the same.";
		$rcol = 'RED';
	}
	elsif ($pass1 eq '') {
		$rmsg = "Empty password.";
		$rcol = 'RED';
	}
	elsif (length($pass1) < 6) {
		$rmsg = "Password must have at least 6 characters.";
		$rcol = 'RED';
	};
	
	if ($rmsg eq '') 
	{
		# No errors so far, do the change.
		my $dst = "ALTER USER $zuser PASSWORD \'$pass1\'";
		my $sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) {
			# Bummer.
			$rmsg = $sth->errstr;
			$rcol = 'RED';
			print "<P><H2><FONT COLOR=$rcol>$rmsg</FONT></H2><P>";
		} 
		else 
		{
			$dbh->commit;
				
			# Special case - password change.
			# Must login
			st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
			exit;
		};
	}
	else
	{
		print  $query->header(-charset=>$sencoding);
		
		# Prepare the javascript
		my @sna = "companies_id";
		my @tna = "companieslocations_id";

		my $JAVASCRIPT = st_jscript::control_lists_with_javascript($dbh,\@sna, \@tna);

		print  $query->start_html(-title=>$formtitles{$action},
				 	  -script=>$JAVASCRIPT,
					  -text=>$textcolor,
					  -lang=>$slang,
					  -BGCOLOR=>$bgcolor);

		st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);
		print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";
		
		### Display the previous form (update form - change password) ###
		display_update_password_form ($rmsg, $query, $cgipath, $headcellcolor, $cellcolor, $rcol);
	};
}
else
{
	### Other cases do the classic ###
	
	print $query->header(-charset=>$sencoding);

	# Prepare the javascript
	my @sna = "companies_id";
	my @tna = "companieslocations_id";

	my $JAVASCRIPT = st_jscript::control_lists_with_javascript($dbh,\@sna, \@tna);
	
	my $onLoad = '';
	
	if (!($param_company_id eq 'pflag'))
	{ 
		if ($action eq 4)
		{
			### Case of load insert (add user record) form with param company_id of course ###
			$onLoad = "control_lists(document.insertform, $param_company_id, 1, '')"; 
		}
		else
		{
			### Case of load update (update user record) form with param company_id of course ###
			$onLoad = "control_lists(document.updateform, $param_company_id, 1, '')";
		}
	}
	else
	{
		if ($action eq 1)
		{
			my $temp_param = $chooserlist[2];
			my $param_company_id = '';
			my $pguserid;

			if ($temp_param eq 'pflag')
			{
				### Case of passing parameter company_id (pflag --> url location [2]) ###
				$param_company_id = $chooserlist[1];	# Case of param company_id
				$pguserid = $chooserlist[3];
			}
			else
			{
				### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
				$param_company_id = '';
				$pguserid = $temp_param; # 0=Just print, 1=Try to create.
			};

			$dst = "SELECT u.companylocation_id 
				FROM st_users u WHERE u.id = $pguserid";
        
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (st_lib::sthErr($sth->err, $sth->errstr)) { 
				# Failed 
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
	
			my @row_ary = $sth->fetchrow_array;
		
			## Check the default value for company depending on the location value ###	
			my $default_value_for_company = st_jscript::sub_def_value_company($dbh, $row_ary[0]);

			### Find the index of companylocation - for using it in javascript code ###
			$dst = "SELECT u.id, u.name 
				FROM st_companieslocations u WHERE u.id = $row_ary[0]";

			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (st_lib::sthErr($sth->err, $sth->errstr)) { 
				# Failed 
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};

			if (@row_ary = $sth->fetchrow_array)
			{ $name_location =  $row_ary[1]; }
			
			### Case of load update (update user record) form without param company_id of course ###
			$onLoad = "control_lists(document.updateform, $default_value_for_company, 0, '$name_location')";
		}
	}

	print  $query->start_html(-title=>$formtitles{$action},
			 	  -script=>$JAVASCRIPT,
				  -text=>$textcolor,
				  -onLoad=>$onLoad,
				  -lang=>$slang,
				  -BGCOLOR=>$bgcolor);

	st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);

	print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";
}

#---------------------------------------------#
### Everything from here is action depended ###
#---------------------------------------------#

if ($action == 0) {
	
	# Display user catalog - action = 0
	
	my $dst = "SELECT u.id, u.username, u.fullname, u.client, u.technician, u.admin, u.email, u.phone1, u.phone2,
			  u.fax, u.active, u.main_contact, u.userlevel_id, u.companylocation_id,
			  l.name, l.description, c.name
		   FROM st_users u INNER JOIN st_companieslocations l ON u.companylocation_id = l.id
		   		   INNER JOIN st_companies c ON l.company_id = c.id
				   ORDER BY c.id, u.fullname, u.technician, l.id";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	print "<TABLE>";
	print "<TR><TD BGCOLOR=$headcellcolor>Username</TD>";
	print "<TD BGCOLOR=$headcellcolor>Fullname</TD>";
	print "<TD BGCOLOR=$headcellcolor>Company</TD>";
	print "<TD BGCOLOR=$headcellcolor>Location</TD>";
	print "<TD BGCOLOR=$headcellcolor>Permissions</TD>";
	print "<TD BGCOLOR=$headcellcolor></TD></TR><TR>";

	my @row_ary;
	my $permissions;
	
	while (@row_ary = $sth->fetchrow_array) {
		
		if ($row_ary[5] == 1) {
			$permissions = '<FONT COLOR=RED>Administrator</FONT>';
		} elsif ($row_ary[4] == 1) {
			$permissions = '<FONT COLOR=GREEN>CSE</FONT>';
		} elsif ($row_ary[3] == 1) {
			$permissions = '<FONT COLOR=BLUE>Customer</FONT>';
		} else {
			$permissions = '<FONT COLOR=RED>Unknown!!!</FONT>';
		};

		if ($row_ary[11] == 1) {
			$permissions = "<B>$permissions</B>";
		};
		#--------------------------------------------------------------------------#
		### Check case of calling st_usermanagement.pl with parameter company_id ###
		#--------------------------------------------------------------------------#
		
		$flag_company_id_param = 0;
		
		if (!($param_company_id eq ''))
		{
			$flag_company_id_param = 1;

			#-------------------------------------------------------------#
			### Check if this user belongs to this company (company_id) ###
			#-------------------------------------------------------------#
		
			### Find the company_id of current user ###
			$dst = "SELECT u.company_id 
		  		FROM st_companieslocations u WHERE u.id = $row_ary[13];";
      
			$ssth = $dbh->prepare($dst);
			$ssth->execute;
			if (st_lib::sthErr($ssth->err, $ssth->errstr)) { 
				# Failed 
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};

			my @temp_row_ary;
			if (@temp_row_ary = $ssth->fetchrow_array)	
			{
				### Compare the parameter with the company_id of current user ###
				if ($param_company_id eq $temp_row_ary[0])
				{	$flag_company_id_param = 2;	}
			}
		}
		
		#-------------------------------------#
		### Explain (flag_company_id_param) ###
		#-------------------------------------#

		# $flag_company_id_param --> 	0: means no passing parameter company_id
		#				1: passing parameter but user doesn 't belong to the specific company
		#				2: passing and matching with the specific company
		
		if (($flag_company_id_param eq 0) or ($flag_company_id_param eq 2)) 
		{
			if ($flag_admin_group eq 1)
			{
				if ($flag_company_id_param eq 0)
				{
					print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_usermanagement.pl?1+pflag+$row_ary[0]\">$row_ary[1]</TD>";
				}
				else
				{
					print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_usermanagement.pl?1+$param_company_id+pflag+$row_ary[0]\">$row_ary[1]</TD>";
				}
			}
			else
			{
				print "<TR><TD BGCOLOR=$cellcolor>$row_ary[1]</TD>";
			}

			print "<TD BGCOLOR=$cellcolor><B>$row_ary[2]</B></TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[16]</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[14] ($row_ary[15])</TD>";
			print "<TD BGCOLOR=$cellcolor>$permissions</TD>";
		
			#####  Check pg_users file to find out which users can be disactivated  #####
	
			$flag_control = "false";	# By default false - user has been disactivated
							# flag_control = true - user is superuser - always activated
		
			$flag_control = st_jscript::check_pg_users_for_delete($row_ary[1]);
		
			if (($flag_control eq "true") or ($flag_admin_group eq 0)) 
			{
				print "<TD BGCOLOR=$cellcolor></TD></TR>";
			} 
			else 
			{
				if ($row_ary[10] eq 1)
				{
					if ($flag_company_id_param eq 0)
					{
						print "<TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_usermanagement.pl?2+pflag+$row_ary[0]\">Disactivation</TD>";
					}
					else
					{
						print "<TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_usermanagement.pl?2+$param_company_id+pflag+$row_ary[0]\">Disactivation</TD>";
					}
				}
				else
				{
					if ($flag_company_id_param eq 0)
					{
						print "<TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_usermanagement.pl?6+pflag+$row_ary[0]+$row_ary[1]\">Activation</TD>";
					}
					else
					{
						print "<TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_usermanagement.pl?6+$param_company_id+pflag+$row_ary[0]+$row_ary[1]\">Activation</TD>";
					}
				}
			}
		}
	};
	print "</TABLE>";
		
	if (!($param_company_id eq ''))
	{
		if ($flag_admin_group eq 1)
		{ print "<P><A HREF=\"$cgipath/st_usermanagement.pl?4+$param_company_id+pflag\">Add new user</A>"; }
		
		### Case of parameter company_id - load a link for returning to the previous form ###
		print "<P><A HREF=\"$cgipath/st_companies.pl?4+$param_company_id\">Return</A>";
	}
	else
	{
		if ($flag_admin_group eq 1)
		{ print "<P><A HREF=\"$cgipath/st_usermanagement.pl?4+pflag\">Add new user</A>"; }
	}
	
} elsif ($action == 1) {
	
	# Edit user (user record) - action = 1
	
	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $pguserid;

	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$pguserid = $chooserlist[3];
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$pguserid = $temp_param; # 0=Just print, 1=Try to create.
	};

	my $rcol = $headcellcolor;

	my $dst = "SELECT u.id, u.username, u.fullname, u.client, u.technician, u.admin, u.email, u.phone1, u.phone2,
			  u.fax, u.active, u.main_contact, u.userlevel_id, u.companylocation_id 
		   FROM st_users u
		   WHERE u.id = $pguserid";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	### Check if passing any company_id parameter ###
	
	$flag_company_id_param = 0;
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}
	
	my @row_ary = $sth->fetchrow_array;

	if ($flag_company_id_param eq 0)
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?3+pflag+$row_ary[0]",
						 -name=>'updateform',
	                		         -enctype=>$sencoding);
	}
	else
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?3+$param_company_id+pflag+$row_ary[0]",
						 -name=>'updateform',
	                		         -enctype=>$sencoding);
	}
	
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>Username: <B>$row_ary[1]</B></CENTER></TD></TR>";
	

	# HTML code - Display the edit form of user record

	print "<TR><TD BGCOLOR=$headcellcolor ALIGN=right>Fullname: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'fullname',
				-size=>30,
				-value=>$row_ary[2],
				-maxlength=>2048);
	my $check_value = 'false';
	
	print "<TD BGCOLOR=$headcellcolor ALIGN=right>Email: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'email',
				-value=>$row_ary[6],
				-size=>25,
				-maxlength=>256);
				
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN=right>Phone (1): </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'phone1',
				-value=>$row_ary[7],
				-size=>10,
				-maxlength=>20);

	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=right>Phone (2): </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'phone2',
				-value=>$row_ary[8],
				-size=>10,
				-maxlength=>20);
	
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN=right>Fax: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'fax',
				-value=>$row_ary[9],
				-size=>10,
				-maxlength=>20);

	### Userlevels values

	my ($st_level_id, $st_level_names) = st_jscript::sub_userlevel_names;

	print "<TD BGCOLOR=$headcellcolor ALIGN='right'>User Type: </TD><TD BGCOLOR=$rcol>";
	print $query->popup_menu(-name=>'userlevel_id',
				     -values=>$st_level_id,
				     #-default=>$default_value_for_level,
				     -default=>$row_ary[12],
				     -labels=>$st_level_names
				     #-onChange=>$onChange);
				     );
	print "</TD>";

	$check_value = 'false';
	if ($row_ary[10] == '1') { $check_value = 'true'; }
	
	print $query->hidden(-name=>'active',
			       -value=>$check_value,
			       -label=>'Active',
			       -checked=>$row_ary[10]);

	# Take the companies from st_companies table
	my ($st_companies_id, $st_companies_names) = st_jscript::sub_companies_names;
	my $onChange="control_lists(document.updateform,document.updateform.companies_id.options[document.updateform.companies_id.selectedIndex].value, 0, '')";
	
	### Check the default value for company depending on the location value ###	
	my $default_value_for_company = st_jscript::sub_def_value_company($dbh,$row_ary[13]);
	
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Company: </TD><TD BGCOLOR=$rcol>";
	if ($flag_company_id_param == 1) {
		print $query->hidden(-name=>'companies_id',
			       	     -default=>$default_value_for_company);
		print "<B>$$st_companies_names{$default_value_for_company}</B>";
	} else {
		print $query->popup_menu(-name=>'companies_id',
					 -values=>$st_companies_id,
					 -default=>$default_value_for_company,
					 -labels=>$st_companies_names,
					 -onChange=>$onChange);
	};
	print "</TD>";
	
	# Take the company locations from st_companieslocations table
	my ($st_companieslocations_id, $st_companieslocations_names);
	if ($flag_company_id_param == 1) {
		# We need only the locations of the specific company.
		($st_companieslocations_id, $st_companieslocations_names) = st_jscript::sub_companieslocations_names($default_value_for_company);
	} else { 
		($st_companieslocations_id, $st_companieslocations_names) = st_jscript::sub_companieslocations_names;
	};

	print "<TD BGCOLOR=$headcellcolor ALIGN='right'>Location: </TD><TD BGCOLOR=$rcol>";
	print $query->popup_menu(-name=>'companieslocations_id',
				     -values=>$st_companieslocations_id,
				     -default=>$row_ary[13],
				     -labels=>$st_companieslocations_names);
	print "</TD></TR>";

	$check_value = 'false';
	if ($row_ary[3] == '1') { $check_value = 'true'; }
	
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Type of user:</TD><TD BGCOLOR=$rcol>";
	print $query->checkbox(-name=>'client',
			       -value=>$check_value,
			       -label=>'Customer',
			       -checked=>$row_ary[3],
			       -onClick=>"check_userlevel('client')");

	$check_value = 'false';
	if ($row_ary[4] == '1') { $check_value = 'true'; }
	
	print "</TD><TD BGCOLOR=$rcol>";
	print $query->checkbox(-name=>'technician',
			       -value=>$check_value,
			       -label=>'CSE',
			       -checked=>$row_ary[4],
			       -onClick=>"check_userlevel('technician')");
	
	$check_value = 'false';
	if ($row_ary[5] == '1') { $check_value = 'true'; }

	print "</TD><TD BGCOLOR=$rcol>";
	print $query->checkbox(-name=>'admin',
			       -value=>$check_value,
			       -label=>'Admin',
			       -checked=>$row_ary[5],
			       -onClick=>"check_userlevel('admin')");

	$check_value = 'false';
	if ($row_ary[11] == '1') { $check_value = 'true'; }

	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$rcol COLSPAN=3>";
	print $query->checkbox(-name=>'main_contact',
			       -value=>$check_value,
			       -label=>'Main Contact',
			       -checked=>$row_ary[11]);
	
	print "</TD></TR>";
	
	$flag_techs_mc_group = 0;	### By default the flag is 0 - User doesn't belong to techs_mc group ###
	$flag_techs_mc_group = check_user_if_group_techs_mc (@row_ary);

	### Hidden field for passing <username> to update page (action) ###
	print $query->hidden(-name=>'username',
			     -value=>$row_ary[1]);
	
	### Check the flags and display the proper link ###

	if ($flag_admin_group eq 1)
	{
		if ($flag_techs_mc_group eq 1)
		{
			if ($flag_company_id_param eq 0)
			{
				print "<TR><TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$headcellcolor COLSPAN=3><A HREF=\"$cgipath/st_usermanagement.pl?8+pflag+$row_ary[0]+$row_ary[1]\">Category foremost</TD></TR>";
			
				#----------------------------------------------------------------------------------------------#
				### Call sub_catforemost_display routine for "printing" foremost categories for current user ###
				#----------------------------------------------------------------------------------------------#

				$rcol = 'GREEN';
				sub_catforemost_display ($dbh, $pguserid, $rcol);
			}
			else
			{
				print "<TR><TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$headcellcolor COLSPAN=3><A HREF=\"$cgipath/st_usermanagement.pl?8+$param_company_id+pflag+$row_ary[0]+$row_ary[1]\">Category foremost</TD></TR>";

				#----------------------------------------------------------------------------------------------#
				### Call sub_catforemost_display routine for "printing" foremost categories for current user ###
				#----------------------------------------------------------------------------------------------#

				$rcol = 'GREEN';
				sub_catforemost_display ($dbh, $pguserid, $rcol);
			}
		}

		#-----------------------------------------------------------------------------------------------------#
		### Call sub_grants_serv_display routine for managing grants to table st_surv_answ for current user ###
		#-----------------------------------------------------------------------------------------------------#
		
		sub_grants_serv_display ($dbh, $row_ary[1]);
	}
	
	print "</TD></TR>";
	
	if ($flag_admin_group eq 1)
	{
		print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";
		print $query->submit(-value=>'Update');
		print "</CENTER></TD></TR>";
	}
	
	print "</TABLE>";
	print $query->endform;

	if ($flag_company_id_param eq 0)
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
	else
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }

} elsif ($action == 2) {
	
	# Disactivation user confirmation - action = 2
	
	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $pguserid;

	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$pguserid = $chooserlist[3];
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$pguserid = $temp_param; # 0=Just print, 1=Try to create.
	};

	### Check if passing any company_id parameter ###
	
	$flag_company_id_param = 0;
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}

	$dst = "SELECT u.id, u.username, u.fullname, u.client, u.technician, u.admin, u.email, u.phone1, u.phone2,
		       u.fax, u.active, u.main_contact, u.userlevel_id, u.companylocation_id 
		FROM st_users u
		WHERE u.id = $pguserid";

	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @row_ary = $sth->fetchrow_array;

	print "<H2>User disactivation <B>$row_ary[1] ($row_ary[2])</B></H2><P><FONT COLOR=RED><H2>Confirm?</H2></FONT><P>";
	print "<TABLE><TR>";
	
	if ($flag_company_id_param eq 0)
	{
		print "<TD><H3><A HREF=\"$cgipath/st_usermanagement.pl?5+pflag+$row_ary[0]+$row_ary[1]\"><FONT COLOR=RED>Yes</FONT></A></H3></TD><TD> -- </TD><TD><H3><A HREF=\"$cgipath/st_usermanagement.pl?0\"><FONT COLOR=GREEN>No</FONT></A></H3></TD>";
	}
	else
	{
		print "<TD><H3><A HREF=\"$cgipath/st_usermanagement.pl?5+$param_company_id+pflag+$row_ary[0]+$row_ary[1]\"><FONT COLOR=RED>Yes</FONT></A></H3></TD><TD> -- </TD><TD><H3><A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\"><FONT COLOR=GREEN>No</FONT></A></H3></TD>";
	}

} elsif ($action == 3) {
	
	# Update user (user record) - action = 3
	
	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $pguserid;

	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$pguserid = $chooserlist[3];
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$pguserid = $temp_param; # 0=Just print, 1=Try to create.
	};

	### Check if passing any company_id parameter ###
	
	$flag_company_id_param = 0;
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}

	my $username = $query->param('username');
	my $newname = $query->param('fullname'); 
	
	my $newclient = 'false';
	if ($query->param('client')) { $newclient = 'true'; }

	my $newtechnician = 'false';
	if ($query->param('technician')) { $newtechnician = 'true'; }

	my $newadmin = 'false';
	if ($query->param('admin')) { $newadmin = 'true'; }

	my $newemail = $query->param('email');
	my $newphone1 = $query->param('phone1');
	my $newphone2 = $query->param('phone2');
	my $newfax = $query->param('fax');

	my $nu_userlevel = $query->param('userlevel_id');

	my $newmain_contact = 'false';
	if ($query->param('main_contact')) { $newmain_contact = 'true'; }
	
	my $newcompanies_id = $query->param('companieslocations_id');
	
	# SQL statement which update user record

	$dst = "UPDATE st_users SET fullname = '$newname',
	           	            client = '$newclient',
				    technician = '$newtechnician',
				    admin = '$newadmin',
				    email = '$newemail',
				    phone1 = '$newphone1',
				    phone2 = '$newphone2',
				    fax = '$newfax',
				    main_contact = '$newmain_contact',
				    userlevel_id = '$nu_userlevel',
				    companylocation_id = '$newcompanies_id'
		  		    WHERE id = '$pguserid'";
	
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	if ($sth->rows != 1) {
		# There was no record, insert one. 
		
		# SQL statements which insert a new user record
		
		# What statements ?
		
		my $sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
	};
	
	### Check grant_survey checkbox ###
	my $grant_survey = $query->param('grant_survey');

	if ($grant_survey)
	{
		print STDERR "Checkbox (grant) is checked - Add grants !!!";
		### Start add grants.... 
	
		$dst = "GRANT SELECT ON st_surv_answ TO $username";
	
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
	}
	else
	{
		print STDERR "Checkbox (grant) is not checked - Remove grants !!!";
		### Start remove grants....
		
		$dst = "REVOKE SELECT ON st_surv_answ FROM $username";
	
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
	}
	
	$dbh->commit;
	print "<H2><FONT COLOR=GREEN>Successful update</FONT></H2><P>";

	if ($flag_company_id_param eq 0)
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
	else
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }

} elsif ($action == 4) {
	
	# Add new user (user record) - action = 4
	
	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $param;

	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$param = $chooserlist[3]; # 0=Just print, 1=Try to create.
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$param = $temp_param; # 0=Just print, 1=Try to create.
	};

	my $rmsg = ''; 
	my $rcol = $headcellcolor;
		
	if ($param) 
	{
		#---------------------------------------------------------------------------------------------------------#
		### Check case of calling st_usermanagement.pl (action 4+pflag+1 [create it]) with parameter company_id ###
		#---------------------------------------------------------------------------------------------------------#
	
		$flag_company_id_param = 0;
		
		if (!($param_company_id eq ''))
		{
			$flag_company_id_param = 1;
		}

		# Try to create
		my $username = $query->param('username');
		# Trim white space
		$username =~ s/^\s*(.*?)\s*$/$1/;
		my $fullname = $query->param('fullname');
		$fullname =~ s/^\s*(.*?)\s*$/$1/;
		my $pass1 = $query->param('pass1');
		$pass1 =~ s/^\s*(.*?)\s*$/$1/;
		my $pass2 = $query->param('pass2');
		$pass2 =~ s/^\s*(.*?)\s*$/$1/;
	
		if ($username eq '') {
			$rmsg = "Empty username.";
			$rcol = 'RED';
		}
		elsif ( $pass1 ne $pass2 ) {
			$rmsg = "Passwords are not the same."; 
			$rcol = 'RED';
		}
		elsif ($pass1 eq '') {
			$rmsg = "Empty password.";
			$rcol = 'RED';
		}
		elsif (length($pass1) < 6) {
			$rmsg = "Password must have at least 6 characters.";
			$rcol = 'RED';
		};

		if ($rmsg eq '') {
			# No error so far, try to insert.
			my $dst = "CREATE USER $username WITH PASSWORD \'$pass1\'";
			my $sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined ($sth->err)) { 
				# Failed 
				$rmsg = $sth->errstr;
				$rcol = 'RED';
			} else {
				# Insert fullname record

				my $newname = $query->param('fullname'); # Nothing else...

				my $newclient = 'false';
				if ($query->param('client')) { $newclient = 'true'; }

				my $newtechnician = 'false';
				if ($query->param('technician')) { $newtechnician = 'true'; }

				my $newadmin = 'false';
				if ($query->param('admin')) { $newadmin = 'true'; }

				my $newemail = $query->param('email');
				my $newphone1 = $query->param('phone1');
				my $newphone2 = $query->param('phone2');
				my $newfax = $query->param('fax');

				my $newmain_contact = 'false';
				if ($query->param('main_contact')) { $newmain_contact = 'true'; }
	
				my $newcompanieslocations_id = $query->param('companieslocations_id');

				# SQL statement which insert user record

				$dst = "INSERT INTO st_users (username, fullname,
					 	              client, technician,
							      admin, email, phone1, phone2,
							      fax, main_contact, userlevel_id, companylocation_id)
						   	      VALUES ('$username', '$newname',
								         '$newclient', '$newtechnician',
								         '$newadmin',  '$newemail',
								         '$newphone1', '$newphone2',
								         '$newfax', '$newmain_contact', '0',
								         '$newcompanieslocations_id')";
				my $sth = $dbh->prepare($dst);
				$sth->execute;
				if (defined ($sth->err)) { 
					# Failed 
					$rmsg = $sth->errstr;
					$rcol = 'RED';
				};
			};
		};
		if ($rmsg eq '') {
			# Commit it.
			$dbh->commit;
			$rmsg = "Successfully added user!";
			$rcol = 'GREEN';
			print "<H2><FONT COLOR=GREEN>Successfully added user</FONT></H2><P>";

			if ($flag_company_id_param eq 0)
			{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
			else
			{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>";}
		} else {

			### Display the previous form (inputform - insert user record) with a status bar which 
			### will inform user for the specific error

			display_input_form($rmsg, $query, $cgipath, $headcellcolor, $cellcolor, $rcol, $flag_company_id_param, $param_company_id);
			
			$dbh->rollback;
		};

	}
	else {

	#-------------------------------------------------------------------------------------#
	### Check case of calling st_usermanagement.pl (action 4) with parameter company_id ###
	#-------------------------------------------------------------------------------------#
	
	$flag_company_id_param = 0;
		
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}

	
	# HTML code - Display the input form of user record
	
	if ($flag_company_id_param eq 0)
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?4+pflag+1",
					 -name=>'insertform',
                        		 -enctype=>$sencoding);
	}
	else
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?4+$param_company_id+pflag+1",
					 -name=>'insertform',
                        		 -enctype=>$sencoding);
	}
	
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Username: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'username',
				-size=>16,
				-maxlength=>32);
	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=right>Fullname: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'fullname',
				-size=>30,
				-maxlength=>2048);
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Password: </TD><TD BGCOLOR=$cellcolor>";
	print $query->password_field(-name=>'pass1',
				-size=>10,
				-maxlength=>10);
	print "</TD><TD BGCOLOR=$headcellcolor>Confirm password: </TD><TD BGCOLOR=$cellcolor>";
	print $query->password_field(-name=>'pass2',
				-size=>10,
				-maxlength=>10);
	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Email: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'email',
				-size=>25,
				-maxlength=>256);

	print "</TD><TD BGCOLOR=$headcellcolor ALIGN='right'>Fax: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'fax',
				-size=>10,
				-maxlength=>10);

	print "</TD></TR>";
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Phone (1): </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'phone1',
				-size=>10,
				-maxlength=>20);

	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=right>Phone (2): </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'phone2',
				-size=>10,
				-maxlength=>20);
	
	print $query->hidden(-name=>'active',
			       -label=>'Active',
			       -value=>'true');

	# Take the companies from st_companies table
	
	my ($st_companies_id, $st_companies_names) = st_jscript::sub_companies_names;
	my $onChange = "control_lists(document.insertform,document.insertform.companies_id.options[document.insertform.companies_id.selectedIndex].value, 0, '')";
	
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Company: </TD><TD BGCOLOR=$rcol>";
	if ($flag_company_id_param == 1) {
		print $query->hidden(-name=>'companies_id',
			       	     -default=>$param_company_id);
		print "<B>$$st_companies_names{$param_company_id}</B>";
	} else {
		print $query->popup_menu(-name=>'companies_id',
				     -values=>$st_companies_id,
				     -onChange=>$onChange,
				     -default=>'',
				     -labels=>$st_companies_names);
	};

	print "</TD>";
	
	# Take the company locations from st_companieslocations table
	my ($st_companieslocations_id, $st_companieslocations_names);
	if ($flag_company_id_param == 1) {
		# We need only the locations of the specific company.
		($st_companieslocations_id, $st_companieslocations_names) = st_jscript::sub_companieslocations_names($param_company_id);
	} else { 
		($st_companieslocations_id, $st_companieslocations_names) = st_jscript::sub_companieslocations_names;
	};


	print "<TD BGCOLOR=$headcellcolor ALIGN='right'>Location: </TD><TD BGCOLOR=$rcol>";
	print $query->popup_menu(-name=>'companieslocations_id',
				     -values=>$st_companieslocations_id,
				     -default=>'',
				     -labels=>$st_companieslocations_names);
	print "</TD></TR>";

	print "<TR><TD BGCOLOR=$rcol ALIGN='right'>Type of user:</TD><TD BGCOLOR=$rcol>";
	print $query->checkbox(-name=>'client',
			       -label=>'Customer',
			       -value=>'false',
			       -onClick=>"check_userlevel('client')");

	print "</TD></TD><TD BGCOLOR=$rcol>";
	print $query->checkbox(-name=>'technician',
			       -label=>'CSE',
			       -value=>'false',
			       -onClick=>"check_userlevel('technician')");

	print "</TD></TD><TD BGCOLOR=$rcol>";
	print $query->checkbox(-name=>'admin',
			       -label=>'Admin',
			       -value=>'false',
			       -onClick=>"check_userlevel('admin')");
	
	print "</TR><TR><TD BGCOLOR=$rcol></TD><TD BGCOLOR=$rcol COLSPAN=3>";
	print $query->checkbox(-name=>'main_contact',
			       -label=>'Main Contact',
			       -value=>'false');
	
	print "</TD></TR>";


	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";
	print $query->submit(-value=>'Add');
	print "</CENTER></TD></TR></TABLE>";
	print $query->endform;
	
	### Check case of company_id param ###

	if ($flag_company_id_param == 0)
	{
		print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>";
	}
	else
	{
		print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>";
	}
	};
} elsif ($action == 5) {
	
	# Disactivate user - after confirmation - action = 5
	
	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $userid;

	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$userid = $chooserlist[3];
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$userid = $temp_param; # 0=Just print, 1=Try to create.
	};

	### Check if passing any company_id parameter ###
	
	$flag_company_id_param = 0;
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}

	#-----------------------------------------#
	### Drop User must be done with Trigger ###
	#-----------------------------------------#
	
	### Change active (flag) to false ###

	my $dst = "UPDATE st_users SET active = 'false'
	  		   	   WHERE id = '$userid'";

	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		
		if ($flag_company_id_param == 0)
		{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
		else
		{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }
		
		print $query->end_html;
		$dbh->disconnect;
		exit;
	}

	$dbh->commit;
	print "<H2><FONT COLOR=GREEN>Successful user disactivation </FONT></H2><P>";
	if ($flag_company_id_param == 0)
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
	else
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }

} elsif ($action == 6) {

	### Activate User ###
	
	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $param;
	my $username;
	my $userid;

	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$param = $chooserlist[5]; # 0=Just print, 1=Try to create.
		$userid = $chooserlist[3];
		$username = $chooserlist[4];
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$param = $chooserlist[4]; # 0=Just print, 1=Try to create.
		$userid = $chooserlist[2];
		$username = $chooserlist[3];
	};

	### Check if passing any company_id parameter ###
	
	$flag_company_id_param = 0;
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}
	
	my $rmsg = '';
	my $rcol = $headcellcolor;

	$dst = "SELECT u.fullname FROM st_users u
		WHERE u.id = $userid";

	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @row_ary = $sth->fetchrow_array;
	my $fullname = $row_ary[0];

	if ($param) 
	{
		### Try to activate (create) user ###
		
		$username =~ s/^\s*(.*?)\s*$/$1/;
		my $pass1 = $query->param('pass1');
		$pass1 =~ s/^\s*(.*?)\s*$/$1/;
		my $pass2 = $query->param('pass2');
		$pass2 =~ s/^\s*(.*?)\s*$/$1/;
		
		if ($username eq '') {
			$rmsg = "Empty username.";
			$rcol = 'RED';
		}
		elsif ( $pass1 ne $pass2 ) {
			$rmsg = "Passwords are not the same."; 
			$rcol = 'RED';
		}
		elsif ($pass1 eq '') {
			$rmsg = "Empty password.";
			$rcol = 'RED';
		}
		elsif (length($pass1) < 6) {
			$rmsg = "Password must have at least 6 characters.";
			$rcol = 'RED';
		};

		if ($rmsg eq '') {
			# No error so far, try to insert.
			$dst = "CREATE USER $username WITH PASSWORD \'$pass1\'";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined ($sth->err)) { 
				# Failed 
				$rmsg = $sth->errstr;
				$rcol = 'RED';
			} 
			else 
			{
				### Must change the active option - Table st_users ###
				### Change active (flag) to true ###

				$dst = "UPDATE st_users SET active = 'true'
				  		   	   WHERE id = '$userid'";

				$sth = $dbh->prepare($dst);
				$sth->execute;
				if (st_lib::sthErr($sth->err, $sth->errstr)) { 
					# Failed 
					
					if ($flag_company_id_param eq 0)
					{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
					else
					{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }
					print $query->end_html;
					$dbh->disconnect;
					exit;
				}
				
				# Commit it.
				$dbh->commit;

				$rmsg = "Successfull user activation";
				$rcol = 'GREEN';
				print "<H2><FONT COLOR=GREEN>$rmsg</FONT></H2><P>";
				
				if ($flag_company_id_param eq 0)
				{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
				else
				{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }
			}
		} else {

			### Display the previous form (passwordform) with a status bar which 
			### will inform user for the specific error
			
			if ($fullname eq '')  {	$fullname = $query->param('fullname'); }
			
			display_password_activation_form($rmsg, $query, $cgipath, $headcellcolor, $cellcolor, $rcol, $userid, $username, $fullname, $flag_company_id_param, $param_company_id);
			
			$dbh->rollback;
		};
	}
	else
	{
		# Just print the password form.

		if ($flag_company_id_param eq 0)
		{
		
			print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?6+pflag+$userid+$username+1",
						 -name=>'passwordform',
	        	       		         -enctype=>$sencoding);
		}
		else
		{
			print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?6+$param_company_id+pflag+$userid+$username+1",
						 -name=>'passwordform',
	        	       		         -enctype=>$sencoding);
		}
		
		print "<H2>User activation <B>$username ($fullname)</B></H2>";
		### Try to pass with a hidden field the fullname of current user ###
		print $query->hidden(-name=>'fullname',
				     -value=>$fullname);

		print "<TABLE><TR>";
		print "<TD BGCOLOR=$headcellcolor>New password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->password_field(-name=>'pass1',
					     -size=>10,
					     -maxlength=>10);
		print "</CENTER></TD><TD BGCOLOR=$headcellcolor>Confirm new password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->password_field(-name=>'pass2',
					     -size=>10,
					     -maxlength=>10);
		print "</TD></TR><TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";
		print $query->submit(-value=>'Activate');
		print "</CENTER></TD></TR></TABLE>";
		print $query->endform;
		
		if ($flag_company_id_param eq 0)
		{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
		else
		{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }
	}

} elsif ($action == 7) {
	
	# Change password - action = 7
	
	my $param = $chooserlist[1];
	my $rmsg = '';
	my $rcol = 'GREEN';
	
	if ($param == 0)
	{
		# Just print the form.
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?7+1",
					 -name=>'updateform',
	                	         -enctype=>$sencoding);
		print "<TABLE><TR>";
		print "<TD BGCOLOR=$headcellcolor>New password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->password_field(-name=>'pass1',
					-size=>10,
					-maxlength=>10);
		print "</CENTER></TD><TD BGCOLOR=$headcellcolor>Confirm new password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->password_field(-name=>'pass2',
					-size=>10,
					-maxlength=>10);
		print "</CENTER></TD></TR><TR><TD BGCOLOR=$headcellcolor>Old password:</TD><TD BGCOLOR=$cellcolor>";
		print $query->password_field(-name=>'oldpass',
					-size=>10,
					-maxlength=>10);
		print "</TD><TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>";
		print $query->submit(-value=>'Change');
		print "</CENTER></TD></TR></TABLE>";
		print $query->endform;
	};

} elsif ($action == 8) {

	my $temp_param = $chooserlist[2];
	my $param_company_id = '';
	my $param;
	my $username;
	my $userid;


	if ($temp_param eq 'pflag')
	{
		### Case of passing parameter company_id (pflag --> url location [2]) ###
		$param_company_id = $chooserlist[1];	# Case of param company_id
		$param = $chooserlist[5]; # 0 = Just print, 1 = Try to create.
		$userid = $chooserlist[3];
		$username = $chooserlist[4];
	}
	else
	{
		### Case of pflag parameter at url location [1] - simple situation without parameter company_id ###
		$param_company_id = '';
		$param = $chooserlist[4]; # 0 = Just print, 1 = Try to create.
		$userid = $chooserlist[2];
		$username = $chooserlist[3];
	};

	### Check if passing any company_id parameter ###
	
	$flag_company_id_param = 0;
	if (!($param_company_id eq ''))
	{
		$flag_company_id_param = 1;
	}

	if ($param)
	{
		### Insert a new record to st_techs_mc_faulttypes ###

		my @tmp;
		my @faltypes;
		my $metr1=0;
		### fetch all fault types and put then in array faultypes ###
		my $dst = "SELECT u.id FROM st_faulttypes u";
		my $sth = $dbh->prepare($dst);
		$sth->execute;
		while (@tmp = $sth->fetchrow_array)
		{
			$faltypes[$metr1]=$tmp[0];
			$metr1++;
		}


		### create new queries for insert
		my @QUERIES;

		$metr1=0;
		my $metr3=0;
		my $metr2=0;
		for (@faltypes)
		{
			$metr2=0;
			for (@catformost)
			{
				if ($catformost[$metr2][0] eq $faltypes[$metr1])
				{
					if ($QUERIES[$metr3][0] ne $faltypes[$metr1]) { $metr3++; }
					$QUERIES[$metr3][0]=$faltypes[$metr1];
					if ($catformost[$metr2][1] eq "SCSE") { $QUERIES[$metr3][1]="y"; }
					if ($catformost[$metr2][1] eq "DutyManager") { $QUERIES[$metr3][2]="y"; }
					if ($catformost[$metr2][1] eq "TechnicalManager") { $QUERIES[$metr3][3]="y"; }
					if ($catformost[$metr2][1] eq "AccountManager") { $QUERIES[$metr3][4]="y"; }
					if ($catformost[$metr2][1] eq "GeneralManager") { $QUERIES[$metr3][5]="y"; }
				}
				$metr2++;
			}
			$metr1++;
		}

		$metr1=0;
		for (@QUERIES)
		{
			if ($QUERIES[$metr1][0] ne "")
			{
				if ($QUERIES[$metr1][1] eq "y") { $QUERIES[$metr1][1]="t" } else { $QUERIES[$metr1][1]="f" }
				if ($QUERIES[$metr1][2] eq "y") { $QUERIES[$metr1][2]="t" } else { $QUERIES[$metr1][2]="f" }
				if ($QUERIES[$metr1][3] eq "y") { $QUERIES[$metr1][3]="t" } else { $QUERIES[$metr1][3]="f" }
				if ($QUERIES[$metr1][4] eq "y") { $QUERIES[$metr1][4]="t" } else { $QUERIES[$metr1][4]="f" }
				if ($QUERIES[$metr1][5] eq "y") { $QUERIES[$metr1][5]="t" } else { $QUERIES[$metr1][5]="f" }
			}
			$metr1++;
		}

		### drop old data ###
		my $dst2="delete from st_techsmc_faulttypes where user_id = $userid";
		my $sth2 = $dbh->prepare($dst2);
		$sth2->execute;
		if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		### Commit it! ###
		$dbh->commit;


		### insert new data ###
		$metr1=0;
		for (@QUERIES)
		{
			if ($QUERIES[$metr1][0] ne "")
			{
				my $dst666="insert into st_techsmc_faulttypes values ($userid,$QUERIES[$metr1][0],'$QUERIES[$metr1][1]','$QUERIES[$metr1][2]','$QUERIES[$metr1][3]','$QUERIES[$metr1][4]','$QUERIES[$metr1][5]')";
				my $sth666 = $dbh->prepare($dst666);
				$sth666->execute;
				if (st_lib::sthErr($sth666->err, $sth666->errstr)) { 
					# Failed 
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
			
			}
			$metr1++;
		}
		### Commit it! ###
		$dbh->commit;

		print "<H2><FONT COLOR=GREEN>Successfully updated categories</FONT></H2><P>";
	}
	else
	{

		if ($flag_company_id_param eq 0)
		{
			print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?8+pflag+$userid+$username+1",
						 -name=>'faulttypeform',
	                		         -enctype=>$sencoding);
		}
		else
		{
			print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?8+$param_company_id+pflag+$userid+$username+1",
						 -name=>'faulttypeform',
	                		         -enctype=>$sencoding);
		}
		print "<TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER>Username: <B>$username</B></CENTER></TD></TR></TABLE>";
		#print "<TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER>Username: <B>$username</B></CENTER></TD></TR>";
		print "<TABLE>";
		print "<TR><TD BGCOLOR=$headcellcolor ALIGN=CENTER><B>Categories</B></TD>";
		print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER><B>CSCE</B></TD>";
		print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER><B>Duty Manager</B></TD>";
		print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER><B>Technical Manager</B></TD>";
		print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER><B>Account Manager</B></TD>";
		print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER><B>General Manager</B></TD>";
		print "</TR>"; 
		# HTML code - Display the fault_type form of current user

		###SELECT 1 pick all categories
		my $dst = "SELECT u.id, u.name FROM st_faulttypes u";
        
		my $sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
	
		my @row_ary;
		my @row_ary_s;
		my @checked;
		my $dst1;
		my $sth1;
		while (@row_ary = $sth->fetchrow_array) 
		{
			$dst1 = "SELECT u.user_id, u.faulttype_id, u.scse, u.duty_m, u.techn_m, u.acc_m, u.general_m FROM st_techsmc_faulttypes u WHERE u.user_id = $userid AND u.faulttype_id = $row_ary[0];";
			$sth1 = $dbh->prepare($dst1);
			$sth1->execute;
			if (st_lib::sthErr($sth1->err, $sth1->errstr)) { 
				# Failed 
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};

			$checked[0]='false';
			$checked[1]='false';
			$checked[2]='false';
			$checked[3]='false';
			$checked[4]='false';
			
			while (@row_ary_s = $sth1->fetchrow_array)
			{
				if (($row_ary_s[1] eq $row_ary[0]) && ($row_ary_s[2] eq '1')) { $checked[0] = 'true'; }
				if (($row_ary_s[1] eq $row_ary[0]) && ($row_ary_s[3] eq '1')) { $checked[1] = 'true'; }
				if (($row_ary_s[1] eq $row_ary[0]) && ($row_ary_s[4] eq '1')) { $checked[2] = 'true'; }
				if (($row_ary_s[1] eq $row_ary[0]) && ($row_ary_s[5] eq '1')) { $checked[3] = 'true'; }
				if (($row_ary_s[1] eq $row_ary[0]) && ($row_ary_s[6] eq '1')) { $checked[4] = 'true'; }
			}	

			print "<TR><TD BGCOLOR=$headcellcolor ALIGN=CENTER> $row_ary[1] </TD>";
			print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER>";
			if ($checked[0] eq 'true')
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_SCSE",
						       -label => '',
			       			       -value => 'true',
						       -checked => 'true');
			}
			else
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_SCSE",
						       -label => '',
			       			       -value => $checked[0]);
			}
			print "</TD>";
			print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER>";
			if ($checked[1] eq 'true')
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_DutyManager",
						       -label => '',
			       			       -value => 'true',
						       -checked => 'true');
			}
			else
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_DutyManager",
						       -label => '',
			       			       -value => $checked[0]);
			}
			print "</TD>";
			print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER>";
			if ($checked[2] eq 'true')
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_TechnicalManager",
						       -label => '',
			       			       -value => 'true',
						       -checked => 'true');
			}
			else
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_TechnicalManager",
						       -label => '',
			       			       -value => $checked[0]);
			}
			print "</TD>";
			print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER>";
			if ($checked[3] eq 'true')
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_AccountManager",
						       -label => '',
			       			       -value => 'true',
						       -checked => 'true');
			}
			else
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_AccountManager",
						       -label => '',
			       			       -value => $checked[0]);
			}
			print "</TD>";
			print "<TD BGCOLOR=$headcellcolor ALIGN=CENTER>";
			if ($checked[4] eq 'true')
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_GeneralManager",
						       -label => '',
			       			       -value => 'true',
						       -checked => 'true');
			}
			else
			{
				print $query->checkbox(-name  => "CATEG_$row_ary[0]_GeneralManager",
						       -label => '',
			       			       -value => $checked[0]);
			}
			print "</TD>";
			print "</TR>";
		}
		print "</TABLE>";
		print $query->submit(-value=>'Update');
		print $query->endform;

	}
	
	if ($flag_company_id_param == 0)
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?1+pflag+$userid+$username\">Return</A>"; }
	else
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?1+$param_company_id+pflag+$userid+$username\">Return</A>"; }
}

elsif ($action == 9) {

	### Action is 9 that means ---> mass mails to users (by company) ###
	#-- Print proper page to choose companies, subject and body mail for sending -#

	my $param = $chooserlist[1];

	### Check first if user is superuser and belongs to admins ###
	$flag_control = "false";	# By default false - user is not superuser.
					# flag_control = true - user is superuser.
	$flag_control = st_jscript::check_pg_users_for_delete($zuser);
	
	if (($flag_control eq "false") or ($flag_admin_group eq 0)) 
	{
		#print STDERR "Permission denied - No superuser (admin) !!!";
		$rmsg = "Permission denied - No superuser (admin) !!!";
		print "<H2><FONT COLOR=RED>$rmsg</FONT></H2><P>";
	}
	else {
	
	if ($param)
	{
		### Action post massmail form - send the proper mails ###
		
		my $subject = $query->param('subject');
		my $body = $query->param('body');
		
		#print STDERR "Subject = $subject\n";
		#print STDERR "Body = $body\n";
		
		my $dst = "SELECT u.id, u.name FROM st_companies u";
        
		my $sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
	
		my @row_ary;
		while (@row_ary = $sth->fetchrow_array) 
		{
			if ($query->param($row_ary[1]))
			{
				#print STDERR "Company = $row_ary[1]\n";
				
				my $dst1 = "SELECT u.id FROM st_companieslocations u WHERE u.company_id = $row_ary[0];";
        
				my $sth1 = $dbh->prepare($dst1);
				$sth1->execute;
				if (st_lib::sthErr($sth1->err, $sth1->errstr)) { 
					# Failed 
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
			
				my @row_ary1;
				while (@row_ary1 = $sth1->fetchrow_array) 
				{
					my $dst2 = "SELECT u.id, u.email, u.fullname FROM st_users u WHERE u.companylocation_id = $row_ary1[0];";
        
					my $sth2 = $dbh->prepare($dst2);
					$sth2->execute;
					if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
						# Failed 
						print $query->end_html;
						$dbh->disconnect;
						exit;
					};

					my @row_ary2;
					while (@row_ary2 = $sth2->fetchrow_array) 
					{
						### Now send mail to proper user (email) ###
						#print STDERR "Email (user_id:$row_ary2[0]) : $row_ary2[1]\n";

						my $to_mail = "$row_ary2[2] <$row_ary2[1]>";
						$to_mail = encode_qp($to_mail);
						$to_mail =~ s/=\r?\n//g;	# Remove the new line added from encode_qp function
						#print STDERR "\nto_mail : $to_mail\n";
						#print STDERR "\n- $smtpserver\n";
						#print STDERR "\n- $fromaddress\n";
						
						(new Mail::Sender)->MailMsg( {smtp => $smtpserver,
									      from => $fromaddress,
							      		      to => '=?' . $sencoding . '?Q?'.$to_mail.'?=',
									      subject => '=?' . $sencoding . '?Q?'.$subject.'?=',
									      msg => $body,
								      	      charset => $sencoding} );
					}
				}
			}
		}
		
		$rmsg = "Sending mails successfully";
		$rcol = 'GREEN';
		print "<H2><FONT COLOR=GREEN>$rmsg</FONT></H2><P>";
	}
	else
	{
		### Just print the massmail form ###
		
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?9+1",
					 -name=>'massmailform',
                		         -enctype=>$sencoding);
		
		print "<TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=3 ALIGN=center><FONT COLOR=GREEN><B>Companies</B></FONT></TD></TR>";
	
		my $dst = "SELECT u.id, u.name FROM st_companies u";
        
		my $sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
	
		my @row_ary;
		my $td_metr = 0;
		print "<TR><TD BGCOLOR=$headcellcolor><FONT COLOR=RED>";
		
		while (@row_ary = $sth->fetchrow_array) 
		{
			print $query->checkbox( -name  => $row_ary[1],
					        -label => $row_ary[1],
			       		        -value => 'false');
			$td_metr = $td_metr + 1;
			
			if (($td_metr % 3) eq 0)
			{ print "</FONT></TD></TR><TR><TD BGCOLOR=$headcellcolor><FONT COLOR=RED>"; }
			else
			{ print "</FONT></TD><TD BGCOLOR=$headcellcolor><FONT COLOR=RED>"; }
		}
		
		print "</FONT></TD></TR>";
		print "<TR><TD BGCOLOR=$headcellcolor ALIGN=right>Subject: </TD><TD BGCOLOR=$cellcolor>";
		print $query->textfield(-name=>'subject',
					-size=>50,
					-maxlength=>100);
	
		print "</TD><TD BGCOLOR=$headcellcolor></TD></TR>";
		print "<TR><TD BGCOLOR=$headcellcolor ALIGN=right>Body: </TD><TD BGCOLOR=$cellcolor>";
		print $query->textarea( -name=>'body',
					-rows=>10,
					-columns=>50);
		
		print "</TD><TD BGCOLOR=$headcellcolor></TD></TR>";
		print "<TR><TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$headcellcolor><CENTER>";
		print $query->submit(-value=>'Send mails');
		print "</CENTER></TD><TD BGCOLOR=$headcellcolor></TD></TR></TABLE>";
		print $query->endform;
	}
	}


} elsif ($action == 10) {
	
	# Display user details - action = 10
	
	my $fault_id = $chooserlist[2];
	my $pguserid = $chooserlist[3];

	my $rcol = $headcellcolor;

	my $dst = "SELECT u.id, u.username, u.fullname, u.client, u.technician, u.admin, u.email, u.phone1, u.phone2,
			  u.fax, u.active, u.main_contact, u.userlevel_id, u.companylocation_id 
		   FROM st_users u
		   WHERE u.id = $pguserid";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	
	my @row_ary = $sth->fetchrow_array;

	
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>Username: <B>$row_ary[1]</B></CENTER></TD></TR>";
	
	# HTML code - Display the edit form of user record
	
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN=right>Fullname: </TD><TD BGCOLOR=$cellcolor>";
	print $row_ary[2];
	
	print "<TD BGCOLOR=$headcellcolor ALIGN=right>Email: </TD><TD BGCOLOR=$cellcolor>";
	print $row_ary[6];
				
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN=right>Phone (1): </TD><TD BGCOLOR=$cellcolor>";
	print $row_ary[7];

	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=right>Phone (2): </TD><TD BGCOLOR=$cellcolor>";
	print $row_ary[8];
	
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN=right>Fax: </TD><TD BGCOLOR=$cellcolor>";
	print $row_ary[9];

	print "</TD><TD BGCOLOR=$headcellcolor COLSPAN=2></TD></TR>";
	
	
	# Take the companies from st_companies table
	my ($st_companies_id, $st_companies_names) = st_jscript::sub_companies_names;
	
	### Check the default value for company depending on the location value ###	
	my $default_value_for_company = st_jscript::sub_def_value_company($dbh,$row_ary[13]);
	
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Company: </TD><TD BGCOLOR=$cellcolor>";
	print $$st_companies_names{ $default_value_for_company };
	print "</TD>";
	
	# Take the company locations from st_companieslocations table
	my ($st_companieslocations_id, $st_companieslocations_names) = st_jscript::sub_companieslocations_names;

	print "<TD BGCOLOR=$headcellcolor ALIGN='right'>Location: </TD><TD BGCOLOR=$cellcolor>";
	print $$st_companieslocations_names{ $row_ary[13] };
	print "</TD></TR>";

	if (($zdata[3] == 1) and ($zdata[5] == 1)) { # This is only for techs_mc
		print "<TR><TD BGCOLOR=$headcellcolor ALIGN='center' COLSPAN=4><B>User Statistics</B></TD</TR>";

		# Total owned
		$dst = "SELECT count(*) from st_faults WHERE logged_by_user_id = $pguserid";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TR><TD BGCOLOR=$headcellcolor>Total owned: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD>";

		# Open owned 
		$dst = "SELECT count(*) from st_faults WHERE logged_by_user_id = $pguserid AND end_time IS NULL";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TD BGCOLOR=$headcellcolor>Open owned: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD></TR>";

		# Closed owned 
		$dst = "SELECT count(*) from st_faults WHERE logged_by_user_id = $pguserid AND end_time IS NOT NULL";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TR><TD BGCOLOR=$headcellcolor>Closed owned: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD>";

		# Open assigned 
		$dst = "SELECT sr_count from st_fpt WHERE user_id = $pguserid";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		if ($row_ary[0] eq '') { $row_ary[0] = 0 };
		print "<TD BGCOLOR=$headcellcolor>Open assigned: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD></TR>";

		# Closed by 
		$dst = "SELECT count(*) from st_faults WHERE closed_by_user_id = $pguserid";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TR><TD BGCOLOR=$headcellcolor>Closed by: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD>";

		# Total Related 
		$dst = "SELECT count(*) FROM st_faults_users_rel WHERE user_id = $pguserid";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TD BGCOLOR=$headcellcolor>Total related: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD></TR>";

		# Open Related 
		$dst = "SELECT count(*) FROM st_faults_users_rel r INNER JOIN st_faults f ON r.fault_id = f.id WHERE r.user_id = $pguserid AND f.end_time IS NULL";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TR><TD BGCOLOR=$headcellcolor>Open related: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD>";

		# Closed Related 
		$dst = "SELECT count(*) FROM st_faults_users_rel r INNER JOIN st_faults f ON r.fault_id = f.id WHERE r.user_id = $pguserid AND f.end_time IS NOT NULL";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@row_ary = $sth->fetchrow_array;
		print "<TD BGCOLOR=$headcellcolor>Closed related: </TD><TD BGCOLOR=$cellcolor>$row_ary[0]</TD></TR>";
	};
	print "</TABLE>";
	if ($fault_id != 0) {
		print "<CENTER>[ <A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">Return to SR</A> ]</CENTER>";
	};


} else {
	# No way to get here!
	print "<P><H1>IMPOSSIBLE!</H1><P>";
	print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Finish, clean up etc....
print "</CENTER>";
st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
print $query->end_html;
$dbh->disconnect;
exit;


### Routine which displays the previous form (inputform - insert a user record ) with a status bar which 
### will inform user for the specific error. 
	
sub display_input_form
{
my ($message, $query, $cgipath, $headcellcolor, $cellcolor, $rcol, $flag_company_id_param, $param_company_id) = @_;

	my $pre_username = $query->param('username');
	my $pre_fullname = $query->param('fullname');
	my $pre_pass1 = $query->param('pass1');
	my $pre_pass2 = $query->param('pass2');
	my $pre_email = $query->param('email');
	my $pre_fax = $query->param('fax');
	my $pre_phone1 = $query->param('phone1');
	my $pre_phone2 = $query->param('phone2');
	my $pre_active = $query->param('active');
	my $pre_companies_id = $query->param('companies_id');
	my $pre_companieslocations_id = $query->param('companieslocations_id');
	my $pre_client = $query->param('client');
	my $pre_technician = $query->param('technician');
	my $pre_admin = $query->param('admin');
	my $pre_main_contact = $query->param('main_contact');
	
	# HTML code - Display the (previous) input form of user record
	
	if ($flag_company_id_param eq 0)
	{
	
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?4+pflag+1",
					 -name=>'insertform',
		                         -enctype=>$sencoding);
	}
	else
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?4+$param_company_id+pflag+1",
					 -name=>'insertform',
		                         -enctype=>$sencoding);
	}
	
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Username: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'username',
				-size=>8,
				-maxlength=>8,
				-default=>$pre_username);
	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=right>Fullname: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'fullname',
				-size=>30,
				-maxlength=>2048,
				-default=>$pre_fullname);
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Password: </TD><TD BGCOLOR=$cellcolor>";
	print $query->password_field(-name=>'pass1',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_pass1);
	print "</TD><TD BGCOLOR=$headcellcolor>Confirm password: </TD><TD BGCOLOR=$cellcolor>";
	print $query->password_field(-name=>'pass2',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_pass2);
	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Email: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'email',
				-size=>25,
				-maxlength=>30,
				-default=>$pre_email);

	print "</TD><TD BGCOLOR=$headcellcolor ALIGN='right'>Fax: </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'fax',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_fax);

	print "</TD></TR>";
	print "</TD></TR><TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Phone (1): </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'phone1',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_phone1);

	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=right>Phone (2): </TD><TD BGCOLOR=$cellcolor>";
	print $query->textfield(-name=>'phone2',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_phone2);
	
	print $query->hidden(-name=>'active',
			       -label=>'Active',
			       -value=>'true');

	# Take the companies from st_companies table
	my ($st_companies_id, $st_companies_names) = st_jscript::sub_companies_names;
	my $onChange="control_lists(document.insertform,document.insertform.companies_id.options[document.insertform.companies_id.selectedIndex].value, 0, '')";
	
	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Company: </TD><TD BGCOLOR=$headcellcolor>";
	print $query->popup_menu(-name=>'companies_id',
				     -values=>$st_companies_id,
				     -onChange=>$onChange,
				     -default=>$pre_companies_id,
				     -labels=>$st_companies_names);
	print "</TD>";
	
	# Take the company locations from st_companieslocations table
	my ($st_companieslocations_id, $st_companieslocations_names) = st_jscript::sub_companieslocations_names;

	print "<TD BGCOLOR=$headcellcolor ALIGN='right'>Location: </TD><TD BGCOLOR=$headcellcolor>";
	print $query->popup_menu(-name=>'companieslocations_id',
				     -values=>$st_companieslocations_id,
				     -default=>$pre_companieslocations_id,
				     -labels=>$st_companieslocations_names);
	print "</TD></TR>";

	print "<TR><TD BGCOLOR=$headcellcolor ALIGN='right'>Type of user:</TD><TD BGCOLOR=$headcellcolor>";
	print $query->checkbox(-name=>'client',
			       -label=>'Customer',
			       -value=>'false',
			       -onClick=>"check_userlevel('client')",
			       -default=>$pre_client);

	print "</TD></TD><TD BGCOLOR=$headcellcolor>";
	print $query->checkbox(-name=>'technician',
			       -label=>'CSE',
			       -value=>'false',
			       -onClick=>"check_userlevel('technician')",
			       -default=>$pre_technician);

	print "</TD></TD><TD BGCOLOR=$headcellcolor>";
	print $query->checkbox(-name=>'admin',
			       -label=>'Admin',
			       -value=>'false',
			       -onClick=>"check_userlevel('admin')",
			       -default=>$pre_admin);
	
	print "</TR><TR><TD BGCOLOR=$headcellcolor></TD><TD COLSPAN=3 BGCOLOR=$headcellcolor>";
	print $query->checkbox(-name=>'main_contact',
			       -label=>'Main Contact',
			       -value=>'false',
			       -default=>$pre_main_contact);
	
	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";
	print $query->submit(-value=>'Add');
	print "</TR><TR><TD BGCOLOR=$rcol COLSPAN=4><CENTER><FONT COLOR=WHITE>$message</FONT></CENTER></TD></TR></TABLE>";
	print $query->endform;
	
	if ($flag_company_id_param eq 0)
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
	else
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }

	return;
}


### Display the previous form (update form - change password) ###

sub display_update_password_form
{
my ($message, $query, $cgipath, $headcellcolor, $cellcolor, $rcol) = @_;

	my $pre_pass1 = $query->param('pass1');
	my $pre_pass2 = $query->param('pass2');
	my $pre_oldpass = $query->param('oldpass');
	
	print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?7+1",
				 -name=>'updateform',
	               	         -enctype=>$sencoding);
	print "<TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->password_field(-name=>'pass1',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_pass1);
	print "</CENTER></TD><TD BGCOLOR=$headcellcolor>Confirm new password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->password_field(-name=>'pass2',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_pass2);
	print "</CENTER></TD></TR><TR><TD BGCOLOR=$headcellcolor>Old password:</TD><TD BGCOLOR=$cellcolor>";
	print $query->password_field(-name=>'oldpass',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_oldpass);
	print "</TD><TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>";
	print $query->submit(-value=>'Change');
	print "</CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$rcol COLSPAN=4><CENTER><FONT COLOR=WHITE>$message</FONT></CENTER></TD></TR></TABLE>";
	print $query->endform;
	return;
}


### Display the previous form (passwordform - activate user) ###

sub display_password_activation_form
{
my ($msg, $query, $cgipath, $headcellcolor, $cellcolor, $rcol, $userid, $username, $fullname, $flag_company_id_param, $param_company_id) = @_;

	my $pre_pass1 = $query->param('pass1');
	my $pre_pass2 = $query->param('pass2');
	
	if ($flag_company_id_param eq 0)
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?6+pflag+$userid+$username+1",
					 -name=>'passswordform',
	        	       	         -enctype=>$sencoding);
	}
	else
	{
		print $query->start_form(-method=>'POST',-action=>"$cgipath/st_usermanagement.pl?6+$param_company_id+pflag+$userid+$username+1",
					 -name=>'passswordform',
	        	       	         -enctype=>$sencoding);
	}
	
	print "<H2>User activation <B>$username ($fullname)</B></H2>";
	### Try to pass with a hidden field the fullname of current user ###
	print $query->hidden(-name=>'fullname',
			     -value=>$fullname);
	
	print "<TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->password_field(-name=>'pass1',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_pass1);
	print "</CENTER></TD><TD BGCOLOR=$headcellcolor>Confirm new password: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->password_field(-name=>'pass2',
				-size=>10,
				-maxlength=>10,
				-default=>$pre_pass2);
	print "</CENTER></TD></TR><TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";
	print $query->submit(-value=>'Activate');
	print "</CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$rcol COLSPAN=4><CENTER><FONT COLOR=WHITE>$msg</FONT></CENTER></TD></TR></TABLE>";
	print $query->endform;

	if ($flag_company_id_param eq 0)
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0\">Return to index</A>"; }
	else
	{ print "<A HREF=\"$cgipath/st_usermanagement.pl?0+$param_company_id\">Return to index</A>"; }
	
	return;
}



### Subroutine for checking if the current user belongs to the techs_mc group ###

sub check_user_if_group_techs_mc
{
my @row_ary = @_;

	if ($row_ary[5] eq 1)
	{
		return 1;
	}
	elsif (($row_ary[4] eq 1) and ($row_ary[11] eq 1))
	{
		return 1;
	}
	else
	{
		return 0;
	}
	return 0;
}


### Subroutine for checking if the current user belongs to the admin group ###

sub check_user_if_group_admin
{
my ($dbh, $username) = @_;

	my $dst = "SELECT u.admin FROM st_users u WHERE u.username = '$username';";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @row_ary;
	if (@row_ary = $sth->fetchrow_array) 
	{
		if ($row_ary[0] eq 1)
		{
			return 1;
		}
		else
		{
			return 0;
		}
		return 0;
	}
	return 0;
}


#--------------------------------------------------------------------------------------------#
### Subroutine sub_catforemost_display for "printing" foremost categories for current user ###
#--------------------------------------------------------------------------------------------#

sub sub_catforemost_display
{
my ($dbh, $userid, $rcol) = @_;

	my $dst = "SELECT u.id, u.name FROM st_faulttypes u";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @row_ary;
	my @row_ary_s;
	my $dst1;
	my $sth1;
	my $dst2;
	my $sth2;
	my @row_ary_2;
	while (@row_ary = $sth->fetchrow_array) 
	{
		$dst1 = "SELECT u.user_id, u.faulttype_id, u.scse, u.duty_m, u.techn_m, u.acc_m, u.general_m FROM st_techsmc_faulttypes u WHERE u.user_id = $userid;";
		        
		$sth1 = $dbh->prepare($dst1);
		$sth1->execute;
		if (st_lib::sthErr($sth1->err, $sth1->errstr)) { 
			# Failed 
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};

		while (@row_ary_s = $sth1->fetchrow_array)
		{
			if ($row_ary_s[1] eq $row_ary[0]) 
			{ 
				#print STDERR "Fault_id = $row_ary[0]\n"; 

				$dst2 = "SELECT u.name FROM st_faulttypes u WHERE u.id = $row_ary[0];";
		        
				$sth2 = $dbh->prepare($dst2);
				$sth2->execute;
				
				if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
					# Failed 
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
				
				if (@row_ary_2 = $sth2->fetchrow_array)
				{
					#print STDERR "Fault_id = $row_ary_2[0]\n";
					print "<TR><TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$headcellcolor COLSPAN=4><FONT COLOR=$rcol>$row_ary_2[0]";
					# Check flags and print hardcoded info.
					if ($row_ary_s[2] eq '1') {
						print " [SCSE] ";
					};
					if ($row_ary_s[3] eq '1') {
						print " [Duty Manager] ";
					};
					if ($row_ary_s[4] eq '1') {
						print " [Technical Manager] ";
					};
					if ($row_ary_s[5] eq '1') {
						print " [Account Manager] ";
					};
					if ($row_ary_s[6] eq '1') {
						print " [General Manager] ";
					};
					
					print "</FONT></TD></TR>";
				}
			}
		}	
	}
	return;
}


#-----------------------------------------------------------------------------------------------------------#
### Subroutine sub_grants_serv_display routine for managing grants to table st_surv_answ for current user ###
#-----------------------------------------------------------------------------------------------------------#
		
sub sub_grants_serv_display
{
my ($dbh, $username) = @_;
my ($def_value, $checked);

	my $dst = "SELECT relacl FROM pg_class WHERE relname = 'st_surv_answ';";
        
	my $sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	
	my @row_ary;
	if (@row_ary = $sth->fetchrow_array) 
	{
		my @temporary_splitname = split(/$username=/,$row_ary[0]);
		if ($row_ary[0] ne $temporary_splitname[0])
		{
			# print STDERR "relacl = $row_ary[0] - Found grants\n\n";
			$def_value = 'true';
			$checked = 'checked';
		}
		else
		{
			# print STDERR "relacl = $row_ary[0] - Not Found grants\n\n";
			$def_value = 'false';
			$checked = '';
		}
	}

	print "<TR><TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$headcellcolor COLSPAN=4>";
	print $query->checkbox(-name=>'grant_survey',
			       -label=>'Grant for survey table',
			       -value=>$def_value,
			       -checked=>$checked);

	print "</TD></TR>";
	return;
}
