#!/usr/bin/perl
#########################################################################
# This script will accept as arguments a table name and an action. Will	#
# read info from zs_* tables and pg_* tables and will create a form 	#
# that will perform the specified action on the table.			#
#									# 
# This is a fork of zs_param. Will be used to offer the javascript 	#
# selection for unit_id column, in tables that have this column.	#
# 									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.1.0	Clone from V0.6.4 of zs_unitbound.pl			#
# V0.1.1	Compatibility for new login system			#
# V0.6.5	Terminology review					#
# V0.6.6	Replaced hardcoded encodings with parameter.		#
# V0.6.7	Replaced hardcoded language with parameter.		#
#									#
# Arguments description: 						#
# tablename: The name of the table.					#
# action: 0=view, 1=insert, 2=update1, 3=delete1, 4=search, 5=update2,	#
#	  6=delete2.							#
# rowid: The oid of the record to change or delete (when action is 2, 3,#
#	 5 or 6).							#
#########################################################################

use strict;
use DBI;
use CGI;
use st_lib;

my $data_source = $st_lib::data_source;	# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my %tcolumns = ();				# real and greek col names.
my @lcolumns;					# only real names.
my @scolumns;					# only real names that can be
						# used to search.
my %columntypes;				# Column data types.
my $dst;					# used for dynamic statements.
my $ndst;					# used for dynamic statements.
my $colname;					# A column name.
my %foreign_keys;				# key is column, data is
						# <tablename>.<columnname>
my %f_keys_counters;				# Holds how many times a table appears in foreign keys
						# in the same table. More that once is special case.
my $where = '';					# A string always attached,
						# becomes ' WHERE ' when needed.

my $key;
my ($rest, $tmp, $scrapret);
my ($mycolname, $foreigntable, $foreigncolumn);

my $debug = $st_lib::debug;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;	# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;	# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path. 
my $sencoding =		$st_lib::sencoding;	# Encoding for HTML etc
my $slang =		$st_lib::slang;		# Language for HTML etc

my $version = "st_unitbound.pl V0.6.7";

#my ($tname, $action, $rest) = @_;
#my ($tname, $action, $rest) = @ARGV; 		#TEMP
my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $tname = $chooserlist[0];
my $action = $chooserlist[1];
my $rowid = $chooserlist[2];

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Initialize CGI and send headers.
print  $query->header(-charset=>$sencoding);

# Find tname in zs_tableinfo. 
$sth = $dbh->prepare("SELECT gr_tablename, is_param, form_title, do_upd, do_ins, do_del FROM zs_tableinfo where tablename = \'$tname\'");

$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Internal Error.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

if ($sth->rows != 1) {
	print "Internal error, $sth->rows tablenames found.\n";
	st_lib::wDbg("Internal error, $sth->rows tablenames found.\n", "st_unitbound");
	print $query->end_html;
	$sth->finish;
	$dbh->disconnect;
	exit;
};

my @row_ary  = $sth->fetchrow_array;
my $gr_tname = $row_ary[0];
my $is_param = $row_ary[1];
my $form_title = $row_ary[2];
my $do_upd = $row_ary[3];
my $do_ins = $row_ary[4];
my $do_del = $row_ary[5];


print  $query->start_html(-title=>$form_title,
			  -text=>$textcolor,
			  -lang=>$slang,
			  -BGCOLOR=>$bgcolor);


st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);

print "<CENTER><H2><FONT COLOR=$linkcolor>$gr_tname</FONT></H2></CENTER><HR>";

# Let's find row info about the table.
$sth = $dbh->prepare("SELECT zs_columninfo.columnname, zs_columninfo.gr_columnname, zs_columninfo.is_search, pg_type.typname FROM zs_columninfo, pg_type, pg_attribute WHERE zs_columninfo.tablename = \'$tname\' AND zs_columninfo.do_use = \'t\' AND pg_attribute.attrelid = (SELECT oid FROM pg_class WHERE relname = \'$tname\') AND pg_attribute.attname = zs_columninfo.columnname AND pg_type.oid = pg_attribute.atttypid ORDER BY zs_columninfo.ordernum");

$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Internal Error.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

if ($sth->rows < 1) {
	print "Internal error, no columns found.\n";
	st_lib::wDbg("Internal error, no columns found.\n", "st_unitbound");
	print $query->end_html;
	$sth->finish;
	$dbh->disconnect;
	exit;
};


$i = 0;
while (@row_ary = $sth->fetchrow_array) {
	# Add relation name in column names, will be usefull in foreign keys.
	$lcolumns[$i] = $tname . '.' . $row_ary[0];
	$tcolumns{ $lcolumns[$i] } = $row_ary[1];
	if ($row_ary[2]) {
		# Can be used for search
		push @scolumns, $tname . '.' . $row_ary[0];
	};
	$columntypes { $lcolumns[$i] } = $row_ary[3]; # Data type
	$i++;
};

# Find foreign keys and alter all info accordingly.
$sth = $dbh->prepare("SELECT pg_constraint.conrelid,
			pg_constraint.confrelid, pg_constraint.conkey, 
			pg_constraint.confkey 
			FROM pg_constraint, pg_class WHERE 
			((pg_constraint.conrelid = pg_class.oid) AND 
			(pg_class.relname = \'$tname\') AND 
			(pg_constraint.contype = 'f'))");

$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Internal Error.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};
if ($sth->rows) {
	# Got foreign keys, let's use them.
#	$where = ' WHERE '; # Will need where clause.
	while (@row_ary = $sth->fetchrow_array) {
		my (@localrowary, $dst2, $tmp);
		# Find column name of my table.

		($tmp = $row_ary[2]) =~ s/{//;
		$tmp =~ s/}//;
		$dst2 = "SELECT attname FROM pg_attribute WHERE
			((attrelid = " . $row_ary[0] .") AND
			 (attnum = " . $tmp . "))";
		my $sth2 = $dbh->prepare($dst2); 

		$sth2->execute;

		if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		
		if ($sth2->rows != 1) { 
			# This is not correct 
			print "Internal error, pg_attribute returned " . $sth2->rows . "instead of 1.\n";
			st_lib::wDbg("Internal error,pg_attribute returned " . $sth2->rows . "instead of 1.\n", "st_unitbound");
			print $query->end_html;
			$sth2->finish;
			$dbh->disconnect;
			exit;
		};
		@localrowary = $sth2->fetchrow_array;
		$mycolname = $localrowary[0];

		# Find foreign key column name.

		($tmp = $row_ary[3]) =~ s/{//;
		$tmp =~ s/}//;
		
		$sth2 = $dbh->prepare("SELECT attname 
					FROM pg_attribute WHERE
					((attrelid = $row_ary[1]) AND
					 (attnum = $tmp))");
		$sth2->execute;

		if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		
		if ($sth2->rows != 1) { 
			# This is not correct 
			print "Internal error, pg_attribute returned " . $sth2->rows . "instead of 1.\n";
			st_lib::wDbg("Internal error,pg_attribute returned " . $sth2->rows . "instead of 1.\n", "st_unitbound");
			print $query->end_html;
			$sth2->finish;
			$dbh->disconnect;
			exit;
		};
		@localrowary = $sth2->fetchrow_array;
		$foreigncolumn = $localrowary[0];
		# Find foreign key table name

		$sth2 = $dbh->prepare("SELECT relname 
					FROM pg_class WHERE
					oid = $row_ary[1]");
		$sth2->execute;

		if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		
		if ($sth2->rows != 1) { 
			# This is not correct 
			print "Internal error, pg_class returned " . $sth2->rows . "instead of 1.\n";
			st_lib::wDbg("Internal error,pg_class returned " . $sth2->rows . "instead of 1.\n", "st_unitbound");
			print $query->end_html;
			$sth2->finish;
			$dbh->disconnect;
			exit;
		};
		@localrowary = $sth2->fetchrow_array;
		$foreigntable = $localrowary[0];
		# Keep track of how many times a table appears.
		if (exists($f_keys_counters{$foreigntable})) {
			$f_keys_counters{$foreigntable} =  $f_keys_counters{$foreigntable} + 1;
		} else {
			$f_keys_counters{$foreigntable} =  1;
		};
		# Now put everything in %foreign_keys 
		$mycolname = $tname . "." . $mycolname;
		$foreign_keys{$mycolname} = $foreigntable . "." . $foreigncolumn;
	};
};

# If action = 3, we must ask confirmation for deletion.
# Update, 07-07-2003: Must manually get descriptions of foreign keys.
if ($action == 3) {
	# Display row data.
	my $viewtablestring = '';
	$viewtablestring = $viewtablestring . "<CENTER><H2>Confirm deletion</H2><P><TABLE><TR>";
	$dst = 'SELECT ';
	$i = 0;
	while ($colname = $lcolumns[$i]) {
		# The TABLE part
		$viewtablestring = $viewtablestring . "<TD BGCOLOR=$headcellcolor> $tcolumns{ $colname } </TD>";
		# The SELECT part
		if ($i > 0) { 
			$dst = $dst . ", $colname";
		} else {
			$dst = $dst . "$colname";
		};
		$i++;
	};
	$dst = $dst . " FROM $tname ";

	$dst = $dst . $where;
	$tmp = 0;

	# Add row oid in WHERE.
	if ($tmp > 0) {
		$dst = $dst . " AND ";
	} else { 
		if ($where eq '') {
			$dst = $dst . " WHERE ";
		};
	};
	$dst = $dst . " $tname.oid = " . $rowid;

	print $viewtablestring . "</TR><TR>";

	$sth = $dbh->prepare($dst);
	$sth->execute();

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$sth->finish;
		$dbh->disconnect;
		exit;
	};

	if ($sth->rows != 1) {
		print "<TD><H1>Internal Error - found " . $sth->rows . " rows in unique key.</H1></TD></TR></TABLE>";	
	} else {
		# Print the rows
		my $cn = @lcolumns + 0;
		while (@row_ary = $sth->fetchrow_array) {
			for ($i = 0; $i < $cn; $i++) {
				print "<TD BGCOLOR=$cellcolor>";

				# If this is a foreign key, manually select description 
				# from foreign key.
				if (exists $foreign_keys{ $lcolumns[$i] }) {
					# Trim white space
					my $key_value = $row_ary[$i];
					$key_value =~ s/^\s*(.*?)\s*$/$1/;
					if ($key_value ne '') {	
						my ($ftable, $fcolumn) = split /\./, $foreign_keys{ $lcolumns[$i] }, 2; 
						# Determine if foreign table has 'description' column.
						# If not, use id for menu values.
						my $msth = $dbh->prepare("SELECT pg_attribute.attname FROM pg_class, pg_attribute WHERE pg_class.relname = \'$ftable\' AND pg_class.oid = pg_attribute.attrelid AND pg_attribute.attname = \'description\'");
						my $rowsaffected = $msth->execute;
	
						if (st_lib::sthErr($msth->err, $msth->errstr)) { 
							# Internal Error.
							print $query->end_html;
							$dbh->disconnect;
							exit;
						};
	
						$msth->finish;
	
						my $mds;
						if ($rowsaffected < 1) {
							$mds = 'SELECT id FROM ' . $ftable . " WHERE id = \'" . $row_ary[$i] . "\' ORDER BY id ";
						} else {
							$mds = 'SELECT description FROM ' . $ftable . " WHERE id = \'" . $row_ary[$i] . "\' ORDER BY description ";
						};
						my $msth = $dbh->prepare($mds);
						$msth->execute;
						if (st_lib::sthErr($sth->err, $sth->errstr)) { 
							# Internal Error.
							print $query->end_html;
							$msth->finish;
							$dbh->disconnect;
							exit;
						};
						my @mrow = $msth->fetchrow_array;
						# Print some datatypes in special way
						$scrapret = st_lib::viewFormDT($columntypes{ $lcolumns[$i] }, $mrow[0]);
					} else {
						# That's a NULL.
						$scrapret = st_lib::viewFormDT($columntypes{ $lcolumns[$i] }, '');
					};
				} else {
					# Print some datatypes in special way
					$scrapret = st_lib::viewFormDT($columntypes{ $lcolumns[$i] }, $row_ary[$i]);
				};

				print "</TD>";
			};
		};
		print "</TR></TABLE></CENTER>";	
	};

	# Two forms with different actions, delete and cancel.	
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$cellcolor>";
	print $query->start_form(-method=>'POST',
        -action=>"$cgipath/st_unitbound.pl?$tname+6+$rowid",
                                   -enctype=>$sencoding);
	print $query->submit('deletebutton', 'Delete');
	print $query->endform;
	print "</TD>";
	print "<TD BGCOLOR=$cellcolor>";
	print $query->start_form(-method=>'POST',
                                  -action=>"$cgipath/st_unitbound.pl?$tname+0",
                                  -enctype=>$sencoding);
	print $query->submit('cancelbutton', 'Cancel');
	print $query->endform;
	print "</TD></TR></TABLE></CENTER>";

	# We will not show anything else. Close and exit.
	print $query->end_html;
	$sth->finish;
	$dbh->disconnect;
	exit;
};

# If action = 2, we must give the existing row for update.
if ($action == 2) {
	# Display row data in a form, so the user can change them.
	# Update 07-07-2003: Foreign keys descriptions must be 
	# selected manually to avoid problems with NULL values.
	print $query->start_form(-method=>'POST',
				-name => 'updateform',
        			-action=>"$cgipath/st_unitbound.pl?$tname+5+$rowid",
                                -enctype=>$sencoding);

	print "<CENTER><H2>Update record</H2><P><TABLE><TR>";
	$dst = 'SELECT ';
	$i = 0;
	while ($colname = $lcolumns[$i]) {
		# The TABLE part
		print "<TD BGCOLOR=$headcellcolor> $tcolumns{ $colname } </TD>";
		if ($i > 0) { 
			$dst = $dst . ", $colname";
		} else {
			$dst = $dst . "$colname";
		};
		$i++;
	};
	$dst = $dst . " FROM $tname ";

	$dst = $dst . $where;
	$tmp = 0;

	# Add row oid in WHERE.
	if ($tmp > 0) {
		$dst = $dst . " AND ";
	} else { 
		if ($where eq '') {
			$dst = $dst . " WHERE ";
		};
	};
	$dst = $dst . " $tname.oid = " . $rowid;

	print "</TR><TR>";
	$sth = $dbh->prepare($dst);
	$sth->execute();

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$sth->finish;
		$dbh->disconnect;
		exit;
	};

	if ($sth->rows != 1) {
		print "<TD><H1>Internal Error - found " . $sth->rows . " rows in unique key.</H1></TD></TR></TABLE>";	
	} else {
		# Print fillout fields with existing values as default. 
		my $cn = @lcolumns + 0;
		while (@row_ary = $sth->fetchrow_array) {
			for ($i = 0; $i < $cn; $i++) {
				my ($rest, $rcolname) = split /\./, $lcolumns[$i], 2;
				if (0 == 1) {
					# Removed javascript case.
				} elsif (exists $foreign_keys{ $lcolumns[$i] } ) {
					# Foreign key, must use drop down box
					my (@values, %labels, @lrow);
					my ($ftable, $rest) = split /\./, $foreign_keys{ $lcolumns[$i] }, 2; 
					# Determine if foreign table has 'description' column.
					# If not, use id for menu values.
					my $lsth = $dbh->prepare("SELECT pg_attribute.attname FROM pg_class, pg_attribute WHERE pg_class.relname = \'$ftable\' AND pg_class.oid = pg_attribute.attrelid AND pg_attribute.attname = \'description\'");
					my $rowsaffected = $lsth->execute;

					if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
						# Internal Error.
						print $query->end_html;
						$dbh->disconnect;
						exit;
					};

					$lsth->finish;

					if ($rowsaffected < 1) {
						$lsth = $dbh->prepare("SELECT id, id 
								FROM $ftable ORDER BY id ");
					} else {
						$lsth = $dbh->prepare("SELECT id, description 
								FROM $ftable ORDER BY description");
					};

					$lsth->execute;

					if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
						# Internal Error.
						print $query->end_html;
						$dbh->disconnect;
						exit;
					};
		
					while (@lrow = $lsth->fetchrow_array) {
						push @values, $lrow[0];
						$labels{ $lrow[0] } = $lrow[1];
					};
					print "<TD>";
					push @values, ''; # If user doesn't want to select.
					if ($row_ary[$i] ne '') { 
						print $query->popup_menu(-name=>"$lcolumns[$i]",
                                   				-values=>\@values,
				   				-default=>$row_ary[$i],
                                   				-labels=>\%labels);
					} else {
						print $query->popup_menu(-name=>"$lcolumns[$i]",
                                   				-values=>\@values,
				   				-default=>'',
                                   				-labels=>\%labels);
					};
					print "</TD>";
				} else {
					# Simple field
					print "<TD>";
					$scrapret = st_lib::editFormDT($query, $lcolumns[$i], $columntypes{ $lcolumns[$i] }, $row_ary[$i]);
					print "</TD>";
				};
			};
		};
		print "</TR></TABLE>";	
		# Add submit button, end first form, add cancel button.

		print "<CENTER><TABLE><TR>";
		print "<TD BGCOLOR=$cellcolor>";
		print $query->submit('updatebutton', 'Update');
		print $query->endform;
		print "</TD><TD BGCOLOR=$cellcolor>";
		print $query->start_form(-method=>'POST',
                	                  -action=>"$cgipath/st_unitbound.pl?$tname+0",
                        	          -enctype=>$sencoding);
		print $query->submit('cancelbutton', 'Cancel');
		print $query->endform;
		print "</TD></TR></TABLE></CENTER>";

	};

	# We will not show anything else. Close and exit.
	print $query->end_html;
	$sth->finish;
	$dbh->disconnect;
	exit;
};

# If action = 6, we must delete the row.
if ($action == 6) {
	$dst = "DELETE FROM $tname WHERE oid = $rowid";
	$sth = $dbh->prepare($dst);
	print "<CENTER>";
	my $rowsaffected = $sth->execute();

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed to delete.
		print "<H2><FONT COLOR=RED>Unsuccessful deletion!</FONT></H2>";
	};
	$dbh->commit;
	if (defined($rowsaffected)) {
		# If not defined, is an error and handled above
		if ($rowsaffected == 1) { 
			print "<H3><FONT COLOR=GREEN>Record deleted.</FONT></H3><P>";
		} elsif ($rowsaffected == 0) {
			print "<H3><FONT COLOR=RED>Attention: </FONT><FONT COLOR=$headcellcolor>No record deleted.</FONT></H3><P>";
		} else {
			print "<H3><FONT COLOR=RED>Attention: </FONT><FONT COLOR=$headcellcolor>Deleted $rowsaffected records.</FONT></H3><P>";
		};
	};
	print "</CENTER>";
};

# If action = 5, take values and update record (update2)
if ($action == 5) {
	my $pm;
	my $firsttoken = 1;
	my @params = $query->param;
	my $dust = "UPDATE $tname SET "; # Dynamic Update STatement
	foreach $pm (@params) {
		if (exists $tcolumns{ $pm })  {
			# We got a column here.
			my $pmvalue = $query->param($pm);
			if ($columntypes{ $pm } eq 'bool') {
				# NULL in radio buttons is -1
				if ($pmvalue == -1) {
					$pmvalue = '';
				};
			};
			# Trim white space
			$pmvalue =~ s/^\s*(.*?)\s*$/$1/;
			# Escape single quotes
			$pmvalue =~ s/\'/\\\'/g;
			# Take tablename off
			($rest, $pm) = split /\./, $pm, 2;
			if ($pmvalue ne '') {
				if ($firsttoken) {
					$dust = $dust . $pm . " = " . "\'$pmvalue\'";
					$firsttoken = 0;
				} else { 
					$dust = $dust . ', ' . $pm . " = " . "\'$pmvalue\'";
				};
			} else {
				# NULL value 
				if ($firsttoken) {
					$dust = $dust . $pm . " = NULL";
					$firsttoken = 0;
				} else { 
					$dust = $dust . ', ' . $pm . " = NULL";
				};
			};
			$query->param("$tname.$pm", '');
		};
	};
	# Add id 
	$dust = $dust . " WHERE oid = \'$rowid\'";

	my $usth = $dbh->prepare($dust);

	$usth->execute();
	print "<CENTER>";
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Error on Update.
		print "<CENTER><H2><FONT COLOR=RED>Unsuccessful update.</FONT></H2></CENTER>";
	};
	$dbh->commit;
	$usth->finish;
	print "</CENTER>";
};

# Create a search form
print $query->start_form(-method=>'POST',
                                   -action=>"$cgipath/st_unitbound.pl?$tname+4",
				   -name=>'searchform',
                                   -enctype=>$sencoding);
print "<CENTER><TABLE><TR>";
# Print header row first
$i = 0;
while ($colname = $scolumns[$i]) {
	print "<TD BGCOLOR=$headcellcolor> $tcolumns{ $colname } </TD>";
	$i++
};
print "</TR><TR>";
# Now print search fields
$i = 0;
print "<H3><FONT COLOR=$headcellcolor>Search</FONT></H3>";
while ($colname = $scolumns[$i]) {
	my ($rest, $cleancname) = split /\./, $colname, 2;
	if (0 == 1) {
		# Special case, use javascript.
		# Removed.	
	} elsif (exists $foreign_keys{$colname}) {
		# Foreign key, must use drop down box
		my (@values, %labels, @lrow);
		my ($ftable, $rest) = split /\./, $foreign_keys{ $colname }, 2; 
		# Determine if foreign table has 'description' column.
		# If not, use id for menu values.
		my $lsth = $dbh->prepare("SELECT pg_attribute.attname FROM pg_class, pg_attribute WHERE pg_class.relname = \'$ftable\' AND pg_class.oid = pg_attribute.attrelid AND pg_attribute.attname = \'description\'");
		my $rowsaffected = $lsth->execute;

		if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};

		$lsth->finish;

		if ($rowsaffected < 1) {
			$lsth = $dbh->prepare("SELECT id, id 
					FROM $ftable ORDER BY id ");
		} else {
			$lsth = $dbh->prepare("SELECT id, description 
					FROM $ftable ORDER BY description");
		};
		$lsth->execute;

		if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		
		while (@lrow = $lsth->fetchrow_array) {
			push @values, $lrow[0];
			$labels{ $lrow[0] } = $lrow[1];
		};
		print "<TD>";
		push @values, ''; # If user doesn't want to select.
		print $query->popup_menu(-name=>$colname,
                                   -values=>\@values,
				   -default=>'',
                                   -labels=>\%labels);
		print "</TD>";

	} else {
		# Simple field
		print "<TD>";
		$scrapret = st_lib::editFormDT($query, $colname, $columntypes{ $colname }, '');
		print "</TD>";
	};
	$i++
};
print "</TR><TR><TD COLSPAN=$i><CENTER>";

print $query->submit('submitbutton', 'Find');
print "</CENTER></TD></TR></TABLE></CENTER>";

print $query->endform;

# if insert button was pressed, do the insert before the query.
if ($action == 1) {
	my $pm;
	my $firsttoken = 1;
	my @params = $query->param;
	my $distp1 = "INSERT INTO $tname ("; # Dynamic Insert STatement part 1.
	my $distp2 = " VALUES ("; # Dynamic Insert STatement part 2.
	foreach $pm (@params) {
		my $keepthat;
		($keepthat, $pm) = split /\./, $pm, 2;
		if (exists $tcolumns{ $pm }) {
			# We got a column here.
			my $pmvalue = $query->param("insert.$pm");
			if ($columntypes{ $pm } eq 'bool') {
				# NULL in radio buttons is -1
				if ($pmvalue == -1) {
					$pmvalue = '';
				};
			};
			$query->param("insert.$pm", '');
			# Trim white space
			$pmvalue =~ s/^\s*(.*?)\s*$/$1/;
			# Escape single quotes
			$pmvalue =~ s/\'/\\\'/g;
			# Take tablename off
			($rest, $pm) = split /\./, $pm, 2;
			if ($pmvalue ne '') {
				if ($firsttoken) {
					$distp1 = $distp1 . $pm; 
					$distp2 = $distp2 . "\'$pmvalue\'";
					$firsttoken = 0;
				} else { 
					$distp1 = $distp1 . ', ' . $pm; 
					$distp2 = $distp2 . ', ' . "\'$pmvalue\'";
				};
			};
		};
	};
	$distp1 = $distp1 . ') ' . $distp2 . ')';

	my $isth = $dbh->prepare($distp1);

	$isth->execute();
	print "<CENTER>";
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Error on Insert.
		print "<CENTER><H2><FONT COLOR=RED>Unsuccessful add</FONT></H2></CENTER>";
	};
	$dbh->commit;
	$isth->finish;
	print "</CENTER>";
};


# Add an insert form also, only if insert is permitted.
if ($do_ins) {
	print $query->start_form(-method=>'POST',
				 -name=>'insertform',
	                         -action=>"$cgipath/st_unitbound.pl?$tname+1",
	                         -enctype=>$sencoding);
	print "<CENTER><HR><H3><FONT COLOR=$headcellcolor>Add</FONT></H3><TABLE><TR>";
	# Print header row first
	$i = 0;
	while ($colname = $lcolumns[$i]) {
		print "<TD BGCOLOR=$headcellcolor> $tcolumns{ $colname } </TD>";
		$i++
	};
	#print "$i";
	print "</TR><TR>";
	# Now print fill out fields
	$i = 0;
	while ($colname = $lcolumns[$i]) {
		my ($rest, $cleancname) = split /\./, $colname, 2;
		if (0 == 1) {
			# Special case, use javascript.
			# Removed.
		} elsif (exists $foreign_keys{$colname}) {
			# Foreign key, must use drop down box
			my (@values, %labels, @lrow);
			my ($ftable, $rest) = split /\./, $foreign_keys{ $colname }, 2; 


			# Determine if foreign table has 'description' column.
			# If not, use id for menu values.
			my $lsth = $dbh->prepare("SELECT pg_attribute.attname FROM pg_class, pg_attribute WHERE pg_class.relname = \'$ftable\' AND pg_class.oid = pg_attribute.attrelid AND pg_attribute.attname = \'description\'");
			my $rowsaffected = $lsth->execute;
	
			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
	
			$lsth->finish;
	
			if ($rowsaffected < 1) {
				$lsth = $dbh->prepare("SELECT id, id 
						FROM $ftable ORDER BY id ");
			} else {
				$lsth = $dbh->prepare("SELECT id, description 
						FROM $ftable ORDER BY description ");
			};

			$lsth->execute;
	
			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			
			while (@lrow = $lsth->fetchrow_array) {
				push @values, $lrow[0];
				$labels{ $lrow[0] } = $lrow[1];
			};
			print "<TD>";
			push @values, ''; # If user doesn't want to select.
			print $query->popup_menu(-name=>"insert.$colname",
       	                            -values=>\@values,
					   -default=>'',
       	                           -labels=>\%labels);
			print "</TD>";
	
		} else {
			# Simple field
			print "<TD>";
			$scrapret = st_lib::editFormDT($query, "insert.$colname", $columntypes{ $colname }, '');
			print "</TD>";
		};
		$i++
	};
	print "</TR><TR><TD COLSPAN=$i><CENTER>";

	print $query->submit('insertbutton', 'Add');
	print "</CENTER></TD></TR></TABLE></CENTER>";

	print $query->endform;
};

print "<HR>";
# Ok, now prepare the select and in the same time build the table.
my $viewtablestring = '';
$viewtablestring = $viewtablestring . "<CENTER><H3><FONT COLOR=$headcellcolor>Data</FONT></H3><TABLE><TR>";
# Build a left join select.
my $ljdst = 'SELECT ';
$i = 0;
while ($colname = $lcolumns[$i]) {
	# The TABLE part
	$viewtablestring = $viewtablestring . "<TD BGCOLOR=$headcellcolor> $tcolumns{ $colname } </TD>";
	# The SELECT part
	if (exists $foreign_keys{$colname}) {
		# The first part of select needs the description,
		# not the actual key.
		# Update: But only if description actually exists.
		$tmp = $foreign_keys{$colname};
		($tmp, $rest) = split /\./, $tmp, 2;
		if ($f_keys_counters{$tmp} < 2) {
			# if too many times, treat it as simple column, will find descriptions later.
			my $lsth = $dbh->prepare("SELECT pg_attribute.attname FROM pg_class, pg_attribute WHERE pg_class.relname = \'$tmp\' AND pg_class.oid = pg_attribute.attrelid AND pg_attribute.attname = \'description\'");
			my $rowsaffected = $lsth->execute;

			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};

			$lsth->finish;
			if ($rowsaffected < 1) {
				$colname = $tmp . ".id";
			} else {
				$colname = $tmp . ".description";
			};

		};
	};
	if ($i > 0) { 
		$ljdst = $ljdst . ", $colname";
	} else {
		$ljdst = $ljdst . "$colname";
	};
	$i++;
};
 
# Add two extra cells for the buttons.
if ($do_upd) {
	$viewtablestring = $viewtablestring . "<TD BGCOLOR=$headcellcolor> </TD>";
};
if ($do_del) {
	$viewtablestring = $viewtablestring . "<TD BGCOLOR=$headcellcolor> </TD>";
};

$ljdst = $ljdst . ", $tname.oid FROM ";		#We need the record oid for updates and deletes.

# Add parentheses. 
foreach $key (sort keys %foreign_keys) {
	my $tmp = $foreign_keys{$key};
	($tmp, $rest) = split /\./, $tmp, 2;
	if ($f_keys_counters{$tmp} < 2) {
		$ljdst = $ljdst . "(";		
	};
};

$tmp = 0;
# Add foreign keys with left joins. 
if (scalar(keys %foreign_keys) > 0) {
	# We do have foreign keys
	foreach $key (sort keys %foreign_keys) {
		my ($fktname, $rest) = split /\./, $foreign_keys{$key}, 2;
		if ($f_keys_counters{$fktname} < 2) {
			if ($tmp == 0) {
				$ljdst = "$ljdst $tname"; 
			};
			$ljdst = "$ljdst left join $fktname on $key = " . $foreign_keys{$key} . ") "; 
			$tmp++;
		};
	};
} else {
	# No foreign keys, add table name in left join select.
	$ljdst = "$ljdst $tname";
};

# If search button was pressed, add search parameters to query.
if ($action == 4) {
	my $pm;
	my @params = $query->param;
	foreach $pm (@params) {
		if (exists $tcolumns{ $pm }) {
			# We got a column here.
			my $pmvalue = $query->param($pm);
			if ($columntypes{ $pm } eq 'bool') {
				# NULL in radio buttons is -1
				if ($pmvalue == -1) {
					$pmvalue = '';
				};
			};
			# Trim white space
			$pmvalue =~ s/^\s*(.*?)\s*$/$1/;
			# Escape single quotes
			$pmvalue =~ s/\'/\\\'/g;
			if ($pmvalue ne '') {
				if ($where eq "") {
					# There is not WHERE clause so far, add it.
					$where = " WHERE ";
					$ljdst = $ljdst . $where;
					# Boolean columns need special treatment
					if ($columntypes{ $pm } eq 'bool') {
						$ljdst = $ljdst . $pm . " = \'$pmvalue\'";
					} else {
						$ljdst = $ljdst . $pm . ' ILIKE \'' . $pmvalue . '\'';	
					};
				} else {
					# Use AND.
					# Boolean columns need special treatment
					if ($columntypes{ $pm } eq 'bool') {
						$ljdst = $ljdst . ' AND ' . $pm . " = \'$pmvalue\'";
					} else {
						$ljdst = $ljdst . ' AND ' . $pm . ' ILIKE \'' . $pmvalue . '\'';	
					};
				};
			};
		};
	};
};
# Debug stuff: 

#print "<P>foreign_keys<P>";
#foreach $key (sort keys %foreign_keys) {
#	print "<P> $key = " . $foreign_keys{$key} . "<P>";
#};
#print "<P>f_keys_counters<P>";
#foreach $key (sort keys %f_keys_counters) {
#	print "<P> $key = " . $f_keys_counters{$key} . "<P>";
#};

#End debug stuff

print $viewtablestring . "</TR><TR>";

$sth = $dbh->prepare($ljdst);
$sth->execute();

if (st_lib::sthErr($sth->err, $sth->errstr)) { 
# Internal Error.
	print $query->end_html;
	$sth->finish;
	$dbh->disconnect;
	exit;
};

my $totalrows = $sth->rows;

if ($sth->rows == 0) {
	 print "<TD COLSPAN=$i><H2><FONT COLOR=BLUE><CENTER>No records found.</CENTER></H2></TD></TR></TABLE>";	
} else {
	# Print the rows
	my $cn = @lcolumns + 0;
	while (@row_ary = $sth->fetchrow_array) {
		for ($i = 0; $i < $cn; $i++) {
			print "<TD BGCOLOR=$cellcolor>";
			if (exists($foreign_keys{ $lcolumns[$i] })) {
				my ($fktname, $rest) = split /\./, $foreign_keys{ $lcolumns[$i] }, 2;
				if (($f_keys_counters{$fktname} > 1) and ($row_ary[$i] ne '')) {
					# One of multiple foreign keys...
					# Manual select. Bingo.
					my $ldst = "SELECT $fktname.";
					my $lsth = $dbh->prepare("SELECT pg_attribute.attname FROM pg_class, pg_attribute WHERE pg_class.relname = \'$fktname\' AND pg_class.oid = pg_attribute.attrelid AND pg_attribute.attname = \'description\'");
					my $rowsaffected = $lsth->execute;

					if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
						# Internal Error.
						print $query->end_html;
						$dbh->disconnect;
						exit;
					};

					$lsth->finish;
					if ($rowsaffected < 1) {
						$ldst = $ldst . "id";
					} else {
						$ldst = $ldst . "description";
					};

					$ldst = $ldst . " FROM $fktname, $tname WHERE " . $lcolumns[$i] . " = " . $foreign_keys{ $lcolumns[$i] } . " AND " . $foreign_keys{ $lcolumns[$i] } . " = " . $row_ary[$i] ;
					my $lsth2 = $dbh->prepare($ldst);
					$lsth2->execute;
	
					if (st_lib::sthErr($lsth2->err, $lsth2->errstr)) { 
						# Internal Error.
						print $query->end_html;
						$dbh->disconnect;
						exit;
					};
	
					my @lrow = $lsth2->fetchrow_array;
	
					$scrapret = st_lib::viewFormDT($columntypes{ $lcolumns[$i] }, $lrow[0]);
				} else {
					$scrapret = st_lib::viewFormDT($columntypes{ $lcolumns[$i] }, $row_ary[$i]);
				};
				
			} else {
				# Print some datatypes in special way
				$scrapret = st_lib::viewFormDT($columntypes{ $lcolumns[$i] }, $row_ary[$i]);
			};
			print "</TD>";
		};
		# Add update and delete buttons
		if ($do_upd) {
			print "<TD BGCOLOR=$cellcolor>";
			print $query->start_form(-method=>'POST',
       	                            -action=>"$cgipath/st_unitbound.pl?$tname+2+" . $row_ary[$i],
       	                            -enctype=>$sencoding);
			print $query->submit('updatebutton', 'Update');
			print $query->endform;
			print "</TD>";
		};
		if ($do_del) {
			print "<TD BGCOLOR=$cellcolor>";
			print $query->start_form(-method=>'POST',
       	                            -action=>"$cgipath/st_unitbound.pl?$tname+3+" . $row_ary[$i],
       	                            -enctype=>$sencoding);
				print $query->submit('deletebutton', 'Delete');
			print $query->endform;
			print "</TD>";
		};

		print "</TR><TR>";
	};
};

print "</TR></TABLE><BR><H3><FONT COLOR=$cellcolor>Total records: " . $totalrows . "</FONT></H3></CENTER>";	

st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
#print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";

print $query->end_html;
$sth->finish;
$dbh->disconnect;
exit;
