#!/usr/bin/perl
#########################################################################
# Detailed statistics screens						#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Revision history: 							#
# V0.0.0	Starting... (Nov 1 2005)				#
# V0.0.1	First statistics screen working (with pie)		#
# V0.0.2	Second statistics screen working (with bars)		#
# V0.0.3	Elapsed time statistics screen working (with pie)	#
# V0.0.4	Per priority statistics screen working (with pie)	#
# V0.0.5	Three booleans screen working (with pies)		#
# V0.0.6	Opened per user screen working (with bars)		#
# V0.0.7	Opened per company screen working (with bars)		#
# V0.0.8	Added footer with total in all screens.			#
# V0.0.9	Per priority changed to initial priority.		#
# V0.1.0	Elapsed time depended on working hours or not.		#
# V0.1.1	Better graphs font (parameter in stunt.conf).		#
# V0.1.2	Strings coming from db converted to utf8 in graphs.	#
# V0.1.3	Added links to directory for elapsed groups.		#
# V0.1.4	Replaced hardcoded encodings with parameter.		#
# V0.1.5	Replaced hardcoded language with parameter.		#
# V0.1.6	First version of SLA statistics screen.			#
# V0.1.7	Added CSV output on SLA screen.				#
#									#
# Arguments description (* = internal, not menu):			#
# 	action: 							#
#########################################################################

use strict;
use DBI;
use CGI;
use st_lib;
use GD::Graph::pie;
use GD::Graph::bars;
use Unicode::MapUTF8 qw(to_utf8 from_utf8 utf8_supported_charset);

my $data_source = $st_lib::data_source;		# Where to look...
my ($sth, $sth2); 				# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my ($dst, $dst2);				# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables

my $debug = $st_lib::debug;

my $myhost = $st_lib::myhost;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path 
my $wh_start = 		$st_lib::wh_start;	# working hours start
my $wh_end = 		$st_lib::wh_end;	# working hours end
my $graphfont =		$st_lib::graphfont; 	# Font for graphs.
my $sencoding =		$st_lib::sencoding;	# Encoding for HTML etc
my $slang =		$st_lib::slang;		# Language for HTML etc

my %formtitles = ( 	
		# Form title depending on action. Also used to check
		# parameter validity.
		0 => 'Statistics',
		1 => 'Statistics per SR type',
		2 => 'Statistics per CSE',
		3 => 'Elapsed time statistics',
		4 => 'Statistics per initial priority',
		5 => 'Various Statistics',
		6 => 'Opened SRs per user',
		7 => 'Opened SRs per company',
		8 => 'Elapsed time statistics (working hours)',
		9 => 'Elapsed time statistics (outside working hours)',
		10 => 'SLA times compliance',
		11 => 'SLA times compliance (CSV)',
		);

my $version = "st_stats.pl V0.1.7";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $action = $chooserlist[0];

if (not (exists $formtitles{$action})) {
	# Default is 0
	$action = 0;
};

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Initialize CGI and send headers.
# ... but if 11 is called, don't.
if ($action != 11) {
	print  $query->header(-charset=>$sencoding);
	print  $query->start_html(-title=>$formtitles{$action},
				  -text=>$textcolor,
				  -lang=>$slang,
				  -BGCOLOR=>$bgcolor);

	st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);

	print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";

};

if (not (($zdata[3] == 1) and ($zdata[5] == 1))) {
	# This is only for tech_mc
	# Deny access, but don't tell exactly why... >:-)
	print "<FONT COLOR=RED><H1>Service unavailable.</H1></FONT>";
	print "Code 404";
	print $query->end_html;
	$dbh->disconnect;
	st_lib::wDbg("SECURITY: User $zdata[0] tried to access statistics without correct permission.", "st_stats");
	exit;
};

# Everything from here is action depended.

if ($action == 0) {
	# Select date period and SR types for statistics.
	# This screen will have multiple uses.
	my @values;
	my %labels;
	my $cgi_select = $chooserlist[1];

	my %cgi_select_list = (
				0 => "$cgipath/st_stats.pl?1",
				1 => "$cgipath/st_stats.pl?2",
				2 => "$cgipath/st_stats.pl?3+0",
				3 => "$cgipath/st_stats.pl?4",
				4 => "$cgipath/st_stats.pl?5",
				5 => "$cgipath/st_stats.pl?6",
				6 => "$cgipath/st_stats.pl?7",
				7 => "$cgipath/st_stats.pl?3+1",
				8 => "$cgipath/st_stats.pl?3+2",
				9 => "$cgipath/st_stats.pl?10",
				);

	my %cgi_select_titles = (
				0 => "SRs per type",
				1 => "SRs per CSE",
				2 => "Elapsed time",
				3 => "SRs per initial priority",
				4 => "Various Statistics",
				5 => "Opened SRs per user",
				6 => "Opened SRs per company",
				7 => "Elapsed time (working hours)",
				8 => "Elapsed time (outside working hours)",
				9 => "SLA times compliance",
				);

	print $query->start_form(-method=>'POST',
       		                         -action=>$cgi_select_list{ $cgi_select },
					 -name=>'form',
       		                         -enctype=>$sencoding);

	print "<CENTER><TABLE>";
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER><B>$cgi_select_titles{ $cgi_select }</B></CENTER></TD</TR>";
	# Date fields.
	print "<TR><TD BGCOLOR=$headcellcolor>Period from: </TD><TD BGCOLOR=$cellcolor><CENTER>";
       	print $query->textfield(-name=>'start_date',
       	                         -size=>20,
				 -default=>'',
       	                         -maxlength=>255);
	print "</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor>To: </TD><TD BGCOLOR=$cellcolor><CENTER>";
       	print $query->textfield(-name=>'end_date',
       	                         -size=>20,
				 -default=>'',
       	                         -maxlength=>255);
	print "</CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=4><CENTER><I>Date format example: </I><B>Jan 10 2004 13:00</B> - Leave blank for full report.</CENTER></TD></TR>";
	# Fill scrolling list with SR types
	# Update: in case 9, select only types with SLA data.
	if ($cgi_select == 9) {
		$dst = "SELECT id, name 
			FROM st_faulttypes 
			WHERE manual_dates = 't'
			ORDER BY name";
	} else {
		$dst = "SELECT id, name 
			FROM st_faulttypes ORDER BY name";
	};
	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
		push @values, $lrow[0];
		$labels{ $lrow[0] } = "$lrow[1]";
	};
	print "<TR><TD BGCOLOR=$headcellcolor>Select SR types: </TD><TD BGCOLOR=$cellcolor COLSPAN=2>";

	# Print scrolling list - by default, all elements selected.
	print $query->scrolling_list(-name=>'typeslist',
                                     -values=>\@values,
                                     -default=>\@values,
                                     -size=>5,
                                     -multiple=>'true',
                                     -labels=>\%labels);
	print "</TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print "</CENTER></TD></TR></TABLE>";
	print $query->endform;
} elsif ($action == 1) {
	# SRs per type

	# Read dates and selected types
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');

	# Get type names
	my %labels;
	$dst = "SELECT id, name FROM st_faulttypes ORDER BY name";
	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
		$labels{ $lrow[0] } = "$lrow[1]";
	};

	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';

	# Get results 
	# dst2 and sth2 are used to count total number of faults.

	$dst = "SELECT faulttype_id, count(*) FROM st_faults WHERE faulttype_id IN $sqlin ";
	$dst2 = "SELECT count(*) FROM st_faults WHERE faulttype_id IN $sqlin ";

	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};
	$dst = $dst . " GROUP BY faulttype_id ORDER BY 2 DESC";

	$sth = $dbh->prepare($dst);
	$sth2 = $dbh->prepare($dst2);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	$sth2->execute;
	if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @tmp = $sth2->fetchrow_array;
	my $totalfaultnumber = $tmp[0];
	$sth2->finish;

	# Print results (while building pie data)
	my (@piedata, $i);
	$i = 0;

	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>SR type</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 

	while (@lrow = $sth->fetchrow_array) {
		# Selected, print it.
		print "<TR><TD BGCOLOR=$cellcolor>";
		print $labels{ $lrow[0] };
		print "</TD><TD BGCOLOR=$cellcolor>$lrow[1]</TD>";
		my $pc = $lrow[1] * 100 / $totalfaultnumber;
		print "<TD BGCOLOR=$cellcolor ALIGN=RIGHT>" . sprintf("%3.2f\%", $pc) . "</TD></TR>";
		$piedata[0][$i] = to_utf8({
						-string => $labels{ $lrow[0] },
						-charset => $sencoding});
		$piedata[1][$i] = $lrow[1];
		$i++;
	};

	&table_footer($start_date, $end_date, $totalfaultnumber);

	print "</TABLE>";
	# Create and print pie chart.

	# Define filename
	my $timehex = $zuser . sprintf("%lx", time);

	my $graph = GD::Graph::pie->new(400, 300);	
	$graph->set( 
      			title             => 'SR count per type',
			suppress_angle    => 4
  			) or die $graph->error;

	$graph->set_label_font($graphfont, 9);
	$graph->set_value_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);


	my $gd = $graph->plot(\@piedata)->png or die $graph->error;

	open(IMG, ">/tmp/$timehex") or die $!;

	print IMG $gd;

	close IMG;

	print "<P><P><TABLE><TR><TD BGCOLOR=$cellcolor><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></TD></TR></TABLE>";

} elsif ($action == 2) {
	# Per CSE
	# Read dates and selected types
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');

	my $i;
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';
	$dst = "SELECT tof.fullname, count(*) FROM st_tech_of_fault tof INNER JOIN st_faults f ON tof.id = f.id WHERE f.faulttype_id IN $sqlin";
	$dst2 = "SELECT count(*) FROM st_faults WHERE faulttype_id IN $sqlin ";
	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND f.start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND f.start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	$dst = $dst . "GROUP BY tof.fullname ORDER BY 2 DESC";
	$sth = $dbh->prepare($dst);
	$sth2 = $dbh->prepare($dst2);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	$sth2->execute;
	if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @tmp = $sth2->fetchrow_array;
	my $totalfaultnumber = $tmp[0];
	$sth2->finish;

	my (@piedata, $i);
	$i = 0;

	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>CSE name</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>SR Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 

	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor>";
			print $lrow[0];
			print "</TD><TD BGCOLOR=$cellcolor>$lrow[1]</TD>";
			my $pc = $lrow[1] * 100 / $totalfaultnumber;
			print "<TD BGCOLOR=$cellcolor ALIGN=RIGHT>" . sprintf("%3.2f\%", $pc) . "</TD></TR>";
			$piedata[0][$i] = to_utf8({
							-string => $lrow[0],
							-charset => $sencoding });
			$piedata[1][$i] = $lrow[1];
			$i++;
	};

	&table_footer($start_date, $end_date, $totalfaultnumber);
	
	print "</TABLE>";
	 
	# Create and print pie chart.

	# Define filename
	my $timehex = $zuser . sprintf("%lx", time);

	my $graph = GD::Graph::bars->new(800, 600);	
	$graph->set( 
      			title             => 'SR count per CSE',
			x_labels_vertical => 1,
  			) or die $graph->error;

	$graph->set_x_axis_font($graphfont, 9);
	$graph->set_y_axis_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);

	my $gd = $graph->plot(\@piedata)->png or die $graph->error;

	open(IMG, ">/tmp/$timehex") or die $!;

	print IMG $gd;

	close IMG;

	print "<P><P><TABLE><TR><TD BGCOLOR=$cellcolor><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></TD></TR></TABLE>";

} elsif ($action == 3) {
	# Elapsed time statistics
	# $select_type:
	#	0: All
	#	1: Whithin working hours
	#	2: Outside working hours
	my $select_type = $chooserlist[1];

	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');
	

	my ($i, @tmp);
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';

	# Four different queries. All have the same WHERE clause with dates and faulttypes exclusions.
	my $whereclause = "WHERE faulttype_id IN $sqlin ";

	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$whereclause = $whereclause . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$whereclause = $whereclause . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	# Build more where clause for time of day selection.
	if ($select_type eq '1') {
		$whereclause = $whereclause . " AND CAST(start_time AS TIME) >= CAST(\'$wh_start\' AS TIME) AND CAST(start_time AS TIME) <= CAST(\'$wh_end\' AS TIME) ";
		print "<CENTER><H2><FONT COLOR=$headcellcolor>(working hours)</FONT></H2><P>";
	} elsif ($select_type eq '2') {
		$whereclause = $whereclause . " AND ((CAST(start_time AS TIME) < CAST(\'$wh_start\' AS TIME)) OR (CAST(start_time AS TIME) > CAST(\'$wh_end\' AS TIME))) ";
		print "<CENTER><H2><FONT COLOR=$headcellcolor>(outside working hours)</FONT></H2><P>";
	} else {
		# Nothing.
		print "<CENTER><H2><FONT COLOR=$headcellcolor>(24h)</FONT></H2><P>";
	};

	st_lib::wDbg("$whereclause", "st_stats");
	

	# First query, te < 10min
	$dst = "SELECT COUNT(*) FROM st_elapsed " . $whereclause . " AND e10min IS TRUE";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $e10min = $tmp[0];

	# Second query, 10min < te < 30min
	$dst = "SELECT COUNT(*) FROM st_elapsed " . $whereclause . " AND e30min IS TRUE";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $e30min = $tmp[0];

	# Third query, 30min < te < 60min
	$dst = "SELECT COUNT(*) FROM st_elapsed " . $whereclause . " AND e1hour IS TRUE";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $e1hour = $tmp[0];

	# Fourth query,  60min < te
	$dst = "SELECT COUNT(*) FROM st_elapsed " . $whereclause . " AND emore IS TRUE";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $emore = $tmp[0];

	# Fifth query, total count 
	$dst = "SELECT COUNT(*) FROM st_elapsed " . $whereclause; 

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $etotal = $tmp[0];

	my @piedata;
	$piedata[0][0] = "Less than 10 min";
	$piedata[1][0] = $e10min;
	$piedata[0][1] = "Less than 30 min";
	$piedata[1][1] = $e30min;
	$piedata[0][2] = "Less than 60 min";
	$piedata[1][2] = $e1hour;
	$piedata[0][3] = "More than 60 min";
	$piedata[1][3] = $emore;

	# Print results
	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>Elapsed time (ET)</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 
	print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_faults.pl?3+2+0\">ET < 10min</A></TD><TD BGCOLOR=$cellcolor>$e10min</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $e10min * 100 / $etotal) . "</TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_faults.pl?3+2+1\">10min < ET < 30min</A></TD><TD BGCOLOR=$cellcolor>$e30min</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $e30min * 100 / $etotal) . "</TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_faults.pl?3+2+2\">30min < ET < 60min</A></TD><TD BGCOLOR=$cellcolor>$e1hour</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $e1hour * 100 / $etotal) . "</TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_faults.pl?3+2+3\">60min < ET</A></TD><TD BGCOLOR=$cellcolor>$emore</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $emore * 100 / $etotal) . "</TD></TR>";

	&table_footer($start_date, $end_date, $etotal);

	print "</TABLE>";
	 
	# Create and print pie chart.

	# Define filename
	my $timehex = $zuser . sprintf("%lx", time);

	my $graph = GD::Graph::pie->new(400, 300);	
	$graph->set( 
      			title             => 'Elapsed time',
  			) or die $graph->error;

	$graph->set_label_font($graphfont, 9);
	$graph->set_value_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);

	my $gd = $graph->plot(\@piedata)->png or die $graph->error;

	open(IMG, ">/tmp/$timehex") or die $!;

	print IMG $gd;

	close IMG;

	print "<P><P><TABLE><TR><TD BGCOLOR=$cellcolor><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></TD></TR></TABLE>";

} elsif ($action == 4) {
	# Per priority
	# Read dates and selected types
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');

	my $i;
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';
	$dst = "SELECT lof.name, count(*) FROM st_init_level_of_fault lof INNER JOIN st_faults f ON lof.id = f.id WHERE f.faulttype_id IN $sqlin";
	$dst2 = "SELECT count(*) FROM st_faults WHERE faulttype_id IN $sqlin ";
	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND f.start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND f.start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	$dst = $dst . "GROUP BY lof.name ORDER BY 2 DESC";
	$sth = $dbh->prepare($dst);
	$sth2 = $dbh->prepare($dst2);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	$sth2->execute;
	if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @tmp = $sth2->fetchrow_array;
	my $totalfaultnumber = $tmp[0];
	$sth2->finish;

	my (@piedata, $i);
	$i = 0;

	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>Priority</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>SR Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 

	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor>";
			print $lrow[0];
			print "</TD><TD BGCOLOR=$cellcolor>$lrow[1]</TD>";
			my $pc = $lrow[1] * 100 / $totalfaultnumber;
			print "<TD BGCOLOR=$cellcolor ALIGN=RIGHT>" . sprintf("%3.2f\%", $pc) . "</TD></TR>";
			$piedata[0][$i] = to_utf8({
							-string =>$lrow[0],
							-charset => $sencoding });
			$piedata[1][$i] = $lrow[1];
			$i++;
	};

	&table_footer($start_date, $end_date, $totalfaultnumber);

	print "</TABLE>";
	 
	# Create and print pie chart.

	# Define filename
	my $timehex = $zuser . sprintf("%lx", time);

	my $graph = GD::Graph::pie->new(400, 300);	
	$graph->set( 
      			title             => 'SR count per initial priority',
		#	x_labels_vertical => 1,
  			) or die $graph->error;

	$graph->set_label_font($graphfont, 9);
	$graph->set_value_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);

	my $gd = $graph->plot(\@piedata)->png or die $graph->error;

	open(IMG, ">/tmp/$timehex") or die $!;

	print IMG $gd;

	close IMG;

	print "<P><P><TABLE><TR><TD BGCOLOR=$cellcolor><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></TD></TR></TABLE>";

} elsif ($action == 5) {
	# The three boolean statistics - all in one screen. 

	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');
	

	my ($i, @tmp);
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';

	# Three plus one different queries. All have the same WHERE clause with dates and faulttypes exclusions.
	my $whereclause = "WHERE faulttype_id IN $sqlin ";

	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$whereclause = $whereclause . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$whereclause = $whereclause . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	# First query, faults with TAC. 
	$dst = "SELECT COUNT(*) FROM st_faults " . $whereclause . " AND tac_num IS NOT NULL";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $tac_count = $tmp[0];

	# Second query, with RMA. 
	$dst = "SELECT COUNT(*) FROM st_faults " . $whereclause . " AND rma_num IS NOT NULL";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $rma_count = $tmp[0];

	# Third query, surveys answered. 
	$dst = "SELECT COUNT(*) FROM st_faults " . $whereclause . " AND survey_done IS TRUE";

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $surveycount = $tmp[0];

	# Fourth query, total count 
	$dst = "SELECT COUNT(*) FROM st_faults " . $whereclause; 

	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	@tmp = $sth->fetchrow_array;
	my $etotal = $tmp[0];

	my (@piedata1, @piedata2, @piedata3);
	$piedata1[0][0] = "W/o TAC case";
	$piedata1[1][0] = $etotal - $tac_count;
	$piedata1[0][1] = "With TAC case";
	$piedata1[1][1] = $tac_count;
	$piedata2[0][0] = "W/o RMA";
	$piedata2[1][0] = $etotal - $rma_count;
	$piedata2[0][1] = "With RMA";
	$piedata2[1][1] = $rma_count;
	$piedata3[0][0] = "W/o survey";
	$piedata3[1][0] = $etotal - $surveycount;
	$piedata3[0][1] = "With Survey answered";
	$piedata3[1][1] = $surveycount;

	# Print results
	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B></B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 
	# TAC Case
	my $pc = ($etotal - $tac_count)*100 / $etotal;
	print "<TR><TD BGCOLOR=$cellcolor>W/o TAC case</TD><TD BGCOLOR=$cellcolor>" . sprintf("%.0f", $etotal-$tac_count) . "</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $pc) . "</TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor>With TAC case</TD><TD BGCOLOR=$cellcolor>$tac_count</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $tac_count * 100 / $etotal) . "</TD></TR>";
	# Create and print pie chart.
	# Define filename
	my $timehex = $zuser . sprintf("%lx", time) . 'TAC';
	my $graph = GD::Graph::pie->new(200, 150);	
	$graph->set( 
      			title             => 'TAC case',
  			) or die $graph->error;
	$graph->set_label_font($graphfont, 9);
	$graph->set_value_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);
	my $gd = $graph->plot(\@piedata1)->png or die $graph->error;
	open(IMG, ">/tmp/$timehex") or die $!;
	print IMG $gd;
	close IMG;
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></CENTER></TD></TR>";
	# RMA	
	print "<TR><TD BGCOLOR=$cellcolor>W/o RMA</TD><TD BGCOLOR=$cellcolor>" . sprintf("%.0f", $etotal-$rma_count) . "</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", ($etotal - $rma_count) * 100 / $etotal) . "</TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor>With RMA</TD><TD BGCOLOR=$cellcolor>$rma_count</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $rma_count * 100 / $etotal) . "</TD></TR>";
	# Create and print pie chart.
	# Define filename
	my $timehex = $zuser . sprintf("%lx", time) . 'RMA';
	my $graph = GD::Graph::pie->new(200, 150);	
	$graph->set( 
      			title             => 'RMA',
  			) or die $graph->error;
	$graph->set_label_font($graphfont, 9);
	$graph->set_value_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);
	my $gd = $graph->plot(\@piedata2)->png or die $graph->error;
	open(IMG, ">/tmp/$timehex") or die $!;
	print IMG $gd;
	close IMG;
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></CENTER></TD></TR>";

	# Survey	
	print "<TR><TD BGCOLOR=$cellcolor>W/o survey</TD><TD BGCOLOR=$cellcolor>" . sprintf("%.0f", $etotal-$surveycount) . "</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", ($etotal - $surveycount) * 100 / $etotal) . "</TD></TR>";
	print "<TR><TD BGCOLOR=$cellcolor>With Survey answered</TD><TD BGCOLOR=$cellcolor>$surveycount</TD><TD BGCOLOR=$cellcolor>" . sprintf("%3.2f\%", $surveycount * 100 / $etotal) . "</TD></TR>";
	# Create and print pie chart.
	# Define filename
	my $timehex = $zuser . sprintf("%lx", time) . 'SURV';
	my $graph = GD::Graph::pie->new(200, 150);	
	$graph->set( 
      			title             => 'Survey answered',
  			) or die $graph->error;
	$graph->set_label_font($graphfont, 9);
	$graph->set_value_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);
	my $gd = $graph->plot(\@piedata3)->png or die $graph->error;
	open(IMG, ">/tmp/$timehex") or die $!;
	print IMG $gd;
	close IMG;
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></CENTER></TD></TR>";

	&table_footer($start_date, $end_date, $etotal);

	print "</TABLE>";
	 
} elsif ($action == 6) {
	# Per Owner
	# Read dates and selected types
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');

	my $i;
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';
	$dst = "SELECT u.fullname, count(*) FROM st_users u INNER JOIN st_faults f ON u.id = f.logged_by_user_id WHERE f.faulttype_id IN $sqlin";
	$dst2 = "SELECT count(*) FROM st_faults WHERE faulttype_id IN $sqlin ";
	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND f.start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND f.start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	$dst = $dst . "GROUP BY u.fullname ORDER BY 2 DESC";
	$sth = $dbh->prepare($dst);
	$sth2 = $dbh->prepare($dst2);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	$sth2->execute;
	if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @tmp = $sth2->fetchrow_array;
	my $totalfaultnumber = $tmp[0];
	$sth2->finish;

	my (@piedata, $i);
	$i = 0;

	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>Fullname</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>SR Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 

	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor>";
			print $lrow[0];
			print "</TD><TD BGCOLOR=$cellcolor>$lrow[1]</TD>";
			my $pc = $lrow[1] * 100 / $totalfaultnumber;
			print "<TD BGCOLOR=$cellcolor ALIGN=RIGHT>" . sprintf("%3.2f\%", $pc) . "</TD></TR>";
			$piedata[0][$i] = to_utf8({
							-string => $lrow[0],
							-charset => $sencoding });
			$piedata[1][$i] = $lrow[1];
			$i++;
	};
	&table_footer($start_date, $end_date, $totalfaultnumber);
	print "</TABLE>";
	 
	# Create and print pie chart.

	# Define filename
	my $timehex = $zuser . sprintf("%lx", time);

	my $graph = GD::Graph::bars->new(800, 600);	
	$graph->set( 
      			title             => 'Opened SRs per user',
			x_labels_vertical => 1,
  			) or die $graph->error;

	$graph->set_x_axis_font($graphfont, 9);
	$graph->set_y_axis_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);
	my $gd = $graph->plot(\@piedata)->png or die $graph->error;

	open(IMG, ">/tmp/$timehex") or die $!;

	print IMG $gd;

	close IMG;

	print "<P><P><TABLE><TR><TD BGCOLOR=$cellcolor><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></TD></TR></TABLE>";

} elsif ($action == 7) {
	# Per Company
	# Read dates and selected types
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');

	my $i;
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';
	$dst = "SELECT c.name, count(*) FROM st_faults_companies_v c INNER JOIN st_faults f ON c.id = f.id WHERE f.faulttype_id IN $sqlin";
	$dst2 = "SELECT count(*) FROM st_faults WHERE faulttype_id IN $sqlin ";
	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND f.start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND f.start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
		$dst2 = $dst2 . " AND start_time <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	$dst = $dst . "GROUP BY c.name ORDER BY 2 DESC";
	$sth = $dbh->prepare($dst);
	$sth2 = $dbh->prepare($dst2);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	$sth2->execute;
	if (st_lib::sthErr($sth2->err, $sth2->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my @tmp = $sth2->fetchrow_array;
	my $totalfaultnumber = $tmp[0];
	$sth2->finish;

	my (@piedata, $i);
	$i = 0;

	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>Company</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>SR Count</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Percentage</B></CENTER></TD></TR>"; 

	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor>";
			print $lrow[0];
			print "</TD><TD BGCOLOR=$cellcolor>$lrow[1]</TD>";
			my $pc = $lrow[1] * 100 / $totalfaultnumber;
			print "<TD BGCOLOR=$cellcolor ALIGN=RIGHT>" . sprintf("%3.2f\%", $pc) . "</TD></TR>";
			$piedata[0][$i] = to_utf8({
							-string => $lrow[0],
							-charset => $sencoding });
			$piedata[1][$i] = $lrow[1];
			$i++;
	};
	&table_footer($start_date, $end_date, $totalfaultnumber);
	print "</TABLE>";
	 
	# Create and print pie chart.

	# Define filename
	my $timehex = $zuser . sprintf("%lx", time);

	my $graph = GD::Graph::bars->new(800, 600);	
	$graph->set( 
      			title             => 'Opened SRs per company',
			x_labels_vertical => 1,
  			) or die $graph->error;

	$graph->set_x_axis_font($graphfont, 9);
	$graph->set_y_axis_font($graphfont, 9);
	$graph->set_title_font($graphfont, 14);
	my $gd = $graph->plot(\@piedata)->png or die $graph->error;

	open(IMG, ">/tmp/$timehex") or die $!;

	print IMG $gd;

	close IMG;

	print "<P><P><TABLE><TR><TD BGCOLOR=$cellcolor><IMG SRC=$cgipath/st_sendfile.pl?1+$timehex></TD></TR></TABLE>";

} elsif ($action == 10) {
	# SLA statistics screen 
	# Read dates and selected types
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');


	my $i;
	# Build SQL IN string with types from the typeslist.
	my $sqlin = '(';
	for $i (0 .. $#typeslist) {
		if ($i == 0) {
			$sqlin = $sqlin . $typeslist[$i];
		} else {
			$sqlin = $sqlin . ',' . $typeslist[$i];
		};
	};
	$sqlin = $sqlin . ')';
	$dst = "SELECT id, faulttype_id, company_name, location_name, shortdescr, report_timestamp, responce_time, recovery_time, sla_responce, sla_resolution, recovery_nok, responce_nok
			FROM f2sla WHERE faulttype_id IN $sqlin";
	# Add dates in WHERE clause.
	if ($start_date ne '') {
		$dst = $dst . " AND report_timestamp >= CAST(\'$start_date\' AS TIMESTAMP)";
	};
	if ($end_date ne '') {
		$dst = $dst . " AND report_timestamp <= CAST(\'$end_date\' AS TIMESTAMP)";
	};

	$dst = $dst . " ORDER BY 5 DESC";
	$sth = $dbh->prepare($dst);
	
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	my (@piedata, $i);
	$i = 0;

	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><CENTER><B>SR id</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Company</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Location</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Description</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Reported</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Responce time</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>Resolution time</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>SLA responce time</B></CENTER></TD>"; 
	print "<TD BGCOLOR=$headcellcolor><CENTER><B>SLA resolution time</B></CENTER></TD></TR>"; 

	my @lrow;
	my $sla_ok = 0;
	my $sla_nok = 0;
	my $totalfaultnumber = 0;
	while (@lrow = $sth->fetchrow_array) {
			if ($lrow[6] eq '') { $lrow[6] = 'N/A'; };
			if ($lrow[7] eq '') { $lrow[7] = 'N/A'; };
			print "<TR><TD BGCOLOR=$cellcolor>" . $lrow[0] . "</TD>";
			print "<TD BGCOLOR=$cellcolor>$lrow[2]</TD>";
			print "<TD BGCOLOR=$cellcolor>$lrow[3]</TD>";
			print "<TD BGCOLOR=$cellcolor>$lrow[4]</TD>";
			print "<TD BGCOLOR=$cellcolor>$lrow[5]</TD>";
			my $color = 'GREEN';
			if ($lrow[11]) { $color = 'RED' };
			print "<TD BGCOLOR=$color>$lrow[6]</TD>";
			$color = 'GREEN';
			if ($lrow[10]) { $color = 'RED' };
			print "<TD BGCOLOR=$color>$lrow[7]</TD>";
			print "<TD BGCOLOR=$cellcolor>$lrow[8]</TD>";
			print "<TD BGCOLOR=$cellcolor>$lrow[9]</TD>";
			print "</TR>";
			if (($lrow[10] eq 't') or ($lrow[11] eq 't')) { 
				$sla_nok++;
			} else {
				$sla_ok++;
			};
			$totalfaultnumber++;
	};
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=9><CENTER>";
	print $query->start_form(-method=>'POST',
       		                         -action=>"$cgipath/st_stats.pl?11",
					 -name=>'form',
       		                         -enctype=>$sencoding);
	# Print the above as hidden for use by 11.
	print $query->hidden(-name=>'start_date',
                                    -default=>$start_date);
	print $query->hidden(-name=>'end_date',
                                    -default=>$end_date);
	print $query->hidden(-name=>'typeslist',
                                    -default=>\@typeslist);
	print $query->submit(-name=>'CSV file');

	print $query->endform;

	print "</TABLE>";
	print "<TABLE>";
	&table_footer($start_date, $end_date, $totalfaultnumber);
	print "</TABLE>";
	 
} elsif ($action == 11) {
	print  $query->header(-charset=>$sencoding,
				-type=>'application/octet-stream',
				-attachment=>'statistics.csv');
	my $start_date = $query->param('start_date');
	my $end_date = $query->param('end_date');
	my @typeslist = $query->param('typeslist');
	my @csvarr = ();
	st_lib::slasummarytxt($dbh, $start_date, $end_date, \@typeslist, \@csvarr);
	for (@csvarr) {
		print $_ . "\n";
	};
} else {
	# No way to get here!
	print "<P><H1>IMPOSSIBLE!</H1><P>";
	print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Finish, clean up etc....
if ($action != 11) {
	print "</CENTER>";
	st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
	print $query->end_html;
};
$sth->finish;
$dbh->disconnect;
exit;

sub table_footer {
	# Print a footer with time period and total.
	my ($start_date, $end_date, $totalfaultnumber, $scrap) = @_;
	
	print "<TR><TD BGCOLOR=$headcellcolor><CENTER>";
	if (($start_date eq '') and ($end_date eq '')) {
		print "<B>No date limits</B>";
	} elsif (($start_date eq '') and ($end_date ne '')) {
		print "<B>SRs opened before $end_date</B>";
	} elsif (($start_date ne '') and ($end_date eq '')) {
		print "<B>SRs opened after $start_date</B>";
	} elsif (($start_date ne '') and ($end_date ne '')) {
		print "<B>SRs opened from $start_date to $end_date</B>";
	} else {
		print "Impossible.";
	};
	print "</TD><TD BGCOLOR=$headcellcolor ALIGN=RIGHT><B>Accounted SRs:</B></TD><TD BGCOLOR=$headcellcolor ALIGN=LEFT><B>$totalfaultnumber</B></TD></TR>";
	return;
}; # End table_footer
