#!/usr/bin/perl
#########################################################################
# Reads data about a file from database, checks permissions, locates 	#
# file in disk and sends it to the user.				#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.0.0	Starting... (02 Jun 2004)				#
# V0.0.1	First working version (03 Jun 2004)			#
# V0.0.2	Added routine for images				#
# V0.0.3	Replaced hardcoded encodings with parameter.		#
# V0.0.4	Replaced hardcoded language with parameter.		#
#									#
# Arguments description (* = internal, not menu):			#
# 	action: 							#
#		0: Send file.						#
#	file_id: The file id in st_files table.				#
#########################################################################

use strict;
use DBI;
use CGI;
use st_lib;

my $data_source = $st_lib::data_source;		# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables

my $debug = $st_lib::debug;

my $myhost = $st_lib::myhost;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;	# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;	# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path 
my $filedbpath = 	$st_lib::filedbpath;	# File DB path.
my $sencoding =		$st_lib::sencoding;	# Encoding for HTML etc
my $slang =		$st_lib::slang;		# Language for HTML etc

my %formtitles = ( 	
		# Form title depending on action. Also used to check
		# parameter validity.
		0 => 'File download',
		1 => 'Image display',
		);

my $version = "st_files.pl V0.0.4";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $action = $chooserlist[0];

if (not (exists $formtitles{$action})) {
	# Default is 0
	$action = 0;
};

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Initialize CGI and send headers.
#################################################################
# Special case, headers are not initialized here, because	#
# they depend on action result.					#
#################################################################

# Everything from here is action depended.

if ($action == 0) {
	# Send file. 
	my $error = 0;
	my ($errortext, $filename, $realfilename, $size, $delete_time, $fault_id);
	my $fbupr = -1;
	# First, find out file data.
	my $file_id = $chooserlist[1];

	$dst = "SELECT filename, realfilename, size, delete_time, fault_id 
		FROM st_files
		WHERE id = $file_id"; 
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (defined($sth->err)) { 
		$errortext = $sth->errstr;
		$error = 1;
	} elsif ($sth->rows == 0) {
		$errortext = 'File record non-existent.';
		$error = 1;
	};
	if (not($error)) {
		# Check permissions.
		@row_ary = $sth->fetchrow_array;
		$fault_id = $row_ary[4];
		$fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
		if ($fbupr < 1) {
			$errortext = 'Service Request number non-existent.';
			$error = 1;
		};
	};
	if (not($error)) {
		# Check real file existance.
		$realfilename = $row_ary[1];
		my $rfn = "$filedbpath/$realfilename";
		if (not(-e $rfn)) {
			$errortext = 'ERROR: Real file does not exist. Corrupted file DB ?';
			$error = 1;
		};
	};
	if (not($error)) {
		# Try to open file.
		if (open MYFILE, "$filedbpath/$realfilename") {
			# Send file to user.
			$filename = $row_ary[0];
			$size = $row_ary[2];
			print $query->header(		-type=>'application/octet-stream',
							-attachment=>$filename,
							-Content_length=>$size);
			my $line;
			while ($line = <MYFILE>) {
				print $line;
			};
#			print $query->end_html;
			$sth->finish;
			$dbh->disconnect;
			exit;
		} else {
			$errortext = 'ERROR: Real file could not be opened. Corrupted file DB ?';
			$error = 1;
		};
	};
	# If we get here, there must be an error.
	print  $query->header(-charset=>$sencoding);
	print  $query->start_html(-title=>$formtitles{$action},
				  -text=>$textcolor,
				  -lang=>$slang,
				  -BGCOLOR=>$bgcolor);
	st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);
	print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";
	print "<H2><FONT COLOR=RED>$errortext</FONT></H2>";
	st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
	print $query->end_html;

} elsif ($action == 1) {

	my ($errortext, $filename, $error, $size, $delete_time, $fault_id);
	$filename = $chooserlist[1];
	if (open MYFILE, "/tmp/$filename") {
		print $query->header(	-type=>'image/gif');
		my $line;
		while ($line = <MYFILE>) {
			print $line;
		};
		close MYFILE;
		# Remove it...
		my @args = ("rm", "/tmp/$filename");
		system(@args) == 0 or die "system @args failed: $?";
		exit;
	} else {
		$errortext = 'ERROR: Real image file could not be opened.';
		$error = 1;
	};
	# If we get here, there must be an error.
	print  $query->header(-charset=>$sencoding);
	print  $query->start_html(-title=>$formtitles{$action},
				  -text=>$textcolor,
				  -lang=>$slang,
				  -BGCOLOR=>$bgcolor);
#	st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);
	print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";
	print "<H2><FONT COLOR=RED>$errortext</FONT></H2>";
#	st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
	print $query->end_html;


} else {
	# No way to get here!
	print "<P><H1>IMPOSSIBLE!</H1><P>";
	print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Finish, clean up etc....
$dbh->disconnect;
exit;

