#!/usr/bin/perl
#########################################################################
# A simple menu system.							#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.1.0	Clone from zs_menus V0.1.0.				#
# V0.1.1	Compatibility for new login system			#
# V0.1.2	Logout added.						#
# V0.1.3	Translated to english.					#
# V0.1.4	Terminology review and corrections.			#
# V0.1.5	Added MOTD.						#
# V0.1.6	Replaced hardcoded encodings with parameter.		#
# V0.1.7	Replaced hardcoded language with parameter.		#
#									#
# Arguments description 						#
#	action: 							#
#		0: Initial menu						#
#		1: Open menu who's id is the next argument.		#
#		2: Close menu who's id is the next argument.		#
#		3: Validate User.					#
#		4: Add item to favorites (id is next arg).		#
#		5: Remove item from favorites (id is next arg).		#
#		6: Logout.						#
#########################################################################


use strict;
use DBI;
use CGI;
use st_lib;

my $data_source = $st_lib::data_source;		# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.

my $dst;					# used for dynamic statements.
my $ndst;					# used for dynamic statements.
my $colname;					# A column name.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables

my $debug = $st_lib::debug;

my $myhost = $st_lib::myhost;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path 
my $secretdir =		$st_lib::secretdir;	# Session files path 
my $motd =		$st_lib::motd;		# Message of the day. 
my $sencoding =		$st_lib::sencoding;	# Encoding for HTML etc
my $slang =		$st_lib::slang;		# Language for HTML etc


my $version = "st_menus.pl V0.1.7";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $action = $chooserlist[0];
my $menuid = $chooserlist[1];
my $open_menus = $chooserlist[2];

if (not(defined $action)) { 
	$action = 0; # Default
};

st_lib::wDbg("Action is $action", "st_menus");
if ($action == 3) {
	# Validate user and exit.
	my $user = $query->param('user');
	my $pass = $query->param('pass');
	my $urltogo = $query->param('urltogo');
	st_lib::ValidateUser($user, $pass, $urltogo, $query);
	exit 0;
};

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);

if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Get user's postgres id.
my $dst = "SELECT usesysid, usesuper FROM pg_user WHERE usename = \'$zuser\'";
my $sth = $dbh->prepare($dst);
$sth->execute;
if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Failed 
	print $query->end_html;
	$dbh->disconnect;
	exit;
};
my @row_ary = $sth->fetchrow_array;
my $usesysid = $row_ary[0];
my $issuperuser = $row_ary[1];
# Now get user's group list 
$dst = "SELECT grosysid, grolist FROM pg_group";
$sth = $dbh->prepare($dst);
$sth->execute;
if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Failed 
	print $query->end_html;
	$dbh->disconnect;
	exit;
};
my @usergroups;
while (@row_ary = $sth->fetchrow_array) {
	my @list = st_lib::pgarr2arr($row_ary[1]);
	if (st_lib::found(\@list, $usesysid)) {
		push @usergroups, $row_ary[0];
	};
};


if (not(defined $open_menus)) {
	# Try the cookie
	$open_menus = $query->cookie(-name=>'st_menustatus');
	if (not(defined $open_menus)) {
		# Initial state
		$open_menus = '';
	};
};
my @om = split /x/, $open_menus;

if ($action == 1) {
	# Open menu
	push @om, $menuid;
} elsif ($action == 2) {
	# close menu
	@om = removele(\@om, $menuid);
} elsif ($action == 4) {
	# Add menuid to favorites.
	my $dst = "INSERT INTO zs_menus_favorites(zs_menus_id, username) VALUES (\'$menuid\', \'$zuser\')"; 
	my $sth = $dbh->prepare($dst);
	$sth->execute();
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	$dbh->commit;
} elsif ($action == 5) {
	# Remove menuid from favorites.
	my $dst = "DELETE FROM zs_menus_favorites WHERE zs_menus_id = \'$menuid\' AND username = \'$zuser\'"; 
	my $sth = $dbh->prepare($dst);
	$sth->execute();
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Failed 
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	$dbh->commit;
} elsif ($action == 6) {
	my $filepath = "$secretdir$zuser";
	st_lib::wDbg("File is $filepath", "st_menus");
	my $cnt = unlink "$filepath";
	st_lib::wDbg("cnt is $cnt", "st_menus");
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Rebuild open_menus string.
$open_menus = '';
foreach $tmp (@om) {
	if ($open_menus ne '') {
		# Character 'x' is used to pass all ids (numbers) as a single 
		# argument through the url.
		$open_menus = $open_menus . 'x';
	};
	$open_menus = $open_menus . $tmp; 
};

# Keep open_menus on a cookie too.
my $statuscookie = $query->cookie(-name=>'st_menustatus',
				-value=>$open_menus,
				-domain=>$myhost);

print  $query->header(	-cookie=>[$statuscookie],
			-charset=>$sencoding);
print  $query->start_html(-title=>'Main menu',
			  -text=>$textcolor,
			  -lang=>$slang,
			  -BGCOLOR=>$bgcolor);

st_lib::zsHeaderFooter(0, $zfullname, $version, 1, \@zdata);

print "<CENTER><H2><FONT COLOR=$linkcolor>Main menu</FONT></H2><P>";

# First get top level records
$dst = "SELECT id, description, url, vfg FROM zs_menus WHERE parent = 0 ORDER BY orderby";
$sth = $dbh->prepare($dst);
$sth->execute();
if (st_lib::sthErr($sth->err, $sth->errstr)) { 
	# Failed to select.
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

print "<TABLE><TR>";
my $cnt = 0; # For changing rows.
# Main loop
while (@row_ary = $sth->fetchrow_array) {
	# This will run only if the user has one of the groups in vfg.
	# ... or if the user is postgres.
	if (($issuperuser) or (st_lib::vgok(\@usergroups, $row_ary[3]))) {
		print "<TD BGCOLOR=$headcellcolor style=\"vertical-align: top; text-align: left;\"><FONT COLOR=$headtextcolor>";
		# Trim white space
		$row_ary[2] =~ s/^\s*(.*?)\s*$/$1/;
		if ($row_ary[2] eq '') {
			# Folder, no url.
			if (st_lib::found(\@om, $row_ary[0])) {
				# It's open, give closing url.
				print "<I><A NAME=\"" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?2+" . $row_ary[0] . "+$open_menus#" . $row_ary[0] . "\">- " . $row_ary[1] . "</A></I>";
				# Now open it.
				open_menu($row_ary[0], 0, \@om, $open_menus);
			} else {
				# It's closed, give open URL
				print "<B><A NAME=\"" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?1+" . $row_ary[0] . "+$open_menus#" . $row_ary[0] . "\">+ " . $row_ary[1] . "</A></B>";
			};
		} else {
			# URL in top level.
			my $dst = "SELECT count(*) from zs_menus_favorites WHERE zs_menus_id = \'" . $row_ary[0] . "\' AND username = \'$zuser\'";
			my $sth = $dbh->prepare($dst);
			$sth->execute();
			if (st_lib::sthErr($sth->err, $sth->errstr)) { 
				# Failed to select.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			my @l_row_ary = $sth->fetchrow_array;	
			my $f_str = '- ';
			if ($l_row_ary[0] == 0) {
				# Add "Add to favorites" link.
				$f_str = "<A NAME=\"AF" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?4+" . $row_ary[0] . "#AF" . $row_ary[0] . "\">*</A> ";
			};
			print "$f_str<A HREF=\"" . $row_ary[2] . "\">" . $row_ary[1] . "</A>";
		};
		print "</TD>";
		$cnt++;
		if ($cnt > 1) {
			# Change row
			$cnt = 0;
			print "</TR><TR>";
		};
	};
}; # End main loop.

# Extra menu items - Favorites

print "<TD BGCOLOR=$headcellcolor style=\"vertical-align: top; text-align: left;\"><FONT COLOR=$headtextcolor>";
if (st_lib::found(\@om, 0)) {
	# It's open, give closing url.
	print "<I><A NAME=\"0\"></A><A HREF=\"$cgipath/st_menus.pl?2+0+$open_menus#0\">- Favorites</A></I>";
	# Now open it.
	open_menu(0, 0, \@om, $open_menus);
} else {
	# It's closed, give open URL
	print "<B><A NAME=\"0\"></A><A HREF=\"$cgipath/st_menus.pl?1+0+$open_menus#0\">+ Favorites</A></B>";
};
print "</TD>";
$cnt++;
if ($cnt == 1) {
	# Print an empty cell. 
	print "<TD BGCOLOR=$headcellcolor></TD>";
};


print "</TR>";

print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>$motd</CENTER></TD></TR>";
print "</TABLE>";
$sth->finish;
print "</CENTER>";
st_lib::zsHeaderFooter(1, $zfullname, $version, 1, \@zdata);

print $query->end_html;
$dbh->disconnect;
exit;

#########################################################################
# Remove a number from an array.					#
#########################################################################
sub removele {
	my ($aref, $token) = @_;
	my @toret;
	my $tmp;
	foreach $tmp ( @$aref ) {
		if ($tmp != $token) {
			push @toret, $tmp;	
		};
	};
	return @toret;
}; # sub removele ends here.

#########################################################################
# If a folder menu is marked as open, find and print child items. This  #
# is called recursively, if more open folders are found.		#
#									#
# Parameters: 								#
#	$menu_id: 	The id of the folder to open.			#
#	$level:		The first call has always level 0. While on 	#
#			recursion, the level grows by one on each call.	#
#	$omref: 	A reference to @om from main program. These are	#
#			the ids of the open menus.			#
#	$open_menus: 	The same ids as above, but for use in URLs. We	#
# 			could rebuild it from $omref, but as it is 	#
#			already created, there is no need.		#
#########################################################################
sub open_menu {
	my ($menu_id, $level, $omref, $open_menus) = @_;
	my ($i, @row_ary, $dst);

	# Find the menu items we look for.
	if ($menu_id == 0) {
		# Special case, favorites menu
		$dst = "SELECT id, description, url, vfg FROM zs_menus WHERE id IN (SELECT zs_menus_id FROM zs_menus_favorites WHERE username = \'$zuser\') ORDER BY orderby";
	} else {
		$dst = "SELECT id, description, url, vfg FROM zs_menus WHERE parent = \'$menu_id\' ORDER BY orderby";
	};
	my $om_sth = $dbh->prepare($dst);
	$om_sth->execute();

	if (st_lib::sthErr($om_sth->err, $om_sth->errstr)) { 
		# Failed to select.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	print "<br>";
	print "<TABLE>";
	# Main loop.
	while (@row_ary = $om_sth->fetchrow_array) {
		# This will run only if the user has one of the groups in vfg.
		# ... or if the user is postgres.
		if (($issuperuser) or (st_lib::vgok(\@usergroups, $row_ary[3]))) {
			st_lib::wDbg("Working on: " . $row_ary[0] . "|" . $row_ary[1] . "|" . $row_ary[2], "open_menu");
		
			print "<TR><TD BGCOLOR=$cellcolor><FONT COLOR=$headtextcolor>";
			for ($i=0;$i<=$level;$i++) {
				# To give a tabbed look.
				print "&nbsp;&nbsp;";
			};
			# Trim white space, just in case.
			$row_ary[2] =~ s/^\s*(.*?)\s*$/$1/;
			if ($row_ary[2] eq '') {
				# Folder, no url.
				if (st_lib::found($omref, $row_ary[0])) {
					# It's open, give closing url.
					print "<I><A NAME=\"" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?2+" . $row_ary[0] . "+$open_menus#" . $row_ary[0] . "\">- " . $row_ary[1] . "</A></I>";
					# Now open it.
					open_menu($row_ary[0], $level + 1, $omref, $open_menus);
				} else {
					# It's closed, give open URL
					print "<B><A NAME=\"" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?1+" . $row_ary[0] . "+$open_menus#" . $row_ary[0] . "\">+ " . $row_ary[1] . "</A></B>";
				};
			} else {
				# URL
				my $dst = "SELECT count(*) from zs_menus_favorites WHERE zs_menus_id = \'" . $row_ary[0] . "\' AND username = \'$zuser\'";
				my $sth = $dbh->prepare($dst);
				$sth->execute();
				if (st_lib::sthErr($sth->err, $sth->errstr)) { 
					# Failed to select.
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
				my @l_row_ary = $sth->fetchrow_array;	
				my $f_str = '- ';
				if ($l_row_ary[0] == 0) {
					# Add "Add to favorites" link.
					$f_str = "<A NAME=\"AF" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?4+" . $row_ary[0] . "#AF" . $row_ary[0] . "\">*</A> ";
				};
				if (($l_row_ary[0] > 0) && ($menu_id == 0)) {
					# We are currently printing favorites menu, add remove from favorites link.
					$f_str = "<A NAME=\"AF" . $row_ary[0] . "\"></A><A HREF=\"$cgipath/st_menus.pl?5+" . $row_ary[0] . "#AF" . $row_ary[0] . "\">*</A> ";
				};
				print "$f_str<A HREF=\"" . $row_ary[2] . "\">" . $row_ary[1] . "</A>";
			};
			print "</TD></TR>"
		};
	}; # End main loop.
	print "</TR></TABLE>";
	$om_sth->finish;
}; # sub open_menu ends here.

