#!/usr/bin/perl
#########################################################################
# Display relations between users and fault types.			#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.0.0	Starting... (27 August 2004)				#
# V0.0.1	First working version					#
# V0.0.2	Added mail alerts display.				#
# V0.0.3	Replaced hardcoded encodings with parameter.		#
# V0.0.4	Replaced hardcoded language with parameter.		#
#									#
# Arguments description (* = internal, not menu):			#
# 	action: 							#
#		0: 	Main display.					#
#########################################################################

use strict;
use DBI;
use CGI;
use st_lib;

my $data_source = $st_lib::data_source;		# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables

my $debug = $st_lib::debug;

my $myhost = $st_lib::myhost;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;	# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path 
my $sencoding =		$st_lib::sencoding;	# Encoding for HTML etc
my $slang =		$st_lib::slang;		# Language for HTML etc


my %formtitles = ( 	
		# Form title depending on action. Also used to check
		# parameter validity.
		0 => 'SR types matrix',
		);

my $version = "st_ftusermatrix.pl V0.0.4";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $action = $chooserlist[0];

if (not (exists $formtitles{$action})) {
	# Default is 0
	$action = 0;
};

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

#########################################
# zdata format: 			#
#  0 ->	id (st_users.id)		#
#  1 -> active (bool)			#
#  2 -> client (bool)			#
#  3 -> technician (bool)		#
#  4 -> admin (bool)			#
#  5 -> main contact (bool)		#
#  6 -> st_userlevels.id		#
#  7 -> st_companieslocations.id	#
#  8 -> st_companies.id			#
#  9 -> Logged since (epoch)		#
# 10 -> st_companies.name		#
# 11 -> st_userlevels.name		#
#########################################

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Initialize CGI and send headers.
print  $query->header(-charset=>$sencoding);
print  $query->start_html(-title=>$formtitles{$action},
			  -text=>$textcolor,
			  -lang=>$slang,
			  -BGCOLOR=>$bgcolor);

st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);

print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";

# Everything from here is action depended.

if ($action == 0) {
	if (not(($zdata[3] == 1) and ($zdata[5] == 1))) {
		# Only mc techs.
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Database error. Please contact system administrator.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault types matrix without permission.", "st_ftusermatrix");
		exit;
	};
	my %naioxi = (
			0 => 'No',
			1 => 'Yes'
			);

	# Ok, start printing.
	print "<TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>SR type</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>SCSEs</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>Duty Managers</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>Technical Managers</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>Account Managers</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>General Managers</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>Hourly SCSE mail?</CENTER></B>";
	print "<TD BGCOLOR=$headcellcolor><B><CENTER>Mail Alerts ?</CENTER></B>";
	print "</TR>";
	$dst = "SELECT id, name, annoyscse, alertmails FROM st_faulttypes";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@row_ary = $sth->fetchrow_array) {
		my $scse_txt = '';
		my $dm_txt = '';
		my $tm_txt = '';
		my $sm_txt = ''; 
		my $gm_txt = '';
		my $ldst = "SELECT tt.user_id, tt.scse, tt.duty_m, tt.techn_m, tt.acc_m, tt.general_m,
				u.fullname, u.email 
			    FROM st_techsmc_faulttypes tt INNER JOIN st_users u ON tt.user_id = u.id
			    WHERE tt.faulttype_id = $row_ary[0]
			    AND   u.active = \'t\'";
		my $lsth = $dbh->prepare($ldst);
		$lsth->execute;
		if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		my @l_ary;
		while (@l_ary = $lsth->fetchrow_array) {
			if ($l_ary[1] == 1) { $scse_txt = $scse_txt . "$l_ary[6] ($l_ary[7])<br>"}; 
			if ($l_ary[2] == 1) { $dm_txt = $dm_txt . "$l_ary[6] ($l_ary[7])<br>"}; 
			if ($l_ary[3] == 1) { $tm_txt = $tm_txt . "$l_ary[6] ($l_ary[7])<br>"}; 
			if ($l_ary[4] == 1) { $sm_txt = $sm_txt . "$l_ary[6] ($l_ary[7])<br>"}; 
			if ($l_ary[5] == 1) { $gm_txt = $gm_txt . "$l_ary[6] ($l_ary[7])<br>"}; 
		};
		print "<TR>";
		print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[1]</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>$scse_txt</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>$dm_txt</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>$tm_txt</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>$sm_txt</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>$gm_txt</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>" . $naioxi{ $row_ary[2] } . "</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>" . $naioxi{ $row_ary[3] } . "</CENTER></TD>";
		print "</TR>";
	};
	print "</TABLE>";
} else {
	# No way to get here!
	print "<P><H1>IMPOSSIBLE!</H1><P>";
	print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Finish, clean up etc....
print "</CENTER>";
st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
print $query->end_html;
$dbh->disconnect;
exit;

