#!/usr/bin/perl
#########################################################################
# Main faults code (insert/update/delete).				#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.0.0	Starting... (12 Mar 2004)				#
# V0.1.0	Insert working.						#
# V0.2.0	Search working (user mode).				#
# V0.2.1	Search working for all levels of users.			#
#		Added default status on insert.				#
#		Basic main screen functionality (just display)		#
# V0.2.2	Tech assignment ready.					#
# V0.2.3	Level change ready. Status change ready.		#
#		Close ticket ready. Added buttons line.			#
#		Comment insert ready.					#
# V0.2.4	Related users are displayed. Buttons line now splits 	#
#		every 4 buttons. Related users management completed.	#
#		Added ASC/DESC in search results sorting.		#
# V0.2.5	Corrected search bug. New search options (assigned and 	#
#		time period). Added basic statistics screen. *_mc's are	#
#		not affected by ro record in related users.		#
# V0.2.6	Techs can now create faults for other companies. Fault	#
#		id is displayed after insert. User can directly go to 	#
# 		a specific fault by entering fault id in search form.	#
#		Close and status change buttons appear only in tickets	#
# 		that have been assigned. Added fault level in search	#
#		results and in ordering options. Added fault id in 	#
#		search results and in main fault screen.		#
# V0.2.7	Clients cannot remove related users. Clients_mc can 	#
#		remove only own company users.				#
# V0.2.8	Added calls to mail_routine. Dates are printed using 	#
#		datetostr except statistics, where a quicj hack has 	#
# 		been used.						#
# V0.2.9	Mail routine calls reviewed. All messages translated to #
#		english.						#
# V0.3.0	Severity highlights in faults directory. RMA and TAC	#
#		fields added.						#
# V0.3.1	Implemented survey system.				#
# V0.3.2	Implemented security checks on surveys.			#
# V0.3.3	Implemented fault type selection per company.		#
# V0.3.4	New lines translated to <P> when displaying log entries.#
#		Search screen: Only valid fault types appear in drop 	#
#		down. Affinity filter in place.				#
# V0.3.5	Terminology review and corrections.			#
# V0.3.6	Fault cancellation implemented. Corrected bug in search #
#		results. Replaced closing date in search results with	#
#		fault status.						#
# V0.3.7	File management.					#
# V0.3.8	Extra permissions checks added.				#
# V0.3.9	Filename from Windows problem fixed. Extra check in 	#
#		files directory to detect missing files. Mail routine	#
#		call in file submit.					#
# V0.4.0	Yet another faults directory presentation change.	#
# V0.4.1	Added links in every user name and company location.	#
#		Added mostly to use the "TITLE" tag for phone numbers.	#
#		The links are empty, will be pointing to user details.	#
# V0.4.2	Added links to user details.				#
# V0.4.3	Added links to location details.			#
# V0.4.4	Replaced [NOT] IN with [NOT] EXISTS in main search 	#
#		queries for speed.					#
# V0.4.5	Small cosmetic change.					#
# V0.4.6	Fault logs screen.					#
# V0.4.7	New fault mails go only to users with scse = true.	#
# V0.4.8	Mail alerts log added to fault log screen.		#
# V0.4.9	Mail alerts log is now complete, not last one only.	#
# V0.5.0	Default severity in new SR is now NULL.			#
# V0.5.1	Cosmetic changes.					#
# V0.5.2	Only active users displayed in related add dropdown.	#
# V0.5.3	Techs in tech assignement dropdown have now number of 	#
#		open SR assigned to them displayed next to their name.	#
# V0.5.4	Last option of affinity filter extended to include 	#
#		faults related to user through faulttype. This option	#
#		is now selected by default.				#
# V0.5.5	Added better ordering in SR assignment, ordering and  	#
#		empty default selection in related users.		#
# V0.5.6	Added Service Reports Code - NOT LINKED YET.	  	#
# V0.5.7	Service reports code linked, service report search 	#
#		added, refresh button added.				#
# V0.5.8	Mail preferences by user added.				#
# V0.5.9	Multiple time records in Service Reports added.		#
# V0.6.0	Buttons for SR altering actions are now added only if 	#
#		the user has write permission on the SR.		#
# V0.6.1	If userlevel is 1, apply affinity filter anyway. 	#
#		Users with userlevel > 0 do not appear in CSEs list on 	#
#		SR assignment.						#
# V0.6.2	Missing description in error creation produces error. 	#
# V0.6.3	Files management partly available in closed faults. 	#
# V0.6.4	Added mail sent when a survey is answered.	 	#
# V0.6.5	Added filter for answered surveys in search.		#
# V0.6.6	Added XSS counter measures in log entries.		#
# V0.6.7	More XSS counter measures.				#
# V0.6.8	More XSS counter measures.				#
# V0.6.9	Fixed double entries in customers closed fault search	#
# V0.7.0	Added relations between faults.				#
# V0.7.1	Added parameter for CSE dropdown sort.			#
# V0.7.2	Relaxed some permissions.				#
# V0.7.3	Implemented new menu style in main fault screen.	#
# V0.7.4	Special coloring for closed SRs severities.		#
# V0.7.5	Default type in new SR is now NULL if available types 	#
#		are more than 1.					#
#		Removed TAC and RMA fields from fault create screen.	#
#		Cancel SR is only available in closed tickets.		#
# V0.7.6	Added closed timestamp display in closed faults  	#
#		directory.						#
# V0.7.7	Added special case in directory for elapsed groups.	#
# V0.7.8	Replaced hardcoded encodings with parameter.		#
# V0.7.9	Replaced hardcoded language with parameter.		#
# V0.8.0	Translated greek message.				#
# V0.8.1	Added printer friently fault screen.			#
# V0.8.2	Display and manage manual dates.			#
# V0.8.3	Display and manage SLA actions and fail comments.	#
# V0.8.4	A column in st_companies (user_order_by) is now used to	#
#		determine how the locations are sorted in user's new	#
#		fault column. Does not affects tech's screen.		#
# V0.8.5	Added a check in search results to avoid displaying 	#
#		confidential faults that the user has no permissions 	#
#		for.							#
# V0.8.6	Added lock SR (confidential) routines.			#
#									#
# Arguments description (* = internal, not menu):			#
# 	action: 							#
#	 0: 	New fault form						#
#	 1: 	Insert fault step 2					#
#	 2: 	Search form for faults					#
#	 3: 	Search results 						#
#	 4: 	Main fault screen					#
#	 5: 	Tech assignment						#
#	 6: 	Level change						#
#	 7: 	Status change						#
#	 8: 	Close ticket						#
#	 9: 	New comment						#
#	10: 	Related users management.				#
#	11: 	Statistics (client version).				#
#	12: 	TAC number form.					#
#	13: 	RMA number form.					#
#	14: 	Survey form for client to fill.				#
#	15: 	Display survey.						#
#	16: 	Cancel fault.						#
#	17: 	Files screen.						#
#	18: 	Delete file confirmation.				#
#	19: 	Fault logs screen.					#
#	20: 	Service Reports Screen.					#
#	21: 	Personal mail preferences management.			#
#	22: 	Relations between faults management.			#
#	23: 	Delete relation confirmation.				#
#	24: 	Main fault screen - printer friently, read only.	#
#	25: 	Manual dates form.					#
#	26: 	Mark SR as confidential.				#
#########################################################################

use strict;
use DBI;
use CGI;
use st_lib;
use st_jscript;
use st_mail;

my $data_source = $st_lib::data_source;		# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables
my $JAVASCRIPT;					# String for Javascript routines
my @nothing;					# Nothing!

my $debug = $st_lib::debug;

my $myhost = $st_lib::myhost;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;	# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;	# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path 
my $criticalid = 	$st_lib::criticalid;	# Critical fault severity db id.
my $highid = 		$st_lib::highid;	# High fault severity db id.
my $filedbpath = 	$st_lib::filedbpath;	# File DB path.
my $cse_sort = 		$st_lib::cse_sort;	# CSE dropdown sorting way.
my $sencoding = 	$st_lib::sencoding;	# Encoding for html etc.
my $slang =		$st_lib::slang;		# Language for HTML etc
my $lockedcolor =	$st_lib::lockedcolor;	# Color to mark confidential tickets. 


my %formtitles = ( 	
		# Form title depending on action. Also used to check
		# parameter validity.
		0 => 'Create new Service Request',
		1 => 'Create new Service Request',
		2 => 'Service Request directory',
		3 => 'Service Request directory',
		4 => 'Service Request main screen',
		5 => 'Assign to technician',
		6 => 'Change severity level',
		7 => 'Change Service Request status',
		8 => 'Close Service Request',
		9 => 'Insert new log entry',
		10 => 'Related users',
		11 => 'Statistics',
		12 => 'TAC number',
		13 => 'RMA number',
		14 => 'Survey form',
		15 => 'Survey form',
		16 => 'Cancel Service Request',
		17 => 'Service Request Files Screen',
		18 => 'Delete file',
		19 => 'Service Request Logs',
		20 => 'Service Reports Management',
		21 => 'Mail Preferences',
		22 => 'Related SRs management',
		23 => 'Delete relation',
		24 => 'Service Request main screen',
		25 => 'Edit manual dates',
		26 => 'Mark SR as confidential',
		);

my $version = "st_faults.pl V0.8.6";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $action = $chooserlist[0];

if (not (exists $formtitles{$action})) {
	# Default is 0
	$action = 0;
};

#########################################
# zdata format: 			#
#  0 ->	id (st_users.id)		#
#  1 -> active (bool)			#
#  2 -> client (bool)			#
#  3 -> technician (bool)		#
#  4 -> admin (bool)			#
#  5 -> main contact (bool)		#
#  6 -> st_userlevels.id		#
#  7 -> st_companieslocations.id	#
#  8 -> st_companies.id			#
#  9 -> Logged since (epoch)		#
# 10 -> st_companies.name		#
# 11 -> st_userlevels.name		#
#################################################################################
# Clarification on st_userlevels.id: 						#
# Techs with this set to >0, are people  that need to have access in all faults	#
# but not write access. So, they have read access in faults non-related to them #
# but normal access (in the usual way) if they are related.			#
# 2 has read access in all faults, 1 has access depending in relation with 	#
# fault type.									#
#################################################################################

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};


my $query = new CGI;
# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

if ($zdata[3] == 1) { 
	# Techs will need javascript.
	# Prepare the javascript
	my @sna = "company_id";
	my @tna = "companylocation_id";

	my $JAVASCRIPT = st_jscript::control_lists_with_javascript($dbh,\@sna, \@tna);

	# Initialize CGI and send headers.
	print  $query->header(-charset=>$sencoding);
	print  $query->start_html(-title=>$formtitles{$action},
			 	  -script=>$JAVASCRIPT,
				  -text=>$textcolor,
				  -lang=>$slang,
				  -BGCOLOR=>$bgcolor);
} else {
	# Other users will not have javascript.
	# Initialize CGI and send headers.
	print  $query->header(-charset=>$sencoding);
	print  $query->start_html(-title=>$formtitles{$action},
				  -text=>$textcolor,
				  -lang=>$slang,
				  -BGCOLOR=>$bgcolor);
};

if ($action != 24) {
	# Don't print header in printer friently screen
	st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);
};

print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";

# Everything from here is action depended.
if ($action == 0) {
	# Create new fault form
	my (@values, %labels, @lrow, $tpref, $origtab);
	print $query->start_form(-method=>'POST',
                                   -action=>"$cgipath/st_faults.pl?1",
				   -name=>'insertform',
                                   -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";

	# Short description. POC.
	print "<TD BGCOLOR=$headcellcolor>Short description: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textfield(-name=>'shortdescr',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";

	print "</TR><TR>";


	# Text area for details.
	print "<TD BGCOLOR=$headcellcolor>Full description: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textarea(-name=>'descrtext',
				-rows=>5,
				-columns=>60);
	print "</CENTER></TD>";
	print "</TR><TR>";

	if (($zdata[3] == 1) and ($zdata[6] == 0)) {
		# Techs can create faults for other companies
		# Take the companies from st_companies table
		my ($st_companies_id, $st_companies_names) = st_jscript::sub_companies_names;
		my $onChange="control_lists(document.insertform,document.insertform.company_id.options[document.insertform.company_id.selectedIndex].value)";
		print "<TR><TD BGCOLOR=$headcellcolor>Company: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->popup_menu(-name=>'company_id',
					 -values=>$st_companies_id,
					 -labels=>$st_companies_names,
				     	 -default=>'',
					 -onChange=>$onChange);
		print "</CENTER></TD>";
		my @st_companieslocations_id = ('');
		my %st_companieslocations_names = ( '' => '<----------------');

		print "<TD BGCOLOR=$headcellcolor>Location: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->popup_menu(-name=>'companylocation_id',
					 -values=>\@st_companieslocations_id,
				     	 -default=>'',
					 -labels=>\%st_companieslocations_names);
		print "</CENTER></TD>";

	} else {
		# Companylocation_id. Drop down, use only the records of the user's company.

		# Check st_companies to find out how the dropdown will be sorted.
		$sth = $dbh->prepare("SELECT user_order_by FROM st_companies 
					WHERE id = $zdata[8]");
		$sth->execute;
	
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		my $user_order_by = 'id'; # Default
		@lrow = $sth->fetchrow_array;
		if ($lrow[0] ne '') {
			$user_order_by = $lrow[0];
		};

		print "<TD BGCOLOR=$headcellcolor>SR location: </TD>";
		$sth = $dbh->prepare("SELECT id, name FROM st_companieslocations 
					WHERE company_id = $zdata[8]
					ORDER BY $user_order_by ");
		$sth->execute;
	
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		while (@lrow = $sth->fetchrow_array) {
			push @values, $lrow[0];
			$labels{ $lrow[0] } = $lrow[1];
		};
		print "<TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
		print $query->popup_menu(-name=>'companylocation_id',
       	              		         -values=>\@values,
       	                        	 -labels=>\%labels,
					 -default=>$zdata[7]); # Default is user's location
		print "</CENTER></TD>";
		
		print "</CENTER></TD>";
	};
	print "</TR><TR>";
	# faulttype_id. Drop down.
	# First get valid fault types for this company.
	$dst = "SELECT faulttype_id from st_comp_ftypes WHERE comp_id = $zdata[8]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @validtypes;
	while (@lrow = $sth->fetchrow_array) {
		push @validtypes, $lrow[0];
	};
	my (@values, %labels);
	print "<TD BGCOLOR=$headcellcolor>SR type: </TD>";
	$sth = $dbh->prepare("SELECT id, name FROM st_faulttypes ORDER BY name");
	$sth->execute;

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		if ((st_lib::found(\@validtypes, $lrow[0])) or (scalar(@validtypes) == 0)) {
			# Only valid types, but if none defined all are valid.
			push @values, $lrow[0];
			$labels{ $lrow[0] } = $lrow[1];
		};
	};
	if (scalar(@values) > 1) {
		# Add an empty entry to avoid mistakes.
		push @values, 'NULL';
		$labels{ 'NULL' } = '--- Please select ---';
	};
	print "<TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'faulttype_id',
                                  -values=>\@values,
				  -default=>'NULL',
                                  -labels=>\%labels);
	print "</CENTER></TD>";


	# faultlevel_id. Drop down.
	my (@values, %labels);
	print "<TD BGCOLOR=$headcellcolor>SR severity: </TD>";
	$sth = $dbh->prepare("SELECT id, name FROM st_faultlevels ORDER BY name");
	$sth->execute;

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		push @values, $lrow[0];
		$labels{ $lrow[0] } = $lrow[1];
	};

	# Add an empty one and make it default
	push @values, 'NULL';
	$labels{ 'NULL' } = '--- Please select ---';
	print "<TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'faultlevel_id',
                                  -values=>\@values,
				  -default=>'NULL',
                                  -labels=>\%labels);
	print "</CENTER></TD>";

	print "</TR><TR>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";	
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD>";	
	print "</TR></TABLE></CENTER>";
} elsif ($action == 1) {
	# Insert fault in database and inform user.
	my $shortdescr = $query->param('shortdescr');
	my $descrtext = $query->param('descrtext');
	my $companylocation_id = $query->param('companylocation_id');
	my $faulttype_id = $query->param('faulttype_id');
	my $faultlevel_id = $query->param('faultlevel_id');
	my $start_time = scalar localtime;
	# Be carefull...
	$dbh->commit;

	# Check for NULL severity/type - DB message is ugly, put something human readable.
	if ($faultlevel_id eq 'NULL') {
		print "<H2><B><FONT COLOR=RED>Severity cannot be null.<br>Please select SR severity.<br>Service Request creation failed!</FONT></B></H2>";
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};
	if ($faulttype_id eq 'NULL') {
		print "<H2><B><FONT COLOR=RED>SR type cannot be null.<br>Please select SR type.<br>Service Request creation failed!</FONT></B></H2>";
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};

	$shortdescr=~s/\'/\"/g;

	if (($shortdescr eq '') or ($descrtext eq '')) {
		print "<H2><B><FONT COLOR=RED>Short and long description cannot be null.<br>Please type a description.<br>Service Request creation failed!</FONT></B></H2>";
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};

	# First, the main record
	# Update: start_date is used as default for report_timestamp
	$dst = "INSERT INTO st_faults(shortdescr, start_time, logged_by_user_id, companylocation_id, faulttype_id, survey_done, report_timestamp)
			VALUES(\'$shortdescr\', \'$start_time\', $zdata[0], $companylocation_id, $faulttype_id, \'f\', \'$start_time\')";
	st_lib::wDbg("DST 1: |$dst|", "st_faults");
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};

	# Find new fault's id.
	$dst = "SELECT currval('st_faults_id_seq')";
	$sth = $dbh->prepare($dst); 
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};
	@row_ary = $sth->fetchrow_array;
	my $fault_id = $row_ary[0]; # Single value.

	$descrtext=~s/\'/\"/g;
	# Insert long description text
	$dst = "INSERT INTO st_faultsmsglog(fault_id, description, log_time, logged_by_user_id) 
			VALUES($fault_id, \'$descrtext\', \'$start_time\',  $zdata[0])";
	st_lib::wDbg("DST 2: |$dst|", "st_faults");
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};

	# Insert first level entry
	$dst = "INSERT INTO st_faultslevellog(change_time, faultlevel_id, changed_by_user_id, fault_id) 
			VALUES(\'$start_time\', $faultlevel_id, $zdata[0], $fault_id)";
#	st_lib::wDbg("DST 3: |$dst|", "st_faults");
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};

	# Insert first status record
	$dst = "INSERT INTO st_faultsstatuslog(change_time, fault_id, faultstatus_id, changed_by_user_id) 
			VALUES(\'$start_time\', $fault_id, 0, $zdata[0])";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};

	# Everything is ok, commit.
	$dbh->commit;
	# Send e-mails.
	$dst = "SELECT user_id FROM st_techsmc_faulttypes WHERE faulttype_id = $faulttype_id AND scse = \'t\'";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};
	my @recipients;
	my @lrow;
	while (@lrow = $sth->fetchrow_array) {
		push @recipients, $lrow[0];
	};
	push @recipients, $zdata[0];
	foreach $tmp (@recipients) {
		st_lib::wDbg("Recipient id: $tmp\n", "st_faults new fault mail");
	};
	st_mail::mail_routine($dbh, $fault_id, 6, \@nothing, \@recipients);
	
	print "<H1><FONT COLOR=GREEN>Insert transaction successfull.</FONT></H1><P>";	
	print "<H3>New SR number: <B>$fault_id</B></H3><P>";	
	print "<A HREF=\"$cgipath/st_faults.pl?0\">[New Service Request]</A> <A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">[Edit just created SR]</A> <A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
} elsif ($action == 2) {
	# Search form for faults. This one is simple, it assumes that the user is a simple client user. 
	# So, no need for user or company selection. Only company sites.
	# Update 22-03-2004: The search form and search result parts will be changed to be used from 
	# any type of users. Five levels of users can be defined using the three user booleans, plus
	# the mc boolean: Client, Client/Admin, Technician, Technician/Admin, Superuser. 
	# The only difference in the search form is that when the user is from Tech and up, all 
	# locations appear in the drop down and a company selection dropdown is added.
	# Update 29-03-2004: More differences added.
	
	# Subaction:
	# 0: Normal operation
	# 1: For fault relations, next chooserlist is original fault.

	my $subaction = $chooserlist[1];
	my $helper_fault_id = $chooserlist[2];
	# Default
	if ($subaction eq '') { $subaction = 0 };
	
	my %sortlabels = (
		'f.start_time DESC' => 'SR Creation date (descending)', 
		'lf.faultlevel_id ASC' => 'SR Severity (descending)', 
		'lf.faultlevel_id DESC' => 'SR Severity (ascending)', 
		'f.start_time ASC' => 'SR Creation date (ascending)', 
		'f.end_time ASC' => 'SR Closing date (ascending)', 
		'f.end_time DESC' => 'SR Closing date (descending)', 
		'u.fullname' => 'Owner name', 
		'f.shortdescr' => 'Description', 
		);
	my @sortvalues = (
			'f.start_time DESC',
			'lf.faultlevel_id ASC', 
			'lf.faultlevel_id DESC', 
			'f.start_time ASC', 
			'f.end_time ASC', 
			'f.end_time DESC', 
			'u.fullname', 
			'f.shortdescr'
			);

	my @timevalues = (
				'',
				'1 hour',
				'6 hours',
				'12 hours',
				'24 hours',
				'2 days',
				'3 days',
				'4 days',
				'5 days',
				'6 days',
				'7 days',
				'2 weeks',
				'3 weeks',
				'1 month',
			);

	my %timelabels = (
				'' => 'Don\'t use',
				'1 hour' => 'Last hour',
				'6 hours' => 'Last six hours',
				'12 hours' => 'Last twelve hours',
				'24 hours' => 'Last day',
				'2 days' => 'Last two days',
				'3 days' => 'Last three days',
				'4 days' => 'Last four days',
				'5 days' => 'Last five days',
				'6 days' => 'Last six days',
				'7 days' => 'Last week',
				'2 weeks' => 'Last two weeks',
				'3 weeks' => 'Last three weeks',
				'1 month' => 'Last month',
			);
	my @ofiltervalues = ('', '1', '2', '3', '4');

	my %ofilterlabels = (
				'' => 'Don\'t use',
				'1' => 'Owned by me',
				'2' => 'Assigned to me',
				'3' => 'Related to me',
				'4' => 'Related to me in any way'
				);

	if ($zdata[3] == 1) {
		# use companies
		$sortlabels{ 'c.name' } = 'Company';
		push @sortvalues, 'c.name';
	} else {
		# use companies locations.
		$sortlabels{ 'l.name' } = 'Location';
		push @sortvalues, 'l.name';
	};


	my (@values, %labels, @lrow, $tpref, $origtab);
	if ($subaction == 0) {
		print $query->start_form(-method=>'POST',
       		                         -action=>"$cgipath/st_faults.pl?3+0",
					 -name=>'searchform',
       		                         -enctype=>$sencoding);
	} elsif ($subaction == 1) {
		print $query->start_form(-method=>'POST',
       		                         -action=>"$cgipath/st_faults.pl?3+1+$helper_fault_id",
					 -name=>'searchform',
       		                         -enctype=>$sencoding);
	} else {
		# IMPOSSIBLE.
		print "Impossible.";
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	print "<CENTER><TABLE><TR>";


	# Short description. POC.
	print "<TD BGCOLOR=$headcellcolor>Short description: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textfield(-name=>'shortdescr',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";

	print "</TR><TR>";

	# Companylocation_id. Drop down, use only the records of the user's company.
	# Replaced by companies drop down if user is a tech.
	if ($zdata[3] == 1) {
		# Tech, companies
		print "<TD BGCOLOR=$headcellcolor><CENTER>Company: </CENTER></TD>";
		$sth = $dbh->prepare("SELECT id, name FROM st_companies
					ORDER BY name");
		$sth->execute;

		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		while (@lrow = $sth->fetchrow_array) {
			push @values, $lrow[0];
			$labels{ $lrow[0] } = $lrow[1];
		};
		push @values, ''; # If user doesn't want to select.
		$labels{ '' } = 'All';


		print "<TD BGCOLOR=$cellcolor><CENTER>";
		print $query->popup_menu(-name=>'company_id',
       	                           	 -values=>\@values,
       	                           	 -labels=>\%labels,
					  -default=>'');
		print "</CENTER></TD>";
	} else {
		# Client, locations.
		print "<TD BGCOLOR=$headcellcolor><CENTER>Company location:</CENTER> </TD>";
		$sth = $dbh->prepare("SELECT id, name FROM st_companieslocations 
					WHERE company_id = $zdata[8]
					ORDER BY name");
		$sth->execute;

		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		while (@lrow = $sth->fetchrow_array) {
			push @values, $lrow[0];
			$labels{ $lrow[0] } = $lrow[1];
		};
		push @values, ''; # If user doesn't want to select.
		$labels{ '' } = 'All';
	
	
		print "<TD BGCOLOR=$cellcolor><CENTER>";
		print $query->popup_menu(-name=>'companylocation_id',
       	                           -values=>\@values,
       	                           -labels=>\%labels,
					  -default=>$zdata[7]); # Default is user's location
		print "</CENTER></TD>";
	};	
	# faulttype_id. Drop down.
	# First get valid fault types for this company.
	$dst = "SELECT faulttype_id from st_comp_ftypes WHERE comp_id = $zdata[8]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @validtypes;
	while (@lrow = $sth->fetchrow_array) {
		push @validtypes, $lrow[0];
	};

	my (@values, %labels);
	print "<TD BGCOLOR=$headcellcolor><CENTER>SR type:</CENTER> </TD>";
	$sth = $dbh->prepare("SELECT id, name FROM st_faulttypes ORDER BY name");
	$sth->execute;

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		if ((st_lib::found(\@validtypes, $lrow[0])) or (scalar(@validtypes) == 0)) {
			# Only valid types, but if none defined all are valid.
			push @values, $lrow[0];
			$labels{ $lrow[0] } = $lrow[1];
		};
	};
#	while (@lrow = $sth->fetchrow_array) {
#		push @values, $lrow[0];
#		$labels{ $lrow[0] } = $lrow[1];
#	};
	push @values, ''; # If user doesn't want to select.
	$labels{ '' } = 'All';
	print "<TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'faulttype_id',
                                  -values=>\@values,
				  -default=>'',
                                  -labels=>\%labels);
	print "</CENTER></TD>";

	print "</TR><TR>";

	# faultlevel_id. Drop down.
	my (@values, %labels);
	print "<TD BGCOLOR=$headcellcolor><CENTER>SR severity: </CENTER></TD>";
	$sth = $dbh->prepare("SELECT id, name FROM st_faultlevels ORDER BY name");
	$sth->execute;

	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		push @values, $lrow[0];
		$labels{ $lrow[0] } = $lrow[1];
	};
	push @values, ''; # If user doesn't want to select.
	$labels{ '' } = 'All';
	print "<TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'faultlevel_id',
                                  -values=>\@values,
				  -default=>'',
                                  -labels=>\%labels);
	print "</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Order by: </TD><TD BGCOLOR=$cellcolor>";
	print $query->popup_menu(-name=>'sorting',
                                  -values=>\@sortvalues,
				  -default=>'ip',
                                  -labels=>\%sortlabels);
	print "</TD>";	
	print "</TR><TR>";

	print "<TD BGCOLOR=$headcellcolor><CENTER>SR Status: </TD><TD BGCOLOR=$cellcolor>";
	my %rblabels;
	$rblabels{ 'NULL' } = 'Open';
	$rblabels{ 'NOT NULL' } = 'Closed';
	$rblabels{ '' } = 'All';
	print $query->radio_group(-name=>'end_time',
					-values=>['NULL','NOT NULL',''],
					-default=>'NULL',
					-labels=>\%rblabels);
	print "</TD>";

	print "<TD BGCOLOR=$headcellcolor><CENTER>SR Opening date period: </TD><TD BGCOLOR=$cellcolor>";
	print $query->popup_menu(-name=>'openingtime',
                                  -values=>\@timevalues,
				  -default=>'',
                                  -labels=>\%timelabels);
	print "</TD>";	

	print "</TR><TR>";

	if (($zdata[3] == 1) and ($zdata[5] == 1)) { # This is only for techs_mc
		# This is only for techs_mc for now.
		print "<TD BGCOLOR=$headcellcolor><CENTER>Affinity filter:</TD><TD BGCOLOR=$cellcolor COLSPAN=3>";
		print $query->radio_group(-name=>'affinity',
						-values=>\@ofiltervalues,
						-default=>'4',
						-labels=>\%ofilterlabels);
		print "</TD></TR><TR>";
	};

	if (($zdata[3] == 1) and ($zdata[5] == 1)) { # This is only for techs_mc
		print "<TD BGCOLOR=$headcellcolor><CENTER>Assigned: </TD><TD BGCOLOR=$cellcolor>";
		my %rblabels;
		$rblabels{ 'EXISTS' } = 'Yes';
		$rblabels{ 'NOT EXISTS' } = 'No';
		$rblabels{ '' } = 'All';
		print $query->radio_group(-name=>'assigned',
						-values=>['','EXISTS','NOT EXISTS'],
						-default=>'',
						-labels=>\%rblabels);
		print "</TD>";
	} else {
		print "<TD BGCOLOR=$headcellcolor COLSPAN=2></TD>";
	};

	# Detect if user has grant on survey table. If yes, add another checkbox 
	# to filter faults with answered surveys.
	my $surv_grant = 0;
	$dst = "SELECT relacl FROM pg_class WHERE relname = \'st_surv_answ\'";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	} else {
		my @grants = $sth->fetchrow_array;
		my @records = split /,/, $grants[0];
		my $rec;
		for $rec ( @records ) {
			my ($user, $perm) = split /=/, $rec, 2;
			if (($perm eq 'r') and ($user eq $zuser)) {
				$surv_grant = 1;
			};
		};
	};

	if ($surv_grant) {
		my %naioxi = (
				0 => 'No',
				1 => 'Yes'
				);
		my @values = (0, 1);

		print "<TD BGCOLOR=$headcellcolor><CENTER>";	
		print "Answered surveys only: ";
		print "</CENTER></TD>";	
		print "<TD BGCOLOR=$cellcolor><CENTER>";	
		print $query->popup_menu(-name=>'surv_filter',
       		                         -values=>\@values,
					 -default=>0,
       		                         -labels=>\%naioxi);
		print "</CENTER></TD></TR><TR>";	
		print "<TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";	
		print $query->submit('submitbutton', 'Search');
		print $query->endform;
		print "</CENTER></TD>";	
	} else {
       		print $query->hidden(-name=>'surv_filter',
	  				-default=>0);
		print "<TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>";	
		print $query->submit('submitbutton', 'Search');
		print $query->endform;
		print "</CENTER></TD>";	
	};
	print "</TR><TR>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=4><FONT COLOR=WHITE><CENTER>-</CENTER></FONT></TD></TR><TR>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=2><B>Go directly to Service Request with number: </B></TD>";
	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+0",
				 -name=>'goform',
                                 -enctype=>$sencoding);
	print "<TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'fault_id',
				-size=>10,
				-maxlength=>10);
	print "</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>";
	print $query->submit('submitbutton', 'Go to SR');
	print $query->endform;
	print "</CENTER></TD>";	
	
	if ($zdata[3] == 1) {
		# Only for techs.
		print "</TR><TR>";
		print "<TD BGCOLOR=$headcellcolor COLSPAN=2><B>Service Report number search: </B></TD>";
		print $query->start_form(-method=>'POST',
       	    	                         -action=>"$cgipath/st_faults.pl?4+0",
					 -name=>'repform',
       		                         -enctype=>$sencoding);
		print "<TD BGCOLOR=$cellcolor><CENTER>";
		print $query->textfield(-name=>'srep_id',
					-size=>10,
					-maxlength=>80);
		print "</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>";
		print $query->submit('submitbutton', 'Find SR');
		print $query->endform;
		print "</CENTER></TD>";	
	};

	print "</TR></TABLE></CENTER>";
} elsif ($action == 3) {
	# Search results. User mode. The query will only return faults that are 
	# either opened by user or related to user in st_faults_users_rel.
	# An extra check will also make sure that the fault  and the user 
	# have the same company id.
	# Update: See previous part - mode depends on user.

	# Subaction:
	# 0: Normal operation
	# 1: For fault relations, next chooserlist is original fault.
	# 2: For elapsed time, next chooserlist is category: 0 to 3.

	my $subaction = $chooserlist[1];
	my $helper_fault_id = $chooserlist[2];
	# Default
	if ($subaction eq '') { $subaction = 0 };

	my $pm;
	my %columns = (
		'shortdescr' => 'text', 
		'faulttype_id' => 'num', 
		'faultlevel_id' => 'num', 
		'end_time' => 'nbool', 
		'assigned' => 'special', 
		'openingtime' => 'special', 
		'affinity' => 'special', 
		'surv_filter' => 'special', 
		);
	my %shortnames = (
		'shortdescr' => 'f.', 
		'faulttype_id' => 'f.', 
		'faultlevel_id' => 'lf.', 
		'end_time' => 'f.', 
		);
	if ($zdata[3] == 1) {
		$columns{ 'company_id' } = 'num';
		$shortnames{ 'company_id' } = 'l.';
		if ($zdata[5] == 1) {
			# MC Tech user
			$dst = "SELECT DISTINCT f.id, f.shortdescr, f.start_time, f.end_time, u.fullname, c.name, tf.assigned_to_user_id, lf.faultlevel_id, lf.name, sf.name, tf.fullname, f.confidential
				FROM (((((st_faults f INNER JOIN st_users u ON f.logged_by_user_id = u.id)
				  INNER JOIN st_companieslocations l ON f.companylocation_id = l.id)
				  INNER JOIN st_companies c ON l.company_id = c.id)
				  INNER JOIN st_level_of_fault lf ON f.id = lf.id)
				  INNER JOIN st_status_of_fault sf ON f.id = sf.id)
				  LEFT JOIN st_tech_of_fault tf ON f.id = tf.id 
				  WHERE TRUE ";
		} else {
			# Simple tech user
			$dst = "SELECT DISTINCT f.id, f.shortdescr, f.start_time, f.end_time, u.fullname, c.name, tf.assigned_to_user_id, lf.faultlevel_id, lf.name, sf.name, tf.fullname, f.confidential
				FROM (((((st_faults f INNER JOIN st_users u ON f.logged_by_user_id = u.id)
				  INNER JOIN st_companieslocations l ON f.companylocation_id = l.id)
				  INNER JOIN st_companies c ON l.company_id = c.id)
				  INNER JOIN st_tech_of_fault tf ON f.id = tf.id)
				  INNER JOIN st_level_of_fault lf ON f.id = lf.id)
				  INNER JOIN st_status_of_fault sf ON f.id = sf.id ";
			$dst = $dst . " WHERE ((tf.assigned_to_user_id = $zdata[0])"; # $zdata[0] is st_users.id
			$dst = $dst . "       OR (EXISTS (SELECT * FROM st_faults_users_rel WHERE user_id = $zdata[0] AND fault_id = f.id)) "; # $zdata[0] is st_users.id
			$dst = $dst . "       OR (f.logged_by_user_id = $zdata[0])) ";	 # Tech can be client too. 

		};
	} else {
		$columns{ 'companylocation_id' } = 'num';
		$shortnames{ 'companylocation_id' } = 'f.';
		if ($zdata[5] == 1) {
			# MC client user
			$dst = "SELECT DISTINCT f.id, f.shortdescr, f.start_time, f.end_time, u.fullname, l.name, CAST(NULL AS TEXT), lf.faultlevel_id, lf.name, sf.name, tf.fullname, f.confidential
				FROM ((((st_faults f INNER JOIN st_users u ON f.logged_by_user_id = u.id)
				  INNER JOIN st_companieslocations l ON f.companylocation_id = l.id)
				  INNER JOIN st_level_of_fault lf ON f.id = lf.id)
				  INNER JOIN st_status_of_fault sf ON f.id = sf.id)
				  LEFT JOIN st_tech_of_fault tf ON f.id = tf.id 
				WHERE l.company_id = $zdata[8] "; # $zdata[8] is company_id of the user 
		#	$dst = $dst . "       AND (f.id IN (SELECT fault_id FROM st_faults_users_rel WHERE user_id = $zdata[0])) ";	 # $zdata[0] is st_users.id
		} else {
			# Simple client user
			$dst = "SELECT DISTINCT f.id, f.shortdescr, f.start_time, f.end_time, u.fullname, l.name, CAST(NULL AS TEXT), lf.faultlevel_id, lf.name, sf.name, tf.fullname, f.confidential
				FROM ((((st_faults f INNER JOIN st_users u ON f.logged_by_user_id = u.id)
				  INNER JOIN st_companieslocations l ON f.companylocation_id = l.id)
				  INNER JOIN st_level_of_fault lf ON f.id = lf.id)
				  INNER JOIN st_status_of_fault sf ON f.id = sf.id)
				  LEFT JOIN st_tech_of_fault tf ON f.id = tf.id 
				WHERE l.company_id = $zdata[8] "; # $zdata[8] is company_id of the user 
			$dst = $dst . " AND ((f.logged_by_user_id = $zdata[0])"; # $zdata[0] is st_users.id
#			$dst = $dst . "       OR (r.user_id = $zdata[0])) ";	 # $zdata[0] is st_users.id
#			$dst = $dst . "       OR (f.id IN (SELECT fault_id FROM st_faults_users_rel WHERE user_id = $zdata[0]))) ";	 # $zdata[0] is st_users.id
			$dst = $dst . "       OR (EXISTS (SELECT * FROM st_faults_users_rel WHERE user_id = $zdata[0] AND fault_id = f.id))) ";	 # $zdata[0] is st_users.id
		};
	};


	# Constant part ready, let's add search conditions
	my @params = $query->param;

	foreach $pm (@params) {
		if (exists $columns{ $pm }) {
			# Column found.
			my $pmvalue = $query->param($pm);
			# Trim white space
			$pmvalue =~ s/^\s*(.*?)\s*$/$1/;
			# Escape single quotes
			$pmvalue =~ s/\'/\\\'/g;
			if ($pmvalue ne '') {
				$dst = $dst . ' AND ';
				if ($columns{ $pm } eq 'text') {
					$dst = $dst . ' ' . $shortnames{ $pm } . "$pm ILIKE \'$pmvalue\' ";
				} elsif ($columns{ $pm } eq 'num') {
					$dst = $dst . ' ' . $shortnames{ $pm } . "$pm = $pmvalue ";
				} elsif ($columns{ $pm } eq 'nbool') {
					$dst = $dst . ' ' . $shortnames{ $pm } . "$pm IS $pmvalue ";
				} elsif ($columns{ $pm } eq 'special') {
					if ($pm eq 'assigned') {
#						$dst = $dst . "(f.id $pmvalue (SELECT fault_id FROM st_faultstechs))";
						$dst = $dst . "($pmvalue (SELECT * FROM st_faultstechs WHERE fault_id = f.id))";
					} elsif ($pm eq 'affinity') {
						if ($pmvalue eq '1') {
							# Owner
							$dst = $dst . "(f.logged_by_user_id = $zdata[0])";
						} elsif ($pmvalue eq '2') {
							# Assigned
							$dst = $dst . "(tf.assigned_to_user_id = $zdata[0])";
						} elsif ($pmvalue eq '3') {
							# Related 
#							$dst = $dst . "(f.id IN (SELECT fault_id FROM st_faults_users_rel WHERE user_id = $zdata[0]))";
							$dst = $dst . "(EXISTS (SELECT * FROM st_faults_users_rel WHERE user_id = $zdata[0] AND fault_id = f.id))";
						} elsif ($pmvalue eq '4') {
							# All.
							$dst = $dst . "(";
							$dst = $dst . "(f.logged_by_user_id = $zdata[0])";
							$dst = $dst . " OR ";
							$dst = $dst . "(tf.assigned_to_user_id = $zdata[0])";
							$dst = $dst . " OR ";
							$dst = $dst . "(EXISTS (SELECT * FROM st_faults_users_rel WHERE user_id = $zdata[0] AND fault_id = f.id))";
							$dst = $dst . " OR ";
							$dst = $dst . "(EXISTS (SELECT * FROM st_techsmc_faulttypes WHERE user_id = $zdata[0] AND faulttype_id = f.faulttype_id))";
							$dst = $dst . ")";
						};
					} elsif ($pm eq 'openingtime') {
						$dst = $dst . "(f.start_time >= now() - interval \'$pmvalue\')";
					} elsif ($pm eq 'surv_filter') {
						if ($pmvalue eq '1') {
							$dst = $dst . "(EXISTS (SELECT fault_id FROM st_surv_answ WHERE fault_id = f.id))";
						} else {
							$dst = $dst . "(TRUE)";
						};
					};
				};
			};
		};

	};

	if ($subaction == 2) {
		# Add WHERE clause according to elapsed time.

		if ($helper_fault_id eq '0') {
			# Less than 10 min
			$dst = $dst . " AND (EXISTS (SELECT id FROM st_elapsed WHERE e10min IS TRUE AND id = f.id)) ";
		} elsif ($helper_fault_id eq '1') {
			# 30 min > t > 10 min
			$dst = $dst . " AND (EXISTS (SELECT id FROM st_elapsed WHERE e30min IS TRUE AND id = f.id)) ";
		} elsif ($helper_fault_id eq '2') {
			# 60 min > t > 30 min
			$dst = $dst . " AND (EXISTS (SELECT id FROM st_elapsed WHERE e1hour IS TRUE AND id = f.id)) ";
		} else  {
			# t > 60 min
			$dst = $dst . " AND (EXISTS (SELECT id FROM st_elapsed WHERE emore IS TRUE AND id = f.id)) ";
		};
	
	};

	# If userlevel is 1, apply affinity filter anyway. 
	if ($zdata[6] == 1) {
		$dst = $dst . ' AND ';
		$dst = $dst . "(";
		$dst = $dst . "(f.logged_by_user_id = $zdata[0])";
		$dst = $dst . " OR ";
		$dst = $dst . "(tf.assigned_to_user_id = $zdata[0])";
		$dst = $dst . " OR ";
		$dst = $dst . "(EXISTS (SELECT * FROM st_faults_users_rel WHERE user_id = $zdata[0] AND fault_id = f.id))";
		$dst = $dst . " OR ";
		$dst = $dst . "(EXISTS (SELECT * FROM st_techsmc_faulttypes WHERE user_id = $zdata[0] AND faulttype_id = f.faulttype_id))";
		$dst = $dst . ")";
	};
	my $sortcolumn = $query->param('sorting');
	if ($sortcolumn eq '') { $sortcolumn = 'f.start_time ASC' };
	$dst = $dst . " ORDER BY $sortcolumn ";

	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	# Print headers
	print "<TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>SR number</TD>";
	print "<TD BGCOLOR=$headcellcolor>Description</TD>";
	if ($zdata[3] == 1) {
		print "<TD BGCOLOR=$headcellcolor>Company</TD>";
	} else {
		print "<TD BGCOLOR=$headcellcolor>Location</TD>";
	};
	print "<TD BGCOLOR=$headcellcolor>SR Opening date</TD>";
	print "<TD BGCOLOR=$headcellcolor>SR Status</TD>";
	print "<TD BGCOLOR=$headcellcolor>CSE</TD>";
	print "<TD BGCOLOR=$headcellcolor>Owner</TD>";
	print "<TD BGCOLOR=$headcellcolor>SR Severity</TD>";
	print "</TR>";

	# Print data
	my $printed_records = 0;
	if ($sth->rows == 0) {
		print "<TD BGCOLOR=$cellcolor COLSPAN=8><CENTER>No records found.</CENTER></TD></TR></TABLE>";	
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			# On confidential records, extra check for permissions.
			my $fbupr = 1;
			my $idcolor = $cellcolor;
			if ($row_ary[11]) {
				$fbupr = st_lib::fbup(\@zdata, $dbh, $row_ary[0]);	
				$idcolor=$lockedcolor;
			};
			if ($fbupr > 0) { 	# Permission granted, so display the record.
				# Substitutions to avoid XSS attacks.
				$printed_records++;
				$row_ary[1]=~s/&/&#38;/g;
				$row_ary[1]=~s/\(/&#40;/g;
				$row_ary[1]=~s/\)/&#41;/g;
				$row_ary[1]=~s/</&lt;/g;
				$row_ary[1]=~s/>/&gt;/g;
				my ($hl1, $hl2, $cl_date) = '';
				if ($row_ary[10] eq '') {
					$hl1 = "<FONT COLOR=RED><B>";
					$hl2 = "</B></FONT>";
				};
				if ($row_ary[3] ne '') {
					$cl_date = " (" . st_lib::datetostr($row_ary[3]) . ")";
				};
				print "<TR><TD BGCOLOR=$idcolor>$row_ary[0]</TD>";
				if (($subaction == 0) or ($subaction == 2)) {
					# Call normal fault screen
					print "<TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_faults.pl?4+$row_ary[0]\">$row_ary[1]</A></TD>";
				} elsif ($subaction == 1) {
					# Call fault relations screen, with extra argument (result of search).
					print "<TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_faults.pl?22+$helper_fault_id+0+$row_ary[0]\">$row_ary[1]</A></TD>";
				} else {
					# IMPOSSIBLE.
					print "Impossible.";
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
				print "<TD BGCOLOR=$cellcolor>$row_ary[5]</TD>";
				print "<TD BGCOLOR=$cellcolor>" . st_lib::datetostr($row_ary[2]) . "</TD>";
				print "<TD BGCOLOR=$cellcolor>$hl1" . $row_ary[9] . "$hl2$cl_date</TD>";
				print "<TD BGCOLOR=$cellcolor>$row_ary[10]</TD>";
				print "<TD BGCOLOR=$cellcolor>$row_ary[4]</TD>";
				if (($row_ary[7] == $criticalid) and ($row_ary[3] eq '')) {
					print "<TD BGCOLOR=RED><FONT COLOR=WHITE>$row_ary[8]</FONT></TD>";
				} elsif (($row_ary[7] == $highid) and ($row_ary[3] eq '')) {
					print "<TD BGCOLOR=YELLOW>$row_ary[8]</TD>";
				} elsif (($row_ary[7] == $highid) and ($row_ary[3] ne '')) {
					print "<TD BGCOLOR=$cellcolor><FONT COLOR=#999900>$row_ary[8]</FONT></TD>";
				} elsif (($row_ary[7] == $criticalid) and ($row_ary[3] ne '')) {
					print "<TD BGCOLOR=$cellcolor><FONT COLOR=#990000>$row_ary[8]</FONT></TD>";
#				} elsif ($row_ary[3] ne '') {
#					print "<TD BGCOLOR=GREY>$row_ary[8]</TD>";
				} else {
					print "<TD BGCOLOR=$cellcolor>$row_ary[8]</TD>";
				};
				print "</TR>";
			};
		};
		print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=8><CENTER>Records found: " . $printed_records . "</TD></TR>";
	};

	print "</TABLE>";
	$sth->finish;
} elsif ($action == 4) {
	# Display fault 
	my $fault_id = $chooserlist[1];
	my $srep_id;
	my (@menulabels, @menulinks);
	if ($fault_id == 0) {
		# This is direct call from search form, query fault_id from form.
		$fault_id = $query->param('fault_id');
		if ($fault_id eq '') {
			# Nop, let's try srep_id. 
			$srep_id = $query->param('srep_id');
			if ($srep_id eq '') {
				# The user is playing.
				$fault_id = 0;
			} else {
				# Locate fault with the specific srep_id attached.
				$dst = "SELECT fault_id FROM st_sreports WHERE srep_id = $srep_id";
				$sth = $dbh->prepare($dst);
				$sth->execute;
				if (st_lib::sthErr($sth->err, $sth->errstr)) { 
					# Internal Error.
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
				my @tmp_rec = $sth->fetchrow_array;
				$fault_id = $tmp_rec[0];
				if ($fault_id eq '') { 
					# No luck...
					print "<FONT COLOR=RED><H1>Service Report number non-existent.</H1></FONT>";
					print $query->end_html;
					$sth->finish;
					$dbh->disconnect;
					print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
					exit;
				};
			};
		};
	};
	my $extra_action = $chooserlist[2];
	#########################################################################
	#									#
	# Extra actions:							# 
	#  0: New tech assignment.						#
	#  1: New fault level.							#
	#  2: New fault status.							#
	#  3: Close ticket confirmed.						#
	#  4: Close ticket cancelled.						#
	#  5: Insert new comment.						#
	#  6: New TAC number.							#
	#  7: New RMA number.							#
	#  8: Answering survey.							#
	#  9: Cancel ticket confirmed.						#
	#  10: Cancel ticket cancelled.						#
	#  11: Manage manual dates.						#
	#  12: Lock ticket confirmed.						#
	#  13: Lock ticket cancelled.						#
	#									#
	#########################################################################
	my @tmp;
	my $status_line = '-';
	my $status_color = $cellcolor;
#	my $buttons_line = "<CENTER><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A> ";

	push @{ $menulabels[0] }, '[SR directory]';
	push @{ $menulinks[0] }, "$cgipath/st_faults.pl?2";
#	$menulabels[1][2] = '[SR directory]';
#	$menulinks[1][2] = "$cgipath/st_faults.pl?2";
#	my $buttons_cntr = 1;
	my $tcancelled = 0;

	# Before doing anything, check permissions.
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { # Not even readonly.
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without permission.", "st_faults");
		exit;
	};

	if ($extra_action ne '') {
		# Something to do before select
		if ($extra_action == 0) {
			# Tech assignment.

			# Permission check.
			if (($fbupr < 2) or (not (($zdata[3] == 1) and ($zdata[5] == 1)))) { # Must be tech_mc
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $new_id = $query->param('user_id');
			$dst = "INSERT INTO st_faultstechs(assign_time, assigned_by_user_id, assigned_to_user_id, fault_id)
				VALUES(now(), $zdata[0], $new_id, $fault_id)";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				# Check status
				$dst = "SELECT faultstatus_id FROM st_status_of_fault WHERE id = $fault_id";
				$sth = $dbh->prepare($dst);
				$sth->execute;
				if (defined($sth->err)) { 
					# Internal Error.
					$status_line = $sth->errstr;
					$status_color = 'RED';
					st_lib::wDbg("DEBUG: ERROR ON SELECT", "st_faults");
					$dbh->rollback;
				} else {
					@tmp = $sth->fetchrow_array;
					if ($tmp[0] == 0) {
						# make it one.
						$dst = "INSERT INTO st_faultsstatuslog(change_time, fault_id, faultstatus_id, changed_by_user_id)
							VALUES(now(), $fault_id, 1, $zdata[0])";
							$sth = $dbh->prepare($dst);
							$sth->execute;
							if (defined($sth->err)) { 
								# Internal Error.
								$status_line = $sth->errstr;
								$status_color = 'RED';
								$dbh->rollback;
								st_lib::wDbg("DEBUG: ERROR", "st_faults");
							} else {
								$status_line = 'Insert transaction successfull';
								$status_color = 'GREEN';
								$dbh->commit;
								st_lib::wDbg("DEBUG: OK", "st_faults");
								# Send e-mails. 
								st_mail::mail_routine($dbh, $fault_id, 4, \@nothing);
							};
					} else {
						# Just commit and send the bloody mail...
						$status_line = 'Insert transaction successfull';
						$status_color = 'GREEN';
						$dbh->commit;
						st_mail::mail_routine($dbh, $fault_id, 4, \@nothing);
					};
				};
			};
		} elsif ($extra_action == 1) {
			# New fault level
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};
			my $new_id = $query->param('faultlevel_id');
			$dst = "INSERT INTO st_faultslevellog(change_time, changed_by_user_id, faultlevel_id, fault_id)
				VALUES(now(), $zdata[0], $new_id, $fault_id)";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Insert transaction successfull';
				$status_color = 'GREEN';
				$dbh->commit;
				st_mail::mail_routine($dbh, $fault_id, 2, \@nothing);
			};
		} elsif ($extra_action == 2) {
			# New fault status
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $new_id = $query->param('faultstatus_id');
			$dst = "INSERT INTO st_faultsstatuslog(change_time, changed_by_user_id, faultstatus_id, fault_id)
				VALUES(now(), $zdata[0], $new_id, $fault_id)";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Insert transaction successfull';
				$status_color = 'GREEN';
				$dbh->commit;
				st_mail::mail_routine($dbh, $fault_id, 3, \@nothing);
			};
		} elsif ($extra_action == 3) {
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			$dst = "UPDATE st_faults SET end_time = now(), closed_by_user_id = $zdata[0] WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Service Request closed successfully.';
				$status_color = 'GREEN';
				$dbh->commit;
				st_mail::mail_routine($dbh, $fault_id, 5, \@nothing);
			};

		} elsif ($extra_action == 4) {
			$status_line = 'Service Request remains open.';
			$status_color = 'GREEN';
		} elsif ($extra_action == 5) {
			# New comment
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $new_id = $query->param('descrtext');
			$new_id=~s/\'/\\\'/g;
			$dst = "INSERT INTO st_faultsmsglog(log_time, logged_by_user_id, description, fault_id)
				VALUES(now(), $zdata[0], \'$new_id\', $fault_id)";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Insert transaction successfull';
				$status_color = 'GREEN';
				$dbh->commit;
				st_mail::mail_routine($dbh, $fault_id, 1, \@nothing);
			};
		} elsif ($extra_action == 6) {
			# New TAC number
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $new_tac_num = $query->param('tac_num');
			$new_tac_num=~s/\'/\\\'/g;
			$dst = "UPDATE st_faults SET tac_num = \'$new_tac_num\'
				WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Update successfull';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		} elsif ($extra_action == 7) {
			# New RMA number
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $new_rma_num = $query->param('rma_num');
			$new_rma_num=~s/\'/\\\'/g;
			$dst = "UPDATE st_faults SET rma_num = \'$new_rma_num\'
				WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Update successfull';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		} elsif ($extra_action == 8) {
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			# Find fault's type.
			$dst = "SELECT faulttype_id FROM st_faults WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (st_lib::sthErr($sth->err, $sth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			@tmp = $sth->fetchrow_array;
			# Find type's survey id.
			$dst = "SELECT surv_id FROM st_surv2types WHERE type_id = $tmp[0]";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (st_lib::sthErr($sth->err, $sth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			@tmp = $sth->fetchrow_array;
			my $surv_id = $tmp[0];

			my @params = $query->param;
			my $param;
			my $error = 0;
SURVLINE:		foreach $param (@params) {
				my ($rest, $answ_id) = split /QU/, $param, 2; 
				if ($answ_id ne '') {
					# Got answer.
					my $answer = $query->param($param);
					$dst = "INSERT INTO st_surv_answ(fault_id, surv_id, qu_id, answer) 
						VALUES($fault_id, $surv_id, $answ_id, \'$answer\')";
					$sth = $dbh->prepare($dst);
					$sth->execute;
					if (st_lib::sthErr($sth->err, $sth->errstr)) { 
						# Internal Error.
						$error = 1;
						last SURVLINE;
					};
				};
			};
			$dst = "UPDATE st_faults SET survey_done = 't' WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (st_lib::sthErr($sth->err, $sth->errstr)) { 
				# Internal Error.
				$error = 1;
			};
			if ($error) {
				$status_line = 'Sorry, there has been an error in storing your answers.';
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Thank you for filling the survey!';
				$status_color = 'GREEN';
				$dbh->commit;
			};
			if (not($error)) {
				# Build recipient list for mail. 
				my @recipients;
				# See who has read GRANT in survey answers table and send to them.
				$dst = "SELECT relacl FROM pg_class WHERE relname = \'st_surv_answ\'";
				$sth = $dbh->prepare($dst);
				$sth->execute;
				if (st_lib::sthErr($sth->err, $sth->errstr)) { 
					# Internal Error.
				} else {
					# Send mails. Ignore DB error if answers are saved ok.
					my @grants = $sth->fetchrow_array;
					my @records = split /,/, $grants[0];
					my $rec;
					for $rec ( @records ) {
						my ($user, $perm) = split /=/, $rec, 2;
						if ($perm eq 'r') {
							$dst = "SELECT id FROM st_users WHERE username = \'$user\'";
							my $lsth = $dbh->prepare($dst);
							$lsth->execute;
							my @larr = $lsth->fetchrow_array;
							push @recipients, $larr[0];
						};
					};
				};
				# Send mails.
				st_mail::mail_routine($dbh, $fault_id, 10, \@nothing, \@recipients);
			};

		} elsif ($extra_action == 9) {
			# Cancel ticket. Most of the work is done in the cancel_fault pgsql routine.
			# Permission check.
			if (($fbupr < 2) or (not (($zdata[3] == 1) and ($zdata[5] == 1)))) { # Must be tech_mc
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $errorflag = 0;
			$dst = "SELECT cancel_fault($fault_id)";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$errorflag = 1;
			};
			if (not($errorflag)) {
				$dst = "INSERT INTO st_cancelled_by(fault_id, cancelled_by) 
					VALUES ($fault_id, $zdata[0])";
				$sth = $dbh->prepare($dst);
				$sth->execute;
				if (defined($sth->err)) { 
					# Internal Error.
					$status_line = $sth->errstr;
					$status_color = 'RED';
					$errorflag = 1;
				};
			};
			if (not($errorflag)) {
				# All done
				$status_line = 'Service Request cancelled successfully.';
				$status_color = 'GREEN';
				$tcancelled = 1;
				$dbh->commit;
			} else {
				$dbh->rollback;
			};
		} elsif ($extra_action == 10) {
			$status_line = 'Service Request remains valid.';
			$status_color = 'GREEN';
		} elsif ($extra_action == 11) {
			# Edit manual dates.
			# Permission check.
			if (($fbupr < 2) or ($zdata[3] != 1)) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};

			my $new_reported_d = $query->param('reported_d');
			$new_reported_d=~s/\'/\\\'/g;
			# Trim white space
			$new_reported_d =~ s/^\s*(.*?)\s*$/$1/;
			if ($new_reported_d eq '') {
				$new_reported_d = 'NULL';
			} else {
				$new_reported_d = "\'$new_reported_d\'";
			};

			my $new_responce_d = $query->param('responce_d');
			$new_responce_d=~s/\'/\\\'/g;
			# Trim white space
			$new_responce_d =~ s/^\s*(.*?)\s*$/$1/;
			if ($new_responce_d eq '') {
				$new_responce_d = 'NULL';
			} else {
				$new_responce_d = "\'$new_responce_d\'";
			};

			my $new_resolution_d = $query->param('resolution_d');
			$new_resolution_d=~s/\'/\\\'/g;
			# Trim white space
			$new_resolution_d =~ s/^\s*(.*?)\s*$/$1/;
			if ($new_resolution_d eq '') {
				$new_resolution_d = 'NULL';
			} else {
				$new_resolution_d = "\'$new_resolution_d\'";
			};

			my $new_sla_actions = $query->param('sla_actions');
			$new_sla_actions=~s/\'/\\\'/g;
			# Trim white space
			$new_sla_actions =~ s/^\s*(.*?)\s*$/$1/;
			if ($new_sla_actions eq '') {
				$new_sla_actions = 'NULL';
			} else {
				$new_sla_actions = "\'$new_sla_actions\'";
			};

			my $new_sla_fail_comments = $query->param('sla_fail_comments');
			$new_sla_fail_comments=~s/\'/\\\'/g;
			# Trim white space
			$new_sla_fail_comments =~ s/^\s*(.*?)\s*$/$1/;
			if ($new_sla_fail_comments eq '') {
				$new_sla_fail_comments = 'NULL';
			} else {
				$new_sla_fail_comments = "\'$new_sla_fail_comments\'";
			};

			$dst = "UPDATE st_faults SET 
					report_timestamp = $new_reported_d,
					responce_timestamp = $new_responce_d,
					recovery_timestamp = $new_resolution_d,
					sla_actions = $new_sla_actions,
					sla_fail_comments = $new_sla_fail_comments
				WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Update successfull';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		} elsif ($extra_action == 12) {
			# Lock ticket
			# Permission check.
			if ($fbupr < 2) {
				# Deny access, but don't tell exactly why... >:-)
				print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
				print "Code 404";
				print $query->end_html;
				$dbh->disconnect;
				print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
				st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
				exit;
			};
			$dst = "UPDATE st_faults SET confidential = 't' WHERE id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Service request successfully marked as confidential';
				$status_color = $lockedcolor;
				$dbh->commit;
			};
		} elsif ($extra_action == 13) {
			$status_line = 'Service Request NOT marked as confidential.';
			$status_color = 'GREEN';
		};
	};

	if ($tcancelled) {
		print "<TABLE>";
		# Print status line
		print "<TR><TD BGCOLOR=$status_color COLSPAN=4><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
#		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=4>$buttons_line</CENTER></TD></TR>";
		st_lib::st_print_menu(\@menulabels, \@menulinks);
		print "</TABLE>";
		print "</CENTER>";
		st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	$dst = "SELECT f.shortdescr, f.start_time, f.end_time, u.fullname, f.closed_by_user_id, cl.name, c.name, f.logged_by_user_id, f.id,
			f.tac_num, f.rma_num, ft.name, f.faulttype_id, f.survey_done, cl.phone1, u.phone1, u.phone2, cl.id,
			f.report_timestamp, f.responce_timestamp, f.recovery_timestamp, ft.manual_dates, f.sla_actions, f.sla_fail_comments,
			f.confidential
			FROM ((st_faults f INNER JOIN st_users u ON f.logged_by_user_id = u.id)
					  INNER JOIN st_companieslocations cl ON f.companylocation_id = cl.id)
					  INNER JOIN st_companies c ON cl.company_id = c.id
					  INNER JOIN st_faulttypes ft ON f.faulttype_id = ft.id
			WHERE f.id LIKE \'$fault_id\' ";
	if ($zdata[3] == 0) { 
		# Clients must be able to see only their own company's records.
		$dst = $dst . " AND c.id = $zdata[8] ";
	};

	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	if ($sth->rows == 0) { 
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print $query->end_html;
		$sth->finish;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		exit;
	};
	
	my @fault_rec = $sth->fetchrow_array;
		# Substitutions to avoid XSS attacks.
		$fault_rec[0]=~s/&/&#38;/g;
		$fault_rec[0]=~s/\(/&#40;/g;
		$fault_rec[0]=~s/\)/&#41;/g;
		$fault_rec[0]=~s/</&lt;/g;
		$fault_rec[0]=~s/>/&gt;/g;
		$fault_rec[9]=~s/&/&#38;/g;
		$fault_rec[9]=~s/\(/&#40;/g;
		$fault_rec[9]=~s/\)/&#41;/g;
		$fault_rec[9]=~s/</&lt;/g;
		$fault_rec[9]=~s/>/&gt;/g;
		$fault_rec[10]=~s/&/&#38;/g;
		$fault_rec[10]=~s/\(/&#40;/g;
		$fault_rec[10]=~s/\)/&#41;/g;
		$fault_rec[10]=~s/</&lt;/g;
		$fault_rec[10]=~s/>/&gt;/g;
	my $fault_id = $fault_rec[8];
	my $is_open = 1;
	my $is_closed = 0; # Because is_open is used as ro flag, use that for REALLY closed tickets.
	my $close_time = 'N/A';
	if ($fault_rec[2] ne '') {
		# Closed ticket
		$is_open = 0;
		$is_closed = 1;
		$close_time = $fault_rec[2];
	};

	# Check if user has access through st_faults_users_rel and if yes, check access rights
	my $rw = 1;
	$dst = "SELECT write_perm FROM st_faults_users_rel WHERE fault_id = $fault_id AND user_id = $zdata[0]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) { 
		@tmp = $sth->fetchrow_array;
		if ($tmp[0] == 0) {
			$rw = 0;
		};
	}; 
	if (($rw == 0) and ($zdata[5] == 0)) {
		# Quick hack - closed tickets are ro, so if the user has no write permission
		# use the is_open flag to prevent write. *_mc's must not be affected.
		$is_open = 0;
	};

	my $idcolor=$cellcolor;
	if ($fault_rec[24]) { $idcolor=$lockedcolor; };
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor>Description: </TD><TD BGCOLOR=$idcolor COLSPAN=3><CENTER>";
	print $fault_rec[0];
	print "</CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor>SR number:</TD><TD BGCOLOR=$cellcolor><CENTER><B>#$fault_id</B></CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor>SR type:</TD><TD BGCOLOR=$cellcolor>$fault_rec[11]</TD></TR><TR><TD BGCOLOR=$headcellcolor>Company: </TD><TD BGCOLOR=$cellcolor>";
	print $fault_rec[6] . " (<A HREF=\"$cgipath/st_companies.pl?5+0+$fault_rec[17]+$fault_id\" TITLE=\"Phone: $fault_rec[14]\">" . $fault_rec[5] . "</A>)</TD><TD BGCOLOR=$headcellcolor>Owner: </TD><TD BGCOLOR=$cellcolor>";
	print "<A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$fault_rec[7]\" TITLE=\"Phones: $fault_rec[15] $fault_rec[16]\">$fault_rec[3]</A></TD></TR><TR>";
	print "<TD BGCOLOR=$headcellcolor>SR Creation date: </TD><TD BGCOLOR=$cellcolor>" . st_lib::datetostr($fault_rec[1]) . "</TD>";
	print "<TD BGCOLOR=$headcellcolor>SR Closing date: </TD><TD BGCOLOR=$cellcolor>" . st_lib::datetostr($close_time) . "</TD>";
	print "</TR><TR>";
	# Find level
	$dst = "SELECT fl.name FROM st_faultlevels fl INNER JOIN st_level_of_fault lf ON lf.faultlevel_id = fl.id WHERE lf.id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	@tmp = $sth->fetchrow_array;
	print "<TD BGCOLOR=$headcellcolor>SR severity: </TD><TD BGCOLOR=$cellcolor>" . $tmp[0];
#	if (($zdata[5] == 1) and ($is_open) and ($fbupr == 2)) {
	if (($is_open) and ($fbupr == 2)) {
		# *_mc can assign new fault level.
		push @{ $menulabels[2] }, '[Change SR severity]';
		push @{ $menulinks[2] }, "$cgipath/st_faults.pl?6+$fault_id";
	};
	print "</TD>";
	my $cufn = 'N/A';
	if ($fault_rec[4] ne '') {
		$dst = "SELECT fullname, phone1, phone2 from st_users where id = $fault_rec[4]";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@tmp = $sth->fetchrow_array;
		$cufn = "<A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$fault_rec[4]\" TITLE=\"Phones: $tmp[1] $tmp[2]\">$tmp[0]</A>";
		
	};
	print "<TD BGCOLOR=$headcellcolor>SR Closed by: </TD><TD BGCOLOR=$cellcolor>" . $cufn . "</TD>";
	print "</TR><TR>";

	# Find status
	$dst = "SELECT fs.name, fs.id FROM st_faultstatus fs INNER JOIN st_status_of_fault sf ON sf.faultstatus_id = fs.id WHERE sf.id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	@tmp = $sth->fetchrow_array;
	my $fault_status_id = $tmp[1];
	print "<TD BGCOLOR=$headcellcolor>SR status: </TD><TD BGCOLOR=$cellcolor>" . $tmp[0];
#	if (($zdata[3] == 1) and ($zdata[5] == 1) and ($is_open) and ($fault_status_id > 0) and ($fbupr == 2)) { # Unassigned and closed faults are < 1
	if (($is_open) and ($fault_status_id > 0) and ($fbupr == 2)) { # Unassigned and closed faults are < 1
		# clients_mc and techs can change fault status.
		push @{ $menulabels[2] }, '[Change SR status]';
		push @{ $menulinks[2] }, "$cgipath/st_faults.pl?7+$fault_id";
	};
	print "</TD>";

	# Find tech.
	$dst = "SELECT u.fullname, u.id, u.phone1, u.phone2 FROM st_users u INNER JOIN st_tech_of_fault tf ON tf.assigned_to_user_id = u.id WHERE tf.id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	@tmp = $sth->fetchrow_array;
	# Keep that for later.
	my $assigned_tech = $tmp[1];

	print "<TD BGCOLOR=$headcellcolor>Customer Service Engineer: </TD><TD BGCOLOR=$cellcolor>" . "<A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$tmp[1]\" TITLE=\"Phones: $tmp[2] $tmp[3]\">$tmp[0]</A>";
	if (($zdata[3] == 1) and ($zdata[5] == 1) and ($is_open) and ($fbupr == 2)) {
		# techs_mc can assign faults to techs.

		push @{ $menulabels[0] }, '[Assign to CSE]';
		push @{ $menulinks[0] }, "$cgipath/st_faults.pl?5+$fault_id";

	};
	if (($zdata[3] == 1) and ($zdata[5] == 1)  and ($fbupr == 2) and ($is_closed) ) {
		# Can also cancel fault in any moment (even closed - ONLY closed).
		push @{ $menulabels[3] }, '[Cancel SR]';
		push @{ $menulinks[3] }, "$cgipath/st_faults.pl?16+$fault_id";
	};

	print "</TD></TR>";
	# Print TAC and RMA fields.

	print "<TR><TD BGCOLOR=$headcellcolor>TAC number: </TD><TD BGCOLOR=$cellcolor>$fault_rec[9]</TD>";
	print "<TD BGCOLOR=$headcellcolor>RMA number: </TD><TD BGCOLOR=$cellcolor>$fault_rec[10]</TD></TR>";
	
	# If this is a closed case and the user is a client and no survey exists and the type of fault has a survey 
	# assigned, ask for it through status line.
	# If this is a closed case and the user is a tech and  survey exists, add a link to it in buttons line.
	$dst = "SELECT * FROM st_surv2types WHERE type_id = $fault_rec[12]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my $type_has_survey = 1;
	if ($sth->rows == 0) {
		$type_has_survey = 0;
	};

	my $survey_found;
	if ($fault_rec[13] == 1) {
		$survey_found = 1;
	} else {
		$survey_found = 0;
	};
	if (($is_closed) and ($type_has_survey) and ($zdata[3] == 0) and ($zdata[2] == 1) and (not($survey_found))) {
		$status_color = 'YELLOW';
		$status_line = "<A HREF=\"$cgipath/st_faults.pl?14+$fault_id\">Please fill out our satisfaction survey about this case.</A>";
	};
	if (($is_closed) and ($type_has_survey) and ($zdata[3] == 1) and ($survey_found)) {
		push @{ $menulabels[3] }, '[Display survey]';
		push @{ $menulinks[3] }, "$cgipath/st_faults.pl?15+$fault_id";
	};


	# Extra manual timestamp fields - These fields (and the link to update them) appear only if the manual_dates 
	# field in st_faulttypes is true.
	my $manual_dates = 0;
	my $manual_fields_ok = 0;
	if ($fault_rec[21] == 1) {
		# Display 3 extra fields.
		print "<TR><TD BGCOLOR=$headcellcolor>Reported: </TD><TD BGCOLOR=$cellcolor>" . st_lib::datetostr($fault_rec[18]) . "</TD>";
		print "<TD BGCOLOR=$headcellcolor>Responce: </TD><TD BGCOLOR=$cellcolor>" . st_lib::datetostr($fault_rec[19]) . "</TD></TR>";
		print "<TR><TD BGCOLOR=$headcellcolor>Resolution: </TD><TD BGCOLOR=$cellcolor COLSPAN=3>" . st_lib::datetostr($fault_rec[20]) . "</TD></TR>";
		# Notify the menu code to add another menu link.
		$manual_dates = 1;
		# Two more SLA fields - display them only if != ''
		if ($fault_rec[22] ne '') {
			print "<TR><TD BGCOLOR=$headcellcolor>Actions taken: </TD><TD BGCOLOR=$cellcolor COLSPAN=3>" . $fault_rec[22] . "</TD></TR>";
		};
		if ($fault_rec[23] ne '') {
			print "<TR><TD BGCOLOR=$headcellcolor>SLA fail comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=3>" . $fault_rec[23] . "</TD></TR>";
		};
	};
	

	# If users appear in st_faults_users_rel, add one more line.
	$dst = "SELECT u.fullname, r.write_perm, u.phone1, u.phone2, u.id 
		FROM st_faults_users_rel r INNER JOIN st_users u ON r.user_id = u.id
		WHERE r.fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		my $lcntr = 0;
		my $rel_users = '';
		my $sep = '';
		while (@row_ary = $sth->fetchrow_array) {
			if ($lcntr > 0) {
				$sep = ',';
			};
			$lcntr++;
			if ($row_ary[1] == 1) {
				$rel_users = $rel_users . "$sep <A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$row_ary[4]\" TITLE=\"Phones: $row_ary[2] $row_ary[3]\"><B>$row_ary[0]</B></A>";
			} else {
				$rel_users = $rel_users . "$sep <A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$row_ary[4]\" TITLE=\"Phones: $row_ary[2] $row_ary[3]\">$row_ary[0]</A>";
			};
		};
		print "<TR><TD BGCOLOR=$headcellcolor>Related users: </TD><TD BGCOLOR=$cellcolor COLSPAN=3>$rel_users</TD></TR>";
	};

	# If non-deleted files appear in st_files, add one more row:
	$dst = "SELECT id, filename, size 
		FROM st_files
		WHERE fault_id = $fault_id
		AND delete_time IS NULL";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		my $lcntr = 0;
		my $rel_files = '';
		my $sep = '';
		while (@row_ary = $sth->fetchrow_array) {
			if ($lcntr > 0) {
				$sep = ',';
			};
			$lcntr++;
			$rel_files = $rel_files . "$sep <A HREF=\"$cgipath/st_sendfile.pl?0+$row_ary[0]\">$row_ary[1] ($row_ary[2] bytes)</A>";
		};
		print "<TR><TD BGCOLOR=$headcellcolor>Related files: </TD><TD BGCOLOR=$cellcolor COLSPAN=3>$rel_files</TD></TR>";
	};

	# If relations appear in st_f2f, add one more row:
	$dst = "SELECT target_fault_id 
		FROM st_f2f
		WHERE source_fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		my $lcntr = 0;
		my $rel_faults = '';
		my $sep = '';
		while (@row_ary = $sth->fetchrow_array) {
			if ($lcntr > 0) {
				$sep = ',';
			};
			$lcntr++;
			$rel_faults = $rel_faults . "$sep <A HREF=\"$cgipath/st_faults.pl?4+$row_ary[0]\">#$row_ary[0]</A>";
		};
		print "<TR><TD BGCOLOR=$headcellcolor>Related SRs: </TD><TD BGCOLOR=$cellcolor COLSPAN=3>$rel_faults</TD></TR>";
	};

	# Print status line
	print "<TR><TD BGCOLOR=$status_color COLSPAN=4><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";

	# Print buttons line
	# Add logs button
	push @{ $menulabels[3] }, '[SR logs]';
	push @{ $menulinks[3] }, "$cgipath/st_faults.pl?19+$fault_id";
	# Add Service Reports button.
	if (($zdata[3] == 1)  and ($fbupr == 2)) {
		push @{ $menulabels[1] }, '[Service Reports Management]';
		push @{ $menulinks[1] }, "$cgipath/st_faults.pl?20+$fault_id+0";
	};
	# Add files management button.
	push @{ $menulabels[1] }, '[Files management]';
	push @{ $menulinks[1] }, "$cgipath/st_faults.pl?17+$fault_id";

	if (($is_open) and ($fbupr == 2)) {
		# Add related users button
		push @{ $menulabels[1] }, '[Related users Management]';
		push @{ $menulinks[1] }, "$cgipath/st_faults.pl?10+$fault_id+$fault_rec[7]+$assigned_tech+0";

		# Add related faults button
		push @{ $menulabels[1] }, '[Related SRs Management]';
		push @{ $menulinks[1] }, "$cgipath/st_faults.pl?22+$fault_id";

		# Add new comment button.
		push @{ $menulabels[0] }, '[New log entry]';
		push @{ $menulinks[0] }, "$cgipath/st_faults.pl?9+$fault_id";


		if ($fault_status_id > 0) { 
			# Add this button only if the ticket has been assigned.
			# Add close button
			if (($zdata[3] == 1) or ($zdata[5] == 1)) {
				# All techs and client mc's can close a ticket.
				push @{ $menulabels[3] }, '[Close SR]';
				push @{ $menulinks[3] }, "$cgipath/st_faults.pl?8+$fault_id";
			};
		};

		# Add RMA and TAC buttons for techs.
		if ($zdata[3] == 1) {
			push @{ $menulabels[2] }, '[TAC number]';
			push @{ $menulinks[2] }, "$cgipath/st_faults.pl?12+$fault_id";
			push @{ $menulabels[2] }, '[RMA number]';
			push @{ $menulinks[2] }, "$cgipath/st_faults.pl?13+$fault_id";
		};
		# Add manual dates button for techs.
		if (($zdata[3] == 1) and ($manual_dates == 1)) {
			push @{ $menulabels[2] }, '[Manual dates]';
			push @{ $menulinks[2] }, "$cgipath/st_faults.pl?25+$fault_id";
		};
	};
	# Add refresh button
	push @{ $menulabels[3] }, '[Refresh SR]';
	push @{ $menulinks[3] }, "$cgipath/st_faults.pl?4+$fault_id";
	# Add printer friently button
	push @{ $menulabels[3] }, '[Printable]';
	push @{ $menulinks[3] }, "$cgipath/st_faults.pl?24+$fault_id";
	# If non-confidential and user has write access and is tech mc, add confidential button.
	if ((not($fault_rec[24])) and ($fbupr == 2) and (($zdata[3] == 1) and ($zdata[5] == 1))) {
		push @{ $menulabels[0] }, '[Confidential]';
		push @{ $menulinks[0] }, "$cgipath/st_faults.pl?26+$fault_id";
	};

#	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=4>$buttons_line</CENTER></TD></TR>";

	st_lib::st_print_menu(\@menulabels, \@menulinks);
	
	# Print message log
	$dst = "SELECT ml.description, ml.log_time, u.fullname FROM st_faultsmsglog ml
		INNER JOIN st_users u ON ml.logged_by_user_id = u.id
		WHERE ml.fault_id = $fault_id
		ORDER BY ml.log_time DESC";
	$sth = $dbh->prepare($dst);
		
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	while (@tmp = $sth->fetchrow_array) { 
		# Substitutions to avoid XSS attacks.
		$tmp[0]=~s/&/&#38;/g;
		$tmp[0]=~s/\(/&#40;/g;
		$tmp[0]=~s/\)/&#41;/g;
		$tmp[0]=~s/</&lt;/g;
		$tmp[0]=~s/>/&gt;/g;
		# Display newlines somehow.
		$tmp[0]=~s/\n/<br>/g;
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=4><B>$tmp[2]</B><br><I>" . st_lib::datetostr($tmp[1]) . "</I><P>$tmp[0]</TD></TR>";
	};
	print "</TABLE>";
} elsif ($action == 5) {
	# Tech assignment 
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);

	# Fill dropdown with techs.
	if ($cse_sort == 1) {
		$dst = "SELECT u.id, u.fullname, null_to_zero(fp.sr_count) 
			FROM (st_users u LEFT JOIN st_fpt fp ON u.id = fp.user_id)
			WHERE technician = \'t\'
			AND active = \'t\'
			AND u.userlevel_id = 0
			ORDER BY 3 ASC, u.fullname";
	} else {
		$dst = "SELECT u.id, u.fullname, null_to_zero(fp.sr_count) 
			FROM (st_users u LEFT JOIN st_fpt fp ON u.id = fp.user_id)
			WHERE technician = \'t\'
			AND active = \'t\'
			AND u.userlevel_id = 0
			ORDER BY u.fullname";
	};
	$sth = $dbh->prepare($dst);
		
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		if ($lrow[2] eq '') {$lrow[2] = 0}; 
		push @values, $lrow[0];
		$labels{ $lrow[0] } = "$lrow[1] ($lrow[2] SRs)";
	};

	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+0",
				 -name=>'searchform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New CSE: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'user_id',
                               	 -values=>\@values,
                               	 -labels=>\%labels,
				 -default=>'');
	print "</TD></TR><TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD></TR></TABLE>";
} elsif ($action == 6) {
	# Level change 
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);

	# Fill dropdown with levels.
	$dst = "SELECT id, name, description FROM st_faultlevels";
	$sth = $dbh->prepare($dst);
		
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		push @values, $lrow[0];
		$labels{ $lrow[0] } = $lrow[1] . " (" . $lrow[2] . ")";
	};

	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+1",
				 -name=>'searchform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New SR severity level: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'faultlevel_id',
                               	 -values=>\@values,
                               	 -labels=>\%labels,
				 -default=>'');
	print "</TD></TR><TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD></TR></TABLE>";
} elsif ($action == 7) {
	# Status change 
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);

	# Fill dropdown with levels.
	$dst = "SELECT id, name, description FROM st_faultstatus WHERE id > 0"; # Keep closed and unassigned status out of list
	$sth = $dbh->prepare($dst);
		
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	while (@lrow = $sth->fetchrow_array) {
		push @values, $lrow[0];
		$labels{ $lrow[0] } = $lrow[1] . " (" . $lrow[2] . ")";
	};

	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+2",
				 -name=>'searchform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New SR status: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->popup_menu(-name=>'faultstatus_id',
                               	 -values=>\@values,
                               	 -labels=>\%labels,
				 -default=>'');
	print "</TD></TR><TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD></TR></TABLE>";

} elsif ($action == 8) {
	# Close ticket
	my $fault_id = $chooserlist[1];
	print "<P><CENTER><H2>Confirm SR close transaction?</H2></CENTER><br><CENTER><B><H3><FONT COLOR=RED>Warning:</FONT></B>This transaction cannot be undone.</H3><P>";
	print "<H2><A HREF=\"$cgipath/st_faults.pl?4+$fault_id+3\"><FONT COLOR=RED>[Yes]</FONT></A> ";
	print "<A HREF=\"$cgipath/st_faults.pl?4+$fault_id+4\"><FONT COLOR=GREEN>[No]</FONT></A> ";
} elsif ($action == 9) {
	# Add new comment
	my $fault_id = $chooserlist[1];
	my @tmp;
	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+5",
				 -name=>'searchform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New log entry: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textarea(-name=>'descrtext',
				-rows=>5,
				-columns=>60);
	print "</CENTER></TD>";
	print "</TR><TR><TD BGCOLOR=$cellcolor COLSPAN=4><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</TR></TABLE>";

} elsif ($action == 10) {
	# Related users management
	my $fault_id = $chooserlist[1];
	my $log_user_id = $chooserlist[2]; 
	my $tech_user_id = $chooserlist[3]; 
	my $extra_action = $chooserlist[4]; 
	my $status_color = $cellcolor;
	my $status_line = '-';
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { 
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
		exit;
	};

	# Do things...
	if ($extra_action == 1) {
		# Remove users from fault.
		if ($fbupr < 2) { 
			# Deny access, but don't tell exactly why... >:-)
			print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
			print "Code 404";
			print $query->end_html;
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
			exit;
		};

		my %fields = $query->Vars();
		my $fn;
		$dbh->commit;
		my @deletedusers;
DELETELOOP: 	foreach $fn (keys(%fields)) {
			if ($fn ne 'deletebutton') {
				$dst = "DELETE FROM st_faults_users_rel WHERE user_id = $fn AND fault_id = $fault_id";
				$sth = $dbh->prepare($dst);
				$sth->execute;
				if (defined($sth->err)) {
					$status_color = 'RED';
					$status_line = $sth->errstr;
					$dbh->rollback;
					last DELETELOOP;
				};
				push @deletedusers, $fn;
			};
		};
		if ($status_color ne 'RED') {
			$status_color = 'GREEN';
			$status_line = 'Removal transaction successfull.';
			$dbh->commit;
			# Send mails.
			st_mail::mail_routine($dbh, $fault_id, 8, \@deletedusers);
		};
	} elsif ($extra_action == 2) {
		# Add user to fault.
		if ($fbupr < 2) { 
			# Deny access, but don't tell exactly why... >:-)
			print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
			print "Code 404";
			print $query->end_html;
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
			exit;
		};

		my $new_uid = $query->param('user_id');
		my $write_perm = $query->param('write_perm');
		if ($new_uid > 0) {
			my @user;
			push @user, $new_uid;
			$dst = "INSERT INTO st_faults_users_rel(user_id, fault_id, write_perm) 
				VALUES($new_uid, $fault_id, \'$write_perm\')";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) {
				$status_color = 'RED';
				$status_line = $sth->errstr;
				$dbh->rollback;
			} else {
				$status_color = 'GREEN';
				$status_line = 'Addition transaction successfull.';
				$dbh->commit;
				# Send mails.
				st_mail::mail_routine($dbh, $fault_id, 7, \@user);
			};
		} else {
			$status_color = 'YELLOW';
			$status_line = '<FONT COLOR=RED>Please select a user!</FONT>'; 
		};

	} elsif ($extra_action == 0) {
		# Nothing.
	} else {
		# Just print a warning.
		$status_color = 'YELLOW';
		$status_line = "Warning: invalid extra action |$extra_action|, assuming 0.";
	};

	print "<TABLE>";
	# First, check existing relations 
	$dst = "SELECT r.user_id, r.write_perm, u.fullname, v.companyname, v.company_id
		FROM (st_faults_users_rel r 
			INNER JOIN st_users u ON r.user_id = u.id)
			INNER JOIN st_user_company_id_v v ON v.user_id = u.id
		WHERE r.fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		# Print list form with remove checkboxes
		my %naioxi = (
				0 => 'No',
				1 => 'Yes'
				);
		print $query->start_form(-method=>'POST',
                	                 -action=>"$cgipath/st_faults.pl?10+$fault_id+$log_user_id+$tech_user_id+1",
					 -name=>'removeform',
                                	 -enctype=>$sencoding);
		print "<TR><TD BGCOLOR=$headcellcolor>User</TD><TD BGCOLOR=$headcellcolor>Edit permission</TD><TD BGCOLOR=$headcellcolor>Remove</TD></TR>";
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor>$row_ary[2] ($row_ary[3])</TD>";
			print "<TD BGCOLOR=$cellcolor>" . $naioxi{ $row_ary[1] } . "</TD>";
			print "<TD BGCOLOR=$cellcolor>";
			if (($zdata[3] == 1) or (($zdata[8] == $row_ary[4]) and ($zdata[5] == 1))) {
				# Clients can remove only own company's users. Only MCs.
				print $query->checkbox(-name => $row_ary[0], -value => 'ON', -label => '');
			};
			print "</TD></TR>";
		};
		print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=2></TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->submit('deletebutton', 'Remove selected users');
		print $query->endform;
		print "</CENTER></TD></TR>";
	};
	# Print add form
	if (($zdata[3] == 1) and ($zdata[5] == 1)) {
		# techs_mc can add any user from own and client's company
		$dst = "SELECT company_id FROM st_faults_companies_v
			WHERE id = $fault_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		my @tmp = $sth->fetchrow_array;
		my $fault_cid = $tmp[0];

		$dst = "SELECT u.id, u.fullname, v.companyname 
			FROM st_users u INNER JOIN st_user_company_id_v v
					ON u.id = v.user_id
			WHERE 	((v.company_id = $zdata[8]) OR (v.company_id = $fault_cid))
			AND	u.id != $log_user_id
			AND	u.id != $tech_user_id
			AND 	u.active = 't'
			AND 	u.id NOT IN (SELECT user_id FROM st_faults_users_rel r WHERE fault_id = $fault_id)
			ORDER BY u.fullname";
	} else {
		# Only users from the same company
		$dst = "SELECT u.id, u.fullname, v.companyname 
			FROM st_users u INNER JOIN st_user_company_id_v v
					ON u.id = v.user_id
			WHERE 	v.company_id = $zdata[8]
			AND 	u.id != $log_user_id
			AND	u.id != $tech_user_id
			AND 	u.active = 't'
			AND 	u.id NOT IN (SELECT user_id FROM st_faults_users_rel r WHERE fault_id = $fault_id)
			ORDER BY u.fullname";
	};
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		# Print form only when users exist.
		print $query->start_form(-method=>'POST',
       	        	                 -action=>"$cgipath/st_faults.pl?10+$fault_id+$log_user_id+$tech_user_id+2",
					 -name=>'addform',
       	                        	 -enctype=>$sencoding);
		print "<TR><TD BGCOLOR=$headcellcolor>Select user: </TD><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
		my (@values, %labels, @lrow);
		while (@lrow = $sth->fetchrow_array) {
			push @values, $lrow[0];
			$labels{ $lrow[0] } = "$lrow[1] ($lrow[2])";
		};
		# Add empty selection with userid = 0
		push @values, 0;
		$labels{ 0 } = '<please select>';
		print $query->popup_menu(-name=>'user_id',
       		                         -values=>\@values,
					 -default=>0,
       		                         -labels=>\%labels);
		print "</CENTER></TD>";
		print "</TR><TR>";
		print "<TD BGCOLOR=$headcellcolor>Edit permission? </TD><TD BGCOLOR=$cellcolor><CENTER>";
		my %rblabels;
		$rblabels{ 't' } = 'Yes';
		$rblabels{ 'f' } = 'No';
		print $query->radio_group(-name=>'write_perm',
						-values=>['t','f'],
						-default=>'f',
						-labels=>\%rblabels);
		print "</CENTER></TD><TD BGCOLOR=$cellcolor><CENTER>";
		print $query->submit('submitbutton', 'Submit');
		print $query->endform;
		print "</CENTER></TD>";	
		print "</TR>";
	};
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER><A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">Return to SR</A></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$status_color COLSPAN=3><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR></TABLE>";
} elsif ($action == 11) {
	# Statistics. Client version, only own company faults.

	# Queries and labels hash
	my %queries = (
		'1' => "SELECT count(*) FROM st_faults_companies_v WHERE company_id = $zdata[8]",
		'2' => "SELECT count(*) FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE v.company_id = $zdata[8]
		 AND f.end_time IS NULL", 
		'3' => "SELECT count(*) FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE v.company_id = $zdata[8]
		 AND f.end_time IS NOT NULL",
		'4' => "SELECT max(f.end_time - f.start_time) 
		 FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE f.end_time IS NOT NULL
		 AND v.company_id = $zdata[8]",
		'5' => "SELECT min(f.end_time - f.start_time) 
		 FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE f.end_time IS NOT NULL
		 AND v.company_id = $zdata[8]",
		'6' => "SELECT avg(f.end_time - f.start_time) 
		 FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE f.end_time IS NOT NULL
		 AND v.company_id = $zdata[8]",
		'7' => "SELECT max(now() - f.start_time) 
		 FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE f.end_time IS NULL
		 AND v.company_id = $zdata[8]",
		'8' => "SELECT min(now() - f.start_time) 
		 FROM st_faults f 
		 INNER JOIN st_faults_companies_v v 
		 ON f.id = v.id 
		 WHERE f.end_time IS NULL
		 AND v.company_id = $zdata[8]",
		);

	my %labels = (
		'1' => 'Total SR number',
		'2' => 'Total open SR number',
		'3' => 'Total closed SR number',
		'4' => 'Maximum completion time',
		'5' => 'Minimum completion time',
		'6' => 'Average completion time',
		'7' => 'Oldest open SR age',
		'8' => 'Newest open SR age',
		);
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER><B><H3>Company statistics</H3></B></CENTER></TD></TR><TR>";
	my @tmp;
	my $cnt = 0;
	my $kn;
	foreach $kn (sort keys(%queries)) { 
		$cnt++;
		$dst = $queries{ $kn };
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@tmp = $sth->fetchrow_array;
		my $rest;
		($tmp[0], $rest) = split '\.', $tmp[0], 2; # Quick hack to get rid of picoseconds if value is a timestamp.
		print "<TD BGCOLOR=$headcellcolor>" . $labels{ $kn } . "</TD><TD BGCOLOR=$cellcolor><CENTER><B>$tmp[0]</B></CENTER></TD>";
		if (($cnt % 2) == 0) {
			print "</TR><TR>";
		};
	};
	if ($cnt % 2) {
		print "<TD BGCOLOR=$headcellcolor COLSPAN=2></TD>";
	};
	# Now details by location. Find locations and loop through them.
	print "<TD BGCOLOR=$headcellcolor COLSPAN=4><B><H3><CENTER>Statistics by location</CENTER></H3></B></TD></TR>";
	$dst = "SELECT id, name, description, address1, address2, address3 FROM st_companieslocations WHERE company_id = $zdata[8]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @locationarr;
	while (@locationarr = $sth->fetchrow_array) {
		my %queries = (
			'1' => "SELECT count(*) FROM st_faults WHERE companylocation_id = $locationarr[0]",
			'2' => "SELECT count(*) FROM st_faults WHERE companylocation_id = $locationarr[0] AND end_time IS NULL", 
			'3' => "SELECT count(*) FROM st_faults WHERE companylocation_id = $locationarr[0] AND end_time IS NOT NULL",
			'4' => "SELECT max(end_time - start_time) FROM st_faults WHERE end_time IS NOT NULL AND companylocation_id = $locationarr[0]",
			'5' => "SELECT min(end_time - start_time) FROM st_faults WHERE end_time IS NOT NULL AND companylocation_id = $locationarr[0]",
			'6' => "SELECT avg(end_time - start_time) FROM st_faults WHERE end_time IS NOT NULL AND companylocation_id = $locationarr[0]",
			'7' => "SELECT max(now() - start_time) FROM st_faults WHERE end_time IS NULL AND companylocation_id = $locationarr[0]",
			'8' => "SELECT min(now() - start_time) FROM st_faults WHERE end_time IS NULL AND companylocation_id = $locationarr[0]",
			);
	
		my %labels = (
			'1' => 'Total faults number',
			'2' => 'Total open faults number',
			'3' => 'Total closed faults number',
			'4' => 'Maximum completion time',
			'5' => 'Minimum completion time',
			'6' => 'Average completion time',
			'7' => 'Oldest open fault age',
			'8' => 'Newest open fault age',
			);
		print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER><B>$locationarr[1] ($locationarr[2])</B><br><I>$locationarr[3] $locationarr[4] $locationarr[5]</I></TD></TR><TR>";
		my @tmp;
		my $cnt = 0;
		my $kn;
		my $lsth;
		foreach $kn (sort keys(%queries)) { 
			$cnt++;
			$dst = $queries{ $kn };
			$lsth = $dbh->prepare($dst);
			$lsth->execute;
			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			@tmp = $lsth->fetchrow_array;
			my $rest;
			($tmp[0], $rest) = split '\.', $tmp[0], 2; # Quick hack to get rid of picoseconds if value is a timestamp.
			print "<TD BGCOLOR=$headcellcolor>" . $labels{ $kn } . "</TD><TD BGCOLOR=$cellcolor><CENTER><B>$tmp[0]</B></CENTER></TD>";
			if (($cnt % 2) == 0) {
				print "</TR><TR>";
			};
		};
		if ($cnt % 2) {
			print "<TD BGCOLOR=$headcellcolor COLSPAN=2></TD>";
		};
	};

	
	
	print "</TR>";
	
	$sth->finish;
} elsif ($action == 12) {
	# TAC number change 
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);

	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+6",
				 -name=>'updateform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New TAC number: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'tac_num',
				-size=>20,
				-maxlength=>80);
	print "</TD></TR><TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD></TR></TABLE>";
} elsif ($action == 13) {
	# RMA number change 
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);

	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+7",
				 -name=>'updateform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>New RMA number: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'rma_num',
				-size=>20,
				-maxlength=>80);
	print "</TD></TR><TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD></TR></TABLE>";
} elsif ($action == 14) {
	# Survey form
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);
	if ($zdata[3] == 1) {
		# This is tech, not allowed to answer surveys.
		print "<H3><FONT COLOR=RED>You are not authorized!</FONT></H3><P>";
		print "<A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">[Return to SR]</A>";
	} else {
		print $query->start_form(-method=>'POST',
      			                 -action=>"$cgipath/st_faults.pl?4+$fault_id+8",
					 -name=>'updateform',
       		                         -enctype=>$sencoding);
		print "<CENTER><TABLE>";
		# Find fault's type.
		$dst = "SELECT faulttype_id, end_time FROM st_faults WHERE id = $fault_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@tmp = $sth->fetchrow_array;
		# Keep closed status
		my $is_closed = 0;
		if ($tmp[1] ne '') {
			$is_closed = 1;
		};
		# Find type's survey id.
		$dst = "SELECT surv_id FROM st_surv2types WHERE type_id = $tmp[0]";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@tmp = $sth->fetchrow_array;
		# Find questions
		$dst = "SELECT id, type, qu_text, value1, value2 FROM st_surv_design
			WHERE surv_id = $tmp[0]";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		# Got the questions, print the form.
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$headcellcolor>$row_ary[2]</TD>";
			if ($row_ary[1] eq 'num') {
				# Numeric - Radio buttons.
				my $cntr = $row_ary[3];
				# Prepare labels etc.
				my (@values, %labels);
				while ($cntr <= $row_ary[4]) {
					push @values, $cntr;
					$labels{$cntr} = $cntr;
					$cntr++;
				};
				my $name = 'QU' . $row_ary[0];
				print "<TD BGCOLOR=$cellcolor><CENTER>";
			        print $query->radio_group(-name=>$name,
       	                             -values=>\@values,
       	                             -default=>'-',
       	                             -labels=>\%labels);
				print "</CENTER></TD></TR>";
			} elsif ($row_ary[1] eq 'txt') {
				# Text - Text area
				my $name = 'QU' . $row_ary[0];
				print "<TD BGCOLOR=$cellcolor><CENTER>";
				print $query->textarea(-name=>$name,
       	                                  -rows=>$row_ary[3],
       	                                  -columns=>$row_ary[4]);
				print "</CENTER></TD></TR>";
			};
		};
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
		if ($is_closed) {
			print $query->submit('submitbutton', 'Submit');
		} else {
			print '<B><FONT COLOR=RED>The SR is not closed yet, survey cannot be submited.</FONT></B>';
		};
		print $query->endform;
		print "</CENTER></TD></TR></TABLE>";
	};
} elsif ($action == 15) {
	# Print Survey results
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);
	print "<CENTER><TABLE>";
	# Find answers
	$dst = "SELECT a.answer, q.qu_text, q.type, q.value1, q.value2
		FROM st_surv_design q INNER JOIN st_surv_answ a ON q.id = a.qu_id
		WHERE a.fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	# Got the questions, print the form.
	while (@row_ary = $sth->fetchrow_array) {
		print "<TR><TD BGCOLOR=$headcellcolor>$row_ary[1]</TD>";
		if ($row_ary[2] eq 'num') {
			# Numeric - Radio buttons.
			print "<TD BGCOLOR=$cellcolor><CENTER>";
			print "<B><H3>$row_ary[0]</H3></B> (min=$row_ary[3], max=$row_ary[4])";
			print "</CENTER></TD></TR>";
		} elsif ($row_ary[2] eq 'txt') {
			# Text - Text area
			print "<TD BGCOLOR=$cellcolor><CENTER>";
			# Substitutions to avoid XSS attacks.
			$row_ary[0]=~s/&/&#38;/g;
			$row_ary[0]=~s/\(/&#40;/g;
			$row_ary[0]=~s/\)/&#41;/g;
			$row_ary[0]=~s/</&lt;/g;
			$row_ary[0]=~s/>/&gt;/g;
			print "$row_ary[0]";
			print "</CENTER></TD></TR>";
		};
	};
	print "</CENTER></TABLE>";
} elsif ($action == 16) {
	# Cancel ticket
	my $fault_id = $chooserlist[1];
	print "<P><CENTER><H2>Confirm SR <FONT COLOR=RED><B>CANCEL</B></FONT> transaction?</H2></CENTER><br><CENTER><B><H3><FONT COLOR=RED>Warning:</FONT></B>This transaction cannot be undone.</H3><P>";
	print "<H2><A HREF=\"$cgipath/st_faults.pl?4+$fault_id+9\"><FONT COLOR=RED>[Yes]</FONT></A> ";
	print "<A HREF=\"$cgipath/st_faults.pl?4+$fault_id+10\"><FONT COLOR=GREEN>[No]</FONT></A> ";

} elsif ($action == 17) {
	# File management
	my $fault_id = $chooserlist[1];
	my $extra_action = $chooserlist[2];
	my $status_color = $cellcolor;
	my $status_line = '-';
	# Get permissions.
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { 
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
		exit;
	};
	# Do things...
	if ($extra_action == 1) {
		# Get file.
		if ($fbupr < 2) { 
			# Deny access, but don't tell exactly why... >:-)
			print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
			print "Code 404";
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
			print $query->end_html;
			exit;
		};
		# Define filename
		my $timehex = sprintf "%lx", time;
		my $idhex = sprintf "%lx", $fault_id;
		my $realfilename = $timehex . $idhex;
		my $filename = $query->param('uploaded_file');
		my $comments = $query->param('comments');
		my $insert_time = scalar localtime;
		my $uffh = $query->upload('uploaded_file');
		if (!$uffh && $query->cgi_error) {
			print "<FONT COLOR=RED><H1>" . $query->cgi_error . "</H1></FONT>";
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			print $query->end_html;
			exit;
		};

		# Check filename. 
		my @pathz = (split(/\\/,$filename));
		my $filetemp = $pathz[$#pathz];
		my @pathza = (split('/',$filetemp));
		$filename = $pathza[$#pathza];
		if ($filename eq "") {
			print "<FONT COLOR=RED><H1>The filename is invalid.</H1></FONT>";
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			print $query->end_html;
			exit;
		};
		my $fsize = 0;
		my ($bytesread, $buffer);
		st_lib::wDbg(">$filedbpath/$realfilename", "file upload");
		open (OUTFILE, ">$filedbpath/$realfilename") or die "Cannot open output file!!!";
                while ($bytesread=read($uffh,$buffer,1024)) {
			print OUTFILE $buffer;
			$fsize = $fsize + $bytesread;
		};
		# File saved, insert record.
		$dst = "INSERT INTO st_files(filename, realfilename, size, added_by, insert_time, comments, fault_id) 
			VALUES(\'$filename\', \'$realfilename\', $fsize, $zdata[0], \'$insert_time\', \'$comments\', $fault_id)";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) { 
			# Internal Error.
			$status_line = $sth->errstr;
			$status_color = 'RED';
			$dbh->rollback;
		} else {
			$status_line = 'File successfully uploaded.';
			$status_color = 'GREEN';
			$dst = "SELECT currval('st_files_id_seq')";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			@row_ary = $sth->fetchrow_array;
			my $file_id = $row_ary[0];
			$dbh->commit;
			st_mail::mail_routine($dbh, $file_id, 9);
		};
	} elsif ($extra_action == 2) {
		# Delete file from disk - Record remains.
		if ($fbupr < 2) { 
			# Deny access, but don't tell exactly why... >:-)
			print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
			print "Code 404";
			print $query->end_html;
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
			exit;
		};

		my $file_id = $chooserlist[3];
		my $error = 0;
		$dst = "SELECT filename, realfilename FROM st_files WHERE id = $file_id AND fault_id = $fault_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) { 
			# Internal Error.
			$status_line = $sth->errstr;
			$status_color = 'RED';
			$error = 1;
		}; 
		if (not($error)) {
			@row_ary = $sth->fetchrow_array;
			my $rmcnt = unlink "$filedbpath/$row_ary[1]";
			if ($rmcnt == 0) {
				$status_line = "File $row_ary[0] not deleted!";
				$status_color = 'RED';
				$error = 1;
			};
		};
		if (not($error)) {
			my $rtime = scalar localtime;
			$dst = "UPDATE st_files SET removed_by = $zdata[0], delete_time = \'$rtime\' WHERE id = $file_id AND fault_id = $fault_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$error = 1;
				$dbh->rollback;
			} else {
				$status_line = "File $row_ary[0] deleted from server.";
				$status_color = 'GREEN';
				$dbh->commit;
			}; 
		};

	} elsif ($extra_action == 3) {
		$status_line = 'File <B>NOT</B> deleted.';
		$status_color = 'GREEN';
	} elsif ($extra_action == 0) {
		# Nothing.
	} else {
		# Just print a warning.
		$status_color = 'YELLOW';
		$status_line = "Warning: invalid extra action |$extra_action|, assuming 0.";
	};

	# Check for closed fault.
	my $is_closed;
	$dst = "SELECT end_time FROM st_faults WHERE id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @tmp_arr = $sth->fetchrow_array;
	if ($tmp_arr[0] eq '') {
		$is_closed = 0;
	} else {
		$is_closed = 1;
	};
	print "<TABLE>";
	# First, print existing files 
	$dst = "SELECT f.filename, f.size, u.fullname, f.removed_by, f.insert_time, f.delete_time, f.comments, f.id, f.realfilename 
		FROM (st_files f 
			INNER JOIN st_users u ON f.added_by = u.id)
		WHERE f.fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	print "<TR><TD BGCOLOR=$headcellcolor><CENTER>Filename</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>Size (bytes)</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>Added by</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>Date</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>Comments</CENTER></TD><TD BGCOLOR=$headcellcolor></TD></TR>";
	if ($sth->rows > 0) {
		# Print list form with remove links
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor><CENTER>";
			if ($row_ary[5] eq '') {
				print "<A HREF=\"$cgipath/st_sendfile.pl?0+$row_ary[7]\">$row_ary[0]</A>";
			} else {
				print "$row_ary[0]";
			};
			# Substitutions to avoid XSS attacks.
			$row_ary[6]=~s/&/&#38;/g;
			$row_ary[6]=~s/\(/&#40;/g;
			$row_ary[6]=~s/\)/&#41;/g;
			$row_ary[6]=~s/</&lt;/g;
			$row_ary[6]=~s/>/&gt;/g;
			print "</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[1]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[2]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($row_ary[4]) . "</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[6]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>";
			if ($row_ary[5] eq '') {
				# Check if file is there.
				my $rfn = "$filedbpath/" . $row_ary[8];
				if (not(-e $rfn)) {
					print "<B><FONT COLOR=RED>ERROR: Physical file missing!</FONT></B>";
				} else {
					# Add delete link.
					print "<A HREF=\"$cgipath/st_faults.pl?18+$fault_id+$row_ary[7]\">Delete</A>";
				};
			} else {
				# Add delete info.
				my $ldst = "SELECT fullname FROM st_users WHERE id = $row_ary[3]";
				my $lsth = $dbh->prepare($ldst);
				$lsth->execute;
				if (st_lib::sthErr($sth->err, $sth->errstr)) { 
					# Internal Error.
					print $query->end_html;
					$dbh->disconnect;
					exit;
				};
				my @rr = $lsth->fetchrow_array;
				$lsth->finish;
				print "Deleted by $rr[0] at " . st_lib::datetostr($row_ary[5]);
			};
			print "</CENTER></TD></TR>";
		};
	} else {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=6><B><CENTER>No files found.</CENTER></B></TD></TR>";
	};

	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=6><CENTER><A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">Return to SR</A></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$status_color COLSPAN=6><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
	# Print add form, only if permission is ok.
	if (($fbupr == 2) and (not($is_closed))) { 
		print $query->start_multipart_form(-method=>'POST',
       			                          -action=>"$cgipath/st_faults.pl?17+$fault_id+1",
						 -name=>'fileform',
       			                          -enctype=>$sencoding);
		print "<TR><TD BGCOLOR=$headcellcolor>File path: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
       		print $query->filefield(-name=>'uploaded_file',
       		                         -default=>'',
       		                         -size=>80,
       		                         -maxlength=>255);
		print "</CENTER></TD></TR>";
		print "<TR><TD BGCOLOR=$headcellcolor>Comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
       		print $query->textfield(-name=>'comments',
       		                         -size=>80,
       		                         -maxlength=>255);
#		print "</TD><TD BGCOLOR=$headcellcolor>";
		print $query->submit('submitbutton', 'Submit');
		print "</CENTER></TD></TR>";
		print $query->endform;
	};
	print "</TABLE>";
} elsif ($action == 18) {
	# Delete file
	my $fault_id = $chooserlist[1];
	my $file_id = $chooserlist[2];
	print "<P><CENTER><H2>Confirm file delete?</H2></CENTER><br><CENTER><B><H3><FONT COLOR=RED>Warning:</FONT></B>This transaction cannot be undone.</H3><P>";
	print "<H2><A HREF=\"$cgipath/st_faults.pl?17+$fault_id+2+$file_id\"><FONT COLOR=RED>[Yes]</FONT></A> ";
	print "<A HREF=\"$cgipath/st_faults.pl?17+$fault_id+3\"><FONT COLOR=GREEN>[No]</FONT></A> ";
} elsif ($action == 19) {
	# Fault history - Display all available logs.
	my $fault_id = $chooserlist[1];
	my @tmp;
	my $status_line = '-';
	my $status_color = $cellcolor;
	my $buttons_line = "<CENTER><A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">[Return to SR]</A> ";
	my $buttons_cntr = 1;
	my $tcancelled = 0;

	# Before doing anything, check permissions.
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { # Not even readonly.
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access log of fault $fault_id without permission.", "st_faults");
		exit;
	};
	# Get fault record
	$dst = "SELECT shortdescr FROM st_faults WHERE id = $fault_id"; 
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @fault_array = $sth->fetchrow_array;
	# Substitutions to avoid XSS attacks.
	$fault_array[0]=~s/&/&#38;/g;
	$fault_array[0]=~s/\(/&#40;/g;
	$fault_array[0]=~s/\)/&#41;/g;
	$fault_array[0]=~s/</&lt;/g;
	$fault_array[0]=~s/>/&gt;/g;

	print "<TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=1><CENTER><B>SR #$fault_id:</B></CENTER></TD><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER><B>$fault_array[0]</B></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=3><CENTER><B>CSE change log</B></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor><CENTER>Assigned to</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Assigned by</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Date</CENTER></TD></TR>";
	$dst = "SELECT u1.fullname, u2.fullname, l.assign_time, l.assigned_by_user_id, l.assigned_to_user_id, u1.phone1, u1.phone2, u2.phone1, u2.phone2
		FROM (st_faultstechs l 
			INNER JOIN st_users u1 ON l.assigned_by_user_id = u1.id)
			INNER JOIN st_users u2 ON l.assigned_to_user_id = u2.id
		WHERE l.fault_id = $fault_id
		ORDER BY l.assign_time ASC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>No log records found</CENTER></TD></TR>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TD BGCOLOR=$cellcolor><CENTER><A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$row_ary[4]\" TITLE=\"Phones: $row_ary[7] $row_ary[8]\">$row_ary[1]</A></CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER><A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$row_ary[3]\" TITLE=\"Phones: $row_ary[5] $row_ary[6]\">$row_ary[0]</A></CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($row_ary[2]) . "</CENTER></TD>";
			print "</TR>";
		};	
	};
	# Severity change log.
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=3><CENTER><B>Severity change log</B></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor><CENTER>Level</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Set by</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Date</CENTER></TD></TR>";
	$dst = "SELECT u1.fullname, fl.name, l.change_time, l.changed_by_user_id, u1.phone1, u1.phone2
		FROM (st_faultslevellog l 
			INNER JOIN st_users u1 ON l.changed_by_user_id = u1.id)
			INNER JOIN st_faultlevels fl ON l.faultlevel_id = fl.id
		WHERE l.fault_id = $fault_id
		ORDER BY l.change_time ASC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>No log records found</CENTER></TD></TR>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[1]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER><A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$row_ary[3]\" TITLE=\"Phones: $row_ary[4] $row_ary[5]\">$row_ary[0]</A></CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($row_ary[2]) . "</CENTER></TD>";
			print "</TR>";
		};	
	};
	# Status change log.
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=3><CENTER><B>Status change log</B></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor><CENTER>Status</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Set by</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Date</CENTER></TD></TR>";
	$dst = "SELECT u1.fullname, fs.name, l.change_time, l.changed_by_user_id, u1.phone1, u1.phone2
		FROM (st_faultsstatuslog l 
			INNER JOIN st_users u1 ON l.changed_by_user_id = u1.id)
			INNER JOIN st_faultstatus fs ON l.faultstatus_id = fs.id
		WHERE l.fault_id = $fault_id
		ORDER BY l.change_time ASC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>No log records found</CENTER></TD></TR>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[1]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER><A HREF=\"$cgipath/st_usermanagement.pl?10+0+$fault_id+$row_ary[3]\" TITLE=\"Phones: $row_ary[4] $row_ary[5]\">$row_ary[0]</A></CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($row_ary[2]) . "</CENTER></TD>";
			print "</TR>";
		};	
	};

	# Alert mail log.
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=3><CENTER><B>Alert mail log</B></CENTER></TD></TR>";

	# SCSE mails  
	print "<TR><TD BGCOLOR=$cellcolor><CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><B>SCSE mails</B></TD></TR>";

	$dst = "SELECT last_mailx
		FROM st_mail_alerts
		WHERE 	fault_id = $fault_id
		AND 	last_mailx IS NOT NULL
		ORDER BY last_mailx DESC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor><CENTER>No log records found</CENTER></TD></TR></TABLE></TD>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TR><TD BGCOLOR=$cellcolor><CENTER><I>" . st_lib::datetostr($row_ary[0]) . "</I></CENTER></TD></TR>";
		};
		print "</TABLE></TD>";
	};

	# Duty Manager mails  
	print "<TD BGCOLOR=$cellcolor><CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><B>Duty Manager mails</B></TD></TR>";

	$dst = "SELECT last_dm_mailx
		FROM st_mail_alerts
		WHERE 	fault_id = $fault_id
		AND 	last_dm_mailx IS NOT NULL
		ORDER BY last_dm_mailx DESC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor><CENTER>No log records found</CENTER></TD></TR></TABLE></TD>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TR><TD BGCOLOR=$cellcolor><CENTER><I>" . st_lib::datetostr($row_ary[0]) . "</I></CENTER></TD></TR>";
		};
		print "</TABLE></TD>";
	};

	# Account Manager mails  
	print "<TD BGCOLOR=$cellcolor><CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><B>Account Manager mails</B></TD></TR>";

	$dst = "SELECT last_am_mailx
		FROM st_mail_alerts
		WHERE 	fault_id = $fault_id
		AND 	last_am_mailx IS NOT NULL
		ORDER BY last_am_mailx DESC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor><CENTER>No log records found</CENTER></TD></TR></TABLE></TD></TR>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TR><TD BGCOLOR=$cellcolor><CENTER><I>" . st_lib::datetostr($row_ary[0]) . "</I></CENTER></TD></TR>";
		};
		print "</TABLE></TD></TR>";
	};

	# Techical Manager mails  
	print "<TR><TD BGCOLOR=$cellcolor><CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><B>Techical Manager mails</B></TD></TR>";

	$dst = "SELECT last_tm_mailx
		FROM st_mail_alerts
		WHERE 	fault_id = $fault_id
		AND 	last_tm_mailx IS NOT NULL
		ORDER BY last_tm_mailx DESC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor><CENTER>No log records found</CENTER></TD></TR></TABLE></TD>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TR><TD BGCOLOR=$cellcolor><CENTER><I>" . st_lib::datetostr($row_ary[0]) . "</I></CENTER></TD></TR>";
		};
		print "</TABLE></TD>";
	};


	# General Manager mails  
	print "<TD BGCOLOR=$cellcolor><CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor><B>General Manager mails</B></TD></TR>";

	$dst = "SELECT last_gm_mailx
		FROM st_mail_alerts
		WHERE 	fault_id = $fault_id
		AND 	last_gm_mailx IS NOT NULL
		ORDER BY last_gm_mailx DESC";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor><CENTER>No log records found</CENTER></TD></TR></TABLE></TD>";
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR>";
			print "<TR><TD BGCOLOR=$cellcolor><CENTER><I>" . st_lib::datetostr($row_ary[0]) . "</I></CENTER></TD></TR>";
		};
		print "</TABLE></TD>";
	};

	# This cell is empty
	print "<TD BGCOLOR=$cellcolor><CENTER><H2><B>SR #$fault_id</B></H2></CENTER></TD></TR>";

	# Print status line.
	print "<TR><TD BGCOLOR=$status_color COLSPAN=3><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
	# Print buttons line.
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>$buttons_line</CENTER></TD></TR>";
	print "</TABLE>";

} elsif ($action == 20) {
	# Service Reports management
	my $fault_id = $chooserlist[1];
	my $extra_action = $chooserlist[2];
	my $status_color = 'BLACK';
	my $status_line = 'Adding new Service Report - Fill the form below.';
	my $srep_id = '';
	my $cse = 0;
	my $start_date = '';
	my $end_date = '';
	my $added_by = $zdata[0];
	# Get permissions.
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { 
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
		exit;
	};
	# Do things...
	if ($extra_action == 1) {
		# Fill fields with report info for update.
		my $old_srep_id = $chooserlist[3];
		$dst = "SELECT srep_id, start_time, end_time, added_by, onsitecse
			FROM st_sreports 
			WHERE fault_id = $fault_id AND srep_id = $old_srep_id";

		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		my @tmp_rec = $sth->fetchrow_array;
		$srep_id = $tmp_rec[0];
		$start_date = $tmp_rec[1];
		$end_date = $tmp_rec[2];
		$added_by = $tmp_rec[3];
		$cse = $tmp_rec[4];
		$status_color = 'BLACK';
		$status_line = "Updating Service Report #$srep_id";
	} elsif ($extra_action == 2) {
		# New info submited, insert or update.
		my $lsrep_id = $query->param('srep_id'); 
		my $lcse = $query->param('user_id');
		my $lstart_date = $query->param('start_date');
		my $lend_date = $query->param('end_date');
		my $tr_add = $query->param('tr_add');
		# First, check out if report already exists.
		$dst = "SELECT fault_id FROM st_sreports WHERE srep_id = $lsrep_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		my $cnt = $sth->rows;
		my $doit = 1;
		if ($tr_add eq 'yes') {
			# Insert new time record. Use srep_id, times and ignore everything else.
			$dst = "INSERT INTO st_srepxtra(srep_id, start_time, end_time)
				VALUES($lsrep_id, \'$lstart_date\', \'$lend_date\')";
			$status_line = "Time record added successfully on Service Report #$lsrep_id.";
		} elsif ($cnt == 0) {
			# Insert 
			$dst = "INSERT INTO st_sreports(srep_id, fault_id, added_by, onsitecse, start_time, end_time)
				VALUES($lsrep_id, $fault_id," . $zdata[0] . ", $lcse, \'$lstart_date\', \'$lend_date\')";
			$status_line = 'Service Report added successfully.';
		} else {
			# Update
			my @tmp_rec = $sth->fetchrow_array;
			if ($tmp_rec[0] == $fault_id) { 
				$dst = "UPDATE st_sreports SET added_by = " . $zdata[0] . ", onsitecse = $lcse,
						start_time = \'$lstart_date\', end_time = \'$lend_date\'
					WHERE srep_id = $lsrep_id AND fault_id = $fault_id"; 
				$status_line = 'Service Report successfully updated.';
			} else {
				$status_line = 'This Service Report belongs to another Service Request.';
				$status_color = 'RED';
				$doit = 0;
			};
		};
		if ($doit) {	
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) {
				# Ooops!
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_color = 'GREEN';
				$dbh->commit;
			};
		};
	} elsif ($extra_action == 3) {
		# Fill fields with report info for new time record.
		my $old_srep_id = $chooserlist[3];
		$dst = "SELECT srep_id, added_by, onsitecse
			FROM st_sreports 
			WHERE fault_id = $fault_id AND srep_id = $old_srep_id";

		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		my @tmp_rec = $sth->fetchrow_array;
		$srep_id = $tmp_rec[0];
		$added_by = $tmp_rec[1];
		$cse = $tmp_rec[2];
		$status_color = 'BLACK';
		$status_line = "Adding new time record to Service Report #$srep_id";

	} elsif ($extra_action == 4) {
		# Delete time record.
		my $tr_id = $chooserlist[3];
		my $local_srep_id = $chooserlist[4];
		# Verify data consistency. 
		$dst = "SELECT srep_id
			FROM st_sreports 
			WHERE fault_id = $fault_id AND srep_id = $local_srep_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		if ($sth->rows == 0) {
			$status_line = 'Data inconsistency detected!'; 
			$status_color = 'RED';
		} else {
			$dst = "DELETE FROM st_srepxtra WHERE tr_id = $tr_id AND srep_id = $local_srep_id ";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) {
				# Ooops!
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_color = 'GREEN';
				$status_line = 'Time record deleted.';
				$dbh->commit;
			};

		};
		
	} elsif ($extra_action == 0) {
		# Nothing.
	} else {
		# Just print a warning.
		$status_color = 'YELLOW';
		$status_line = "Warning: invalid extra action |$extra_action|, assuming 0.";
	};

	print "<TABLE>";
	# First, print existing records 
	$dst = "SELECT f.srep_id, f.start_time, f.end_time, u.fullname, u1.fullname
		FROM (st_sreports f 
			INNER JOIN st_users u ON f.added_by = u.id)
			INNER JOIN st_users u1 ON f.onsitecse = u1.id
		WHERE f.fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	print "<TR><TD BGCOLOR=$headcellcolor><CENTER>Service Report #</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>Added by</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>On site CSE</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>Start Date</CENTER></TD><TD BGCOLOR=$headcellcolor><CENTER>End Date</CENTER></TD></TR>";
	if ($sth->rows > 0) {
		# Print list form with edit links
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor><CENTER><B>$row_ary[0]</B></CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[3]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>$row_ary[4]</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($row_ary[1]) . "</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($row_ary[2]) . "</CENTER></TD>";

			# Print extra times or button to insert one.

			my $ldst = "SELECT tr_id, start_time, end_time FROM st_srepxtra WHERE srep_id = $row_ary[0]";
			my $lsth = $dbh->prepare($ldst);
			$lsth->execute;
			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			my @lrow;
			while (@lrow = $lsth->fetchrow_array) {
				# Print extra time records.
				print "<TR><TD BGCOLOR=$cellcolor></TD>";
				print "<TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
				print "<A HREF=\"$cgipath/st_faults.pl?20+$fault_id+4+$lrow[0]+$row_ary[0]\">[Delete this time record]</A></CENTER></TD>";
				print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($lrow[1]) . "</CENTER></TD>";
				print "<TD BGCOLOR=$cellcolor><CENTER>" . st_lib::datetostr($lrow[2]) . "</CENTER></TD>";

			};
			print "<TR><TD BGCOLOR=$cellcolor></TD><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
			print "<A HREF=\"$cgipath/st_faults.pl?20+$fault_id+1+$row_ary[0]\">[Edit main Service Report record]</A></CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
			print "<A HREF=\"$cgipath/st_faults.pl?20+$fault_id+3+$row_ary[0]\">[Add new time record]</A></CENTER></TD></TR>";

			# Add an empty row for clarity.
			print "<TR></TD><TD BGCOLOR=$cellcolor COLSPAN=5><FONT COLOR=WHITE>-</FONT></TD></TR>";
			



		};
	} else {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=5><B><CENTER>No Service Reports found.</CENTER></B></TD></TR>";
	};

	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER><A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">[Return to SR]</A> <A HREF=\"$cgipath/st_faults.pl?20+$fault_id+0\">[Add another Service Report]</A></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$status_color COLSPAN=5><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
	# Print add form, only if permission is ok.
	# ... and not if we just inserted or updated anything.
	if (($fbupr == 2) and ($extra_action != 2)) { 
		my (@values, %labels, @lrow, $tpref, $origtab);

		# Fill dropdown with techs.
		$dst = "SELECT u.id, u.fullname, null_to_zero(fp.sr_count) 
			FROM (st_users u LEFT JOIN st_fpt fp ON u.id = fp.user_id)
			WHERE technician = \'t\' AND active = \'t\'
			ORDER BY 3 ASC, u.fullname";
		$sth = $dbh->prepare($dst);
		
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		while (@lrow = $sth->fetchrow_array) {
			if ($lrow[2] eq '') {$lrow[2] = 0}; 
			push @values, $lrow[0];
			$labels{ $lrow[0] } = "$lrow[1] ($lrow[2] SRs)";
		};
		push @values, 0;
		$labels{ 0 } = '<none selected>';

		print $query->start_multipart_form(-method=>'POST',
       			                          -action=>"$cgipath/st_faults.pl?20+$fault_id+2",
						 -name=>'fileform',
       			                          -enctype=>$sencoding);
		print "<TR><TD BGCOLOR=$headcellcolor>Service Report #: </TD><TD BGCOLOR=$cellcolor><CENTER>";
		if (($extra_action == 1) or ($extra_action == 3)) {
       			print $query->hidden(-name=>'srep_id',
		  				-default=>$srep_id);
			print "<B>$srep_id</B>";
		} else {
       			print $query->textfield(-name=>'srep_id',
       		       		                -size=>10,
		  				-default=>$srep_id,
       		 	      	                -maxlength=>255);
		};
		print "</CENTER></TD>";
		print "<TD BGCOLOR=$headcellcolor>On Site CSE: </TD><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>";
		if ($extra_action == 3) {
			# This hidden field is used by the update routine (see extra_action = 2) to determine
			# that the user tries to add another time record and act accordingly.
       			print $query->hidden(-name=>'tr_add',
		  				-default=>'yes');
			print "<B>" . $labels{ $cse } . "</B>";

		} else {
			print $query->popup_menu(-name=>'user_id',
       	               		         	 -values=>\@values,
       	               		         	 -labels=>\%labels,
						 -default=>$added_by);
		};
		print "</CENTER></TD></TR>";
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER><I>Date format example: </I><B>Jan 10 2004 13:00</B></CENTER></TD></TR>";
		print "<TR><TD BGCOLOR=$headcellcolor>Start Date: </TD><TD BGCOLOR=$cellcolor><CENTER>";
       		print $query->textfield(-name=>'start_date',
       		                         -size=>20,
					 -default=>$start_date,
       		                         -maxlength=>255);
		print "</CENTER></TD>";
		print "<TD BGCOLOR=$headcellcolor>End Date: </TD><TD BGCOLOR=$cellcolor><CENTER>";
       		print $query->textfield(-name=>'end_date',
       		                         -size=>20,
					 -default=>$end_date,
       		                         -maxlength=>255);
		print "</CENTER></TD>";
		print "<TD BGCOLOR=$cellcolor><CENTER>";
		print $query->submit('submitbutton', 'Submit');
		print $query->endform;
		print "</CENTER></TD></TR></TABLE>";

	};
	print "</TABLE>";

} elsif ($action == 21) {
	# Personal mail preferences management. 
	my $extra_action = $chooserlist[1];
	my $status_color = $cellcolor;
	my $status_line = '-';

	my %fields = (
		1	=>	'newlogentry',
		2	=>	'severchange',
		3	=>	'statuschang',
		4	=>	'techassignm',
		5	=>	'closedfault',
		6	=>	'addnewfault',
		7	=>	'relusersadd',
		8	=>	'relusersrem',
		9	=>	'filesupload'
	);

	my %descriptions = (
		1	=>	'New Log Entry',
		2	=>	'Severity Change',
		3	=>	'Status Change',
		4	=>	'CSE Assignment',
		5	=>	'SR Closed',
		6	=>	'New SR',
		7	=>	'Related User Added',
		8	=>	'Related User Removed',
		9	=>	'New File Uploaded'
	);

	my %yesno = (
		0	=> 'No',
		1	=> 'Yes'
	);

	# Do things...
	if ($extra_action == 1) {
		# Update record 
		my %lfields = $query->Vars();
		my $fn;
		my $fitem = 1;
		my $dst = "UPDATE st_mailprefs SET ";
		foreach $fn (keys(%lfields)) {
			if (substr($fn, 0, 2) eq 'MP') {
				if (not($fitem)) { $dst = $dst . ", " } else { $fitem = 0 };
				my $cnt = substr($fn, 2);
				my $val = $query->param($fn);
				$dst = $dst . $fields{ $cnt } . "=\'" . $val . "\'";
			};
		};
		$dst = $dst . " WHERE user_id = $zdata[0]";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) {
			$status_color = 'RED';
			$status_line = $sth->errstr;
			$dbh->rollback;
		} else {
			$status_color = 'GREEN';
			$status_line = 'Update successfull.';
			$dbh->commit;
		};

	} elsif ($extra_action == 0) {
		# Nothing.
	} else {
		# Just print a warning.
		$status_color = 'YELLOW';
		$status_line = "Warning: invalid extra action |$extra_action|, assuming 0.";
	};


	print "<TABLE>";
	print $query->start_form(-method=>'POST',
       	                         -action=>"$cgipath/st_faults.pl?21+1",
				 -name=>'form1',
       	                         -enctype=>$sencoding);

	# First, print existing record
	$dst = "SELECT user_id, newlogentry,  severchange, statuschang, techassignm, closedfault, addnewfault, relusersadd, relusersrem, filesupload
		FROM st_mailprefs 
		WHERE user_id = $zdata[0]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @mailprefs;
	if ($sth->rows == 0) {
		st_lib::wDbg("DEBUG: Starting insert of default mailprefs", "st_faults");
		# Insert default record now.
		$dbh->commit;
		$dst = "INSERT INTO st_mailprefs(user_id) VALUES($zdata[0])";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->rollback;
			$dbh->disconnect;
			exit;
		} else {
			$dbh->commit;
			@mailprefs = ($zdata[0], '1', '1', '1', '1', '1', '1', '1', '1', '1');
			st_lib::wDbg("DEBUG: Insert of default mailprefs complete", "st_faults");
		};
	} else {
		st_lib::wDbg("DEBUG: Got mailprefs", "st_faults");
		@mailprefs = $sth->fetchrow_array;
	};
	print "<TR>";
	
	for ($i = 1; $i < 10; $i++) {
		print "<TD BGCOLOR=$headcellcolor><CENTER><B>" . $descriptions{ $i } . "</B></CENTER></TD><TD BGCOLOR=$cellcolor><CENTER>";
	
		print $query->radio_group(-name=>"MP$i",
					-values=>['0','1'],
					-override=>1,
					-default=>"$mailprefs[$i]",
					-labels=>\%yesno);
		print "</CENTER></TD>";
		if (($i % 2) == 0) { print "</TR><TR>" };
	};
	if (($i % 2) != 0) {
		print "</TR><TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER>"; 
	} else {
		print "<TD BGCOLOR=$cellcolor COLSPAN=4><CENTER>"; 
	};
	print $query->submit('submitbutton', 'Update');
	print "</CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$status_color COLSPAN=4><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR></TABLE>";
	print $query->endform;
} elsif ($action == 22) {
	# Relations between faults management
	my $fault_id = $chooserlist[1];
	my $extra_action = $chooserlist[2];
	my $helper_fault_id = $chooserlist[3];
	my $status_color = $cellcolor;
	my $status_line = '-';
	# Get permissions.
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { 
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
		exit;
	};
	# Do things...
	if ($extra_action == 1) {
		# Create relation.
		if ($fbupr < 2) { 
			# Deny access, but don't tell exactly why... >:-)
			print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
			print "Code 404";
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
			print $query->end_html;
			exit;
		};
		my $new_fault_id = $query->param('new_fault_id');
		# Insert record.
		$dst = "INSERT INTO st_f2f(source_fault_id, target_fault_id) 
			VALUES($fault_id, $new_fault_id)";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) { 
			# Internal Error.
			$status_line = $sth->errstr;
			$status_color = 'RED';
			$dbh->rollback;
		} else {
			$status_line = 'Relation successfully created.';
			$status_color = 'GREEN';
			$dbh->commit;
		};
	} elsif ($extra_action == 2) {
		# Delete relation.
		if ($fbupr < 2) { 
			# Deny access, but don't tell exactly why... >:-)
			print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
			print "Code 404";
			print $query->end_html;
			$dbh->disconnect;
			print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
			st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without correct permission.", "st_faults");
			exit;
		};

		$dst = "DELETE FROM st_f2f WHERE source_fault_id = $fault_id AND target_fault_id = $helper_fault_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) { 
			# Internal Error.
			$status_line = $sth->errstr;
			$status_color = 'RED';
			$dbh->rollback;
		} else {
			$status_line = "Relation deleted.";
			$status_color = 'GREEN';
			$dbh->commit;
		}; 
	} elsif ($extra_action == 3) {
		$status_line = 'Relation <B>NOT</B> deleted.';
		$status_color = 'GREEN';
	} elsif ($extra_action == 0) {
		# Nothing.
	} else {
		# Just print a warning.
		$status_color = 'YELLOW';
		$status_line = "Warning: invalid extra action |$extra_action|, assuming 0.";
	};

	# Check for closed fault.
	my $is_closed;
	$dst = "SELECT end_time FROM st_faults WHERE id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @tmp_arr = $sth->fetchrow_array;
	if ($tmp_arr[0] eq '') {
		$is_closed = 0;
	} else {
		$is_closed = 1;
	};
	print "<TABLE>";
	# First, print existing records 
	$dst = "SELECT f.shortdescr, r.target_fault_id 
		FROM (st_faults f 
			INNER JOIN st_f2f r ON f.id = r.target_fault_id)
		WHERE r.source_fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER><B>SR Description</B></CENTER></TD></TR>";
	if ($sth->rows > 0) {
		# Print list form with remove links
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor><CENTER>";
			# Substitutions to avoid XSS attacks.
			$row_ary[0]=~s/&/&#38;/g;
			$row_ary[0]=~s/\(/&#40;/g;
			$row_ary[0]=~s/\)/&#41;/g;
			$row_ary[0]=~s/</&lt;/g;
			$row_ary[0]=~s/>/&gt;/g;
			print "<A HREF=\"$cgipath/st_faults.pl?4+$row_ary[1]\">$row_ary[0]</A>";
			print "</CENTER></TD>";
			print "<TD BGCOLOR=$cellcolor><CENTER>";
			# Add delete link.
			print "<A HREF=\"$cgipath/st_faults.pl?23+$fault_id+$row_ary[1]\">(delete)</A>";
			print "</CENTER></TD></TR>";
		};
	} else {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=2><B><CENTER>No related SRs found.</CENTER></B></TD></TR>";
	};
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=2><CENTER><A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">Return to SR</A></CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$status_color COLSPAN=2><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
	# Print add form, only if permission is ok.
	if (($fbupr == 2) and (not($is_closed))) { 
		print $query->start_multipart_form(-method=>'POST',
       			                          -action=>"$cgipath/st_faults.pl?22+$fault_id+1",
						 -name=>'insertform',
       			                          -enctype=>$sencoding);
		print "<TR><TD BGCOLOR=$headcellcolor ALIGN=RIGHT><B>SR #</B>: </TD><TD BGCOLOR=$cellcolor><CENTER>";
       		print $query->textfield(-name=>'new_fault_id',
       		                         -size=>20,
					 -default=>$helper_fault_id,
       		                         -maxlength=>255);
		print "</TD></TR><TR>";
		print "<TD BGCOLOR=$cellcolor><CENTER>";
		print $query->submit('submitbutton', 'Submit');
		print "</TD>";
		print $query->endform;
		print $query->start_multipart_form(-method=>'POST',
       			                          -action=>"$cgipath/st_faults.pl?2+1+$fault_id+1",
						 -name=>'searchform',
       			                          -enctype=>$sencoding);
		print "<TD BGCOLOR=$cellcolor><CENTER>";
		print $query->submit('submitbutton', 'Search');
		print "</CENTER></TD></TR>";
	};
	print "</TABLE>";
} elsif ($action == 23) {
	# Delete relation
	my $fault_id = $chooserlist[1];
	my $target_fault_id = $chooserlist[2];
	print "<P><CENTER><H2>Confirm relation delete?</H2></CENTER><br><CENTER><B><H3><FONT COLOR=RED>Warning:</FONT></B>This transaction cannot be undone.</H3><P>";
	print "<H2><A HREF=\"$cgipath/st_faults.pl?22+$fault_id+2+$target_fault_id\"><FONT COLOR=RED>[Yes]</FONT></A> ";
	print "<A HREF=\"$cgipath/st_faults.pl?22+$fault_id+3\"><FONT COLOR=GREEN>[No]</FONT></A> ";
} elsif ($action == 24) {
	# Display fault - printer friently 
	my $fault_id = $chooserlist[1];
	my $srep_id;
	my @tmp;

	# Before doing anything, check permissions.
	my $fbupr = st_lib::fbup(\@zdata, $dbh, $fault_id);
	if ($fbupr < 1) { # Not even readonly.
		# Deny access, but don't tell exactly why... >:-)
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print "Code 404";
		print $query->end_html;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		st_lib::wDbg("SECURITY: User $zdata[0] tried to access fault $fault_id without permission.", "st_faults");
		exit;
	};

	$dst = "SELECT f.shortdescr, f.start_time, f.end_time, u.fullname, f.closed_by_user_id, cl.name, c.name, f.logged_by_user_id, f.id,
			f.tac_num, f.rma_num, ft.name, f.faulttype_id, f.survey_done, cl.phone1, u.phone1, u.phone2, cl.id,
			cl.address1 || cl.address2 || cl.address3, cl.phone1 || ' ' || cl.phone2
			FROM ((st_faults f INNER JOIN st_users u ON f.logged_by_user_id = u.id)
					  INNER JOIN st_companieslocations cl ON f.companylocation_id = cl.id)
					  INNER JOIN st_companies c ON cl.company_id = c.id
					  INNER JOIN st_faulttypes ft ON f.faulttype_id = ft.id
			WHERE f.id LIKE \'$fault_id\' ";
	if ($zdata[3] == 0) { 
		# Clients must be able to see only their own company's records.
		$dst = $dst . " AND c.id = $zdata[8] ";
	};

	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	if ($sth->rows == 0) { 
		print "<FONT COLOR=RED><H1>Service Request number non-existent.</H1></FONT>";
		print $query->end_html;
		$sth->finish;
		$dbh->disconnect;
		print "<P><A HREF=\"$cgipath/st_faults.pl?2\">[SR directory]</A>";
		exit;
	};
	
	my @fault_rec = $sth->fetchrow_array;
		# Substitutions to avoid XSS attacks.
		$fault_rec[0]=~s/&/&#38;/g;
		$fault_rec[0]=~s/\(/&#40;/g;
		$fault_rec[0]=~s/\)/&#41;/g;
		$fault_rec[0]=~s/</&lt;/g;
		$fault_rec[0]=~s/>/&gt;/g;
		$fault_rec[9]=~s/&/&#38;/g;
		$fault_rec[9]=~s/\(/&#40;/g;
		$fault_rec[9]=~s/\)/&#41;/g;
		$fault_rec[9]=~s/</&lt;/g;
		$fault_rec[9]=~s/>/&gt;/g;
		$fault_rec[10]=~s/&/&#38;/g;
		$fault_rec[10]=~s/\(/&#40;/g;
		$fault_rec[10]=~s/\)/&#41;/g;
		$fault_rec[10]=~s/</&lt;/g;
		$fault_rec[10]=~s/>/&gt;/g;
	my $fault_id = $fault_rec[8];
	my $is_open = 1;
	my $is_closed = 0; # Because is_open is used as ro flag, use that for REALLY closed tickets.
	my $close_time = 'N/A';
	if ($fault_rec[2] ne '') {
		# Closed ticket
		$is_open = 0;
		$is_closed = 1;
		$close_time = $fault_rec[2];
	};

	# Check if user has access through st_faults_users_rel and if yes, check access rights
	my $rw = 1;
	$dst = "SELECT write_perm FROM st_faults_users_rel WHERE fault_id = $fault_id AND user_id = $zdata[0]";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) { 
		@tmp = $sth->fetchrow_array;
		if ($tmp[0] == 0) {
			$rw = 0;
		};
	}; 
	if (($rw == 0) and ($zdata[5] == 0)) {
		# Quick hack - closed tickets are ro, so if the user has no write permission
		# use the is_open flag to prevent write. *_mc's must not be affected.
		$is_open = 0;
	};

	print "<TABLE BORDER=1><TR><TD>Description: </TD><TD COLSPAN=3><CENTER><B>";
	print $fault_rec[0];
	print "</B></CENTER></TD></TR>";
	print "<TR><TD>SR number:</TD><TD><CENTER><B>#$fault_id</B></CENTER></TD>";
	print "<TD>SR type:</TD><TD><B>$fault_rec[11]</B></TD></TR><TR><TD>Company: </TD><TD COLSPAN=3><B>";
	print $fault_rec[6] . " (" . $fault_rec[5] . " " .  $fault_rec[18] . " " . $fault_rec[19] . ")</B></TD></TR><TR><TD>Owner: </TD><TD COLSPAN=3>";
	print "<B>$fault_rec[3]</B></TD></TR><TR>";
	print "<TD>SR Creation date: </TD><TD><B>" . st_lib::datetostr($fault_rec[1]) . "</B></TD>";
	print "<TD>SR Closing date: </TD><TD><B>" . st_lib::datetostr($close_time) . "</B></TD>";
	print "</TR><TR>";
	# Find level
	$dst = "SELECT fl.name FROM st_faultlevels fl INNER JOIN st_level_of_fault lf ON lf.faultlevel_id = fl.id WHERE lf.id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	@tmp = $sth->fetchrow_array;
	print "<TD>SR severity: </TD><TD><B>" . $tmp[0];
	print "</B></TD>";
	my $cufn = 'N/A';
	if ($fault_rec[4] ne '') {
		$dst = "SELECT fullname, phone1, phone2 from st_users where id = $fault_rec[4]";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (st_lib::sthErr($sth->err, $sth->errstr)) { 
			# Internal Error.
			print $query->end_html;
			$dbh->disconnect;
			exit;
		};
		@tmp = $sth->fetchrow_array;
		$cufn = "$tmp[0]";
	};
	print "<TD>SR Closed by: </TD><TD><B>" . $cufn . "</B></TD>";
	print "</TR><TR>";

	# Find status
	$dst = "SELECT fs.name, fs.id FROM st_faultstatus fs INNER JOIN st_status_of_fault sf ON sf.faultstatus_id = fs.id WHERE sf.id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	@tmp = $sth->fetchrow_array;
	my $fault_status_id = $tmp[1];
	print "<TD>SR status: </TD><TD><B>" . $tmp[0];
	print "</B></TD>";

	# Find tech.
	$dst = "SELECT u.fullname, u.id, u.phone1, u.phone2 FROM st_users u INNER JOIN st_tech_of_fault tf ON tf.assigned_to_user_id = u.id WHERE tf.id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	@tmp = $sth->fetchrow_array;
	# Keep that for later.
	my $assigned_tech = $tmp[1];

	print "<TD>Customer Service Engineer: </TD><TD><B>" . "$tmp[0]";

	print "</B></TD></TR>";
	# Print TAC and RMA fields.

	print "<TR><TD>TAC number: </TD><TD>$fault_rec[9]</TD>";
	print "<TD>RMA number: </TD><TD>$fault_rec[10]</TD></TR>";
	
	# If users appear in st_faults_users_rel, add one more line.
	$dst = "SELECT u.fullname, r.write_perm, u.phone1, u.phone2, u.id 
		FROM st_faults_users_rel r INNER JOIN st_users u ON r.user_id = u.id
		WHERE r.fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		my $lcntr = 0;
		my $rel_users = '';
		my $sep = '';
		while (@row_ary = $sth->fetchrow_array) {
			if ($lcntr > 0) {
				$sep = ',';
			};
			$lcntr++;
			if ($row_ary[1] == 1) {
				$rel_users = $rel_users . "$sep <B>$row_ary[0]</B>";
			} else {
				$rel_users = $rel_users . "$sep $row_ary[0]";
			};
		};
		print "<TR><TD>Related users: </TD><TD COLSPAN=3>$rel_users</TD></TR>";
	};

	# If non-deleted files appear in st_files, add one more row:
	$dst = "SELECT id, filename, size 
		FROM st_files
		WHERE fault_id = $fault_id
		AND delete_time IS NULL";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		my $lcntr = 0;
		my $rel_files = '';
		my $sep = '';
		while (@row_ary = $sth->fetchrow_array) {
			if ($lcntr > 0) {
				$sep = ',';
			};
			$lcntr++;
			$rel_files = $rel_files . "$sep $row_ary[1] ($row_ary[2] bytes)";
		};
		print "<TR><TD>Related files: </TD><TD COLSPAN=3>$rel_files</TD></TR>";
	};

	# If relations appear in st_f2f, add one more row:
	$dst = "SELECT target_fault_id 
		FROM st_f2f
		WHERE source_fault_id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows > 0) {
		my $lcntr = 0;
		my $rel_faults = '';
		my $sep = '';
		while (@row_ary = $sth->fetchrow_array) {
			if ($lcntr > 0) {
				$sep = ',';
			};
			$lcntr++;
			$rel_faults = $rel_faults . "$sep <A HREF=\"$cgipath/st_faults.pl?4+$row_ary[0]\">#$row_ary[0]</A>";
		};
		print "<TR><TD>Related SRs: </TD><TD COLSPAN=3>$rel_faults</TD></TR>";
	};

	# Print message log
	$dst = "SELECT ml.description, ml.log_time, u.fullname FROM st_faultsmsglog ml
		INNER JOIN st_users u ON ml.logged_by_user_id = u.id
		WHERE ml.fault_id = $fault_id
		ORDER BY ml.log_time DESC";
	$sth = $dbh->prepare($dst);
		
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	while (@tmp = $sth->fetchrow_array) { 
		# Substitutions to avoid XSS attacks.
		$tmp[0]=~s/&/&#38;/g;
		$tmp[0]=~s/\(/&#40;/g;
		$tmp[0]=~s/\)/&#41;/g;
		$tmp[0]=~s/</&lt;/g;
		$tmp[0]=~s/>/&gt;/g;
		# Display newlines somehow.
		$tmp[0]=~s/\n/<br>/g;
		print "<TR><TD COLSPAN=4><B>$tmp[2]</B><br><I>" . st_lib::datetostr($tmp[1]) . "</I><P>$tmp[0]</TD></TR>";
	};
	print "</TABLE>";
} elsif ($action == 25) {
	# Edit manual dates 
	my $fault_id = $chooserlist[1];
	my @tmp;
	my (@values, %labels, @lrow, $tpref, $origtab);
	$dst = "SELECT report_timestamp, responce_timestamp, recovery_timestamp, sla_actions, sla_fail_comments
			FROM st_faults WHERE id = $fault_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (defined($sth->err)) { 
		# Internal Error.
		print "<B><FONT COLOR=RED>" . $sth->errstr . "</FONT></B>";
		$dbh->rollback;
		exit;
	}; 
	@lrow = $sth->fetchrow_array;

	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_faults.pl?4+$fault_id+11",
				 -name=>'updateform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE>";
	print "<TR><TD BGCOLOR=$headcellcolor>New report timestamp: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'reported_d',
				-size=>20,
				-default=>st_lib::datetostr($lrow[0]),
				-maxlength=>80);
	print "</TD>";
	print "<TD BGCOLOR=$headcellcolor>New responce timestamp: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'responce_d',
				-size=>20,
				-default=>st_lib::datetostr($lrow[1]),
				-maxlength=>80);
	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor>New resolution timestamp: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textfield(-name=>'resolution_d',
				-size=>20,
				-default=>st_lib::datetostr($lrow[2]),
				-maxlength=>80);
	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor>Actions taken: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textfield(-name=>'sla_actions',
				-size=>50,
				-default=>st_lib::datetostr($lrow[3]),
				-maxlength=>160);
	print "</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor>SLA fail comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textfield(-name=>'sla_fail_comments',
				-size=>50,
				-default=>st_lib::datetostr($lrow[4]),
				-maxlength=>160);
	print "</TD></TR>";

	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=4><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print $query->endform;
	print "</CENTER></TD></TR></TABLE>";

} elsif ($action == 26) {
	# Lock ticket
	my $fault_id = $chooserlist[1];
	print "<P><CENTER><H2>Mark SR as confidential?</H2></CENTER><br><CENTER><B><H3><FONT COLOR=RED>Warning:</FONT></B>This transaction cannot be undone.</H3><P>";
	print "<H2><A HREF=\"$cgipath/st_faults.pl?4+$fault_id+12\"><FONT COLOR=RED>[Yes]</FONT></A> ";
	print "<A HREF=\"$cgipath/st_faults.pl?4+$fault_id+13\"><FONT COLOR=GREEN>[No]</FONT></A> ";
} else {
	# No way to get here!
	print "<P><H1>IMPOSSIBLE!</H1><P>";
	print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Finish, clean up etc....
print "</CENTER>";
if ($action != 24) {
	# Don't print in printer friendly.
	st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
};
print $query->end_html;
$sth->finish;
$dbh->disconnect;
exit;

