#!/usr/bin/perl
#########################################################################
# Companies management code.						#
#									#
# Artist: Theodore J. Soldatos						#
#									#
# Copyright (C) 2004-2005 Space Hellas					#
# Copyright (C) 2004-2005 Theodore J. Soldatos				#
#									#
# This program is free software; you can redistribute it and/or		#
# modify it under the terms of the GNU General Public License		#
# as published by the Free Software Foundation; either version 2	#
# of the License, or (at your option) any later version.		#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License	#
# along with this program; if not, write to the Free Software		#
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,		#
# MA  02110-1301, USA							#
#									#
# Revision history: 							#
# V0.0.0	Starting... (30-03-2004)				#
# V0.0.1	Basic functionality ready.				#
# V0.0.2	Translated to english.					#
# V0.0.3	Companies fault type management added.			#
# V0.0.4	Terminology review.					#
# V0.0.5	Added r/o option in locations form.			#
# V0.0.6	Fault types per company displayed in directory.		#
#		Users and fault types displayed in details.		#
#		Number of users per company in directory.		#
# V0.0.7	Lock out non-tech users.				#
# V0.0.8	Replaced hardcoded encodings with parameter.		#
# V0.0.9	Replaced hardcoded language with parameter.		#
# V0.1.0	Permitted location ro display for everybody.		#
# V0.1.1	Added responce and resolution SLA times by location.	#
# V0.1.2	Added locident (external code) field.			#
#									#
# Arguments description (* = internal, not menu):			#
# 	action: 							#
#	 0: 	New company form					#
#	 1: 	Insert company step 2					#
#	 2: 	Search form for companies				#
#	 3: 	Search results 						#
#	 4: 	Main company screen					#
#	 5: 	Main location screen					#
#	 6: 	New location screen					#
#	 7: 	Disactivate company					#
#	 8: 	Company fault types management.				#
#########################################################################

use strict;
use DBI;
use CGI;
use st_lib;

my $data_source = $st_lib::data_source;		# Where to look...
my $sth; 					# SQL statement handler. 
my ($rc, $strrc);				# Errors.
my $i;						# Counter.
my $dst;					# used for dynamic statements.
my ($rest, $tmp, $scrapret, @row_ary);		# Various tmp variables

my $debug = $st_lib::debug;

my $myhost = $st_lib::myhost;
# Colors
my $bgcolor = 		$st_lib::bgcolor; 	# General page background color
my $headcellcolor = 	$st_lib::headcellcolor;	# Head cells in tables
my $mheadcellcolor = 	$st_lib::mheadcellcolor;# Head cells in tables, mandatory fields.
my $cellcolor =	 	$st_lib::cellcolor;	# Cells in tables
my $textcolor =		$st_lib::textcolor;	# General text color
my $headtextcolor = 	$st_lib::headtextcolor;	# Head cells text color
my $lighttextcolor = 	$st_lib::lighttextcolor;# Non-existent attributes
my $linkcolor =		$st_lib::linkcolor;	# Links
my $vlinkcolor =	$st_lib::vlinkcolor;	# Visited links
my $cgipath =		$st_lib::cgipath;	# CGI path 
my $sencoding =		$st_lib::sencoding;	# Encoding for HTML etc
my $slang =		$st_lib::slang;		# Language for HTML etc


my %formtitles = ( 	
		# Form title depending on action. Also used to check
		# parameter validity.
		0 => 'Add new company',
		1 => 'Add new company',
		2 => 'Companies directory',
		3 => 'Companies directory',
		4 => 'Company details',
		5 => 'Update location',
		6 => 'Add location',
		7 => 'Disactivate company',
		8 => 'Company SR types',
		);

my $version = "st_companies.pl V0.1.2";

my $query = new CGI;
my @chooserlist = $query->url_param('keywords');
my $action = $chooserlist[0];

if (not (exists $formtitles{$action})) {
	# Default is 0
	$action = 0;
};

#########################################
# zdata format: 			#
#  0 ->	id (st_users.id)		#
#  1 -> active (bool)			#
#  2 -> client (bool)			#
#  3 -> technician (bool)		#
#  4 -> admin (bool)			#
#  5 -> main contact (bool)		#
#  6 -> st_userlevels.id		#
#  7 -> st_companieslocations.id	#
#  8 -> st_companies.id			#
#  9 -> Logged since (epoch)		#
# 10 -> st_companies.name		#
# 11 -> st_userlevels.name		#
#########################################

# Check credentials, if not ok call GetUserForLogin
my ($zuser, $zpass, $zfullname, @zdata) = st_lib::GetCredentials($query);
if ($zpass eq '0') {
	# Must login
	st_lib::GetUserForLogin("$cgipath/st_menus.pl?0", $query);
	exit;
};

# Initialize db connection
my $dbh = DBI->connect($data_source, $zuser, $zpass, { RaiseError => 0, PrintError => 1, AutoCommit => 0, ShowErrorStatement => 1 });

# Initialize CGI and send headers.
print  $query->header(-charset=>$sencoding);
print  $query->start_html(-title=>$formtitles{$action},
			  -text=>$textcolor,
			  -lang=>$slang,
			  -BGCOLOR=>$bgcolor);

st_lib::zsHeaderFooter(0, $zfullname, $version, 0, \@zdata);

print "<CENTER><H2><FONT COLOR=$headcellcolor>" . $formtitles{$action} . "</FONT></H2><P>";

# Make a permission check - only "normal" scse's and above have access here.
# Read-only location data display permitted to anyone.
if (
	not (($zdata[3] == 1) and ($zdata[5] == 1) and ($zdata[6] == 0))
	and 
	not (($chooserlist[1] == 0) and ($action == 5))
	) {
	print "<H3><P>Sorry, you do not have permission to access this page.<P></H3>";
	print "</CENTER>";
	st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Everything from here is action depended.

if ($action == 0) {
	# Create new company form.
	my (@values, %labels, @lrow, $tpref, $origtab);
	print $query->start_form(-method=>'POST',
                                   -action=>"$cgipath/st_companies.pl?1",
				   -name=>'insertform',
                                   -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	# Name. POC.
	print "<TD BGCOLOR=$headcellcolor>Name: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textfield(-name=>'name',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";

	print "</TR><TR>";
	# Text area for comments.
	print "<TD BGCOLOR=$headcellcolor>Comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=3><CENTER>";
	print $query->textarea(-name=>'comments',
				-rows=>3,
				-columns=>60);
	print "</CENTER></TD>";
	print "</TR><TR>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>";	
	print $query->submit('submitbutton', 'Add');
	print $query->endform;
	print "</CENTER></TD>";	
	print "</TR></TABLE></CENTER>";
} elsif ($action == 1) {
	# Insert company in database and inform user.
	my $name = $query->param('name');
	my $comments = $query->param('comments');
	$name=~s/\'/\\\'/g;
	$comments=~s/\'/\\\'/g;

	# Insert new company
	$dst = "INSERT INTO st_companies(name, comments, active)
			VALUES(\'$name\', \'$comments\', \'t\')";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};
	# Find new company's id.
	$dst = "SELECT currval('st_companies_id_seq')";
	$sth = $dbh->prepare($dst); 
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->rollback;
		$dbh->disconnect;
		exit;
	};
	@row_ary = $sth->fetchrow_array;
	my $company_id = $row_ary[0]; # Single value.
	# Everything is ok, commit.
	$dbh->commit;
	print "<H1><FONT COLOR=GREEN>Insert transaction successfull!</FONT></H1><P>";	
	print "<A HREF=\"$cgipath/st_companies.pl?0\">[New company]</A> <A HREF=\"$cgipath/st_companies.pl?4+$company_id\">[Edit just created company]</A> <A HREF=\"$cgipath/st_companies.pl?2\">[Companies directory]</A>";
} elsif ($action == 2) {
	# Search form for companies
	my (@values, %labels, @lrow, $tpref, $origtab);
	print $query->start_form(-method=>'POST',
                                 -action=>"$cgipath/st_companies.pl?3",
				 -name=>'searchform',
                                 -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	# Name. POC.
	print "<TD BGCOLOR=$headcellcolor>Name: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'name',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";

	print "</TR><TR>";
	print "<TD BGCOLOR=$headcellcolor><CENTER>Active: </TD><TD BGCOLOR=$cellcolor>";
	my %rblabels;
	$rblabels{ 't' } = 'Yes';
	$rblabels{ 'f' } = 'No';
	$rblabels{ '' } = 'All';
	print $query->radio_group(-name=>'active',
					-values=>['t','f',''],
					-default=>'t',
					-labels=>\%rblabels);
	print "</TD>";

	print "</TR><TR>";

	print "<TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>";	
	print $query->submit('submitbutton', 'Search');
	print $query->endform;
	print "</CENTER></TD>";	
		
	print "</TR></TABLE></CENTER>";
} elsif ($action == 3) {
	# Search results.
	my $pm;
	my %columns = (
		'name' => 'text', 
		'active' => 'bool', 
		);
	$dst = "SELECT id, name, active FROM st_companies WHERE TRUE ";
	# Constant part ready, let's add search conditions
	my @params = $query->param;

	foreach $pm (@params) {
		if (exists $columns{ $pm }) {
			# Column found.
			my $pmvalue = $query->param($pm);
			# Trim white space
			$pmvalue =~ s/^\s*(.*?)\s*$/$1/;
			# Escape single quotes
			$pmvalue =~ s/\'/\\\'/g;
			if ($pmvalue ne '') {
				$dst = $dst . ' AND ';
				if ($columns{ $pm } eq 'text') {
					$dst = "$dst $pm ILIKE \'$pmvalue\' ";
				} elsif ($columns{ $pm } eq 'bool') {
					$dst = "$dst $pm = \'$pmvalue\' ";
				};
			};
		};
	};
	$dst = $dst . " ORDER BY active, name ";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	# Print headers
	print "<TABLE><TR>";
	print "<TD BGCOLOR=$headcellcolor>Name</TD>";
	print "<TD BGCOLOR=$headcellcolor>Active</TD>";
	print "<TD BGCOLOR=$headcellcolor>Fault types</TD>";
	print "<TD BGCOLOR=$headcellcolor># of active users</TD></TR>";
	# Print data
	my %tf = (
		'1' => 'Yes',
		'0' => 'No'
		);
	if ($sth->rows == 0) {
		print "<TD BGCOLOR=$cellcolor COLSPAN=4><CENTER>No records found.</CENTER></TD></TR></TABLE>";	
	} else {
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_companies.pl?4+$row_ary[0]\">$row_ary[1]</A></TD>";
			print "<TD BGCOLOR=$cellcolor>" . $tf{ $row_ary[2] } . "</TD>";
			# Get fault types 
			my $ldst = "SELECT ft.name 
					FROM st_faulttypes ft 
						INNER JOIN st_comp_ftypes c 
						ON ft.id = c.faulttype_id
					WHERE c.comp_id = $row_ary[0]";
			my $lsth = $dbh->prepare($ldst);
			$lsth->execute;
			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			my @lrow;
			print "<TD BGCOLOR=$cellcolor>";
			while (@lrow = $lsth->fetchrow_array) {
				print "$lrow[0]<br>";
			};
			print "</TD>";

			# Get number of users 
			$ldst = "SELECT count(*) FROM st_user_company_id_v WHERE company_id = $row_ary[0] AND active = 't'";
			my $lsth = $dbh->prepare($ldst);
			$lsth->execute;
			if (st_lib::sthErr($lsth->err, $lsth->errstr)) { 
				# Internal Error.
				print $query->end_html;
				$dbh->disconnect;
				exit;
			};
			@lrow = $lsth->fetchrow_array;
			if ($lrow[0] eq '') { $lrow[0] = 0 };
			print "<TD BGCOLOR=$cellcolor><CENTER>$lrow[0]</CENTER></TD>";


			print "</TR>";
		};
		print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=4><CENTER>Total records: " . $sth->rows . "</TD></TR>";
	};

	print "</TABLE>";
	$sth->finish;
} elsif ($action == 4) {
	# Display company 
	my $company_id = $chooserlist[1];
	my $extra_action = $chooserlist[2];
	my %tf = (
		'1' => 'Active',
		'0' => 'Inactive'
		);
	my %tf2 = (
		'1' => 'Yes',
		'0' => 'No'
		);
	#########################################################################
	#									#
	# Extra actions:							# 
	#	 0: Add new location						#
	#	 1: Update location						#
	#	 2: Disactivate company						#
	#	 3: No action							#
	#									#
	#########################################################################
	my @tmp;
	my $status_line = '-';
	my $status_color = $cellcolor;
	my $buttons_line = "<CENTER><A HREF=\"$cgipath/st_companies.pl?2\">[Companies directory]</A> ";
	my $buttons_cntr = 1;
	if ($extra_action ne '') {
		# Something to do before select
		if ($extra_action == 0) {
			my $name = $query->param('name');
			$name =~s/\'/\\\'/g;
			my $description = $query->param('description');
			$description =~s/\'/\\\'/g;
			my $address1 = $query->param('address1');
			$address1 =~s/\'/\\\'/g;
			my $address2 = $query->param('address2');
			$address2 =~s/\'/\\\'/g;
			my $address3 = $query->param('address3');
			$address3 =~s/\'/\\\'/g;
			my $phone1 = $query->param('phone1');
			$phone1 =~s/\'/\\\'/g;
			my $phone2 = $query->param('phone2');
			$phone2 =~s/\'/\\\'/g;
			my $fax = $query->param('fax');
			$fax =~s/\'/\\\'/g;
			my $comments = $query->param('comments');
			$comments =~s/\'/\\\'/g;
			my $contact_info = $query->param('contact_info');
			$contact_info =~s/\'/\\\'/g;
			my $main_location = $query->param('main_location');
			
			my $sla_responce = $query->param('sla_responce');
			$sla_responce =~s/\'/\\\'/g;
			# Trim white space
			$sla_responce =~ s/^\s*(.*?)\s*$/$1/;
			if ($sla_responce eq '') { $sla_responce = '00:00' };
			my $sla_resolution = $query->param('sla_resolution');
			$sla_resolution =~s/\'/\\\'/g;
			# Trim white space
			$sla_resolution =~ s/^\s*(.*?)\s*$/$1/;
			if ($sla_resolution eq '') { $sla_resolution = '00:00' };

			my $locident = $query->param('locident');
			$locident =~s/\'/\\\'/g;
			# Trim white space
			$locident =~ s/^\s*(.*?)\s*$/$1/;

			$dst = "INSERT INTO st_companieslocations(name, description, address1, address2, address3, phone1, phone2,
						fax, comments, contact_info, active, main_location, company_id, sla_responce, sla_resolution, locident)
				VALUES(\'$name\', \'$description\', \'$address1\', \'$address2\', \'$address3\', \'$phone1\', \'$phone2\', 
					\'$fax\', \'$comments\', \'$contact_info\', \'t\', \'$main_location\', $company_id, \'$sla_responce\', \'$sla_resolution\', \'$locident\')";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Successful add';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		} elsif ($extra_action == 1) {
			my $location_id = $chooserlist[3];
			my $name = $query->param('name');
			$name =~s/\'/\\\'/g;
			my $description = $query->param('description');
			$description =~s/\'/\\\'/g;
			my $address1 = $query->param('address1');
			$address1 =~s/\'/\\\'/g;
			my $address2 = $query->param('address2');
			$address2 =~s/\'/\\\'/g;
			my $address3 = $query->param('address3');
			$address3 =~s/\'/\\\'/g;
			my $phone1 = $query->param('phone1');
			$phone1 =~s/\'/\\\'/g;
			my $phone2 = $query->param('phone2');
			$phone2 =~s/\'/\\\'/g;
			my $fax = $query->param('fax');
			$fax =~s/\'/\\\'/g;
			my $comments = $query->param('comments');
			$comments =~s/\'/\\\'/g;
			my $contact_info = $query->param('contact_info');
			$contact_info =~s/\'/\\\'/g;
			my $main_location = $query->param('main_location');
			
			my $sla_responce = $query->param('sla_responce');
			$sla_responce =~s/\'/\\\'/g;
			# Trim white space
			$sla_responce =~ s/^\s*(.*?)\s*$/$1/;
			if ($sla_responce eq '') { $sla_responce = '00:00' };
			my $sla_resolution = $query->param('sla_resolution');
			$sla_resolution =~s/\'/\\\'/g;
			# Trim white space
			$sla_resolution =~ s/^\s*(.*?)\s*$/$1/;
			if ($sla_resolution eq '') { $sla_resolution = '00:00' };

			my $locident = $query->param('locident');
			$locident =~s/\'/\\\'/g;
			# Trim white space
			$locident =~ s/^\s*(.*?)\s*$/$1/;

			$dst = "UPDATE st_companieslocations
				SET name=\'$name\', description=\'$description\', address1=\'$address1\', address2=\'$address2\', 
				address3=\'$address3\', phone1=\'$phone1\', phone2=\'$phone2\', 
				fax=\'$fax\', comments=\'$comments\', contact_info=\'$contact_info\', main_location=\'$main_location\',
				sla_responce=\'$sla_responce\', sla_resolution=\'$sla_resolution\', locident=\'$locident\'
				WHERE id = $location_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Insert transaction successfull';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		} elsif ($extra_action == 2) {
			$dst = "UPDATE st_companies SET active=\'f\' WHERE id = $company_id";
			$sth = $dbh->prepare($dst);
			$sth->execute;
			if (defined($sth->err)) { 
				# Internal Error.
				$status_line = $sth->errstr;
				$status_color = 'RED';
				$dbh->rollback;
			} else {
				$status_line = 'Disactivation successfull';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		} elsif ($extra_action == 3) {
			# No action
			$status_line = 'No change.';
			$status_color = 'GREEN';
		};
	};
	$dst = "SELECT name, comments, active FROM st_companies WHERE id = $company_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};

	if ($sth->rows == 0) { 
		print "<FONT COLOR=RED><H1>Internal error: Record not found.</H1></FONT>";
		print $query->end_html;
		$sth->finish;
		$dbh->disconnect;
		exit;
	};
	my @company_rec = $sth->fetchrow_array;
	print "<TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=11><CENTER><H3><B>$company_rec[0] (" . $tf{ $company_rec[2] } . ")</B></H3></CENTER></TD></TR>";  
	print "<TR><TD BGCOLOR=$headcellcolor>Comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=10>$company_rec[1]</TD></TR>";
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=11><CENTER><B>Locations</B></H3></CENTER></TD></TR>";  

	# Find locations.
	$dst = "SELECT id, name, description, address1, address2, address3, phone1, phone2, fax, contact_info, active, main_location, sla_responce, sla_resolution, locident 
		FROM st_companieslocations WHERE company_id = $company_id";
	
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TR><TD BGCOLOR=$cellcolor COLSPAN=11><CENTER>No records found.</CENTER></TD></TR>";
	} else {
		# Print location data
		print "<TR><TD BGCOLOR=$headcellcolor>Name</TD>";
		print "<TD BGCOLOR=$headcellcolor>Description</TD>";
		print "<TD BGCOLOR=$headcellcolor>Address</TD>";
		print "<TD BGCOLOR=$headcellcolor>Phones</TD>";
		print "<TD BGCOLOR=$headcellcolor>Fax</TD>";
		print "<TD BGCOLOR=$headcellcolor>Contact</TD>";
		print "<TD BGCOLOR=$headcellcolor>Active</TD>";
		print "<TD BGCOLOR=$headcellcolor>SLA Responce</TD>";
		print "<TD BGCOLOR=$headcellcolor>SLA Resolution</TD>";
		print "<TD BGCOLOR=$headcellcolor>Main location</TD>";
		print "<TD BGCOLOR=$headcellcolor>Ext. code</TD></TR>";
		while (@row_ary = $sth->fetchrow_array) {
			print "<TR><TD BGCOLOR=$cellcolor><A HREF=\"$cgipath/st_companies.pl?5+$company_id+$row_ary[0]\">$row_ary[1]</A></TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[2]</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[3] $row_ary[4] $row_ary[5]</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[6] $row_ary[7]</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[8]</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[9]</TD>";
			print "<TD BGCOLOR=$cellcolor>" . $tf2{ $row_ary[10] } . "</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[12]</TD>";
			print "<TD BGCOLOR=$cellcolor>$row_ary[13]</TD>";
			print "<TD BGCOLOR=$cellcolor>" . $tf2{ $row_ary[11] } . "</TD>";
			print "<TD BGCOLOR=$cellcolor>" . $row_ary[14] . "</TD></TR>";
		};
		print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=11><CENTER>Total records: " . $sth->rows . "</TD></TR>";
	};
	# Print users and fault types.
	print "<TR><TD BGCOLOR=$headcellcolor COLSPAN=5><CENTER><B>Company Users</B></CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=6><CENTER><B>Company SR Types</B></CENTER></TD></TR><TR>";
	# Users: 
	$dst = "SELECT user_id, username, fullname 
		FROM st_user_company_id_v WHERE company_id = $company_id AND active = 't'";
	
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>No records found.</CENTER></TD>";
	} else {
		# Print user data 
		print "<TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
		while (@row_ary = $sth->fetchrow_array) {
			print "<A HREF=\"$cgipath/st_usermanagement.pl?10+0+0+$row_ary[0]\">$row_ary[2]</A><BR>";
		};
		print "</CENTER></TD>";
	};
	# Fault types: 
	
	$dst = "SELECT ft.name 
			FROM st_faulttypes ft 
			INNER JOIN st_comp_ftypes c 
			ON ft.id = c.faulttype_id
		WHERE c.comp_id = $company_id";

	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	if ($sth->rows == 0) {
		print "<TD BGCOLOR=$cellcolor COLSPAN=6><CENTER><FONT COLOR=RED><B>Warning: No records found!<BR>All types available to company users!</B></FONT></CENTER></TD>";
	} else {
		# Print fault types data 
		print "<TD BGCOLOR=$cellcolor COLSPAN=6><CENTER>";
		while (@row_ary = $sth->fetchrow_array) {
			print "$row_ary[0]<BR>";
		};
		print "</CENTER></TD>";
	};
	print "</TR>";
	



	
	# Print status line
	print "<TR><TD BGCOLOR=$status_color COLSPAN=11><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
	# Print buttons line
	$buttons_line = $buttons_line . "<A HREF=\"$cgipath/st_companies.pl?6+$company_id\">[New location]</A> "; 
	$buttons_cntr++;
	if (($buttons_cntr % 4) == 0) {
		# New line
		$buttons_line = $buttons_line . "<br>";
	};

	$buttons_line = $buttons_line . "<A HREF=\"$cgipath/st_companies.pl?7+$company_id\">[Disactivate company]</A> "; 
	$buttons_cntr++;
	if (($buttons_cntr % 4) == 0) {
		# New line
		$buttons_line = $buttons_line . "<br>";
	};

	$buttons_line = $buttons_line . "<A HREF=\"$cgipath/st_usermanagement.pl?0+$company_id\">[Company users]</A> "; 
	$buttons_cntr++;
	if (($buttons_cntr % 4) == 0) {
		# New line
		$buttons_line = $buttons_line . "<br>";
	};
	$buttons_line = $buttons_line . "<A HREF=\"$cgipath/st_companies.pl?8+$company_id\">[Permitted fault types]</A> "; 
	$buttons_cntr++;
	if (($buttons_cntr % 4) == 0) {
		# New line
		$buttons_line = $buttons_line . "<br>";
	};
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=11>$buttons_line</CENTER></TD></TR>";
	$sth->finish;
} elsif ($action == 5) {
	# Form to edit location
	my $company_id = $chooserlist[1];
	my $location_id = $chooserlist[2];
	my $ro = 0;
	my $fault_id;
	if ($company_id == 0) {
		$fault_id = $chooserlist[3];
		$ro = 1;
	};
	$dst = "SELECT id, name, description, address1, address2, address3, phone1, phone2, fax, comments, contact_info, active, main_location, sla_responce, sla_resolution, locident
		FROM st_companieslocations WHERE id = $location_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @loc_rec = $sth->fetchrow_array;
	if (not ($ro)) {
		print $query->start_form(-method=>'POST',
       		                         -action=>"$cgipath/st_companies.pl?4+$company_id+1+$location_id",
					 -name=>'updateform',
       		                         -enctype=>$sencoding);
	};
	print "<CENTER><TABLE><TR>";
	# Name. POC.
	print "<TD BGCOLOR=$headcellcolor>Name: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'name',
				-size=>80,
				-default=>$loc_rec[1],
				-maxlength=>80);
	} else {
		print $loc_rec[1];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Description. POC.
	print "<TD BGCOLOR=$headcellcolor>Description: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'description',
				-size=>80,
				-value=>$loc_rec[2],
				-maxlength=>80);
	} else {
		print $loc_rec[2];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Address 1. POC.
	print "<TD BGCOLOR=$headcellcolor>Address 1: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'address1',
				-size=>20,
				-default=>$loc_rec[3],
				-maxlength=>80);
	} else {
		print $loc_rec[3];
	};
	print "</CENTER></TD>";
	# Address 2. POC.
	print "<TD BGCOLOR=$headcellcolor>Address 2: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'address2',
				-size=>20,
				-default=>$loc_rec[4],
				-maxlength=>80);
	} else {
		print $loc_rec[4];
	};
	print "</CENTER></TD>";
	# Address 3. POC.
	print "<TD BGCOLOR=$headcellcolor>Address 3: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'address3',
				-size=>20,
				-default=>$loc_rec[5],
				-maxlength=>80);
	} else {
		print $loc_rec[5];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Phone 1. POC.
	print "<TD BGCOLOR=$headcellcolor>Phone 1: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'phone1',
				-size=>20,
				-default=>$loc_rec[6],
				-maxlength=>80);
	} else {
		print $loc_rec[6];
	};
	print "</CENTER></TD>";
	# Phone 2. POC.
	print "<TD BGCOLOR=$headcellcolor>Phone 2: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'phone2',
				-size=>20,
				-default=>$loc_rec[7],
				-maxlength=>80);
	} else {
		print $loc_rec[7];
	};
	print "</CENTER></TD>";
	# Fax. POC.
	print "<TD BGCOLOR=$headcellcolor>Fax: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'fax',
				-size=>20,
				-default=>$loc_rec[8],
				-maxlength=>80);
	} else {
		print $loc_rec[8];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Text area for comments.
	print "<TD BGCOLOR=$headcellcolor>Comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	if (not ($ro)) {
	print $query->textarea(-name=>'comments',
				-rows=>3,
				-default=>$loc_rec[9],
				-columns=>60);
	} else {
		print $loc_rec[9];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Contact. POC.
	print "<TD BGCOLOR=$headcellcolor>Contact: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'contact_info',
				-size=>80,
				-value=>$loc_rec[10],
				-maxlength=>80);
	} else {
		print $loc_rec[10];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# SLAs. POC.
	print "<TD BGCOLOR=$headcellcolor COLSPAN=2>SLA responce time: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'sla_responce',
				-size=>10,
				-value=>$loc_rec[13],
				-maxlength=>80);
	} else {
		print $loc_rec[13];
	};
	print "</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=2>SLA resolution time: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'sla_resolution',
				-size=>10,
				-value=>$loc_rec[14],
				-maxlength=>80);
	} else {
		print $loc_rec[14];
	};
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Main location. Boolean
	print "<TD BGCOLOR=$headcellcolor><CENTER>Main location: </TD><TD BGCOLOR=$cellcolor>";
	my %rblabels;
	$rblabels{ '1' } = 'Yes';
	$rblabels{ '0' } = 'No';
	if (not ($ro)) {
	print $query->radio_group(-name=>'main_location',
					-values=>['0','1'],
					-default=>$loc_rec[12],
					-labels=>\%rblabels);
	} else {
		print $rblabels{ $loc_rec[12] };
	};
	print "</TD>";

	print "<TD BGCOLOR=$headcellcolor>External code: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	if (not ($ro)) {
	print $query->textfield(-name=>'locident',
				-size=>10,
				-value=>$loc_rec[15],
				-maxlength=>80);
	} else {
		print $loc_rec[15];
	};
	print "</CENTER></TD>";

	print "<TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>";	
	if (not ($ro)) {
	print $query->submit('submitbutton', 'Add');
	print $query->endform;
	} else {
		print "<CENTER>[ <A HREF=\"$cgipath/st_faults.pl?4+$fault_id\">Return to SR</A> ]</CENTER>";
	};
	print "</CENTER></TD>";	
	print "</TR></TABLE></CENTER>";
	$sth->finish;

} elsif ($action == 6) {
	# Form for new location
	my $company_id = $chooserlist[1];
	print $query->start_form(-method=>'POST',
                                   -action=>"$cgipath/st_companies.pl?4+$company_id+0",
				   -name=>'insertform',
                                   -enctype=>$sencoding);
	print "<CENTER><TABLE><TR>";
	# Name. POC.
	print "<TD BGCOLOR=$headcellcolor>Name: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	print $query->textfield(-name=>'name',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Description. POC.
	print "<TD BGCOLOR=$headcellcolor>Description: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	print $query->textfield(-name=>'description',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Address 1. POC.
	print "<TD BGCOLOR=$headcellcolor>Address 1: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'address1',
				-size=>20,
				-maxlength=>80);
	print "</CENTER></TD>";
	# Address 2. POC.
	print "<TD BGCOLOR=$headcellcolor>Address 2: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'address2',
				-size=>20,
				-maxlength=>80);
	print "</CENTER></TD>";
	# Address 3. POC.
	print "<TD BGCOLOR=$headcellcolor>Address 3: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'address3',
				-size=>20,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Phone 1. POC.
	print "<TD BGCOLOR=$headcellcolor>Phone 1: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'phone1',
				-size=>20,
				-maxlength=>80);
	print "</CENTER></TD>";
	# Phone 2. POC.
	print "<TD BGCOLOR=$headcellcolor>Phone 2: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'phone2',
				-size=>20,
				-maxlength=>80);
	print "</CENTER></TD>";
	# Fax. POC.
	print "<TD BGCOLOR=$headcellcolor>Fax: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'fax',
				-size=>20,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Text area for comments.
	print "<TD BGCOLOR=$headcellcolor>Comments: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	print $query->textarea(-name=>'comments',
				-rows=>3,
				-columns=>60);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Contact. POC.
	print "<TD BGCOLOR=$headcellcolor>Contact: </TD><TD BGCOLOR=$cellcolor COLSPAN=5><CENTER>";
	print $query->textfield(-name=>'contact_info',
				-size=>80,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# SLAs. POC.
	print "<TD BGCOLOR=$headcellcolor COLSPAN=2>SLA Responce Time: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'sla_responce',
				-size=>10,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=2>SLA Resolution Time: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'sla_resolution',
				-size=>10,
				-maxlength=>80);
	print "</CENTER></TD>";
	print "</TR><TR>";
	# Main location. Boolean
	print "<TD BGCOLOR=$headcellcolor><CENTER>Main location: </TD><TD BGCOLOR=$cellcolor>";
	my %rblabels;
	$rblabels{ 't' } = 'Yes';
	$rblabels{ 'f' } = 'No';
	print $query->radio_group(-name=>'main_location',
					-values=>['f','t'],
					-default=>'f',
					-labels=>\%rblabels);
	print "</TD>";
	print "<TD BGCOLOR=$headcellcolor COLSPAN=2>External code: </TD><TD BGCOLOR=$cellcolor><CENTER>";
	print $query->textfield(-name=>'locident',
				-size=>10,
				-maxlength=>80);
	print "</CENTER></TD>";

	print "<TD BGCOLOR=$headcellcolor COLSPAN=2><CENTER>";	
	print $query->submit('submitbutton', 'Add');
	print $query->endform;
	print "</CENTER></TD>";	
	print "</TR></TABLE></CENTER>";
} elsif ($action == 7) {
	# Disactivate company
	my $company_id = $chooserlist[1];
	print "<H2>Confirm disactivation?</H2><P>";
	print "<FONT COLOR=RED>Warning: </FONT>All users and locations of current company will be disactivated!<P>";
	print "<H1><A HREF=\"$cgipath/st_companies.pl?4+$company_id+2\"><FONT COLOR=RED>Yes</FONT></A> - <A HREF=\"$cgipath/st_companies.pl?4+$company_id+3\"><FONT COLOR=GREEN>No</FONT></A>"; 
} elsif ($action == 8) {
	my $company_id = $chooserlist[1];
	my $spparam = $chooserlist[2]; # If 1, update.
	my $status_line = '=';
	my $status_color = $cellcolor;
	my $tpr = 4;
	my $cpr = $tpr*2;
	if ($spparam) {
		# Submit.
		# First reset everything
		$dst = "DELETE FROM st_comp_ftypes WHERE comp_id = $company_id";
		$sth = $dbh->prepare($dst);
		$sth->execute;
		if (defined($sth->err)) { 
			# Internal Error.
			$status_line = $sth->errstr;
			$status_color = 'RED';
			$dbh->rollback;
		} else {
			my @params = $query->param;
			my ($param, $error);
			$error=0;
PARAMLOOP:		foreach $param (@params) {
				my ($rest, $type_id) = split /FTCB/, $param, 2;
				if ($type_id ne '') {
					$dst = "INSERT INTO st_comp_ftypes(comp_id, faulttype_id)
						VALUES($company_id, $type_id)";
					$sth = $dbh->prepare($dst);
					$sth->execute;
					if (defined($sth->err)) { 
						# Internal Error.
						$status_line = $sth->errstr;
						$status_color = 'RED';
						$error=1;
						last PARAMLOOP;
					};
				};
			};
			if ($error) {
				$dbh->rollback;
			} else {
				$status_line = 'Insert transaction successfull.';
				$status_color = 'GREEN';
				$dbh->commit;
			};
		};
	};
	# Find company name.
	$dst = "SELECT name FROM st_companies WHERE id = $company_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my @tmp = $sth->fetchrow_array;
	my $company_name = $tmp[0];

	# Find related fault types.
	$dst = "SELECT faulttype_id FROM st_comp_ftypes WHERE comp_id = $company_id";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	my (@validtypes, @type);
	while (@type = $sth->fetchrow_array) {
		push @validtypes, $type[0]; 
	};

	# Get all types
	$dst = "SELECT id, name, description FROM st_faulttypes";
	$sth = $dbh->prepare($dst);
	$sth->execute;
	if (st_lib::sthErr($sth->err, $sth->errstr)) { 
		# Internal Error.
		print $query->end_html;
		$dbh->disconnect;
		exit;
	};
	print $query->start_form(-method=>'POST',
                                   -action=>"$cgipath/st_companies.pl?8+$company_id+1",
				   -name=>'insertform',
                                   -enctype=>$sencoding);

	my $cnt = 0;
	my (@ftype);
	print "<CENTER><TABLE><TR><TD BGCOLOR=$headcellcolor COLSPAN=$cpr><CENTER><B>$company_name</B></CENTER></TD></TR>";
	while (@ftype = $sth->fetchrow_array) {
		print "<TD BGCOLOR=$headcellcolor>$ftype[1] ($ftype[2])</TD><TD BGCOLOR=$cellcolor>";
		my $idname = "FTCB" . $ftype[0];
		if (st_lib::found(\@validtypes, $ftype[0])) {
			print $query->checkbox(-name => $idname, -value => 'ON', -override =>1, -label => '', -checked => 'checked');
		} else {
			print $query->checkbox(-name => $idname, -value => 'ON', -override =>1, -label => '');
		};
		print "</TD>";
		$cnt++;
		if ($cnt % $tpr == 0) {
			# Change table row
			print "</TR><TR>";
		};
	};
	while ($cnt % $tpr > 0) {
		# Create empty cells.
		print "<TD BGCOLOR=$headcellcolor></TD><TD BGCOLOR=$cellcolor></TD>";
		$cnt++;
	};
	print "</TR>";
	print "<TR><TD BGCOLOR=$cellcolor COLSPAN=$cpr><CENTER>";
	print $query->submit('submitbutton', 'Submit');
	print "</CENTER></TD></TR>";
	print "<TR><TD BGCOLOR=$status_color COLSPAN=$cpr><CENTER><FONT COLOR=WHITE>$status_line</FONT></CENTER></TD></TR>";
	print "</TABLE>";
	print $query->endform;
	print "<A HREF=\"$cgipath/st_companies.pl?4+$company_id\">[Return to company screen]</A>";
} else {
	# No way to get here!
	print "<P><H1>IMPOSSIBLE!</H1><P>";
	print "<P><FONT COLOR=$cellcolor>$version</FONT><P>";
	print $query->end_html;
	$dbh->disconnect;
	exit;
};

# Finish, clean up etc....
print "</CENTER>";
st_lib::zsHeaderFooter(1, $zfullname, $version, 0, \@zdata);
print $query->end_html;
$dbh->disconnect;
exit;

