#!/usr/bin/perl
#############################################################################
# MUDA: Resurrection							    #
# MudaServer.pl		: MUDA server watchdog (cron called).		    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

use Config::General;

use strict;
use warnings;

our $mudahome = '/home/theodore/svnMuda/';
our $pidfile = $mudahome . './muda.pid';
our $mudacmd = 'MudaServer.pl';
our $logfile = 'muda.log';
our $holdfile = '/tmp/mudahold';
our $db = $mudahome . 'ramfs/mudaonline.db';
our $origdb = $mudahome . 'db/mudaonline.db';
# Load configuration:
my $conf = new Config::General("/etc/muda.conf");
my %config = $conf->getall;

if (-e $holdfile) { # Don't run, hold file exists.
	exit 0;
};

if (%config) {
	if (defined $config{home}) {
		$mudahome = $config{home};
	};
	if (defined $config{pid}) {
		$pidfile = $mudahome . $config{pid};
	};
	if (defined $config{logfile}) {
		$logfile = $config{logfile};
	};
	if (defined $config{db}) {
		$db = $mudahome . $config{db};
	};
	if (defined $config{origdb}) {
		$origdb = $mudahome . $config{origdb};
	};
};

#my $mudastartcmd = '/bin/bash ' . $mudahome . 'utils/startmuda.sh';
my $mudastartcmd = $mudahome . $mudacmd . " 1>$logfile 2>&1 &";

# Check if i am running.
if (-e $pidfile) { # Stale or fresh ?
	open PIDFILE, "<$pidfile";
	my ($pid, $scrap) = split / /, <PIDFILE>, 2;
	close PIDFILE;
	open PSOUT, "/bin/ps -p $pid |";
	my @psout;
	while (<PSOUT>) { push @psout, $_ }; 
	if (scalar(@psout) > 1) { # Process in lock file exists
		# Server is running, take backup of ramfs DB on disk.
		my @args = ('/bin/cp', $db, $origdb);
		system(@args) == 0 or die "DB backup failed!\n";
		# Also keep a copy of the log:
		@args = ('/bin/cp', $logfile, "$mudahome/muda.log.back");
		system(@args) == 0 or die "Logfile backup failed!\n";
		exit 0;
	} else { # Stale...
		print "Stale pid found, restarting MUDA.\n";
		if (not (-e $db)) {
			print "Running DB not found, copying from disk\n";
			my @args = ('/bin/cp', $origdb, $db);
			system(@args) == 0 or die "DB copy failed!\n";
		};
		chdir $mudahome;
		my @args = ($mudastartcmd);
		system(@args) == 0 or print "MUDA start failed!\n";
		exit 1;
	};
} else {
		print "pid not found, restarting MUDA.\n";
		if (not (-e $db)) {
			print "Running DB not found, copying from disk\n";
			my @args = ('/bin/cp', $origdb, $db);
			system(@args) == 0 or die "DB copy failed!\n";
		};
		chdir $mudahome;
		my @args = ($mudastartcmd);
		system(@args) == 0 or print "MUDA start failed!\n";
		exit 1;
};

