#############################################################################
# MUDA: Resurrection							    #
# walkerNpc.pl		: A simple wandering monster. Attacks when looked at#
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub walkerNpc {
	# We may use an empty sub for non-reacting dump monsters:
	# return 0;
	my ($c_pid, $uid, $lcmd, $message) = @_; 
	if (uc($lcmd) eq '__INFO') {
		# Deaf and blind for now.
		return 0;
	} elsif (uc($lcmd) eq '__LOOKEDAT') {
		# What are you looking at ? 
		my ($v_username, $v_uid, $v_cmqid, $v_roomNum, $v_gender) = &intPid2Details($c_pid);
		my ($username, undef, undef, $roomNum, $gender) = &intUid2Details($uid);
		if ($main::usersMainData[$v_uid]->{ invincible } == 1) {
			# Better not...
			&informRoom($roomNum, $uid, "$username looks frightened.\n");
			return 0;
		};
		# Attack!
		&createFight($uid, $v_uid);
		return 1;
	} elsif (uc($lcmd) eq '__ATTACK') {
		# Dump, will fight.
		return 0;
	} elsif (uc($lcmd) eq '__GIVEN') {
		# Just keep it. $message is ietm id.
		return 0;
	} elsif (uc($lcmd) eq '__TOLD') {
		# Somebody said $message to us.
		return 0;
	} elsif (uc($lcmd) eq '__AMB') {
		# Ambient commands. Message is actual action (push, shake etc).
		return 0;
	} else {
		# We should never reach that normally.
		&logPrint("walkerNpc: fall out on |$lcmd|\n");
		return undef;
	};
};

sub walkerNpcTick {
	my ($notifier_ref, $rest) = @_;
	# We have the notifier object ref passed as parameter.
	# Notifiers created by NPCs have their name set to NPC_<user id>.
	# So we can read and set all NPC's attributes, including room number! :-)

	# DEBUG: stay put for tests:
	#return;

	my $idStr = $notifier_ref->notifier_name;
	my (undef, $uid) = split /_/, $idStr, 2;
	# We don't need all the following, left here for reference:
	my ($username, $pid, $cmqid, $roomNum, $gender) = &intUid2Details($uid);
	# Don't run away from fights:
	foreach my $f (keys %main::fightData) {
		if (
			($main::fightData{$f}->{ attUid } == $uid) or 
			($main::fightData{$f}->{ defUid } == $uid)
		) {
			return;
		};
	};
	my $rc = &randomWalk($roomNum, $uid, $username);
	# rc is the new roomNum, or 0 if failed.
	return;
};

1;
