#############################################################################
# MUDA: Resurrection							    #
# sysmanNpc.pl		: Sysman routines. Tried to make Sysman as similar  # 
#			  as possible to original Sysman (muda8.exe) 	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub sysmanNpc {
	# We may use an empty sub for non-reacting dump monsters:
	# return 0;
	use strict;
	my ($c_pid, $uid, $lcmd, $message) = @_; 
	my ($c_username, $c_uid, $c_cmqid, $c_roomNum, $c_gender) = &intPid2Details($c_pid);
	my $ic_username = $c_username;
	if (
		(defined $c_uid) and 
		($main::usersMainData[$c_uid]->{ invisible }) 
	) {
		$ic_username = 'Somebody';
	};

	my ($username, undef, undef, $roomNum, undef) = &intUid2Details($uid);

	if (uc($lcmd) eq '__INFO') {
		if ($message =~ /just came in/) {
			 ($c_username, $message) = split / /, $message, 2;
			 # Try to get user's PID, whithout it we can't do much!
			 $c_pid = $main::usersMainData[ $main::userPass_ref->{$c_username}->{uid} ]->{ pid };
			 if ($c_pid > 0) {
				 ($c_username, $c_uid, $c_cmqid, $c_roomNum, $c_gender) = &intPid2Details($c_pid);
				 &clientTell($c_cmqid, $c_username, $c_pid, "Sysman points at you!\n");
				 &informRoom($c_roomNum, $uid, "Sysman points at $c_username!\n", $c_uid);
				 &informRoom($c_roomNum, $uid, "Sysman says: \"You, i need a full backup NOW!\"\n");
			 } else {
				 &informRoom($c_roomNum, $uid, "Sysman says: \"Who\'s there?\"\n");
			 };
		};
		return 1;
	} elsif (uc($lcmd) eq '__LOOKEDAT') {
		&informRoom($c_roomNum, $uid, "Sysman says: \"What are you lookin\' at?!\"\n");
		return 1;
	} elsif (uc($lcmd) eq '__ATTACK') {
		# Just cancel the fight.
		&clientTell($c_cmqid, $c_username, $c_pid, "Sysman punches you in the face!\n");
		&informRoom($c_roomNum, $c_uid, "Sysman punches $ic_username in the face!\n", $uid);
		&informRoom($c_roomNum, $uid, "Sysman says: I hate violence!\n");
		$main::usersMainData[ $c_uid ]->{ hitPoints } -= 50;
		if ($main::usersMainData[ $c_uid ]->{ hitPoints } < ($main::usersMainData[ $c_uid ]->{ maxHp } * 0.05)) {
			$main::usersMainData[ $c_uid ]->{ hitPoints } = $main::usersMainData[ $c_uid ]->{ maxHp } * 0.05;
		};
		return 1;
	} elsif (uc($lcmd) eq '__GIVEN') {
		my $iid = $message;
		&informRoom($c_roomNum, $uid, "Sysman says: I don\'t need your trash, $c_username!\n");
		&informRoom($c_roomNum, $uid, "Sysman drops $main::itemData{ $iid }->{ shortDesc }.\n");
		$main::itemData{ $iid }->{ roomID } = $roomNum;
		$main::itemData{ $iid }->{ userID } = 0;
		# Change inventory data structure: 
		my $rec = $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
		delete $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
		# Change room data structure:
		$rec->{ roomID } = $roomNum;
		$rec->{ userID } = 0;
		$main::roomsData[ $roomNum ]->{ presentItems }->{ $iid } = $rec;
		return 1;
	} elsif (uc($lcmd) eq '__TOLD') {
		# Somebody said $message to us.
		my ($sysmanCmd, $args) = split / /, uc($message);
		# Reply something.
		&informRoom($c_roomNum, $uid, "Sysman says: \"No way!\".\n");
		return 1;
	} elsif (uc($lcmd) eq '__AMB') {
		# Ambient commands. Message is actual action (push, shake etc).
		if (($message eq 'PUSH') or ($message eq 'KICK') or ($message eq 'SPIT') or ($message eq 'BITE') or ($message eq 'HUG')) {
			&clientTell($c_cmqid, $c_username, $c_pid, "Sysman hits you!\n");
			&informRoom($c_roomNum, $uid, "Sysman hits $ic_username!\n", $c_uid);
			&informRoom($c_roomNum, $uid, "Sysman says: I hate violence!\n");
		} elsif (($message eq 'KISS') or ($message eq 'TOUCH') or ($message eq 'HAND')or ($message eq 'CARESS')) {
			&informRoom($c_roomNum, $uid, "Sysman looks angry now!\n");
			&informRoom($c_roomNum, $uid, "Sysman says: Yea, you think so!\n");
			&clientTell($c_cmqid, $c_username, $c_pid, "Sysman stares at you and you feel afraid!\n");
		} elsif ($message eq 'SHAKE') {
			&informRoom($c_roomNum, $uid, "Sysman says: \"Go away!\".\n");
		} elsif ($message eq 'BOW') {
			&informRoom($c_roomNum, $uid, "Sysman says: \"Yeah, Yeah...\".\n");
		} else {
			# Should not get here:
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("sysmanNpc: fall out on |$lcmd|\n");
		return undef;
	};
};

sub sysmanNpcTick {
	my ($notifier_ref, $rest) = @_;
	# We have the notifier object ref passed as parameter.
	# Notifiers created by NPCs have their name set to NPC_<user id>.
	# So we can read and set all NPC's attributes, including room number! :-)

	my $idStr = $notifier_ref->notifier_name;
	my (undef, $uid) = split /_/, $idStr, 2;
	# We don't need all the following, left here for reference:
	my ($username, $pid, $cmqid, $roomNum, $gender) = &intUid2Details($uid);
	# randomWalk merely checks for wrong room if called on NPCs with a single
	# room in walk list.
	# my $rc = &randomWalk($roomNum, $uid, $username);
	# rc is the new roomNum, or 0 if failed.
	# But Sysman is special:
	my $protoId = $main::usersMainData[ $uid ]->{ protoId };
	my @walk_list = split /,/, $main::npcProto[ $protoId ]->{ walk_rooms };
	if ($main::npcProto[ $protoId ]->{ walk_rooms } ne '') {
		if (scalar(grep(/^$roomNum$/, @walk_list)) < 1) {
			# Invalid room, teleport:
			my $newpos = 0;
			# Choose from list:
			while ($newpos == 0) {
				$newpos = $main::roomsData[ $walk_list[ rand( scalar( @walk_list ))] ]->{ roomNum };
			};
			#print "DEBUG: Sysman #$uid in invalid room (#$roomNum)! moving to #$newpos\n";
			# Inform old room!
			&informRoom($roomNum, $uid, "Sysman falls into a disk gap!\n");
			&informRoom($roomNum, $uid, "Sysman screams : AAAAAAAAAAAAAAAaaaaaaaaaaa!!!!!\n");
			# Move NPC:
			&movePlayer($uid, $newpos);
			# Inform new room!
			&informRoom($newpos, $uid, "Sysman appears from a disk gap!\n");
			&informRoom($newpos, $uid, "Sysman cleans his clothes from the data dust.\n");
			return $newpos;
		};
	};
	if (rand(1000) > 800) {
		&informRoom($roomNum, $uid, "Sysman says: No more diskspace!\n");
		&informRoom($roomNum, $uid, "Sysman looks very upset!\n");
	};

	return;
};

1;
