#############################################################################
# MUDA: Resurrection							    #
# natalyNpc.pl		: Nataly routines. Tried to make Nataly as similar  #
#			  as possible to original Nataly (muda8.exe) 	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub natalyNpc {
	# We may use an empty sub for non-reacting dump monsters:
	# return 0;
	use strict;
	my ($c_pid, $uid, $lcmd, $message) = @_; 
	my ($c_username, $c_uid, $c_cmqid, $c_roomNum, $c_gender) = &intPid2Details($c_pid);
	my $ic_username = $c_username;
	if (
		(defined $c_uid) and 
		($main::usersMainData[$c_uid]->{ invisible }) 
	) {
		$ic_username = 'Somebody';
	};

	my ($username, undef, undef, $roomNum, undef) = &intUid2Details($uid);
	if (uc($lcmd) eq '__INFO') {
		if ($message =~ /just came in/) {
			 ($c_username, $message) = split / /, $message, 2;
			&intTell($uid, 'TELL', $c_username, "Welcome, $c_username. Hungry?", 1);
		};
		return 1;
	} elsif (uc($lcmd) eq '__LOOKEDAT') {
		return 0;
	} elsif (uc($lcmd) eq '__ATTACK') {
		# Just cancel the fight.
		&clientTell($c_cmqid, $c_username, $c_pid, "A magic force pushes you back!\n");
		&informRoom($c_roomNum, $c_uid, "A magic force pushes $ic_username back!\n", $uid);
		&informRoom($c_roomNum, $uid, "$username smiles and says: You must pay for this!\n");
		$main::usersMainData[ $c_uid ]->{ coins } -= 500;
		&clientTell($c_cmqid, $c_username, $c_pid, "$username takes 500 coins from you!\n");
		&informRoom($c_roomNum, $c_uid, "$username takes 500 coins from $ic_username!\n", $uid);
		return 1;
	} elsif (uc($lcmd) eq '__GIVEN') {
		# Just keep it. $message is item id.
		my $iid = $message;
		if ($main::itemData{ $iid }->{ edible } > 0) {
			# Keep it:
			&informRoom($c_roomNum, $uid, "$username smiles and says: Thank you, $c_username!\n");
			# Consolidate:
			&intConsolidateInv($main::usersMainData[ $uid ]->{ inventory });
		} else {
			# Don't need it.
			&informRoom($c_roomNum, $uid, "$username smiles and says: Thank you, $c_username, but i don't need that!\n");
			&informRoom($c_roomNum, $uid, "$username drops $main::itemData{ $iid }->{ shortDesc }.\n");
			$main::itemData{ $iid }->{ roomID } = $roomNum;
			$main::itemData{ $iid }->{ userID } = 0;
			# Change inventory data structure: 
			my $rec = $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
			delete $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
			# Change room data structure:
			$rec->{ roomID } = $roomNum;
			$rec->{ userID } = 0;
			$main::roomsData[ $roomNum ]->{ presentItems }->{ $iid } = $rec;
			# Consolidate
			&intConsolidateInv($main::roomsData[ $roomNum ]->{ presentItems });
		};
		return 1;
	} elsif (uc($lcmd) eq '__TOLD') {
		# Somebody said $message to us.
		my ($natalyCmd, $args) = split / /, uc($message), 2;
		$natalyCmd = quotemeta($natalyCmd);
		if ('HELP' =~ m/^$natalyCmd/i) {
			&informRoom($c_roomNum, $c_uid, "$username whispers something to $ic_username.\n", $uid);
			&clientTell($c_cmqid, $c_username, $c_pid, "Use WHISPER " . uc($username) . " BUY <item to order>...\n");
			&clientTell($c_cmqid, $c_username, $c_pid, "or MENU.\n");
			#&intTell($uid, 'WHISPER', $c_username, "Use WHISPER " . uc($username) . " BUY <item to order>...", 1);
			#&intTell($uid, 'WHISPER', $c_username, "or MENU.", 1);
			return 1;
		} elsif ('MENU' =~ m/^$natalyCmd/i) {
			my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
			# Just dump Nataly's inventory to user, with a price next to each item.
			if ((scalar keys %$inv_ref) == 0) {
				&intTell($uid, 'TELL', $c_username, "Sorry, I am out of stock!", 1);
				return 1;
			};
			&informRoom($c_roomNum, $c_uid, "$username whispers something to $ic_username.\n", $uid);
			foreach my $iid (keys %$inv_ref) {
				my $price = &intNatalyValue($iid);
				$price += $price * 0.1;
				if ($price < 0) { $price = 0; };
				$price = (sprintf("%.0f", $price)) + 0;
				my $pcs = my $each = '';
				if ($inv_ref->{ $iid }->{ amount } > 1) {
					$pcs = " ($inv_ref->{ $iid }->{ amount } pcs) ";
					$each = ' each';
				};	
				#&intTell($uid, 'TELL', $c_username, $inv_ref->{ $iid }->{ shortDesc } . "$pcs\tfor $price coins$each.", 1);
				my $msg = $inv_ref->{ $iid }->{ shortDesc } . "$pcs\tfor $price coins$each.\n";
				&clientTell($c_cmqid, $c_username, $c_pid, $msg);
			};
			return 1;
		} elsif ('BUY' =~ m/^$natalyCmd/i) {
			my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
			if ((scalar keys %$inv_ref) == 0) {
				&intTell($uid, 'TELL', $c_username, "Sorry, I am out of stock!", 1);
				return 1;
			};
			my @items = ();
			if ($args =~ /^#/) {
				# Special syntax with internal item id to resolve ambiguities
				my ($scrap, $iid) = split /#/, $args, 2;
				if (not defined($inv_ref->{ $iid })) {
					&intTell($uid, 'WHISPER', $c_username, "I don't have a #$iid item.", 1);
				};
				if (
					($inv_ref->{ $iid }->{ invisible } == 1) or 
					($inv_ref->{ $iid }->{ userID } == 0) or
					($inv_ref->{ $iid }->{ userID } != $uid)
				) {
					&intTell($uid, 'WHISPER', $c_username, "I don't have a #$iid item.", 1);
					return @items;
				};
				push @items, $iid;
			} else {
				$args = quotemeta($args);
				foreach my $iid (keys %$inv_ref) {
					if ($inv_ref->{ $iid }->{ invisible } == 0) { 	# Only visible
						my $shortDesc = $inv_ref->{ $iid }->{ shortDesc };
						if ($shortDesc =~ m/$args/i) {
							push @items, $iid;
						};
					};
				};
			};
			if (scalar(@items) == 0) {
				# Not found.
				&intTell($uid, 'WHISPER', $c_username, "I dont have any $args!", 1);
			} elsif (scalar(@items) > 1) {
				# Found more than one:
				&intTell($uid, 'WHISPER', $c_username, "Which one do you want to buy?", 1);
				foreach my $iid (@items) {
					my $price = &intNatalyValue($iid);
					$price += $price * 0.1;
					if ($price < 0) { $price = 0; };
					$price = (sprintf("%.0f", $price)) + 0;
					my $pcs = my $each = '';
					if ($inv_ref->{ $iid }->{ amount } > 1) {
						$pcs = " ($inv_ref->{ $iid }->{ amount } pcs) ";
						$each = ' each';
					};	
					my $msg = "#$iid\t: " . $inv_ref->{ $iid }->{ shortDesc } . "$pcs\tfor $price coins$each.\n";
					&clientTell($c_cmqid, $c_username, $c_pid, $msg);

					#&intTell($uid, 'WHISPER', $c_username, "#$iid\t: " . $inv_ref->{ $iid }->{ shortDesc } . "$pcs for $price coins$each.", 1);
				};
				return 1;
			} else {
				# Exactly one: 
				my $iid = pop @items;
				my $price = &intNatalyValue($iid);
				$price += $price * 0.1;
				$price = (sprintf("%.0f", $price)) + 0;
				my $item_ref = $main::itemData{ $iid };
				if ($price < 0) { $price = 0; };
				if ($price == 0) {
					&intTell($uid, 'WHISPER', $c_username, "You can have this for free...", 1);
				};
				my $shortDesc = $item_ref->{ shortDesc };
				if (($main::itemData{ $iid }->{ worn } == 1) or ($main::itemData{ $iid }->{ wielded } == 1)) {
					&intTell($uid, 'TELL', $c_username, "Sorry, this is not for sale.", 1);
					return 1;
				};
				# If item is multiple and not missile, decrease amount, create a new one and use the
				# new iid for the rest of the command.
				if ($main::itemData{ $iid }->{ amount } > 1) {
					my $niid = &intCreateItemFromItem($uid, $iid, 2);
					if (not $niid) {
						# Error:
						&intTell($uid, 'TELL', $c_username, "Sorry, $shortDesc looks broken.", 1);
						return 1;
					};
					# New item created, decrease amount and work with new item:
					$main::itemData{ $iid }->{ amount } -= 1;
					$main::itemData{ $niid }->{ amount } = 1;
					$iid = $niid;
				};
				if ($price > $main::usersMainData[ $c_uid ]->{ coins }) {
					&intTell($uid, 'TELL', $c_username, "Sorry, you don\'t have enough coins.", 1);
					return 1;
				};
				# Change main data structure:
				$main::itemData{ $iid }->{ userID } = $c_uid;
				# Change inventory data structure: 
				# Remove from donor:
				my $rec = $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
				delete $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
				# Add to recipient:
				$rec->{ userID } = $c_uid;
				$main::usersMainData[ $c_uid ]->{ inventory }->{ $iid } = $rec;
				# Inform
				&clientTell($c_cmqid, $c_username, $c_pid, "You give $price coins to $username.\n");
				&informRoom($c_roomNum, $c_uid, "$ic_username gives $price coins to $username.\n", $uid);
				$main::usersMainData[ $c_uid ]->{ coins } -= $price;
				&clientTell($c_cmqid, $c_username, $c_pid, "$username gives you $shortDesc.\n");
				&informRoom($c_roomNum, $c_uid, "$username gives $shortDesc to $ic_username.\n", $uid);
				# Consolidate:
				&intConsolidateInv($main::usersMainData[ $c_uid ]->{ inventory });
			};
		} else {
			# Reply something.
			#print "DEBUG: I am $uid, he is $c_username\n";
			&intTell($uid, 'TELL', $c_username, "Hi $ic_username, do you need any *help*?", 1);
		};
		return 1;
	} elsif (uc($lcmd) eq '__AMB') {
		# Ambient commands. Message is actual action (push, shake etc).
		if (($message eq 'PUSH') or ($message eq 'KICK') or ($message eq 'SPIT') or ($message eq 'BITE')) {
			&intTell($uid, 'TELL', $c_username, "Hey, what\'s wrong with you!", 1);
		} elsif ($message eq 'HAND') {
			&informRoom($c_roomNum, $uid, "$username blushes!\n");
		} elsif (($message eq 'KISS') or ($message eq 'HUG') or ($message eq 'CARESS')) {
			&clientTell($c_cmqid, $c_username, $c_pid, "Ouch! $username slaps you in the face!\n");
			&informRoom($c_roomNum, $c_uid, "$username slaps $ic_username in the face!\n", $uid);
		} elsif ($message eq 'SHAKE') {
			&intTell($uid, 'TELL', $c_username, "Hi $ic_username, nice to meet you.", 1);
		} elsif ($message eq 'BOW') {
			&clientTell($c_cmqid, $c_username, $c_pid, "$username bows to you.\n");
			&informRoom($c_roomNum, $c_uid, "$username bows to $ic_username.\n", $uid);
		} else {
			# Should not get here:
			&informRoom($c_roomNum, $uid, "$username gasps in astonishment!\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("natalyNpc: fall out on |$lcmd|\n");
		return undef;
	};
};

sub natalyNpcTick {
	use strict;
	my ($notifier_ref, $rest) = @_;
	# We have the notifier object ref passed as parameter.
	# Notifiers created by NPCs have their name set to NPC_<user id>.
	# So we can read and set all NPC's attributes, including room number! :-)

	my $idStr = $notifier_ref->notifier_name;
	my (undef, $uid) = split /_/, $idStr, 2;
	# We don't need all the following, left here for reference:
	my ($username, $pid, $cmqid, $roomNum, $gender) = &intUid2Details($uid);
	# randomWalk merely checks for wrong room if called on NPCs with a single
	# room in walk list.
	# my $rc = &randomWalk($roomNum, $uid, $username);
	# rc is the new roomNum, or 0 if failed.
	# But Nataly is special:
	my $protoId = $main::usersMainData[ $uid ]->{ protoId };
	my @walk_list = split /,/, $main::npcProto[ $protoId ]->{ walk_rooms };
	if ($main::npcProto[ $protoId ]->{ walk_rooms } ne '') {
		if (scalar(grep(/^$roomNum$/, @walk_list)) < 1) {
			# Invalid room, teleport:
			my $newpos = 0;
			# Choose from list:
			while ($newpos == 0) {
				$newpos = $main::roomsData[ $walk_list[ rand( scalar( @walk_list ))] ]->{ roomNum };
			};
			# Inform old room!
			&informRoom($roomNum, $uid, "$username smiles and says: I must go back to the restaurant!\n");
			&informRoom($roomNum, $uid, "$username leaves gracefully.\n");
			# Move NPC:
			&movePlayer($uid, $newpos);
			# Inform new room!
			&informRoom($newpos, $uid, "$username enters and this place is better.\n");
			&informRoom($newpos, $uid, "$username says: Can i help you?\n");
			return $newpos;
		};
	};

	# Restock.
	my @stock = (17, 18, 19, 20, 21);	#itemProto ids.
	my @foods = ('A cherry pie', 'An apple pie', 'A roasted chicken', 'A fish on a stick', 'A boiled cabbage');
	my @colors = ('white', 'black', 'red', 'green', 'yellow', 'blue', 'pink', 'grey');
	my @names = ('mushroom', 'apple', 'appricot', 'pomegranate');
	my @drinks = ('A lagger beer', 'A black beer', 'A red beer', 'A light ale');
	my @types = ('food', 'poison', 'healing', 'intox', 'drink');
	my %type_cnt = ();

	foreach my $type (@types) {
		$type_cnt{$type} = 0;
	};
	# Search inv and count different types:
	my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
	foreach my $iid (keys %$inv_ref) {
		if (
			($inv_ref->{ $iid }->{ edible } > 0) and
			($inv_ref->{ $iid }->{ drinkable } == 0) and
			($inv_ref->{ $iid }->{ poison } == 0) and
			($inv_ref->{ $iid }->{ healing } == 0) and
			($inv_ref->{ $iid }->{ intox } == 0)
		) {
			# Food
			$type_cnt{ food }++;
		} elsif (
			($inv_ref->{ $iid }->{ drinkable } > 0)
		) {
			# Drink
			$type_cnt{ drink }++;
		} elsif (
			($inv_ref->{ $iid }->{ poison } > 0)
		) {
			# poison
			$type_cnt{ poison }++;
		} elsif (
			($inv_ref->{ $iid }->{ poison } == 0) and
			($inv_ref->{ $iid }->{ healing } > 0)
		) {
			# Healing
			$type_cnt{ healing }++;
		} elsif (
			($inv_ref->{ $iid }->{ intox } > 0)
		) {
			# Intoxicating
			$type_cnt{ intox }++;
		};
	};

	# Must have at least 2 from each type.
	foreach my $type (@types) {
		if ($type_cnt{$type} < 2) {
			# Find an item of that type to create.
			foreach my $ipid (@stock) {
				my $niid = &intCreateItemFromProto($uid, $ipid, 2);
				if ($type eq 'food') {
					# Make sure it's straight food and change the descr to something foody.
					my $edible = sprintf("%.0f", rand(30) + 5);
					$inv_ref->{ $niid }->{ edible } = $edible; 
					$inv_ref->{ $niid }->{ drinkable } = 0; 
					$inv_ref->{ $niid }->{ poison } = 0; 
					$inv_ref->{ $niid }->{ healing } = 0; 
					$inv_ref->{ $niid }->{ intox } = 0; 
					my $id1 = sprintf("%.0f", rand(scalar(@foods)) - 1);
					$inv_ref->{ $niid }->{ shortDesc } = $foods[$id1]; 
					$inv_ref->{ $niid }->{ longDesc } = $foods[$id1]; 
				} elsif ($type eq 'drink') {
					my $drinkable = sprintf("%.0f", rand(30) + 5);
					my $intox = sprintf("%.0f", rand(20) + 1);
					$inv_ref->{ $niid }->{ intox } = $intox; 
					my $id1 = sprintf("%.0f", rand(scalar(@drinks)) - 1);
					$inv_ref->{ $niid }->{ shortDesc } = $drinks[$id1]; 
					$inv_ref->{ $niid }->{ longDesc } = $drinks[$id1]; 
				} elsif ($type eq 'poison') {
					my $poison = sprintf("%.0f", rand(20) + 1);
					$inv_ref->{ $niid }->{ poison } = $inv_ref->{ $niid }->{ healing } + $poison; 
					$inv_ref->{ $niid }->{ healing } = 0; 
					# All poison items must me edible and not drinkable.
					my $edible = sprintf("%.0f", rand(30) + 5);
					$inv_ref->{ $niid }->{ edible } = $edible; 
					$inv_ref->{ $niid }->{ drinkable } = 0; 
					my $id1 = sprintf("%.0f", rand(scalar(@colors)) - 1);
					my $id2 = sprintf("%.0f", rand(scalar(@names)) - 1);
					my $desc = 'A ' . $colors[$id1] . ' ' . $names[$id2];
					$inv_ref->{ $niid }->{ shortDesc } = $desc; 
					$inv_ref->{ $niid }->{ longDesc } = "$desc. It looks dangerous."; 
				} elsif ($type eq 'healing') {
					my $healing = sprintf("%.0f", rand(10) + 1);
					$inv_ref->{ $niid }->{ healing } = $inv_ref->{ $niid }->{ poison } + $healing; 
					$inv_ref->{ $niid }->{ poison } = 0; 
					# All healing items must me edible and not drinkable.
					my $edible = sprintf("%.0f", rand(30) + 5);
					$inv_ref->{ $niid }->{ edible } = $edible; 
					$inv_ref->{ $niid }->{ drinkable } = 0; 
					my $id1 = sprintf("%.0f", rand(scalar(@colors)) - 1);
					my $id2 = sprintf("%.0f", rand(scalar(@names)) - 1);
					my $desc = 'A ' . $colors[$id1] . ' ' . $names[$id2];
					$inv_ref->{ $niid }->{ shortDesc } = $desc; 
					$inv_ref->{ $niid }->{ longDesc } = "$desc. It looks fresh."; 
				} elsif ($type eq 'intox') {
					my $intox = sprintf("%.0f", rand(15) + 1);
					$inv_ref->{ $niid }->{ intox } = $intox; 
					# All intox items must me edible and not drinkable.
					my $edible = sprintf("%.0f", rand(30) + 5);
					$inv_ref->{ $niid }->{ edible } = $edible; 
					$inv_ref->{ $niid }->{ drinkable } = 0; 
					my $id1 = sprintf("%.0f", rand(scalar(@colors)) - 1);
					my $id2 = sprintf("%.0f", rand(scalar(@names)) - 1);
					my $desc = 'A ' . $colors[$id1] . ' ' . $names[$id2];
					$inv_ref->{ $niid }->{ shortDesc } = $desc; 
					$inv_ref->{ $niid }->{ longDesc } = "$desc. It looks a bit stale."; 
				};
			};
		};
	};
	# Consolidate:
	&intConsolidateInv($main::usersMainData[ $uid ]->{ inventory });
	return;
};

sub intNatalyValue {
	# Given an item's id, determine its value.
	# Nataly's version, edible stuff.
	my ($iid, $rest) = @_;
	my $item_ref = $main::itemData{ $iid };
	my $value = 0;
	$value += $item_ref->{ edible } * 2;
	$value += $item_ref->{ drinkable } * 2;
	$value -= $item_ref->{ poison } * 3;
	$value += $item_ref->{ healing } * 3;
	$value += $item_ref->{ intox } * 4;
	return $value;
};

1;
