#############################################################################
# MUDA: Resurrection							    #
# catNpc.pl		: Cat routines. Tried to make Cat as similar  # 
#			  as possible to original Cat (muda8.exe) 	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub catNpc {
	# We may use an empty sub for non-reacting dump monsters:
	# return 0;
	use strict;
	my ($c_pid, $uid, $lcmd, $message) = @_; 
	my ($c_username, $c_uid, $c_cmqid, $c_roomNum, $c_gender) = &intPid2Details($c_pid);
	my $ic_username = $c_username;
	if (
		(defined $c_uid) and 
		($main::usersMainData[$c_uid]->{ invisible }) 
	) {
		$ic_username = 'Somebody';
	};

	my ($username, undef, undef, $roomNum, undef) = &intUid2Details($uid);
	if (uc($lcmd) eq '__INFO') {
		return 0;
	} elsif (uc($lcmd) eq '__LOOKEDAT') {
		&informRoom($c_roomNum, $uid, "<Miaw!>\n");
		return 1;
	} elsif (uc($lcmd) eq '__ATTACK') {
		# Just cancel the fight.
		&clientTell($c_cmqid, $c_username, $c_pid, "$username scratches your face!\n");
		&informRoom($c_roomNum, $c_uid, "$username scratches $ic_username in the face!\n", $uid);
		&informRoom($c_roomNum, $uid, "<Miaaaaaaaarrrrrrrr!>\n");
		$main::usersMainData[ $c_uid ]->{ hitPoints } -= 50;
		if ($main::usersMainData[ $c_uid ]->{ hitPoints } < ($main::usersMainData[ $c_uid ]->{ maxHp } * 0.05)) {
			$main::usersMainData[ $c_uid ]->{ hitPoints } = $main::usersMainData[ $c_uid ]->{ maxHp } * 0.05;
		};
		return 1;
	} elsif (uc($lcmd) eq '__GIVEN') {
		my $iid = $message;
		&clientTell($c_cmqid, $c_username, $c_pid, "$username can't hold it. No thumbs!\n");
		&informRoom($c_roomNum, $uid, "$username drops $main::itemData{ $iid }->{ shortDesc }.\n");
		$main::itemData{ $iid }->{ roomID } = $roomNum;
		$main::itemData{ $iid }->{ userID } = 0;
		# Change inventory data structure: 
		my $rec = $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
		delete $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
		# Change room data structure:
		$rec->{ roomID } = $roomNum;
		$rec->{ userID } = 0;
		$main::roomsData[ $roomNum ]->{ presentItems }->{ $iid } = $rec;
		return 1;
	} elsif (uc($lcmd) eq '__TOLD') {
		# Somebody said $message to us.
		my ($catCmd, $args) = split / /, uc($message);
		# Reply something.
		&informRoom($c_roomNum, $uid, "<Miaw?>\n");
		return 1;
	} elsif (uc($lcmd) eq '__AMB') {
		# Ambient commands. Message is actual action (push, shake etc).
		if (($message eq 'PUSH') or ($message eq 'KICK') or ($message eq 'SPIT') or ($message eq 'BITE')) {
			&clientTell($c_cmqid, $c_username, $c_pid, "$username scratches your face!\n");
			&informRoom($c_roomNum, $c_uid, "$username scratches $ic_username in the face!\n", $uid);
			&informRoom($c_roomNum, $uid, "<Miaaaaaaaarrrrrrrr!>\n");
			$main::usersMainData[ $c_uid ]->{ hitPoints } -= 50;
			if ($main::usersMainData[ $c_uid ]->{ hitPoints } < ($main::usersMainData[ $c_uid ]->{ maxHp } * 0.05)) {
				$main::usersMainData[ $c_uid ]->{ hitPoints } = $main::usersMainData[ $c_uid ]->{ maxHp } * 0.05;
			};
			return 1;
		} elsif (($message eq 'KISS') or ($message eq 'TOUCH') or ($message eq 'HAND')or ($message eq 'CARESS')) {
			&informRoom($c_roomNum, $uid, "$username blushes gracefully ...\n");
			&informRoom($c_roomNum, $uid, "$username feels happy.\n");
			&clientTell($c_cmqid, $c_username, $c_pid, "$username stares at you smiling!\n");
		} elsif (($message eq 'SHAKE') or ($message eq 'BOW')) {
			&informRoom($c_roomNum, $uid, "$username looks bored.\n");
		} elsif ($message eq 'HUG') {
			&informRoom($c_roomNum, $uid, "$username turns blue. Don\'t hug her so tight!\n");
		} else {
			# Should not get here:
			&informRoom($c_roomNum, $uid, "$username yawns.\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("catNpc: fall out on |$lcmd|\n");
		return undef;
	};
};

sub catNpcTick {
	my ($notifier_ref, $rest) = @_;
	# We have the notifier object ref passed as parameter.
	# Notifiers created by NPCs have their name set to NPC_<user id>.
	# So we can read and set all NPC's attributes, including room number! :-)

	my $idStr = $notifier_ref->notifier_name;
	my (undef, $uid) = split /_/, $idStr, 2;
	# We don't need all the following, left here for reference:
	my ($username, $pid, $cmqid, $roomNum, $gender) = &intUid2Details($uid);
	# randomWalk merely checks for wrong room if called on NPCs with a single
	# room in walk list.
	# my $rc = &randomWalk($roomNum, $uid, $username);
	# rc is the new roomNum, or 0 if failed.
	# But Cat is special:
	my $protoId = $main::usersMainData[ $uid ]->{ protoId };
	my @walk_list = split /,/, $main::npcProto[ $protoId ]->{ walk_rooms };
	if ($main::npcProto[ $protoId ]->{ walk_rooms } ne '') {
		if (scalar(grep(/^$roomNum$/, @walk_list)) < 1) {
			# Invalid room, teleport:
			my $newpos = 0;
			# Choose from list:
			while ($newpos == 0) {
				$newpos = $main::roomsData[ $walk_list[ rand( scalar( @walk_list ))] ]->{ roomNum };
			};
			# Inform old room!
			&informRoom($roomNum, $uid, "$username dissappears!\n");
			# Move NPC:
			&movePlayer($uid, $newpos);
			# Inform new room!
			&informRoom($newpos, $uid, "$username appears from nowhere!\n");
			return $newpos;
		};
	};
	my $randact = rand(1000);
	if ($randact < 100) {
		&informRoom($roomNum, $uid, "$username yawns.\n");
	} elsif (
		($randact >= 100) and 
		($randact < 200) 
	) {
		&informRoom($roomNum, $uid, "$username scratches.\n");
	} elsif (
		($randact >= 200) and 
		($randact < 300) 
	) {
		&informRoom($roomNum, $uid, "$username falls asleep.\n");
	} elsif (
		($randact >= 300) and 
		($randact < 400) 
	) {
		&informRoom($roomNum, $uid, "$username purrs.\n");
	} elsif (
		($randact >= 400) and 
		($randact < 500) 
	) {
		&informRoom($roomNum, $uid, "$username listens to something.\n");
	} elsif (
		($randact >= 500) and 
		($randact < 600) 
	) {
		&informRoom($roomNum, $uid, "$username licks its self.\n");
	} elsif (
		($randact >= 600) and 
		($randact < 700) 
	) {
	} elsif (
		($randact >= 700) and 
		($randact < 800) 
	) {
	} elsif (
		($randact >= 800) and 
		($randact < 900) 
	) {
	} elsif (
		($randact >= 900) and 
		($randact < 1000) 
	) {
	};
	if (scalar(@{ $main::roomsData[ $roomNum ]->{presentUids} }) > 0) {
		# There are people here.
		USRLOOP:		foreach my $ouid (@{ $main::roomsData[ $roomNum ]->{presentUids} } ) {
			my ($v_username, $v_pid, $v_cmqid, $v_roomNum, $v_gender) = &intUid2Details($ouid);
			my $ic_username = $v_username;
			if (
				(defined $ouid) and 
				($main::usersMainData[$ouid]->{ invisible }) 
			) {
				$ic_username = 'Somebody';
			};
			if ($v_pid > 0) {
				# Logged in user:
				&informRoom($roomNum, $uid, "$username miaws.\n");
				&informRoom($roomNum, $ouid, "$username lies in front of $ic_username.\n", $uid);
				&clientTell($v_cmqid, $v_username, $v_pid, "$username lies in front of you!\n");
				last USRLOOP;
			};
		};
	};
	return;
};

1;
