#############################################################################
# MUDA: Resurrection							    #
# boboNpc.pl		: Bobo routines. Tried to make Bobo as similar as   #
#			  possible to original Bobo (muda8.exe) 	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub boboNpc {
	# We may use an empty sub for non-reacting dump monsters:
	# return 0;
	use strict;
	my ($c_pid, $uid, $lcmd, $message) = @_; 

	my ($c_username, $c_uid, $c_cmqid, $c_roomNum, $c_gender) = &intPid2Details($c_pid);
	my $ic_username = $c_username;
	if (
		(defined $c_uid) and 
		($main::usersMainData[$c_uid]->{ invisible }) 
	) {
		$ic_username = 'Somebody';
	};

	my ($username, undef, undef, $roomNum, undef) = &intUid2Details($uid);

	if (uc($lcmd) eq '__INFO') {
		if ($message =~ /just came in/) {
			 ($c_username, $message) = split / /, $message, 2;
			&intTell($uid, 'TELL', $c_username, "Welcome, $c_username, may I interest you in some fine items?", 1);
		};
		return 1;
	} elsif (uc($lcmd) eq '__LOOKEDAT') {
		return 0;
	} elsif (uc($lcmd) eq '__ATTACK') {
		# Just cancel the fight.
		&clientTell($c_cmqid, $c_username, $c_pid, "A magic force pushes you back!\n");
		&informRoom($c_roomNum, $c_uid, "A magic force pushes $ic_username back!\n", $uid);
		&informRoom($c_roomNum, $uid, "Bobo smiles and says: You must pay for this!\n");
		$main::usersMainData[ $c_uid ]->{ coins } -= 500;
		&clientTell($c_cmqid, $c_username, $c_pid, "Bobo takes 500 coins from you!\n");
		&informRoom($c_roomNum, $c_uid, "Bobo takes 500 coins from $ic_username!\n", $uid);
		return 1;
	} elsif (uc($lcmd) eq '__GIVEN') {
		# Just keep it. $message is item id.
		&informRoom($c_roomNum, $uid, "Bobo smiles and says: Thank you, $c_username!\n");
		# Consolidate:
		&intConsolidateInv($main::usersMainData[ $uid ]->{ inventory });
		return 1;
	} elsif (uc($lcmd) eq '__TOLD') {
		# Somebody said $message to us.
		my ($boboCmd, $args) = split / /, uc($message), 2;
		$boboCmd = quotemeta($boboCmd);
		if ('HELP' =~ m/^$boboCmd/i) {
			&informRoom($c_roomNum, $c_uid, "Bobo whispers something to $ic_username.\n", $uid);
			&clientTell($c_cmqid, $c_username, $c_pid, "Use WHISPER BOBO EXAMINE <item>...\n");
			&clientTell($c_cmqid, $c_username, $c_pid, "or BUY, SELL, VALUE, PRICELIST...\n");
			&clientTell($c_cmqid, $c_username, $c_pid, "It will cost you 200 coins.\n");
			#&intTell($uid, 'WHISPER', $c_username, "Use WHISPER BOBO EXAMINE <item>...", 1);
			#&intTell($uid, 'WHISPER', $c_username, "or BUY, SELL, VALUE, PRICELIST...", 1);
			#&intTell($uid, 'WHISPER', $c_username, "It will cost you 200 coins.", 1);
			return 1;
		} elsif ('EXAMINE' =~ m/^$boboCmd/i) {
			if ($main::usersMainData[ $c_uid ]->{ coins } < 200) {
				&intTell($uid, 'WHISPER', $c_username, "You don\'t have enough coins!", 1);
				return 1;
			};
			my $c_inv_ref = $main::usersMainData[ $c_uid ]->{ inventory };
			my $finish = 0;
			my @items = &intBoboItemChoose($c_inv_ref, \$finish, $uid, $c_username, $c_uid, $args);
			if ($finish) { return 1; };
			if (scalar(@items) == 0) {
				# Not found.
				&intTell($uid, 'WHISPER', $c_username, "You dont have any $args!", 1);
			} elsif (scalar(@items) > 1) {
				# Found more than one:
				&intTell($uid, 'WHISPER', $c_username, "Which one do you want me to examine?", 1);
				foreach my $iid (@items) {
					#&intTell($uid, 'WHISPER', $c_username, "#$iid\t: " . $c_inv_ref->{ $iid }->{ shortDesc }, 1);
					my $msg = "#$iid\t: " . $c_inv_ref->{ $iid }->{ shortDesc } . "\n";
					&clientTell($c_cmqid, $c_username, $c_pid, $msg);
				};
				return 1;
			} else {
				# Exactly one: 
				my $iid = pop @items;
				my $item_ref = $main::itemData{ $iid };
				$main::usersMainData[ $c_uid ]->{ coins } -= 200; 
				&clientTell($c_cmqid, $c_username, $c_pid, "You give 200 coins to Bobo.\n");
				my $resp = 0; 	# If it stays 0 after the spagetti below, we must send
						# a default message.
				if ($item_ref->{ wearable }) {
					# Armour
					if (not defined $item_ref->{ armourClass }) {
						&intTell($uid, 'WHISPER', $c_username, "Hmmm, strange... It\'s armour, but I can't tell anything more...", 1);
					} else {
						my $ac = $item_ref->{ armourClass };
						if ($ac <=5) {
							&intTell($uid, 'WHISPER', $c_username, "Better find something other to protect you...", 1);
						} elsif (($ac > 5) and ($ac <=10)) {
							&intTell($uid, 'WHISPER', $c_username, "Not enough, not enough ...", 1);
						} elsif (($ac > 10) and ($ac <=15)) {
							&intTell($uid, 'WHISPER', $c_username, "Good armor, but better avoid big guys...", 1);
						} elsif (($ac > 15) and ($ac <=20)) {
							&intTell($uid, 'WHISPER', $c_username, "Very good armor, can help you a lot...", 1);
						} elsif (($ac > 20) and ($ac <=25)) {
							&intTell($uid, 'WHISPER', $c_username, "Really good! This thing can save your life!", 1);
						} elsif (($ac > 25) and ($ac <=33)) {
							&intTell($uid, 'WHISPER', $c_username, "Wow! Two more like that, and you are safe!", 1);
						} elsif ($ac > 33) {
							&intTell($uid, 'TELL', $c_username, "Gasp! This is a mage\'s armour!", 1);
							if ($main::usersMainData[ $c_uid ]->{ level } > 17) {
								&clientTell($c_cmqid, $c_username, $c_pid, "Bobo bows to you!\n");
								&informRoom($c_roomNum, $c_uid, "Bobo bows to $c_username!\n");
							} else {
								&intTell($uid, 'TELL', $c_username, "This armour is forbidden for you!", 1);
							};
						} else {
							# We should never need this normally:
							&intTell($uid, 'WHISPER', $c_username, "This armour looks broken!", 1);
						};
					};
					$resp = 1;
				};
				if ($item_ref->{ wieldable }) {
					# Weapon
					$resp = 1;
					if (not defined $item_ref->{ weaponClass }) {
						&intTell($uid, 'WHISPER', $c_username, "Hmmm, strange... It\'s a weapon, but I can't tell anything more...", 1);
					} else {
						my $wc = $item_ref->{ weaponClass };
						if ($wc <=1) {
							&intTell($uid, 'TELL', $c_username, "And you are using this for fights?", 1);
							&informRoom($c_roomNum, $uid, "Bobo falls down laughing.\n");
						} elsif (($wc > 1) and ($wc <= 3)) {
							&intTell($uid, 'TELL', $c_username, "Find some rats and bats to fight with...", 1);
						} elsif (($wc > 3) and ($wc <= 20)) {
							&intTell($uid, 'WHISPER', $c_username, "Not bad, makes your hit about $wc times stronger.", 1);
						} elsif (($wc > 20) and ($wc <= 50)) {
							&intTell($uid, 'WHISPER', $c_username, "Gasp! About $wc weapon level!", 1);
						} elsif ($wc > 50)  {
							&informRoom($c_roomNum, $uid, "Bobo says: Gasp!\n");
							&informRoom($c_roomNum, $uid, "Bobo looks afraid!\n");
						} else {
							# We should never need this normally:
							&intTell($uid, 'WHISPER', $c_username, "This weapon looks broken!", 1);
						};
					};
				};
				if ($item_ref->{ containVolume }) {
					# Container
					&intTell($uid, 'WHISPER', $c_username, "You can put other things in it.", 1);
					$resp = 1;
				};
				if ($item_ref->{ dropable } == 0) {
					# Not dropable
					&intTell($uid, 'WHISPER', $c_username, "You can't drop that!", 1);
					$resp = 1;
				};
				if ($item_ref->{ edible }) {
					&intTell($uid, 'WHISPER', $c_username, "You can eat it when you are hungry.", 1);
					$resp = 1;
				};
				if ($item_ref->{ drinkable }) {
					&intTell($uid, 'WHISPER', $c_username, "You can drink it when you are thirsty.", 1);
					$resp = 1;
				};
				if ($item_ref->{ key }) {
					&intTell($uid, 'WHISPER', $c_username, "You can unlock something with it", 1);
					$resp = 1;
				};
				if ($item_ref->{ executable } ne '') {
					&intTell($uid, 'WHISPER', $c_username, "It has some powers", 1);
					$resp = 1;
				};
				if ($item_ref->{ missile }) {
					&intTell($uid, 'WHISPER', $c_username, "You must use something to launch it.", 1);
					$resp = 1;
				};
				if ($item_ref->{ missile_launcher }) {
					$resp = 1;
					if (not defined $item_ref->{ weaponClass }) {
						&intTell($uid, 'WHISPER', $c_username, "Hmmm, strange... It\'s a weapon, but I can't tell anything more...", 1);
					} else {
						my $wc = $item_ref->{ weaponClass };
						if ($wc <=2) {
							&intTell($uid, 'TELL', $c_username, "And you are using this for fights?", 1);
							&informRoom($c_roomNum, $uid, "Bobo falls down laughing.\n");
						} elsif (($wc > 2) and ($wc <= 4)) {
							&intTell($uid, 'WHISPER', $c_username, "Well, not useless, but find a better one.", 1);
						} elsif (($wc > 4) and ($wc <= 6)) {
							&intTell($uid, 'WHISPER', $c_username, "Not bad, it could help you enough...", 1);
						} elsif (($wc > 6) and ($wc <= 8)) {
							&intTell($uid, 'WHISPER', $c_username, "Gasp! A very good bow, indeed!", 1);
						} elsif ($wc > 10)  {
							&intTell($uid, 'WHISPER', $c_username, "Wow! One of the best bows i\'ve ever seen!", 1);
						} else {
							# We should never need this normally:
							&intTell($uid, 'WHISPER', $c_username, "This weapon looks broken!", 1);
						};
					};
				};
				if ($item_ref->{ keepOnDeath }) {
					&intTell($uid, 'WHISPER', $c_username, "This thing will follow to the other life!", 1);
					$resp = 1;
				};
				if (not $resp) {
					# Somehow Bobo know nothing about this item:
					&intTell($uid, 'TELL', $c_username, "I don't know what this is!", 1);
				};
			};
		} elsif ('VALUE' =~ m/^$boboCmd/i) {
			my $c_inv_ref = $main::usersMainData[ $c_uid ]->{ inventory };
			my $finish = 0;
			my @items = &intBoboItemChoose($c_inv_ref, \$finish, $uid, $c_username, $c_uid, $args);
			if ($finish) { return 1; };
			if (scalar(@items) == 0) {
				# Not found.
				&intTell($uid, 'WHISPER', $c_username, "You dont have any $args!", 1);
			} elsif (scalar(@items) > 1) {
				# Found more than one:
				&intTell($uid, 'WHISPER', $c_username, "Which one do you want me to value?", 1);
				foreach my $iid (@items) {
					my $msg = "#$iid\t: " . $c_inv_ref->{ $iid }->{ shortDesc } . "\n";
					&clientTell($c_cmqid, $c_username, $c_pid, $msg);
					#&intTell($uid, 'WHISPER', $c_username, "#$iid\t: " . $c_inv_ref->{ $iid }->{ shortDesc }, 1);
				};
				return 1;
			} else {
				# Exactly one: 
				my $iid = pop @items;
				my $value = &intBoboValue($iid);
				my $item_ref = $main::itemData{ $iid };
				if ($value == 0) {
					&intTell($uid, 'WHISPER', $c_username, "I am not interested in such items...", 1);
					return 1;
				};
				&intTell($uid, 'WHISPER', $c_username, "I could give $value gold coins for " . $item_ref->{ shortDesc } . ".", 1);

			};
		} elsif ('PRICELIST' =~ m/^$boboCmd/i) {
			my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
			# Just dump Bobo's inventory to user, with a price next to each item.
			# Sell prices are 20% more than buy prices:
			if ((scalar keys %$inv_ref) == 0) {
				&intTell($uid, 'TELL', $c_username, "Sorry, I am out of stock!", 1);
				return 1;
			};
			&informRoom($c_roomNum, $c_uid, "Bobo whispers something to $ic_username.\n", $uid);
			foreach my $iid (keys %$inv_ref) {
				my $price = &intBoboValue($iid);
				$price += $price * 0.2;
				$price = (sprintf("%.0f", $price)) + 0;
				my $pcs = my $each = '';
				if ($inv_ref->{ $iid }->{ amount } > 1) {
					$pcs = " ($inv_ref->{ $iid }->{ amount } pcs) ";
					if ($inv_ref->{ $iid }->{ missile } == 0) {
						# Missiles are sold in bunches.
						$each = ' each';
					} else {
						$price *= $inv_ref->{ $iid }->{ amount };
					};
				};	
				# inTell is too noisy, will use clientTell and informRoom.
				#&intTell($uid, 'TELL', $c_username, $inv_ref->{ $iid }->{ shortDesc } . "$pcs\tfor $price coins$each.", 1);
				my $msg = $inv_ref->{ $iid }->{ shortDesc } . "$pcs\tfor $price coins$each.\n";
				&clientTell($c_cmqid, $c_username, $c_pid, $msg);

			};
			return 1;
		} elsif ('SELL' =~ m/^$boboCmd/i) {
			my $c_inv_ref = $main::usersMainData[ $c_uid ]->{ inventory };
			my $finish = 0;
			my @items = &intBoboItemChoose($c_inv_ref, \$finish, $uid, $c_username, $c_uid, $args);
			if ($finish) { return 1; };
			if (scalar(@items) == 0) {
				# Not found.
				&intTell($uid, 'WHISPER', $c_username, "You dont have any $args!", 1);
			} elsif (scalar(@items) > 1) {
				# Found more than one:
				&intTell($uid, 'WHISPER', $c_username, "Which one do you want to sell?", 1);
				foreach my $iid (@items) {
					my $msg = "#$iid\t: " . $c_inv_ref->{ $iid }->{ shortDesc } . "\n";
					&clientTell($c_cmqid, $c_username, $c_pid, $msg);
					#&intTell($uid, 'WHISPER', $c_username, "#$iid\t: " . $c_inv_ref->{ $iid }->{ shortDesc }, 1);
				};
				return 1;
			} else {
				# Exactly one: 
				my $iid = pop @items;
				my $value = &intBoboValue($iid);
				my $item_ref = $main::itemData{ $iid };
				if ($value == 0) {
					&intTell($uid, 'WHISPER', $c_username, "I am not interested in such items...", 1);
					return 1;
				};
				# Get item from user and give the cash:
				my $shortDesc = $item_ref->{ shortDesc };
				if ($item_ref->{ dropable } == 0) {
					&intTell($uid, 'WHISPER', $c_username, "You can\'t sell that!", 1);
					return 1;
				};
				if ($main::itemData{ $iid }->{ worn } == 1) {
					$main::itemData{ $iid }->{ worn } = 0;
					$main::usersMainData[ $c_uid ]->{ inventory }->{ $iid}->{ worn } = 0;
					&clientTell($c_cmqid, $c_username, $c_pid, "You take off $shortDesc.\n");
					&informRoom($c_roomNum, $c_uid, "$c_username takes off $shortDesc\n");
				};
				if ($main::itemData{ $iid }->{ wielded } == 1) {
					$main::itemData{ $iid }->{ wielded } = 0;
					$main::usersMainData[ $c_uid ]->{ inventory }->{ $iid }->{ wielded } = 0;
					&clientTell($c_cmqid, $c_username, $c_pid, "You unwield $shortDesc.\n");
					&informRoom($c_roomNum, $c_uid, "$c_username unwields $shortDesc\n");
				};
				# If item is multiple, decrease amount, create a new one and use the
				# new iid for the rest of the command.
				if ($main::itemData{ $iid }->{ amount } > 1) {
					my $niid = &intCreateItemFromItem($c_pid, $iid, 1);
					if (not $niid) {
						# Error:
						&clientTell($c_cmqid, $c_username, $c_pid, "You failed to drop $shortDesc (internal error).\n");
						return;
					};
					# New item created, decrease amount and work with new item:
					$main::itemData{ $iid }->{ amount } -= 1;
					$main::itemData{ $niid }->{ amount } = 1;
					$iid = $niid;
				};

				# Change main data structure:
				$main::itemData{ $iid }->{ userID } = $uid;
				# Change inventory data structure: 
				# Remove from donor:
				my $rec = $main::usersMainData[ $c_uid ]->{ inventory }->{ $iid };
				delete $main::usersMainData[ $c_uid ]->{ inventory }->{ $iid };
				# Add to recipient:
				$rec->{ userID } = $uid;
				$main::usersMainData[ $uid ]->{ inventory }->{ $iid } = $rec;
				# Inform
				#my ($v_username, $v_pid, $v_cmqid, $v_roomNum, $v_gender) = &intUid2Details($ouid);
				&clientTell($c_cmqid, $c_username, $c_pid, "You give $shortDesc to Bobo.\n");
				&informRoom($c_roomNum, $c_uid, "$ic_username gives $shortDesc to Bobo.\n", $uid);
				$main::usersMainData[ $c_uid ]->{ coins } += $value;
				&clientTell($c_cmqid, $c_username, $c_pid, "Bobo gives you $value coins.\n");
				&informRoom($c_roomNum, $c_uid, "Bobo gives $value coins to $ic_username.\n", $uid);
				# Consolidate:
				&intConsolidateInv($main::usersMainData[ $uid ]->{ inventory });
			};
		} elsif ('BUY' =~ m/^$boboCmd/i) {
			my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
			if ((scalar keys %$inv_ref) == 0) {
				&intTell($uid, 'TELL', $c_username, "Sorry, I am out of stock!", 1);
				return 1;
			};
			my @items = ();
			if ($args =~ /^#/) {
				# Special syntax with internal item id to resolve ambiguities
				my ($scrap, $iid) = split /#/, $args, 2;
				if (not defined($inv_ref->{ $iid })) {
					&intTell($uid, 'WHISPER', $c_username, "I don't have a #$iid item.", 1);
				};
				if (
					($inv_ref->{ $iid }->{ invisible } == 1) or 
					($inv_ref->{ $iid }->{ userID } == 0) or
					($inv_ref->{ $iid }->{ userID } != $uid)
				) {
					&intTell($uid, 'WHISPER', $c_username, "I don't have a #$iid item.", 1);
					return @items;
				};
				push @items, $iid;
			} else {
				$args = quotemeta($args);
				foreach my $iid (keys %$inv_ref) {
					if ($inv_ref->{ $iid }->{ invisible } == 0) { 	# Only visible
						my $shortDesc = $inv_ref->{ $iid }->{ shortDesc };
						if ($shortDesc =~ m/($args)/i) {
							push @items, $iid;
						};
					};
				};
			};

			if (scalar(@items) == 0) {
				# Not found.
				&intTell($uid, 'WHISPER', $c_username, "I dont have any $args!", 1);
			} elsif (scalar(@items) > 1) {
				# Found more than one:
				&intTell($uid, 'WHISPER', $c_username, "Which one do you want to buy?", 1);
				foreach my $iid (@items) {
					my $msg = "#$iid\t: " . $inv_ref->{ $iid }->{ shortDesc } . "\n";
					&clientTell($c_cmqid, $c_username, $c_pid, $msg);
					#&intTell($uid, 'WHISPER', $c_username, "#$iid\t: " . $inv_ref->{ $iid }->{ shortDesc }, 1);
				};
				return 1;
			} else {
				# Exactly one: 
				my $iid = pop @items;
				my $price = &intBoboValue($iid);
				$price += $price * 0.2;
				$price = (sprintf("%.0f", $price)) + 0;
				my $item_ref = $main::itemData{ $iid };
				if ($price == 0) {
					&intTell($uid, 'WHISPER', $c_username, "You can have this for free...", 1);
				};
				# Get item from user and give the cash:
				my $shortDesc = $item_ref->{ shortDesc };
				if (($main::itemData{ $iid }->{ worn } == 1) or ($main::itemData{ $iid }->{ wielded } == 1)) {
					&intTell($uid, 'TELL', $c_username, "Sorry, this is not for sale.", 1);
					return 1;
				};
				# If item is multiple and not missile, decrease amount, create a new one and use the
				# new iid for the rest of the command.
				if (
					($main::itemData{ $iid }->{ amount } > 1) and 
					($main::itemData{ $iid }->{ missile } == 0)
				) {
					my $niid = &intCreateItemFromItem($uid, $iid, 2);
					if (not $niid) {
						# Error:
						&intTell($uid, 'TELL', $c_username, "Sorry, $shortDesc looks broken.", 1);
						return 1;
					};
					# New item created, decrease amount and work with new item:
					$main::itemData{ $iid }->{ amount } -= 1;
					$main::itemData{ $niid }->{ amount } = 1;
					$iid = $niid;
				} elsif (
					($main::itemData{ $iid }->{ amount } > 1) and 
					($main::itemData{ $iid }->{ missile } > 0)
				) {
					# Missile. Multiply price.
					$price *= $main::itemData{ $iid }->{ amount };
				};
				if ($price > $main::usersMainData[ $c_uid ]->{ coins }) {
					&intTell($uid, 'TELL', $c_username, "Sorry, you don\'t have enough coins.", 1);
					return 1;
				};
				# Change main data structure:
				$main::itemData{ $iid }->{ userID } = $c_uid;
				# Change inventory data structure: 
				# Remove from donor:
				my $rec = $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
				delete $main::usersMainData[ $uid ]->{ inventory }->{ $iid };
				# Add to recipient:
				$rec->{ userID } = $c_uid;
				$main::usersMainData[ $c_uid ]->{ inventory }->{ $iid } = $rec;
				# Inform
				&clientTell($c_cmqid, $c_username, $c_pid, "You give $price coins to Bobo.\n");
				&informRoom($c_roomNum, $c_uid, "$ic_username gives $price coins to Bobo.\n", $uid);
				$main::usersMainData[ $c_uid ]->{ coins } -= $price;
				&clientTell($c_cmqid, $c_username, $c_pid, "Bobo gives you $shortDesc.\n");
				&informRoom($c_roomNum, $c_uid, "Bobo gives $shortDesc to $ic_username.\n", $uid);
				# Consolidate:
				&intConsolidateInv($main::usersMainData[ $c_uid ]->{ inventory });
			};
		} else {
			# Reply something.
			#print "DEBUG: I am $uid, he is $c_username\n";
			&intTell($uid, 'TELL', $c_username, "Hi $c_username, do you need any *help*?", 1);
		};
		return 1;
	} elsif (uc($lcmd) eq '__AMB') {
		# Ambient commands. Message is actual action (push, shake etc).
		if (($message eq 'PUSH') or ($message eq 'KICK') or ($message eq 'SPIT') or ($message eq 'BITE')) {
			&intTell($uid, 'TELL', $c_username, "Hey, what\'s wrong with you!", 1);
		} elsif (($message eq 'KISS') or ($message eq 'HUG') or ($message eq 'HAND')or ($message eq 'CARESS')) {
			&informRoom($c_roomNum, $uid, "Bobo blushes!\n");
		} elsif ($message eq 'SHAKE') {
			&intTell($uid, 'TELL', $c_username, "Hi $c_username, nice to meet you.", 1);
		} elsif ($message eq 'BOW') {
			&clientTell($c_cmqid, $c_username, $c_pid, "Bobo bows to you.\n");
			&informRoom($c_roomNum, $c_uid, "Bobo bows to $ic_username.\n", $uid);
		} else {
			# Should not get here:
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("boboNpc: fall out on |$lcmd|\n");
		return undef;
	};
};

sub boboNpcTick {
	my ($notifier_ref, $rest) = @_;
	# We have the notifier object ref passed as parameter.
	# Notifiers created by NPCs have their name set to NPC_<user id>.
	# So we can read and set all NPC's attributes, including room number! :-)

	my $idStr = $notifier_ref->notifier_name;
	my (undef, $uid) = split /_/, $idStr, 2;
	# We don't need all the following, left here for reference:
	my ($username, $pid, $cmqid, $roomNum, $gender) = &intUid2Details($uid);
	# randomWalk merely checks for wrong room if called on NPCs with a single
	# room in walk list.
	# my $rc = &randomWalk($roomNum, $uid, $username);
	# rc is the new roomNum, or 0 if failed.
	# But Bobo is special:
	my $protoId = $main::usersMainData[ $uid ]->{ protoId };
	my @walk_list = split /,/, $main::npcProto[ $protoId ]->{ walk_rooms };
	if ($main::npcProto[ $protoId ]->{ walk_rooms } ne '') {
		if (scalar(grep(/^$roomNum$/, @walk_list)) < 1) {
			# Invalid room, teleport:
			my $newpos = 0;
			# Choose from list:
			while ($newpos == 0) {
				$newpos = $main::roomsData[ $walk_list[ rand( scalar( @walk_list ))] ]->{ roomNum };
			};
			print "DEBUG: Bobo #$uid in invalid room (#$roomNum)! moving to #$newpos\n";
			# Inform old room!
			&informRoom($roomNum, $uid, "Bobo says: Hey, this is not my shop!\n");
			&informRoom($roomNum, $uid, "Bobo leaves on his Harley.\n");
			# Move NPC:
			&movePlayer($uid, $newpos);
			# Inform new room!
			&informRoom($newpos, $uid, "Bobo enters riding his Harley.\n");
			&informRoom($newpos, $uid, "Bobo says: Can i help you?\n");
			return $newpos;
		};
	};

	# Restock.
	my @stock = (1, 2, 9, 10, 11, 12, 13, 14, 15, 16);	#itemProto ids.
	my @arrow_stock = (8);					#itemProto ids.
	my @types = (2,3,4,6,7,8,9);	# Type ids.
	my @colors = ('white', 'black', 'red', 'green', 'yellow', 'blue', 'pink', 'grey');
	my %type_cnt;
	my $arrcnt = 0;
	foreach my $type (@types) {
		$type_cnt{$type} = 0;
	};
	# Search inv and count different types:
	my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
	foreach my $iid (keys %$inv_ref) {
		$type_cnt{ $inv_ref->{ $iid }->{ gen_item_type } } += $inv_ref->{ $iid }->{ amount };
		if ($inv_ref->{ $iid }->{ missile } == 1) {$arrcnt++;};
	};
	# Must have at least 2 from each type.
	foreach my $type (@types) {
		if ($type_cnt{$type} < 2) {
			# Find an item of that type to create.
			# Actually create one of all items of that type in stock.
			foreach my $ipid (@stock) {
				if ($main::itemProto{$ipid}->{ gen_item_type } == $type) {
					&intCreateItemFromProto($uid, $ipid, 2);
				};
			};
		};
	};
	# Arrows:
	if ($arrcnt < 4) {
		# We have less than 4 bunches of arrows, lets create one.
		foreach $ipid (@arrow_stock) {
			my $iid = &intCreateItemFromProto($uid, $ipid, 2);
			# Customize:
			my $amount = sprintf("%.0f", rand(20)) + 5;
			$inv_ref->{ $iid }->{ amount } = $amount; 
			my $cid1 = sprintf("%.0f", rand(scalar(@colors)) - 1);
			my $cid2 = sprintf("%.0f", rand(scalar(@colors)) - 1);
			if ($cid1 < 0) { $cid = 0; };
			if ($cid2 < 0) { $cid = 0; };
			if ($cid1 == $cid2) {
				$inv_ref->{ $iid }->{ shortDesc } = "A " . $colors[$cid1] . " arrow";
			} else {
				$inv_ref->{ $iid }->{ shortDesc } = "A " . $colors[$cid1] . " and " . $colors[$cid2] . " arrow";
			};
		};
	};
	# Consolidate:
	&intConsolidateInv($main::usersMainData[ $uid ]->{ inventory });

	return;
};

sub intBoboItemChoose {
	my ($c_inv_ref, $finish_ref, $uid, $c_username, $c_uid, $args) = @_;
	my @items = ();
	if ((scalar keys %$c_inv_ref) == 0) {
		&intTell($uid, 'TELL', $c_username, "You don\'t carry anything!", 1);
		$$finish_ref = 1;
		return @items;
	};
	if ($args =~ /^#/) {
		# Special syntax with internal item id to resolve ambiguities
		my ($scrap, $iid) = split /#/, $args, 2;
		if (not defined($c_inv_ref->{ $iid })) {
			&intTell($uid, 'WHISPER', $c_username, "You don't have a #$iid item.", 1);
			$$finish_ref = 1;
			return @items;
		};
		if (
			($c_inv_ref->{ $iid }->{ invisible } == 1) or 
			($c_inv_ref->{ $iid }->{ userID } == 0) or
			($c_inv_ref->{ $iid }->{ userID } != $c_uid)
		) {
			&intTell($uid, 'WHISPER', $c_username, "You don't have a #$iid item.", 1);
			$$finish_ref = 1;
			return @items;
		};
		push @items, $iid;
	} else {
		$args = quotemeta($args);
		foreach my $iid (keys %$c_inv_ref) {
			if ($c_inv_ref->{ $iid }->{ invisible } == 0) { 	# Only visible
				my $shortDesc = $c_inv_ref->{ $iid }->{ shortDesc };
				if ($shortDesc =~ m/$args/i) {
					push @items, $iid;
				};
			};
		};
	};
	return @items;
};

sub intBoboValue {
	# Given an item's id, determine its value.
	my ($iid, $rest) = @_;
	my $item_ref = $main::itemData{ $iid };
	my $value = 0;
	if ($item_ref->{ wearable }) {
		# Armour
		if (defined $item_ref->{ armourClass }) {
			$value += $item_ref->{ armourClass } * 20;
		};
	};
	if ($item_ref->{ wieldable }) {
		# Armour
		if (defined $item_ref->{ weaponClass }) {
			$value += $item_ref->{ weaponClass } * 20;
		};
	};
	# Container
	$value += $item_ref->{ containVolume };
	if ($item_ref->{ missile_launcher }) {
		$value += $item_ref->{ weaponClass } * 100;
	};
	if ($item_ref->{ missile }) {
		$value += $item_ref->{ count } * 20;
	};
	if ($item_ref->{ keepOnDeath }) {
		# Valuable
		$value += 1000;
	};
	return $value;
};

1;
