#############################################################################
# MUDA: Resurrection							    #
# wallMirror.pl		: A wall mirror. Example of standard command 	    #
#			  overriding.					    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub wallMirror {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	#$args = quotemeta($args);
	#print "DEBUG: lcmd is $lcmd\n";	
	#print "DEBUG: args is $args\n";	
	if (uc($lcmd) eq '__LIST') {
		return 'LOOK';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		&clientTell($cmqid, $username, $pid, "It's a mirror. You can look at it.\n");
		return 1;
	} elsif ($lcmd =~ m/LOOK/i)  {
		# Check if the LOOK goes to us:
		my ($at, $mirror) = split / /, uc($args);
		if (
			($at eq 'AT') and
			('MIRROR' =~ m/^$mirror/i)
		) {
			if ($main::usersMainData[$uid]->{ invisible } == 0) {
				&informRoom($roomNum, $uid, "$username looks at the mirror.\n");
			};
			# Quest #1 code:
			$main::questData{1}->{ memory }->{ $uid }->{ mirror } = 1;
			# Show something:
			my $msg = '';
			if ($main::usersMainData[$uid]->{ invisible } == 0) {
				my $msg = "You see $username, " . $main::usersMainData[$uid]->{ desc } . ".\n";
				&clientTell($cmqid, $username, $pid, $msg);
			} else {
				my $msg = "You see nothing. You are invisible. Or a vampire. Or both.\n";
				&clientTell($cmqid, $username, $pid, $msg);
				return 1;
			};
			my (@wielded, @worn) = ();
			my $v_inv_ref = $main::usersMainData[$uid]->{ inventory }; 
			foreach my $viid (keys %$v_inv_ref) {
				if ($v_inv_ref->{ $viid }->{ worn } == 1) {
					push @worn, $v_inv_ref->{ $viid }->{ shortDesc };
				};
				if ($v_inv_ref->{ $viid }->{ wielded } == 1) {
					push @wielded, $v_inv_ref->{ $viid }->{ shortDesc };
				};
			};
			if (scalar(@worn) > 0) {
				my $msg = "$username wears:\n";
				&clientTell($cmqid, $username, $pid, $msg);
				foreach $msg (@worn) {
					&clientTell($cmqid, $username, $pid, "$msg.\n");
				};
			};
			if (scalar(@wielded) > 0) {
				my $msg = "$username wields:\n";
				&clientTell($cmqid, $username, $pid, $msg);
				foreach $msg (@wielded) {
					&clientTell($cmqid, $username, $pid, "$msg.\n");
				};
			};
			return 1;
		} else {
			# Continue with look
			return 0;
		};
	} else {
		# We should never reach that normally.
		&logPrint("wallMirror: fall out\n");
		return undef;
	};
};

1;
