#############################################################################
# MUDA: Resurrection							    #
# templeDevice.pl	: This item will be installed in room #1. Praying   #
#			  to heal, until other healing stuff is coded.	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub templeDevice {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'PRAY';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ($lcmd =~ m/PRAY/i)  {
		# Ignore arguments.
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username prays.\n");
		};
		&clientTell($cmqid, $username, $pid, "You pray to the Gods.\n");
		$main::usersMainData[$uid]->{ hitPoints } = $main::usersMainData[$uid]->{ maxHp };
		&clientTell($cmqid, $username, $pid, "The Gods heal your wounds!\n");
		# Quest #1 code
		if (
			(defined $main::questData{1}->{ memory }->{ $uid }->{ big }) and
			(defined $main::questData{1}->{ memory }->{ $uid }->{ small }) and
			(defined $main::questData{1}->{ memory }->{ $uid }->{ mirror })
		) {
			# Quest solved:
			&clientTell($cmqid, $username, $pid, "You solved the Test Quest!\n");
			my %slv = ();
			while (my ($key, $value) = each %{ $main::usersMainData[ $uid ]->{ quests } }) {
				$slv{$value} = $key;
			};
			if (defined $slv{1}) {
				# Already solved.
			} else {
				# First time.
				$main::usersMainData[$uid]->{ xp } += 2;
				$main::usersMainData[$uid]->{ coins } += 1000;
				&clientTell($cmqid, $username, $pid, "The Gods reward you with 2 xp and 1000 coins!\n");
				# Use an arbitrary string containing the quest id for key. It will be
				# replaced by a db row id in next load.
				$main::usersMainData[ $uid ]->{ quests }->{ QN1 } = 1;
			};
			# Reset quest for player. We may also reset all quest variables here, if there
			# are any variables affecting all users.
			# Reseting must be done by deleting variables, as this will save space in the
			# "memory" field of the quest.
			delete $main::questData{1}->{ memory }->{ $uid };
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("templeDevice: fall out\n");
		return undef;
	};
};

1;
