#############################################################################
# MUDA: Resurrection							    #
# systemTerminal.pl: This item will be installed in the lab. Used to give   #
#			  system info.					    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub systemTerminal {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	#&logPrint("DEBUG: lcmd is |$lcmd|, args is |$args|\n");
	if (uc($lcmd) eq '__LIST') {
		return 'EXAMINE LOOK';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# "furniture". Do nothing.
	} elsif (
			('EXAMINE' =~ m/$lcmd/i) or
			('LOOK' =~ m/$lcmd/i) 
		) {
		my ($at, $rest) = split / /, $args, 2;
		if (not defined $at) { $at = '' };
		if (not defined $rest) { $rest = '' };
		if (uc($at) eq 'AT') {
			$args = $rest;
		};
		#&logPrint("DEBUG: at is |$at|, rest is |$rest|, args is |$args|\n");
		$args = quotemeta($args);
		if (
			(not ('TERMINAL' =~ m/$args/i)) and
#			(not ('AT TERMINAL' =~ m/$args/i)) and
			(not ('SCREEN' =~ m/$args/i)) #and
#			(not ('AT SCREEN' =~ m/$args/i))
		) {
			# These commands (EXAMINE, LOOK), are also normal
			# commands, so we must let the parser continue.
			return 0;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username examines the terminal.\n");
		};
		&clientTell($cmqid, $username, $pid, "This is an old monochrome terminal. On the screen, you can barely read:\n");
		my $mudaprompt = '$>';
		# System uptime:
		open CMDOUT, "/usr/bin/uptime |";
		&clientTell($cmqid, $username, $pid, "$mudaprompt uptime\n");
		while (<CMDOUT>) {
			&clientTell($cmqid, $username, $pid, "$_");
		};
		close CMDOUT;
		open CMDOUT, "/usr/bin/free |";
		&clientTell($cmqid, $username, $pid, "$mudaprompt free\n");
		while (<CMDOUT>) {
			&clientTell($cmqid, $username, $pid, "$_");
		};
		close CMDOUT;
		open CMDOUT, "/bin/uname -a |";
		&clientTell($cmqid, $username, $pid, "$mudaprompt uname -a\n");
		while (<CMDOUT>) {
			&clientTell($cmqid, $username, $pid, "$_");
		};
		close CMDOUT;
		open CMDOUT, "/bin/df -h |";
		&clientTell($cmqid, $username, $pid, "$mudaprompt df -h\n");
		while (<CMDOUT>) {
			&clientTell($cmqid, $username, $pid, "$_");
		};
		close CMDOUT;
		my $suptime = time - $main::boottime;
		my $upstring = "$mudaprompt mutime\nMUDA uptime: ";
		my $days = sprintf("%d", $suptime/86400);
		my $rest = $suptime % 86400;
		my $hours = sprintf("%d", $rest/3600);
		$rest = $rest % 3600;
		my $minutes = sprintf("%d", $rest/60);
		my $seconds = $rest % 60;
		$upstring = $upstring . "$days days, $hours hours, $minutes minutes, $seconds seconds.";
		&clientTell($cmqid, $username, $pid, "$upstring\n");
		
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("systemTerminal: fall out\n");
		return undef;
	};
};

1;
