#############################################################################
# MUDA: Resurrection							    #
# smallGreenButton.pl	: This item code includes loop code and self item   #
#			  alteration.					    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub smallGreenButton {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'PUSH PRESS';
	} elsif (uc($lcmd) eq '__INFORM') {
		if (not defined $cmqid) {
			# We only care for users:
			return 1;
		};
		if ($args =~ m/just came in/i) {
			&clientTell($cmqid, $username, $pid, "A tiny ethereal voice whispers to you: \"Push me!\"\n");
			return 1;
		} else {
			# We can do much more stuff here...
			return 1;
		};
	} elsif (uc($lcmd) eq '__USE') {
		&clientTell($cmqid, $username, $pid, "It's a button. You can push it.\n");
		return 1;
	} elsif (($lcmd =~ m/PUSH/i) or ($lcmd =~ m/PRESS/i)) {
		my $shortDesc = $main::itemData{$iid}->{ shortDesc };
		&clientTell($cmqid, $username, $pid, "You push $shortDesc.\n");
		&informRoom($roomNum, $uid, "$i_username pushes $shortDesc.\n");
		&informRoom($roomNum, -1, "A small buzzer sounds!\n");
		# Quest #1 code:
		$main::questData{1}->{ memory }->{ $uid }->{ small } = 1;
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("smallGreenButton: fall out\n");
		return undef;
	};
};

sub sgbTick {
	my ($notifier_ref, $rest) = @_;
	# We have the notifier object ref passed as parameter.
	# Notifiers created by items have their name set to ITEM_<item id>.
	# So we can read and set all item's attributes, including room number! :-)
	my $idStr = $notifier_ref->notifier_name;
	my (undef, $iid) = split /_/, $idStr, 2;
	my $roomNum = $main::itemData{$iid}->{ roomID };
	if ($roomNum < 1) {
		my $userID = $main::itemData{$iid}->{ userID };
		$roomNum = $main::usersMainData[ $userID ]->{ room };
		if (not defined $roomNum) { $roomNum = 'undef'; };
		if ((not defined $roomNum) or ($roomNum < 1)) {
			# I AM LOST! 
			return;
		};
	};
	my $shortDesc = $main::itemData{$iid}->{ shortDesc };
	if ($shortDesc =~ m/green/i) {
		$main::itemData{$iid}->{ shortDesc } = 'A Small Yellow Button';
		$main::itemData{$iid}->{ longDesc } = 'A strange Small Yellow Button.';
		&informRoom($roomNum, -1, "The small green button turns yellow!\n");
	} else {
		$main::itemData{$iid}->{ shortDesc } = 'A Small Green Button';
		$main::itemData{$iid}->{ longDesc } = 'A strange Small Green Button.';
		&informRoom($roomNum, -1, "The small yellow button turns green!\n");
	};
	return;
};

1;
