#############################################################################
# MUDA: Resurrection							    #
# invisibilityMachine.pl: This item will be installed in the lab. Used to   #
#			  test invisibility code.			    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub invisibilityMachine {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'PULL';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# "furniture". Do nothing.
	} elsif ($lcmd =~ m/PULL/i)  {
		if (not ('HANDLE' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Pull what?\n");
			return 1;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username pulls the handle on the device.\n");
		} else {
			&clientTell($cmqid, $username, $pid, "You pull the handle but nothing happens.\n");
			return 1;
		};
		&clientTell($cmqid, $username, $pid, "You pull the handle and you feel a tickling through your body!\n");
		$main::usersMainData[$uid]->{ invisible } = 300;
		&informRoom($roomNum, $uid, "$username becomes invisible and disappears!\n");
		&clientTell($cmqid, $username, $pid, "You are invisible!\n");
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("invisibilityMachine: fall out\n");
		return undef;
	};
};

1;
