#############################################################################
# MUDA: Resurrection							    #
# goldenBadge.pl	: A badge for the old BITNET MUDA players. Provides #
#			  teleport to low level users.    		    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub goldenBadge {
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	if (uc($lcmd) eq '__LIST') {
		return 'TELEPORT';
	} elsif (uc($lcmd) eq '__INFORM') {
		# This item ignores everything that happens in the room,
		# but we need to have this elsif to avoid fall out.
		return 1;
	} elsif (uc($lcmd) eq '__USE') {
		&clientTell($cmqid, $username, $pid, "It provides the TELEPORT command.\n");
		return 1;
	} elsif ('TELEPORT' =~ m/$lcmd/i) {
		&clientTell($cmqid, $username, $pid, "You touch your badge.\n");
		&informRoom($roomNum, $uid, "$i_username touches the golden badge.\n");
		# Temporary set god mode
		my $origGM = $main::usersMainData[$uid]->{ godMode };
		$main::usersMainData[$uid]->{ godMode } = 1;
		&cmdTeleport($pid, $args);
		$main::usersMainData[$uid]->{ godMode } = $origGM;
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("goldenBadge: fall out\n");
		return undef;
	};
};

1;
