#############################################################################
# MUDA: Resurrection							    #
# coinsItem.pl		: All money in M:R appears as this item.	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub coinsItem {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	if (uc($lcmd) eq '__LIST') {
		return 'GET';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 0;
	} elsif (uc($lcmd) eq '__USE') {
		&clientTell($cmqid, $username, $pid, "Some gold coins in various shapes.\n");
		return 1;
	} elsif ($lcmd =~ m/GET/i) {
		# Check that $args matches our description:
		# ... or our $iid
		my ($scrap, $spiid) = split /#/, $args, 2;
		$args = quotemeta($args);
		if (not (
				($main::itemData{ $iid }->{ shortDesc } =~ m/$args/i) or
				($iid == $spiid)
			)
		) {
			# Do nothing:
			return 0;
		};
		# Inform
		&clientTell($cmqid, $username, $pid, "You take " . $main::itemData{ $iid }->{ amount } . " coins.\n");
		&informRoom($roomNum, $uid, "$i_username takes some coins.\n");
		# Give money
		$main::usersMainData[ $uid ]->{ coins } += $main::itemData{ $iid }->{ amount };
		# Self destruct:
		&intDestroyItem($iid);
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("coinItem: fall out\n");
		return undef;
	};
};

1;
