#############################################################################
# MUDA: Resurrection							    #
# bigRedButton.pl	: Simple item code to test functionality.	    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub bigRedButton {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	if (uc($lcmd) eq '__LIST') {
		return 'PUSH PUNCH PRESS';
	} elsif (uc($lcmd) eq '__INFORM') {
		if (not defined $cmqid) {
			# We only care for users:
			return 1;
		};
		if ($args =~ m/just came in/i) {
			&clientTell($cmqid, $username, $pid, "An ethereal voice whispers to you: \"Push me!\"\n");
			return 1;
		} else {
			# We can do much more stuff here...
			return 1;
		};
	} elsif (uc($lcmd) eq '__USE') {
		&clientTell($cmqid, $username, $pid, "It's a button. You can push it.\n");
		return 1;
	} elsif (
			($lcmd =~ m/PUSH/i) or 
			($lcmd =~ m/PRESS/i) or 
			($lcmd =~ m/PUNCH/i)
		) {
		&clientTell($cmqid, $username, $pid, "You push the Big Red Button.\n");
		&informRoom($roomNum, $uid, "$i_username pushes the Big Red Button.\n");
		&informRoom($roomNum, -1, "A loud horn sounds!\n");
		# Save the economy:
		my $amount = sprintf("%.0f",rand(5000));
		my $rc = &intCreateMoney($roomNum, $amount);
		if ($rc) {
			&informRoom($roomNum, -1, "$amount coins fall from a small opening in the ceiling.\n");
		};

		# Quest #1 code:
		$main::questData{1}->{ memory }->{ $uid }->{ big } = 1;
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("bigRedButton: fall out\n");
		return undef;
	};
};

1;
