#############################################################################
# MUDA: Resurrection							    #
# RCMD986.pl		: Room 986 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD986 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'READ PRESS';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('READ' =~ m/$lcmd/i)  {
		if (not ('SIGN' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Read what?\n");
			return 1;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username reads the sign.\n");
		};
		&clientTell($cmqid, $username, $pid, "*** WELCOME TO MERLINs TEMPLE ***\n");
		&clientTell($cmqid, $username, $pid, "Be careful here. Many hints are hidden\n");
		&clientTell($cmqid, $username, $pid, "in the room`s descriptions...\n");
		&clientTell($cmqid, $username, $pid, "                        Merlin\n");
		&clientTell($cmqid, $username, $pid, "---------------------------------------\n");
		&clientTell($cmqid, $username, $pid, "There is a button near the sign.\n");
		return 1;
	} elsif ('PRESS' =~ m/$lcmd/i)  {
		if (not ('BUTTON' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Press what?\n");
			return 1;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username pressed a button.\n");
		};
		&clientTell($cmqid, $username, $pid, "Well done, you learn fast| Here is a hint:\n");
		&clientTell($cmqid, $username, $pid, "3E4S3E2NWSWN\n");
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD986: fall out\n");
		return undef;
	};
};

sub RCMD986loop {
	return;
};

1;
