#############################################################################
# MUDA: Resurrection							    #
# RCMD9.pl		: Room 9 device. 	 			    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD9 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'EXAMINE';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('EXAMINE' =~ m/$lcmd/i)  {
		if (
			(not ('MONITOR' =~ m/$args/i)) and  
			(not ('TERMINAL' =~ m/$args/i)) 
		) {
			return 0;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username examines a monitor.\n");
		};
		&clientTell($cmqid, $username, $pid, "You see a message from MUDA: \"$username examines a monitor.\"\n");
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD9: fall out\n");
		return undef;
	};
};

sub RCMD9loop {
	return;
};

1;
