#############################################################################
# MUDA: Resurrection							    #
# RCMD193.pl		: Room 193 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD193 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'DRINK';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('DRINK' =~ m/$lcmd/i)  {
		if (not ('PORRIDGE' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Drink what?\n");
			return 1;
		};
		&informRoom($roomNum, $uid, "$i_username drinks some porridge.\n");
		&clientTell($cmqid, $username, $pid, "Ouch! It s too hot!\n");
		if (not defined $main::questData{2}->{ memory }->{ amravar2 }) {
			$main::questData{2}->{ memory }->{ amravar2 } = rand(3) + 1;
		};
		if ($main::questData{2}->{ memory }->{ amravar2 } < 0) {
			&clientTell($cmqid, $username, $pid, "The bowl is now empty.\n");
			&clientTell($cmqid, $username, $pid, "As you put the bowl back on the table, you notice\n");
			&clientTell($cmqid, $username, $pid, "a lion drawn on the bottom!\n");
			&clientTell($cmqid, $username, $pid, "You take the bowl.\n");
			&intCreateItemFromProto($pid, 39, 1);
			$main::questData{2}->{ memory }->{ amravar2 } = rand(3) + 1;
		} else {
			&clientTell($cmqid, $username, $pid, "There is more porridge in the bowl.\n");
			$main::questData{2}->{ memory }->{ amravar2 }--;
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD193: fall out\n");
		return undef;
	};
};

sub RCMD193loop {
	# Reset room: 
	return;
};

1;
