#############################################################################
# MUDA: Resurrection							    #
# RCMD15.pl		: Room 15 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD15 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'EXAMINE GET';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('EXAMINE' =~ m/$lcmd/i)  {
		if (not ('BOOKSHELF' =~ m/$args/i)) {
			return 0;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username examines the bookshelf.\n");
		};
		&clientTell($cmqid, $username, $pid, "This is an old, oak-made book shelf.\n");
		&clientTell($cmqid, $username, $pid, "A book tittled \"The Amra legend\" is pulled out.\n");
		return 1;
	} elsif ('GET' =~ m/$lcmd/i)  {
		if (not ('BOOK' =~ m/$args/i)) {
			return 0;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username takes a book.\n");
		};
		&clientTell($cmqid, $username, $pid, "You got the book. You notice a page marked with a paper.\n");
		&clientTell($cmqid, $username, $pid, "You open the book in that page and you read:\n");
		&clientTell($cmqid, $username, $pid, "Three are the objects to kill Amra!\n");
		&clientTell($cmqid, $username, $pid, "The magic amulet that keeps in his hide-out!\n");
		&clientTell($cmqid, $username, $pid, "The oak bowl, made by Pan, last seen in an oak-house!\n");
		&clientTell($cmqid, $username, $pid, "The Famous Sword, but must be blessed by Merlin!\n");
		&clientTell($cmqid, $username, $pid, "You need the oak-bowl to enter the jungle!\n");
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD15: fall out\n");
		return undef;
	};
};

sub RCMD15loop {
	return;
};

1;
