#############################################################################
# MUDA: Resurrection							    #
# RCMD1105.pl		: Room 1105 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1105 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'ENTER';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('ENTER' =~ m/$lcmd/i)  {
		if (not ('GATES' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Enter what?\n");
			return 1;
		};
		# Look in user's inventory for a specific item:
		my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
		my $found = 0;
		foreach my $iid (keys %{ $inv_ref }) {
			if (${ $inv_ref }{$iid}->{ questCode } eq 'AMRAMO4') {
				$found = 1;
				&clientTell($cmqid, $username, $pid, "You are passing through the gate.\n");
				if ($main::usersMainData[$uid]->{ invisible } == 0) {
					&informRoom($roomNum, $uid, "$username goes through the gate.\n");
				};
				&movePlayer($uid, 1106);
				if ($main::usersMainData[$uid]->{ invisible } == 0) {
					&informRoom(1106, $uid, "$username appears through the gate.\n");
				};
				&clientTell($cmqid, $username, $pid, "The lions are hypnotized by Amra\'s amulet!\n");
				&clientTell($cmqid, $username, $pid, "You have entered Stan\'s treasury!\n");
				&clientTell($cmqid, $username, $pid, "You have solved the quest!\n");
				&clientTell($cmqid, $username, $pid, "Amra\'s amulet evaporates!\n");
				&intDestroyItem($iid);
				my %slv = ();
				while (my ($key, $value) = each %{ $main::usersMainData[ $uid ]->{ quests } }) {
					$slv{$value} = $key;
				};
				if (defined $slv{2}) {
					# Already solved.
				} else {
					# First time.
					$main::usersMainData[$uid]->{ xp } += 20000;
					$main::usersMainData[$uid]->{ coins } += 10000;
					&clientTell($cmqid, $username, $pid, "The Gods reward you with 20000 xp and 10000 coins!\n");
					# Use an arbitrary string containing the quest id for key. It will be
					# replaced by a db row id in next load.
					$main::usersMainData[ $uid ]->{ quests }->{ QN2 } = 2;
				};

			};
		};
		if (not $found) {
			&clientTell($cmqid, $username, $pid, "The lions attack you!\n");
			&clientTell($cmqid, $username, $pid, "Again and again, they bite you! You are close to death!\n");
			&clientTell($cmqid, $username, $pid, "... but a magic force saves you!\n");
			&informRoom($roomNum, $uid, "$i_username is attacked by the lions!\n");
			&informRoom($roomNum, $uid, "$i_username is almost dead!\n");
			if ($main::usersMainData[$uid]->{ invisible } == 0) {
				&informRoom($roomNum, $uid, "$username dissappears in a puf of smoke!\n");
			} else {
				&informRoom($roomNum, $uid, "There is a puf of smoke!\n");
			};
			&movePlayer($uid, 269);
			$main::usersMainData[ $uid ]->{ hitPoints } = 5;
			if ($main::usersMainData[$uid]->{ invisible } == 0) {
				&informRoom(269, $uid, "$username appears in a puf of smoke in a terrible condition!\n");
			} else {
				&informRoom(269, $uid, "There is a puf of smoke!\n");
			};
			&cmdLook($pid);
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1105: fall out\n");
		return undef;
	};
};

sub RCMD1105loop {
	return;
};

1;
