#############################################################################
# MUDA: Resurrection							    #
# RCMD1089.pl		: Room 1089 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1089 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'ENTER';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('ENTER' =~ m/$lcmd/i)  {
		if (not ('PIT' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Enter what?\n");
			return 1;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username enters a hidden pit!\n");
		};
		&clientTell($cmqid, $username, $pid, "You enter the pit!\n");
		&movePlayer($uid, 1104);
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom(1104, $uid, "$username appears from nowhere!\n");
		};
		&cmdLook($pid);
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1089: fall out\n");
		return undef;
	};
};

sub RCMD1089loop {
	return;
};

1;
