#############################################################################
# MUDA: Resurrection							    #
# RCMD1078.pl		: Room 1078 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1078 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'ENTER';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('ENTER' =~ m/$lcmd/i)  {
		if (not ('GATES' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Enter what?\n");
			return 1;
		};
		# Look in user's inventory for a specific item:
		my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
		my $found = 0;
		foreach my $iid (keys %{ $inv_ref }) {
			if (${ $inv_ref }{$iid}->{ questCode } eq 'AMRAMO1') {
				$found = 1;
				&clientTell($cmqid, $username, $pid, "You are passing through the gates.\n");
				if ($main::usersMainData[$uid]->{ invisible } == 0) {
					&informRoom($roomNum, $uid, "$username goes through the gates.\n");
				};
				&movePlayer($uid, 1079);
				if ($main::usersMainData[$uid]->{ invisible } == 0) {
					&informRoom(1079, $uid, "$username appears through the gates.\n");
				};
				&cmdLook($pid);
			};
		};
		if (not $found) {
			&clientTell($cmqid, $username, $pid, "A magic force keeps you back!\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1078: fall out\n");
		return undef;
	};
};

sub RCMD1078loop {
	return;
};

1;
