#############################################################################
# MUDA: Resurrection							    #
# RCMD1023.pl		: Room 1023 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1023 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'HIT';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('HIT' =~ m/$lcmd/i)  {
		if (not ('STONE' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Hit what?\n");
			return 1;
		};
		if ($main::questData{3}->{ memory }->{ stone1023 } == 1) {
			&informRoom($roomNum, $uid, "$i_username hits the stone.\n");
			&clientTell($cmqid, $username, $pid, "You hit the stone. Nothing happens.\n");
			return 1;
		};
		my @wielded = &intInvSelectNum($uid, 'wielded', 1);
		my $qwiid = 0;	# Quest weapon item id.
		foreach my $ii (keys @wielded) {
			if (
				($main::itemData{ $wielded[$ii] }->{ missile } == 1) or
				($main::itemData{ $wielded[$ii] }->{ missile_launcher } == 1) 
				# Avoid smashing bows and arrows...
			) {
				splice(@wielded, $ii, 1);
			} else {
				if ($main::itemData{ $wielded[$ii] }->{ questCode } eq 'MMSW0') {
					# Quest weapon wielded:
					$qwiid = $wielded[$ii];
				};
			};
		};
		if (scalar(@wielded) == 0) {
			# No weapon.
			&informRoom($roomNum, $uid, "$i_username smashes " . $main::lex_his[$gender] . " hand on a stone.\n");
			&clientTell($cmqid, $username, $pid, "Ouch!\n");
			return 1;
		};
		if ($qwiid > 0) {
			# Quest solved!
			&informRoom($roomNum, $uid, "$i_username just destroyed the evil egg!\n");
			&clientTell($cmqid, $username, $pid, "You have destroyed the evil egg!\n");
			&clientTell($cmqid, $username, $pid, "Your weapon evaporates!\n");
			&intDestroyItem($qwiid);
			$main::questData{3}->{ memory }->{ stone1023 } = 1;
			my %slv = ();
			while (my ($key, $value) = each %{ $main::usersMainData[ $uid ]->{ quests } }) {
				$slv{$value} = $key;
			};
			if (defined $slv{3}) {
				# Already solved.
			} else {
				# First time.
				$main::usersMainData[$uid]->{ xp } += 20000;
				$main::usersMainData[$uid]->{ coins } += 10000;
				&clientTell($cmqid, $username, $pid, "The Gods reward you with 20000 xp and 10000 coins!\n");
				# Use an arbitrary string containing the quest id for key. It will be
				# replaced by a db row id in next load.
				$main::usersMainData[ $uid ]->{ quests }->{ QN3 } = 3;
			};
			return 1;
		} else {
			# Break wielded weapon. Just set wc to 0.
			# Select the first weapon by default.
			&clientTell($cmqid, $username, $pid, "You have broken your weapon!\n");
			$main::itemData{ $wielded[0] }->{ shortDesc } .= ' (broken)';
			$main::itemData{ $wielded[0] }->{ weaponClass } = 0;
			return 1;
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1023: fall out\n");
		return undef;
	};
};

sub RCMD1023loop {
	# Reset room:
	$main::questData{3}->{ memory }->{ stone1023 } = 0;
	return;
};

1;
