#############################################################################
# MUDA: Resurrection							    #
# RCMD1017.pl		: Room 1017 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1017 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'CRY';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif (
		('CRY' =~ m/$lcmd/i)
	) {
		&informRoom($roomNum, $uid, "$i_username cries!\n");
		if ($main::questData{2}->{ memory }->{ var1017 }) {
			&clientTell($cmqid, $username, $pid, "Whaaaaaaaa!\n");
			return 1;
		};
		$main::questData{2}->{ memory }->{ var1017 } = 1;
		&clientTell($cmqid, $username, $pid, "A voice tells you: Ok, ok, don t cry! I ll give it to you!\n");
		&clientTell($cmqid, $username, $pid, "You found the 7th part of the sword!\n");
		&clientTell($cmqid, $username, $pid, "You take the sword part.\n");
		&informRoom($roomNum, $uid, "$i_username takes the sword part.\n");
		&intCreateItemFromProto($pid, 34, 1);
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1017: fall out\n");
		return undef;
	};
};

sub RCMD1017loop {
	# Reset room: 
	$main::questData{2}->{ memory }->{ var1017 } = 0;
	return;
};

1;
