#############################################################################
# MUDA: Resurrection							    #
# RCMD1016.pl		: Room 1016 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1016 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'OPEN LOOK EXAMINE SEARCH';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif (
		('OPEN' =~ m/$lcmd/i) or 
		('LOOK' =~ m/$lcmd/i) or 
		('EXAMINE' =~ m/$lcmd/i) or 
		('SEARCH' =~ m/$lcmd/i)  
	) {
		if (not ('AT CHEST' =~ m/$args/i)) {
			return 0;
		};
		&informRoom($roomNum, $uid, "$i_username opens the chest.\n");
		if ($main::questData{2}->{ memory }->{ var1016 }) {
			&clientTell($cmqid, $username, $pid, "The chest is empty.\n");
			return 1;
		};
		$main::questData{2}->{ memory }->{ var1016 } = 1;
		&clientTell($cmqid, $username, $pid, "You found the 6th part of the sword!\n");
		&clientTell($cmqid, $username, $pid, "You take the sword part.\n");
		&informRoom($roomNum, $uid, "$i_username takes the sword part.\n");
		&intCreateItemFromProto($pid, 32, 1);
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1016: fall out\n");
		return undef;
	};
};

sub RCMD1016loop {
	# Reset room: 
	$main::questData{2}->{ memory }->{ var1016 } = 0;
	return;
};

1;
