#############################################################################
# MUDA: Resurrection							    #
# RCMD1015.pl		: Room 1015 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1015 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'EXAMINE';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('EXAMINE' =~ m/$lcmd/i)  {
		if (not ('TORCH' =~ m/$args/i)) {
			return 0;
		};
		if ($main::questData{2}->{ memory }->{ var1015 }) {
			if ($main::usersMainData[$uid]->{ invisible } == 0) {
				&informRoom($roomNum, $uid, "$username examines a torch.\n");
			};
			&clientTell($cmqid, $username, $pid, "This is an old torch.\n");
			return 1;
		};
		$main::questData{2}->{ memory }->{ var1015 } = 1;
		&clientTell($cmqid, $username, $pid, "This is the 5th part of the sword!\n");
		&clientTell($cmqid, $username, $pid, "You take the sword part.\n");
		&informRoom($roomNum, $uid, "$i_username takes the sword part.\n");
		&intCreateItemFromProto($pid, 30, 1);
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1015: fall out\n");
		return undef;
	};
};

sub RCMD1015loop {
	# Reset room: 
	$main::questData{2}->{ memory }->{ var1015 } = 0;
	return;
};

1;
