#############################################################################
# MUDA: Resurrection							    #
# RCMD1010.pl		: Room 1010 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1010 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'PULL';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('PULL' =~ m/$lcmd/i)  {
		if (not ('TORCH' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Pull what?\n");
			return 1;
		};
		&informRoom($roomNum, $uid, "$i_username pulls the torch.\n");
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username disappears!\n");
		};
		&clientTell($cmqid, $username, $pid, "The whole room turns around!\n");
		&movePlayer($uid, 1005);
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom(1005, $uid, "$username appears from nowhere!\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1010: fall out\n");
		return undef;
	};
};

sub RCMD1010loop {
	return;
};

1;
