#############################################################################
# MUDA: Resurrection							    #
# RCMD1005.pl		: Room 1005 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1005 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'PUSH ASSEMBLE';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('PUSH' =~ m/$lcmd/i)  {
		if (not ('TORCH' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Pull what?\n");
			return 1;
		};
		&informRoom($roomNum, $uid, "$i_username pushes the torch.\n");
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username disappears!\n");
		};
		&clientTell($cmqid, $username, $pid, "The whole room turns around!\n");
		&movePlayer($uid, 1010);
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom(1010, $uid, "$username appears from nowhere!\n");
		};
		return 1;
	} elsif ('ASSEMBLE' =~ m/$lcmd/i)  {
		if (not ('SWORD' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Assemble what?\n");
			return 1;
		};
		my @swparts = ('MMSW1', 'MMSW2', 'MMSW3', 'MMSW4', 'MMSW5', 'MMSW6', 'MMSW7');
		my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
		my @foundiids = ();
		foreach my $iid (keys %{ $inv_ref }) {
			my $qq = $inv_ref->{$iid}->{ questCode };
			if (
				(defined $qq) and 
				($qq ne '') and 
				(scalar(grep(/$qq/, @swparts)) > 0)
			) {
				push @foundiids, $iid;
				#&clientTell($cmqid, $username, $pid, "DEBUG: $iid found.\n");
			};
		};
		if (scalar(@swparts) == scalar(@foundiids)) {
			&clientTell($cmqid, $username, $pid, "You done it!\n");
			&informRoom($roomNum, $uid, "$i_username assembles the Famous Elimination Sword!\n");
			foreach my $iid (@foundiids) {
				# Delete parts:
				&intDestroyItem($iid);
			};
			# Now give the sword to user:
			&intCreateItemFromProto($pid, 38, 1);
			return 1;
		} else {
			&clientTell($cmqid, $username, $pid, "You don\'t have all the parts!\n");
			&informRoom($roomNum, $uid, "$i_username fails to assemble some parts.\n");
			return 1;
		};
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1005: fall out\n");
		return undef;
	};
};

sub RCMD1005loop {
	return;
};

1;
