#############################################################################
# MUDA: Resurrection							    #
# RCMD1004.pl		: Room 1004 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1004 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'ENTER';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('ENTER' =~ m/$lcmd/i)  {
		if (not ('MIRROR' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Enter what?\n");
			return 1;
		};
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom($roomNum, $uid, "$username enters the mirror.\n");
			&informRoom($roomNum, $uid, "$username disappears!\n");
		};
		&clientTell($cmqid, $username, $pid, "You feel strange!\n");
		&movePlayer($uid, 1003);
		&clientTell($cmqid, $username, $pid, "You are teleported somewhere!\n");
		if ($main::usersMainData[$uid]->{ invisible } == 0) {
			&informRoom(1003, $uid, "$username appears from nowhere!\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1004: fall out\n");
		return undef;
	};
};

sub RCMD1004loop {
	return;
};

1;
