#############################################################################
# MUDA: Resurrection							    #
# RCMD1003.pl		: Room 1003 device.				    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub RCMD1003 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'SHAKE PRAY';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('PRAY' =~ m/$lcmd/i)  {
		if (not ('MERLIN' =~ m/$args/i)) {
			&clientTell($cmqid, $username, $pid, "Pray to whom?\n");
			return 1;
		};
		# Look in user's inventory for a specific item:
		my $inv_ref = $main::usersMainData[ $uid ]->{ inventory };
		my $found = 0;
		foreach my $iid (keys %{ $inv_ref }) {
			if (${ $inv_ref }{$iid}->{ questCode } eq 'MMSW0') {
				$found = 1;
				&clientTell($cmqid, $username, $pid, "You feel a glow on the sword!\n");
				${ $inv_ref }{$iid}{ questCode } = 'AMRAMO3';
				${ $inv_ref }{$iid}{ shortDesc } = 'The famous Elimination Sword (blessed)';
			};
		};
		if (not $found) {
			&clientTell($cmqid, $username, $pid, "Nothing happens!\n");
		};
		return 1;
	} elsif ($lcmd =~ m/SHAKE/i)  {
		if (not ($args =~ m/HAND/i)) {
			&clientTell($cmqid, $username, $pid, "Shake what?\n");
			return 1;
		};
		&informRoom($roomNum, $uid, "$i_username shakes the hand of the status.\n");

		if ($i_username eq $username) {
			&informRoom($roomNum, $uid, "$i_username disappears!\n");
		};
		&clientTell($cmqid, $username, $pid, "You feel strange!\n");
		&movePlayer($uid, 1004);
		&clientTell($cmqid, $username, $pid, "You are teleported somewhere!\n");
		if ($i_username eq $username) {
			&informRoom(1004, $uid, "$i_username appears from nowhere!\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("RCMD1003: fall out\n");
		return undef;
	};
};

sub RCMD1003loop {
	return;
};

1;
