#############################################################################
# MUDA: Resurrection							    #
# MultiRCMD1089_1103.pl	: Rooms 1089-1103 device. Special case.		    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

sub MultiRCMD1089_1103 {
	use strict;
	my ($pid, $lcmd, $iid, $args) = @_;
	my ($username, $uid, $cmqid, $roomNum, $gender) = &intPid2Details($pid);
	my $i_username = $username;
	if (
		(defined $uid) and 
		($main::usersMainData[$uid]->{ invisible }) 
	) {
		$i_username = 'Somebody';
	};

	$lcmd = quotemeta($lcmd);
	$args = quotemeta($args);
	if (uc($lcmd) eq '__LIST') {
		return 'EXAMINE';
	} elsif (uc($lcmd) eq '__INFORM') {
		return 1; 	# Don't care
	} elsif (uc($lcmd) eq '__USE') {
		return 1;	# Invisible "furniture". Do nothing.
	} elsif ('EXAMINE' =~ m/$lcmd/i)  {
		if (not ('WALL' =~ m/$args/i)) {
			return 0;
		};
		&informRoom($roomNum, $uid, "$i_username examines the stonewall.\n");
		&clientTell($cmqid, $username, $pid, "This is a simple granite wall, too high to climb.\n");
		if ($roomNum == 1089) {
			&clientTell($cmqid, $username, $pid, "There is a pit hidden from the bushes.\n");
		};
		return 1;
	} else {
		# We should never reach that normally.
		&logPrint("MultiRCMD1089_1103: fall out\n");
		return undef;
	};
};

sub MultiRCMD1089_1103loop {
	return;
};

1;
