#!/usr/bin/perl
#############################################################################
# MUDA: Resurrection							    #
# MudaServer.pl		: Main server executable.			    #
# Artist:		: Theodore J. Soldatos				    #
#############################################################################
# This file is part of MUDA:Resurrection.			   	    #
#									    #
# MUDA:Resurrection is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by	    #
# the Free Software Foundation, either version 3 of the License, or	    #
# (at your option) any later version.					    #
#									    #
# MUDA:Resurrection is distributed in the hope that it will be useful,	    #
# but WITHOUT ANY WARRANTY; without even the implied warranty of	    #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    #
# GNU General Public License for more details.				    #
#									    #
# You should have received a copy of the GNU General Public License	    #
# along with MUDA:Resurrection.  If not, see <http://www.gnu.org/licenses/>.#
#									    #
# Copyright 2012 Theodore J. Soldatos					    #
#############################################################################

BEGIN {
    use Cwd;
    our $directory = cwd;
    print $directory;
}

use lib $directory;

use 5.010;
use IO::Async::Stream;
use IO::Async::Timer::Periodic;

use IO::Async::Loop;
use IO::Async::Signal;
use IPC::SysV qw(IPC_PRIVATE IPC_RMID IPC_CREAT S_IRWXU IPC_NOWAIT);
use DBD::SQLite;
use Config::General;

use strict;
use warnings;

use Ms_Libs;

our $serverPID = $$;
our $killrsp;

our $mudahome = '/home/theodore/svnMuda/';
our $dbfile = $mudahome . 'db/muda.db';
our $helpFileDir = $mudahome . './helpFiles/';
our $pidfile = $mudahome . './muda.pid';
our $mudacmd = 'MudaServer.pl';

# Load configuration:
my $conf = new Config::General("/etc/muda.conf");
my %config = $conf->getall;

if (%config) {
	&logPrint( "Parsing Configuration file.\n");
	if (defined $config{home}) {
		$mudahome = $config{home};
		&logPrint( "MUDA home set to $mudahome\n");
	};
	if (defined $config{db}) {
		$dbfile = $mudahome . $config{db};
		&logPrint( "DB path set to $dbfile\n");
	};
	if (defined $config{helpdir}) {
		$helpFileDir = $mudahome . $config{helpdir};
		&logPrint( "Help file path set to $helpFileDir\n");
	};
	if (defined $config{pid}) {
		$pidfile = $mudahome . $config{pid};
		&logPrint( "pid file path set to $pidfile\n");
	};
} else {
	&logPrint( "Configuration file not found, using defaults.\n");
};


# Check if i am running.
if (-e $pidfile) { # Stale or fresh ?
	open PIDFILE, "<$pidfile";
	my ($pid, $scrap) = split / /, <PIDFILE>, 2;
	close PIDFILE;
	open PSOUT, "/bin/ps -p $pid |";
	my @psout;
	while (<PSOUT>) { push @psout, $_ }; 
	if (scalar(@psout) > 1) { # Process in lock file exists
		&logPrint( "The server is already running. Exiting... \n");
		exit 1;
		}
	else { # Stale...
		&logPrint( "Removing stale lockfile.\n");
		unlink $pidfile;
		};
	};

# Write new pid file.
open PIDFILE, ">$pidfile";
print PIDFILE $serverPID;
close PIDFILE;

# Integrity checks:
&checkRCMDintegrity;

# Create main message queue:
our $mmqid = msgget(1000000, IPC_CREAT | S_IRWXU);

our $loop = IO::Async::Loop->new;

$loop->add( IO::Async::Timer::Periodic->new(
   # This will call the main operational code of Muda:
   interval => 1,
   notifier_name => 'MAIN',
   on_tick => \&mainMudaTick 
)->start );

$loop->add( IO::Async::Timer::Periodic->new(
   # This will call the user save routine:
   interval => 300,
   notifier_name => 'SAVELOGGEDUSERS',
   on_tick => \&saveLoggedInUsers 
)->start );

$loop->add( IO::Async::Timer::Periodic->new(
   # This will call the fight routine:
   interval => 2,
   notifier_name => 'FIGHTROUTINE',
   on_tick => \&mainFightTick
)->start );

# This will check main msg queue when signaled with USR1 from some client:
my $signal = IO::Async::Signal->new(
    name => "USR1",
    notifier_name => 'CLIENTSIG',
    on_receipt => \&mainClientSigSub
 );

 $loop->add( $signal );


# Initialize:
my $old_fh = select(STDOUT);
$| = 1;
select($old_fh);


my $roomsDataPath = './/ROOMS.DAT';
my $roomsLongPath = './ROOMS.LOD';
my $roomsShortPath = './ROOMS.SHD';
my $usersMainData = './user.csv';
our $cntr = our $timecntr = 0;
our $termWidth = 78;	# Terminal width! :-)
our $clientTimeout = 10;# After these timeticks without ping, user is autofrozen.
our $fightTimeOut = 600; # Fights expire after 10 mins.

our $pos = 1;	# "User" position.

our %dirLtS = ( EAST		=>	'E',
		WEST		=>	'W',
		SOUTH		=>	'S',
		NORTH		=>	'N',
		UP		=>	'U',
		DOWN		=>	'D',
		SOUTHEAST	=>	'SE',
		SOUTHWEST	=>	'SW',
		NORTHEAST	=>	'NE',
		NORTHWEST	=>	'NW'
	);

our %dirStL = ( E	=>	'EAST',
		W	=>	'WEST',
		S	=>	'SOUTH',
		N	=>	'NORTH',
		U	=>	'UP',
		D	=>	'DOWN',
		SE	=>	'SOUTHEAST',
		SW	=>	'SOUTHWEST',
		NE	=>	'NORTHEAST',
		NW	=>	'NORTHWEST'
	);

our @directions = ('E', 'W', 'N', 'S', 'U', 'D', 'SE', 'SW', 'NE', 'NW');
our @longDirections = ('EAST', 'WEST', 'NORTH', 'SOUTH', 'UP', 'DOWN', 'SOUTHEAST', 'SOUTHWEST', 'NORTHEAST', 'NORTHWEST');

our @lex_he = ('he', 'she', 'it');
our @lex_his = ('his', 'her', 'its');
our @lex_gender = ('Male', 'Female', 'Other');

# Level descriptions:
our %userLevels = (
		1	=>	'Novice',
		2	=>	'Builder',
		3	=>	'Beginner',
		4	=>	'Hobbit',
		5	=>	'Tricker',
		6	=>	'Apprentice',
		7	=>	'Graduate',
		8	=>	'Champion',
		9	=>	'Hero',
		10	=>	'Great Hero',
		11	=>	'Magician',
		12	=>	'Sorcerer',
		13	=>	'Wizard',
		14	=>	'Necromancer',
		15	=>	'Great Necromancer',
		16	=>	'Cadet submage',
		17	=>	'Submage',
		18	=>	'Cadet Mage',
		19	=>	'Mage',
		20	=>	'Semigod',
		21	=>	'God'
);

# Ambient commands with targets texts:
our %ambCmdTexts = (
      KISS => {
         TextToUser => "You are kissing ",
         TextToVictim => " kisses you.",
         TextToOthers => " kisses ",
      },
      HUG => {
         TextToUser => "You are hugging ",
         TextToVictim => " hugs you.",
         TextToOthers => " hugs ",
      },
      HAND => {
         TextToUser => "You are kindly kissing the hand of ",
         TextToVictim => " kindly kisses your hand.",
         TextToOthers => " kindly kisses the hand of ",
      },
      SHAKE => {
         TextToUser => "You are kindly shaking the hand of ",
         TextToVictim => " kindly shakes your hand.",
         TextToOthers => " kindly shakes the hand of ",
      },
      SPIT => {
         TextToUser => "You are spitting on ",
         TextToVictim => " spits on you !",
         TextToOthers => " spits on ",
      },
      BITE => {
         TextToUser => "You are biting ",
         TextToVictim => " bites you !",
         TextToOthers => " bites ",
      },
      KICK => {
         TextToUser => "You are kicking ",
         TextToVictim => " kicks you !",
         TextToOthers => " kicks ",
      },
      PUSH => {
         TextToUser => "You are pushing ",
         TextToVictim => " pushes you !",
         TextToOthers => " pushes ",
      },
      CARESS => {
         TextToUser => "You are kindly caressing ",
         TextToVictim => " kindly caresses you.",
         TextToOthers => " kindly caresses ",
      },
      TOUCH => {
         TextToUser => "You are touching ",
         TextToVictim => " touches you.",
         TextToOthers => " touches ",
      },	
      BOW => {
         TextToUser => "You bow to ",
         TextToVictim => " bows to you.",
         TextToOthers => " bows to ",
      },	
 );

# Data structures:

our @roomsLongDescr = ();
our @roomsShortDescr = (); 	# Descriptions.

our @roomsData = ();		# Room data. An array of hashes.
our @usersMainData = ();	# User data. An array of hashes. NPCs ("smart"
				# monsters) and "dump" monsters included.
our @npcProto = ();		# NPCs prototypes. All NPC are created by 
				# copying from this table. Array of hashes.
				# Almost identical to usersMainData.
our $userPass_ref = {};		# Users. Hash of hashes. Username key, pass 
				# and uid values. Login.
our @loggedInUsers = (); 	# An array of usernames.
our $pid2username_ref = {}; 	# Hash. Find username by pid.
our %itemData = ();		# Hash of hashes. All actual items.
our %itemProto = ();		# Hash of hashes. Prototypes for items. Items
				# should only be created based on these.
our %itemTypes = ();		# Hash of hashes.
our $cmdhash_ref = {}; 		# Hash. Basic commands (not items' or NPCs').
our $stats_ref = {};		# Hash. Game statistics.
our %fightData = ();		# Hash of hashes. Keeps active fights. These
				# are not saved anywhere.
our %questData = ();		# Hash of hashes. Only one field needs to be
				# saved back.
our $maxItemId = 0;		# Will be used to define id of new items.
our $maxUserId = 0;		# Will be used to define id of new users/NPCs.
our $itemLock = 0;		# Will be 1 during item creation.
our $npcLock = 0;		# Will be 1 during NPC creation.
our $userLock = 0;		# Will be 1 during user creation.
our @deadNpcs = ();		# List of dead NPCs' uids. Will be used for 
				# revival routine.

our $mrVersion = '12.12.09 alpha';
our $prompt = ">";
our $boottime = time;

my $cmdArgs;

# Room data:
&loadRooms;
# Main user data:
&loadUserData;
# Item prototypes:
&loadItemProto;
# Item types:
&loadItemTypes;
# Item data:
&loadItemData;
# Commands: 
&loadCommands;
# NPC prototypes:
&loadNpcProto;
# Quests:
&loadQuests;
# Item command code:
&reloadItemCode;
# NPCs command code:
&reloadNpcCode;

# Shutdown on INT
$SIG{INT} = \&sysCmdShutdown;

# DEBUG init:
#use Data::Dumper;
#print Dumper(\%questData);
#$questData{1}->{ memory }->{ test } = 1;
#my $memory = $questData{1}->{ memory };
#$memory->{ test2 } = 5;
#print Dumper(\%questData);

##############################################
#############  INIT ENDS HERE.  ##############
##############################################

# GO!
$loop->run;

exit;

sub mainClientSigSub { 
	# Read queue:
	my $buf;
	while (msgrcv($mmqid, $buf, 2048, 0, IPC_NOWAIT)){
		my $bytes = do {use bytes; length($buf)};
                my ($typ_rcvd, $rcvdData) = unpack("l! a*", $buf);

		my ($clientPID, $clientCMD, $clientArgs) = split / /, $rcvdData, 3;
		if (not defined $clientCMD) {$clientCMD = '';};
		if (not defined $clientArgs) {$clientArgs = '';};
		$clientCMD = quotemeta($clientCMD);
		if ($clientCMD eq 'cmdLogin') {
			# Login try.
			my $cmqid = msgget($clientPID, S_IRWXU);
			if (not (defined($cmqid))) { 
				&logPrint("A ghost!\n|$rcvdData|\n");
			} else {
				# Connected.
				&logPrint("New login: $clientPID is $clientArgs\n"); 
				my ($username, $password) = split / /, $clientArgs, 2;
				# Check if $username exists
				my $usernameUnknown = 1;
				foreach my $uname (keys %$userPass_ref) {
					if ($uname eq $username) {
						$usernameUnknown = 0;
					};
				};
				if ($usernameUnknown) {
					# Failure.
					&logPrint("$username failed login (unknown) from $clientPID.\n"); 
					#&clientTell($cmqid, $username, $clientPID, '0');
					my $mqmsg = pack("l! a*", 1, '0');
					msgsnd($cmqid, $mqmsg, IPC_NOWAIT);
					next;
				};
				if (	defined($userPass_ref->{$username}->{password}) 
					and ($userPass_ref->{$username}->{password} eq $password) 
					and ($usersMainData[ $userPass_ref->{$username}->{uid} ]->{ pid } == -1) 
					and ($usersMainData[ $userPass_ref->{$username}->{uid} ]->{ qid } == -1)
					and ($usersMainData[ $userPass_ref->{$username}->{uid} ]->{ npc } == 0)) {
					# Success.
					&logPrint("$username logged in from $clientPID.\n"); 
					&tellAllUsers("$username connected.\n");
					push @loggedInUsers, $username;
					# Keep user message queue id and pid somewhere:
					$usersMainData[ $userPass_ref->{$username}->{uid} ]->{ pid } = $clientPID;
					$usersMainData[ $userPass_ref->{$username}->{uid} ]->{ qid } = $cmqid;
					$pid2username_ref->{$clientPID} = $username;
					#&clientTell($cmqid, $username, $clientPID, $serverPID);
					my $mqmsg = pack("l! a*", 1, $serverPID);
					msgsnd($cmqid, $mqmsg, IPC_NOWAIT);
					my $newUid = $userPass_ref->{$username}->{uid};
					my $newRoomNum = $usersMainData[ $newUid ]->{ room }; 
					if ($main::usersMainData[$newUid]->{ invisible } == 0) {
						&informRoom($newRoomNum, $newUid, "The ice statue of $username comes to life!\n");
					};
					$main::usersMainData[ $newUid ]->{ lastCon } = DateTime::Format::SQLite->format_datetime(DateTime->now);
					&intLoginPage($clientPID);
					&cmdLook($clientPID);
					next;
				} elsif (	defined($userPass_ref->{$username}->{password}) 
						and ($userPass_ref->{$username}->{password} eq $password) 
						and ($usersMainData[ $userPass_ref->{$username}->{uid} ]->{ pid } != -1) 
						and ($usersMainData[ $userPass_ref->{$username}->{uid} ]->{ qid } != -1)) {
					&logPrint("$username failed double login from $clientPID.\n"); 
					#&clientTell($cmqid, $username, $clientPID, '-1');
					my $mqmsg = pack("l! a*", 1, '-1');
					msgsnd($cmqid, $mqmsg, IPC_NOWAIT);
					next;
				} else {
					# Failure.
					&logPrint("$username failed login from $clientPID.\n"); 
					#&clientTell($cmqid, $username, $clientPID, '0');
					my $mqmsg = pack("l! a*", 1, '0');
					msgsnd($cmqid, $mqmsg, IPC_NOWAIT);
					next;
				};
			};
		} elsif ($clientCMD eq 'cmdLogout') {
			&clientLogout($clientPID);
		} elsif ($clientCMD eq 'cmdPing') {
			&clientPing($clientPID);
		} elsif ((scalar(grep(/^$clientCMD$/, @directions)) == 1) or (scalar(grep(/^$clientCMD$/, @longDirections)) == 1)) {
			&cmdGo($clientPID, $clientCMD);
		} else {
			&parseCommand($clientPID, $clientCMD, $clientArgs);
		};
	};
}

sub mainMudaTick {
	# Increase timeout counter of loggedin clients and auto-logout
	# inactive clients:
	&clientTimeouts;
	# Check message queue:
	&mainClientSigSub;
	# Revive NPCs
	&npcRevival;
	# Fuel, heal etc.
	&intMetabolism;
};
